/* datamodel.c generated by valac 0.14.0, the Vala compiler
 * generated from datamodel.vala, do not modify */

/* datamodel.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Seif Lotfy <seif@lotfy.com>
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


#define ZEITGEIST_TYPE_TIME_RANGE (zeitgeist_time_range_get_type ())
#define ZEITGEIST_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRange))
#define ZEITGEIST_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))
#define ZEITGEIST_IS_TIME_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_IS_TIME_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_TIME_RANGE))
#define ZEITGEIST_TIME_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangeClass))

typedef struct _ZeitgeistTimeRange ZeitgeistTimeRange;
typedef struct _ZeitgeistTimeRangeClass ZeitgeistTimeRangeClass;
typedef struct _ZeitgeistTimeRangePrivate ZeitgeistTimeRangePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ZEITGEIST_TYPE_RESULT_TYPE (zeitgeist_result_type_get_type ())

#define ZEITGEIST_TYPE_RELEVANT_RESULT_TYPE (zeitgeist_relevant_result_type_get_type ())

#define ZEITGEIST_TYPE_STORAGE_STATE (zeitgeist_storage_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define ZEITGEIST_TYPE_EVENT (zeitgeist_event_get_type ())
#define ZEITGEIST_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEvent))
#define ZEITGEIST_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))
#define ZEITGEIST_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))

typedef struct _ZeitgeistEvent ZeitgeistEvent;
typedef struct _ZeitgeistEventClass ZeitgeistEventClass;
typedef struct _ZeitgeistEventPrivate ZeitgeistEventPrivate;

#define ZEITGEIST_TYPE_SUBJECT (zeitgeist_subject_get_type ())
#define ZEITGEIST_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject))
#define ZEITGEIST_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))
#define ZEITGEIST_IS_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_IS_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_SUBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))

typedef struct _ZeitgeistSubject ZeitgeistSubject;
typedef struct _ZeitgeistSubjectClass ZeitgeistSubjectClass;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
typedef struct _ZeitgeistSubjectPrivate ZeitgeistSubjectPrivate;

struct _ZeitgeistTimeRange {
	GObject parent_instance;
	ZeitgeistTimeRangePrivate * priv;
};

struct _ZeitgeistTimeRangeClass {
	GObjectClass parent_class;
};

struct _ZeitgeistTimeRangePrivate {
	gint64 _start;
	gint64 _end;
};

typedef enum  {
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS = 0,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS = 1,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS = 2,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS = 3,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS = 4,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS = 5,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR = 6,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR = 7,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR = 8,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR = 9,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN = 10,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN = 11,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN = 12,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN = 13,
	ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR = 14,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION = 15,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION = 16,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION = 17,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION = 18,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE = 19,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE = 20,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE = 21,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE = 22,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI = 23,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI = 24,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI = 25,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI = 26,
	ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN = 27,
	ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN = 28,
	ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN = 29,
	ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN = 30
} ZeitgeistResultType;

typedef enum  {
	ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT = 0,
	ZEITGEIST_RELEVANT_RESULT_TYPE_RELATED = 1
} ZeitgeistRelevantResultType;

typedef enum  {
	ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE = 0,
	ZEITGEIST_STORAGE_STATE_AVAILABLE = 1,
	ZEITGEIST_STORAGE_STATE_ANY = 2
} ZeitgeistStorageState;

struct _ZeitgeistEvent {
	GObject parent_instance;
	ZeitgeistEventPrivate * priv;
};

struct _ZeitgeistEventClass {
	GObjectClass parent_class;
};

struct _ZeitgeistEventPrivate {
	guint32 _id;
	gint64 _timestamp;
	gchar* _interpretation;
	gchar* _manifestation;
	gchar* _actor;
	gchar* _origin;
	GPtrArray* _subjects;
	GByteArray* _payload;
};

struct _ZeitgeistSubject {
	GObject parent_instance;
	ZeitgeistSubjectPrivate * priv;
};

struct _ZeitgeistSubjectClass {
	GObjectClass parent_class;
};

struct _ZeitgeistSubjectPrivate {
	gchar* _uri;
	gchar* _interpretation;
	gchar* _manifestation;
	gchar* _mimetype;
	gchar* _origin;
	gchar* _text;
	gchar* _storage;
	gchar* _current_uri;
};


static gpointer zeitgeist_time_range_parent_class = NULL;
static gpointer zeitgeist_event_parent_class = NULL;
static gpointer zeitgeist_subject_parent_class = NULL;

gint64 zeitgeist_timestamp_now (void);
gint64 zeitgeist_timestamp_from_timeval (GTimeVal* tv);
GType zeitgeist_time_range_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_TIME_RANGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_TIME_RANGE, ZeitgeistTimeRangePrivate))
enum  {
	ZEITGEIST_TIME_RANGE_DUMMY_PROPERTY,
	ZEITGEIST_TIME_RANGE_START,
	ZEITGEIST_TIME_RANGE_END
};
ZeitgeistTimeRange* zeitgeist_time_range_new (gint64 start_msec, gint64 end_msec);
ZeitgeistTimeRange* zeitgeist_time_range_construct (GType object_type, gint64 start_msec, gint64 end_msec);
static void zeitgeist_time_range_set_start (ZeitgeistTimeRange* self, gint64 value);
static void zeitgeist_time_range_set_end (ZeitgeistTimeRange* self, gint64 value);
ZeitgeistTimeRange* zeitgeist_time_range_new_anytime (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_anytime (GType object_type);
ZeitgeistTimeRange* zeitgeist_time_range_new_to_now (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_to_now (GType object_type);
ZeitgeistTimeRange* zeitgeist_time_range_new_from_now (void);
ZeitgeistTimeRange* zeitgeist_time_range_construct_from_now (GType object_type);
ZeitgeistTimeRange* zeitgeist_time_range_new_from_variant (GVariant* variant);
ZeitgeistTimeRange* zeitgeist_time_range_construct_from_variant (GType object_type, GVariant* variant);
GVariant* zeitgeist_time_range_to_variant (ZeitgeistTimeRange* self);
gint64 zeitgeist_time_range_get_start (ZeitgeistTimeRange* self);
gint64 zeitgeist_time_range_get_end (ZeitgeistTimeRange* self);
ZeitgeistTimeRange* zeitgeist_time_range_intersect (ZeitgeistTimeRange* self, ZeitgeistTimeRange* time_range);
static void zeitgeist_time_range_finalize (GObject* obj);
static void _vala_zeitgeist_time_range_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_time_range_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType zeitgeist_result_type_get_type (void) G_GNUC_CONST;
GType zeitgeist_relevant_result_type_get_type (void) G_GNUC_CONST;
GType zeitgeist_storage_state_get_type (void) G_GNUC_CONST;
gboolean zeitgeist_check_field_match (const gchar* property, const gchar* template_property, gboolean is_symbol, gboolean can_wildcard);
gboolean zeitgeist_engine_parse_negation (gchar** val);
GList* zeitgeist_symbol_get_all_parents (const gchar* symbol_uri);
gboolean zeitgeist_engine_parse_wildcard (gchar** val);
GType zeitgeist_event_get_type (void) G_GNUC_CONST;
GType zeitgeist_subject_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_EVENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_EVENT, ZeitgeistEventPrivate))
enum  {
	ZEITGEIST_EVENT_DUMMY_PROPERTY,
	ZEITGEIST_EVENT_ID,
	ZEITGEIST_EVENT_TIMESTAMP,
	ZEITGEIST_EVENT_INTERPRETATION,
	ZEITGEIST_EVENT_MANIFESTATION,
	ZEITGEIST_EVENT_ACTOR,
	ZEITGEIST_EVENT_ORIGIN,
	ZEITGEIST_EVENT_SUBJECTS,
	ZEITGEIST_EVENT_PAYLOAD
};
gint zeitgeist_event_num_subjects (ZeitgeistEvent* self);
GPtrArray* zeitgeist_event_get_subjects (ZeitgeistEvent* self);
void zeitgeist_event_add_subject (ZeitgeistEvent* self, ZeitgeistSubject* subject);
ZeitgeistEvent* zeitgeist_event_new_from_variant (GVariant* event_variant);
ZeitgeistEvent* zeitgeist_event_construct_from_variant (GType object_type, GVariant* event_variant);
#define ZEITGEIST_UTILS_SIG_EVENT "asaasay"
void zeitgeist_event_set_id (ZeitgeistEvent* self, guint32 value);
void zeitgeist_event_set_timestamp (ZeitgeistEvent* self, gint64 value);
void zeitgeist_event_set_interpretation (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_manifestation (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_actor (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_origin (ZeitgeistEvent* self, const gchar* value);
ZeitgeistSubject* zeitgeist_subject_new_from_variant (GVariant* subject_variant);
ZeitgeistSubject* zeitgeist_subject_construct_from_variant (GType object_type, GVariant* subject_variant);
void zeitgeist_event_set_payload (ZeitgeistEvent* self, GByteArray* value);
GByteArray* zeitgeist_event_get_payload (ZeitgeistEvent* self);
GVariant* zeitgeist_event_to_variant (ZeitgeistEvent* self);
guint32 zeitgeist_event_get_id (ZeitgeistEvent* self);
gint64 zeitgeist_event_get_timestamp (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_interpretation (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_manifestation (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_actor (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_origin (ZeitgeistEvent* self);
GVariant* zeitgeist_subject_to_variant (ZeitgeistSubject* self);
void zeitgeist_event_debug_print (ZeitgeistEvent* self);
const gchar* zeitgeist_subject_get_uri (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_interpretation (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_manifestation (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_mimetype (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_origin (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_text (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_current_uri (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_storage (ZeitgeistSubject* self);
gboolean zeitgeist_event_matches_template (ZeitgeistEvent* self, ZeitgeistEvent* template_event);
gboolean zeitgeist_subject_matches_template (ZeitgeistSubject* self, ZeitgeistSubject* template_subject);
ZeitgeistEvent* zeitgeist_event_new (void);
ZeitgeistEvent* zeitgeist_event_construct (GType object_type);
void zeitgeist_event_set_subjects (ZeitgeistEvent* self, GPtrArray* value);
static GObject * zeitgeist_event_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void zeitgeist_event_finalize (GObject* obj);
static void _vala_zeitgeist_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GPtrArray* zeitgeist_events_from_variant (GVariant* vevents);
GVariant* zeitgeist_events_to_variant (GPtrArray* events);
GVariant* zeitgeist_events_get_null_event_variant (void);
#define ZEITGEIST_SUBJECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectPrivate))
enum  {
	ZEITGEIST_SUBJECT_DUMMY_PROPERTY,
	ZEITGEIST_SUBJECT_URI,
	ZEITGEIST_SUBJECT_INTERPRETATION,
	ZEITGEIST_SUBJECT_MANIFESTATION,
	ZEITGEIST_SUBJECT_MIMETYPE,
	ZEITGEIST_SUBJECT_ORIGIN,
	ZEITGEIST_SUBJECT_TEXT,
	ZEITGEIST_SUBJECT_STORAGE,
	ZEITGEIST_SUBJECT_CURRENT_URI
};
void zeitgeist_subject_set_uri (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_interpretation (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_manifestation (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_origin (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_mimetype (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_text (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_storage (ZeitgeistSubject* self, const gchar* value);
void zeitgeist_subject_set_current_uri (ZeitgeistSubject* self, const gchar* value);
ZeitgeistSubject* zeitgeist_subject_new (void);
ZeitgeistSubject* zeitgeist_subject_construct (GType object_type);
static void zeitgeist_subject_finalize (GObject* obj);
static void _vala_zeitgeist_subject_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_subject_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


gint64 zeitgeist_timestamp_now (void) {
	gint64 result = 0LL;
	GTimeVal _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	g_get_current_time (&_tmp0_);
	_tmp1_ = zeitgeist_timestamp_from_timeval (&_tmp0_);
	result = _tmp1_;
	return result;
}


gint64 zeitgeist_timestamp_from_timeval (GTimeVal* tv) {
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	GTimeVal _tmp0_;
	glong _tmp1_;
	gint64 _tmp2_;
	GTimeVal _tmp3_;
	glong _tmp4_;
	g_return_val_if_fail (tv != NULL, 0LL);
	_tmp0_ = *tv;
	_tmp1_ = _tmp0_.tv_sec;
	_result_ = ((gint64) _tmp1_) * 1000;
	_tmp2_ = _result_;
	_tmp3_ = *tv;
	_tmp4_ = _tmp3_.tv_usec;
	_result_ = _tmp2_ + (((gint64) _tmp4_) / 1000);
	result = _result_;
	return result;
}


ZeitgeistTimeRange* zeitgeist_time_range_construct (GType object_type, gint64 start_msec, gint64 end_msec) {
	ZeitgeistTimeRange * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	self = (ZeitgeistTimeRange*) g_object_new (object_type, NULL);
	_tmp0_ = start_msec;
	zeitgeist_time_range_set_start (self, _tmp0_);
	_tmp1_ = end_msec;
	zeitgeist_time_range_set_end (self, _tmp1_);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new (gint64 start_msec, gint64 end_msec) {
	return zeitgeist_time_range_construct (ZEITGEIST_TYPE_TIME_RANGE, start_msec, end_msec);
}


ZeitgeistTimeRange* zeitgeist_time_range_construct_anytime (GType object_type) {
	ZeitgeistTimeRange * self = NULL;
	gint64 _tmp0_;
	_tmp0_ = G_MAXINT64;
	self = (ZeitgeistTimeRange*) zeitgeist_time_range_construct (object_type, (gint64) 0, _tmp0_);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new_anytime (void) {
	return zeitgeist_time_range_construct_anytime (ZEITGEIST_TYPE_TIME_RANGE);
}


ZeitgeistTimeRange* zeitgeist_time_range_construct_to_now (GType object_type) {
	ZeitgeistTimeRange * self = NULL;
	gint64 _tmp0_ = 0LL;
	_tmp0_ = zeitgeist_timestamp_now ();
	self = (ZeitgeistTimeRange*) zeitgeist_time_range_construct (object_type, (gint64) 0, _tmp0_);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new_to_now (void) {
	return zeitgeist_time_range_construct_to_now (ZEITGEIST_TYPE_TIME_RANGE);
}


ZeitgeistTimeRange* zeitgeist_time_range_construct_from_now (GType object_type) {
	ZeitgeistTimeRange * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_;
	_tmp0_ = zeitgeist_timestamp_now ();
	_tmp1_ = G_MAXINT64;
	self = (ZeitgeistTimeRange*) zeitgeist_time_range_construct (object_type, _tmp0_, _tmp1_);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new_from_now (void) {
	return zeitgeist_time_range_construct_from_now (ZEITGEIST_TYPE_TIME_RANGE);
}


ZeitgeistTimeRange* zeitgeist_time_range_construct_from_variant (GType object_type, GVariant* variant) {
	ZeitgeistTimeRange * self = NULL;
	GVariant* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gint64 start_msec;
	gint64 end_msec;
	GVariant* _tmp2_;
	g_return_val_if_fail (variant != NULL, NULL);
	_tmp0_ = variant;
	_tmp1_ = g_variant_get_type_string (_tmp0_);
	g_assert (g_strcmp0 (_tmp1_, "(xx)") == 0);
	start_msec = (gint64) 0;
	end_msec = (gint64) 0;
	_tmp2_ = variant;
	g_variant_get (_tmp2_, "(xx)", &start_msec, &end_msec, NULL);
	self = (ZeitgeistTimeRange*) zeitgeist_time_range_construct (object_type, start_msec, end_msec);
	return self;
}


ZeitgeistTimeRange* zeitgeist_time_range_new_from_variant (GVariant* variant) {
	return zeitgeist_time_range_construct_from_variant (ZEITGEIST_TYPE_TIME_RANGE, variant);
}


GVariant* zeitgeist_time_range_to_variant (ZeitgeistTimeRange* self) {
	GVariant* result = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_start;
	_tmp1_ = self->priv->_end;
	_tmp2_ = g_variant_new ("(xx)", _tmp0_, _tmp1_, NULL);
	_tmp3_ = g_variant_ref_sink (_tmp2_);
	result = _tmp3_;
	return result;
}


ZeitgeistTimeRange* zeitgeist_time_range_intersect (ZeitgeistTimeRange* self, ZeitgeistTimeRange* time_range) {
	ZeitgeistTimeRange* result = NULL;
	ZeitgeistTimeRange* _tmp0_;
	ZeitgeistTimeRange* _result_;
	gint64 _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp15_;
	ZeitgeistTimeRange* _tmp16_;
	gint64 _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (time_range != NULL, NULL);
	_tmp0_ = zeitgeist_time_range_new ((gint64) 0, (gint64) 0);
	_result_ = _tmp0_;
	_tmp1_ = self->priv->_start;
	_tmp2_ = time_range;
	_tmp3_ = _tmp2_->priv->_start;
	if (_tmp1_ < _tmp3_) {
		gint64 _tmp4_;
		ZeitgeistTimeRange* _tmp5_;
		gint64 _tmp6_;
		_tmp4_ = self->priv->_end;
		_tmp5_ = time_range;
		_tmp6_ = _tmp5_->priv->_start;
		if (_tmp4_ < _tmp6_) {
			result = NULL;
			_g_object_unref0 (_result_);
			return result;
		} else {
			ZeitgeistTimeRange* _tmp7_;
			ZeitgeistTimeRange* _tmp8_;
			gint64 _tmp9_;
			_tmp7_ = _result_;
			_tmp8_ = time_range;
			_tmp9_ = _tmp8_->priv->_start;
			zeitgeist_time_range_set_start (_tmp7_, _tmp9_);
		}
	} else {
		gint64 _tmp10_;
		ZeitgeistTimeRange* _tmp11_;
		gint64 _tmp12_;
		_tmp10_ = self->priv->_start;
		_tmp11_ = time_range;
		_tmp12_ = _tmp11_->priv->_end;
		if (_tmp10_ > _tmp12_) {
			result = NULL;
			_g_object_unref0 (_result_);
			return result;
		} else {
			ZeitgeistTimeRange* _tmp13_;
			gint64 _tmp14_;
			_tmp13_ = _result_;
			_tmp14_ = self->priv->_start;
			zeitgeist_time_range_set_start (_tmp13_, _tmp14_);
		}
	}
	_tmp15_ = self->priv->_end;
	_tmp16_ = time_range;
	_tmp17_ = _tmp16_->priv->_end;
	if (_tmp15_ < _tmp17_) {
		gint64 _tmp18_;
		ZeitgeistTimeRange* _tmp19_;
		gint64 _tmp20_;
		_tmp18_ = self->priv->_end;
		_tmp19_ = time_range;
		_tmp20_ = _tmp19_->priv->_start;
		if (_tmp18_ < _tmp20_) {
			result = NULL;
			_g_object_unref0 (_result_);
			return result;
		} else {
			ZeitgeistTimeRange* _tmp21_;
			gint64 _tmp22_;
			_tmp21_ = _result_;
			_tmp22_ = self->priv->_end;
			zeitgeist_time_range_set_end (_tmp21_, _tmp22_);
		}
	} else {
		gint64 _tmp23_;
		ZeitgeistTimeRange* _tmp24_;
		gint64 _tmp25_;
		_tmp23_ = self->priv->_start;
		_tmp24_ = time_range;
		_tmp25_ = _tmp24_->priv->_end;
		if (_tmp23_ > _tmp25_) {
			result = NULL;
			_g_object_unref0 (_result_);
			return result;
		} else {
			ZeitgeistTimeRange* _tmp26_;
			ZeitgeistTimeRange* _tmp27_;
			gint64 _tmp28_;
			_tmp26_ = _result_;
			_tmp27_ = time_range;
			_tmp28_ = _tmp27_->priv->_end;
			zeitgeist_time_range_set_end (_tmp26_, _tmp28_);
		}
	}
	result = _result_;
	return result;
}


gint64 zeitgeist_time_range_get_start (ZeitgeistTimeRange* self) {
	gint64 result;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_start;
	result = _tmp0_;
	return result;
}


static void zeitgeist_time_range_set_start (ZeitgeistTimeRange* self, gint64 value) {
	gint64 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_start = _tmp0_;
	g_object_notify ((GObject *) self, "start");
}


gint64 zeitgeist_time_range_get_end (ZeitgeistTimeRange* self) {
	gint64 result;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_end;
	result = _tmp0_;
	return result;
}


static void zeitgeist_time_range_set_end (ZeitgeistTimeRange* self, gint64 value) {
	gint64 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_end = _tmp0_;
	g_object_notify ((GObject *) self, "end");
}


static void zeitgeist_time_range_class_init (ZeitgeistTimeRangeClass * klass) {
	zeitgeist_time_range_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistTimeRangePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_time_range_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_time_range_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_time_range_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_TIME_RANGE_START, g_param_spec_int64 ("start", "start", "start", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_TIME_RANGE_END, g_param_spec_int64 ("end", "end", "end", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void zeitgeist_time_range_instance_init (ZeitgeistTimeRange * self) {
	self->priv = ZEITGEIST_TIME_RANGE_GET_PRIVATE (self);
}


static void zeitgeist_time_range_finalize (GObject* obj) {
	ZeitgeistTimeRange * self;
	self = ZEITGEIST_TIME_RANGE (obj);
	G_OBJECT_CLASS (zeitgeist_time_range_parent_class)->finalize (obj);
}


GType zeitgeist_time_range_get_type (void) {
	static volatile gsize zeitgeist_time_range_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_time_range_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistTimeRangeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_time_range_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistTimeRange), 0, (GInstanceInitFunc) zeitgeist_time_range_instance_init, NULL };
		GType zeitgeist_time_range_type_id;
		zeitgeist_time_range_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistTimeRange", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_time_range_type_id__volatile, zeitgeist_time_range_type_id);
	}
	return zeitgeist_time_range_type_id__volatile;
}


static void _vala_zeitgeist_time_range_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistTimeRange * self;
	self = ZEITGEIST_TIME_RANGE (object);
	switch (property_id) {
		case ZEITGEIST_TIME_RANGE_START:
		g_value_set_int64 (value, zeitgeist_time_range_get_start (self));
		break;
		case ZEITGEIST_TIME_RANGE_END:
		g_value_set_int64 (value, zeitgeist_time_range_get_end (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_time_range_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistTimeRange * self;
	self = ZEITGEIST_TIME_RANGE (object);
	switch (property_id) {
		case ZEITGEIST_TIME_RANGE_START:
		zeitgeist_time_range_set_start (self, g_value_get_int64 (value));
		break;
		case ZEITGEIST_TIME_RANGE_END:
		zeitgeist_time_range_set_end (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType zeitgeist_result_type_get_type (void) {
	static volatile gsize zeitgeist_result_type_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_result_type_type_id__volatile)) {
		static const GEnumValue values[] = {{ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS", "most-recent-events"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENTS", "least-recent-events"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS", "most-recent-subjects"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECTS", "least-recent-subjects"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS", "most-popular-subjects"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECTS", "least-popular-subjects"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ACTOR", "most-popular-actor"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ACTOR", "least-popular-actor"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_ACTOR", "most-recent-actor"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ACTOR", "least-recent-actor"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_ORIGIN", "most-recent-origin"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_ORIGIN", "least-recent-origin"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_ORIGIN", "most-popular-origin"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_ORIGIN", "least-popular-origin"}, {ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR, "ZEITGEIST_RESULT_TYPE_OLDEST_ACTOR", "oldest-actor"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECT_INTERPRETATION", "most-recent-subject-interpretation"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_SUBJECT_INTERPRETATION", "least-recent-subject-interpretation"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECT_INTERPRETATION", "most-popular-subject-interpretation"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_SUBJECT_INTERPRETATION", "least-popular-subject-interpretation"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_MIMETYPE", "most-recent-mimetype"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_MIMETYPE", "least-recent-mimetype"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_MIMETYPE", "most-popular-mimetype"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_MIMETYPE", "least-popular-mimetype"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_CURRENT_URI", "most-recent-current-uri"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_CURRENT_URI", "least-recent-current-uri"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_CURRENT_URI", "most-popular-current-uri"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_CURRENT_URI", "least-popular-current-uri"}, {ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENT_ORIGIN", "most-recent-event-origin"}, {ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_LEAST_RECENT_EVENT_ORIGIN", "least-recent-event-origin"}, {ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_MOST_POPULAR_EVENT_ORIGIN", "most-popular-event-origin"}, {ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN, "ZEITGEIST_RESULT_TYPE_LEAST_POPULAR_EVENT_ORIGIN", "least-popular-event-origin"}, {0, NULL, NULL}};
		GType zeitgeist_result_type_type_id;
		zeitgeist_result_type_type_id = g_enum_register_static ("ZeitgeistResultType", values);
		g_once_init_leave (&zeitgeist_result_type_type_id__volatile, zeitgeist_result_type_type_id);
	}
	return zeitgeist_result_type_type_id__volatile;
}


GType zeitgeist_relevant_result_type_get_type (void) {
	static volatile gsize zeitgeist_relevant_result_type_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_relevant_result_type_type_id__volatile)) {
		static const GEnumValue values[] = {{ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT, "ZEITGEIST_RELEVANT_RESULT_TYPE_RECENT", "recent"}, {ZEITGEIST_RELEVANT_RESULT_TYPE_RELATED, "ZEITGEIST_RELEVANT_RESULT_TYPE_RELATED", "related"}, {0, NULL, NULL}};
		GType zeitgeist_relevant_result_type_type_id;
		zeitgeist_relevant_result_type_type_id = g_enum_register_static ("ZeitgeistRelevantResultType", values);
		g_once_init_leave (&zeitgeist_relevant_result_type_type_id__volatile, zeitgeist_relevant_result_type_type_id);
	}
	return zeitgeist_relevant_result_type_type_id__volatile;
}


/**
     * Enumeration class defining the possible values for the storage
     * state of an event subject.
     *
     * The StorageState enumeration can be used to control whether or
     * not matched events must have their subjects available to the user.
     * Fx. not including deleted files, files on unplugged USB drives,
     * files available only when a network is available etc.
     */
GType zeitgeist_storage_state_get_type (void) {
	static volatile gsize zeitgeist_storage_state_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_storage_state_type_id__volatile)) {
		static const GEnumValue values[] = {{ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE, "ZEITGEIST_STORAGE_STATE_NOT_AVAILABLE", "not-available"}, {ZEITGEIST_STORAGE_STATE_AVAILABLE, "ZEITGEIST_STORAGE_STATE_AVAILABLE", "available"}, {ZEITGEIST_STORAGE_STATE_ANY, "ZEITGEIST_STORAGE_STATE_ANY", "any"}, {0, NULL, NULL}};
		GType zeitgeist_storage_state_type_id;
		zeitgeist_storage_state_type_id = g_enum_register_static ("ZeitgeistStorageState", values);
		g_once_init_leave (&zeitgeist_storage_state_type_id__volatile, zeitgeist_storage_state_type_id);
	}
	return zeitgeist_storage_state_type_id__volatile;
}


gboolean zeitgeist_check_field_match (const gchar* property, const gchar* template_property, gboolean is_symbol, gboolean can_wildcard) {
	gboolean result = FALSE;
	gboolean matches;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* parsed;
	gboolean _tmp2_ = FALSE;
	gboolean is_negated;
	const gchar* _tmp3_;
	const gchar* _tmp22_;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_;
	gboolean _tmp27_;
	g_return_val_if_fail (property != NULL, FALSE);
	g_return_val_if_fail (template_property != NULL, FALSE);
	matches = FALSE;
	_tmp0_ = template_property;
	_tmp1_ = g_strdup (_tmp0_);
	parsed = _tmp1_;
	_tmp2_ = zeitgeist_engine_parse_negation (&parsed);
	is_negated = _tmp2_;
	_tmp3_ = parsed;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		result = TRUE;
		_g_free0 (parsed);
		return result;
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = parsed;
		_tmp5_ = property;
		if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
			matches = TRUE;
		} else {
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_;
			gboolean _tmp14_;
			_tmp7_ = is_symbol;
			if (_tmp7_) {
				const gchar* _tmp8_;
				GList* _tmp9_ = NULL;
				GList* _tmp10_;
				const gchar* _tmp11_;
				GCompareFunc _tmp12_;
				GList* _tmp13_ = NULL;
				_tmp8_ = property;
				_tmp9_ = zeitgeist_symbol_get_all_parents (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = parsed;
				_tmp12_ = g_strcmp0;
				_tmp13_ = g_list_find_custom (_tmp10_, _tmp11_, _tmp12_);
				_tmp6_ = _tmp13_ != NULL;
				_g_list_free0 (_tmp10_);
			} else {
				_tmp6_ = FALSE;
			}
			_tmp14_ = _tmp6_;
			if (_tmp14_) {
				matches = TRUE;
			} else {
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_;
				gboolean _tmp18_;
				_tmp16_ = can_wildcard;
				if (_tmp16_) {
					gboolean _tmp17_ = FALSE;
					_tmp17_ = zeitgeist_engine_parse_wildcard (&parsed);
					_tmp15_ = _tmp17_;
				} else {
					_tmp15_ = FALSE;
				}
				_tmp18_ = _tmp15_;
				if (_tmp18_) {
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					gboolean _tmp21_ = FALSE;
					_tmp19_ = property;
					_tmp20_ = parsed;
					_tmp21_ = g_str_has_prefix (_tmp19_, _tmp20_);
					if (_tmp21_) {
						matches = TRUE;
					}
				}
			}
		}
	}
	_tmp22_ = parsed;
	g_debug ("datamodel.vala:282: Checking matches for %s", _tmp22_);
	_tmp24_ = is_negated;
	if (_tmp24_) {
		gboolean _tmp25_;
		_tmp25_ = matches;
		_tmp23_ = !_tmp25_;
	} else {
		gboolean _tmp26_;
		_tmp26_ = matches;
		_tmp23_ = _tmp26_;
	}
	_tmp27_ = _tmp23_;
	result = _tmp27_;
	_g_free0 (parsed);
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


gint zeitgeist_event_num_subjects (ZeitgeistEvent* self) {
	gint result = 0;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_subjects;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void zeitgeist_event_add_subject (ZeitgeistEvent* self, ZeitgeistSubject* subject) {
	GPtrArray* _tmp0_;
	ZeitgeistSubject* _tmp1_;
	ZeitgeistSubject* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subject != NULL);
	_tmp0_ = self->priv->_subjects;
	_tmp1_ = subject;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	g_ptr_array_add (_tmp0_, _tmp2_);
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


ZeitgeistEvent* zeitgeist_event_construct_from_variant (GType object_type, GVariant* event_variant) {
	ZeitgeistEvent * self = NULL;
	GVariant* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GVariant* _tmp2_;
	GVariantIter* _tmp3_ = NULL;
	GVariantIter* iter;
	GVariantIter* _tmp4_;
	gsize _tmp5_ = 0UL;
	GVariantIter* _tmp6_;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_;
	GVariantIter* _tmp9_ = NULL;
	GVariantIter* _tmp10_;
	GVariantIter* event_array;
	GVariantIter* _tmp11_;
	GVariant* _tmp12_ = NULL;
	GVariant* _tmp13_;
	GVariantIter* _tmp14_ = NULL;
	GVariantIter* _tmp15_;
	GVariantIter* subjects_array;
	GVariantIter* _tmp16_;
	GVariant* _tmp17_ = NULL;
	GVariant* payload_variant;
	GVariantIter* _tmp18_;
	gsize _tmp19_ = 0UL;
	gsize event_props;
	gsize _tmp20_;
	GVariantIter* _tmp21_;
	GVariant* _tmp22_ = NULL;
	GVariant* _tmp23_;
	const gchar* _tmp24_ = NULL;
	guint64 _tmp25_ = 0ULL;
	GVariantIter* _tmp26_;
	GVariant* _tmp27_ = NULL;
	GVariant* _tmp28_;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* str_timestamp;
	const gchar* _tmp32_;
	GVariantIter* _tmp36_;
	GVariant* _tmp37_ = NULL;
	GVariant* _tmp38_;
	const gchar* _tmp39_ = NULL;
	GVariantIter* _tmp40_;
	GVariant* _tmp41_ = NULL;
	GVariant* _tmp42_;
	const gchar* _tmp43_ = NULL;
	GVariantIter* _tmp44_;
	GVariant* _tmp45_ = NULL;
	GVariant* _tmp46_;
	const gchar* _tmp47_ = NULL;
	gsize _tmp48_;
	GVariant* _tmp64_;
	gsize _tmp65_ = 0UL;
	guint payload_length;
	guint _tmp66_;
	g_return_val_if_fail (event_variant != NULL, NULL);
	self = (ZeitgeistEvent*) g_object_new (object_type, NULL);
	_tmp0_ = event_variant;
	_tmp1_ = g_variant_get_type_string (_tmp0_);
	g_assert (g_strcmp0 (_tmp1_, "(" ZEITGEIST_UTILS_SIG_EVENT ")") == 0);
	_tmp2_ = event_variant;
	_tmp3_ = g_variant_iter_new (_tmp2_);
	iter = _tmp3_;
	_tmp4_ = iter;
	_tmp5_ = g_variant_iter_n_children (_tmp4_);
	g_assert (_tmp5_ >= ((gsize) 3));
	_tmp6_ = iter;
	_tmp7_ = g_variant_iter_next_value (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_variant_iter_new (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_variant_unref0 (_tmp8_);
	event_array = _tmp10_;
	_tmp11_ = iter;
	_tmp12_ = g_variant_iter_next_value (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_variant_iter_new (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_variant_unref0 (_tmp13_);
	subjects_array = _tmp15_;
	_tmp16_ = iter;
	_tmp17_ = g_variant_iter_next_value (_tmp16_);
	payload_variant = _tmp17_;
	_tmp18_ = event_array;
	_tmp19_ = g_variant_iter_n_children (_tmp18_);
	event_props = _tmp19_;
	_tmp20_ = event_props;
	g_assert (_tmp20_ >= ((gsize) 5));
	_tmp21_ = event_array;
	_tmp22_ = g_variant_iter_next_value (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_variant_get_string (_tmp23_, NULL);
	_tmp25_ = uint64_parse (_tmp24_);
	zeitgeist_event_set_id (self, (guint32) _tmp25_);
	_g_variant_unref0 (_tmp23_);
	_tmp26_ = event_array;
	_tmp27_ = g_variant_iter_next_value (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_variant_get_string (_tmp28_, NULL);
	_tmp30_ = g_strdup (_tmp29_);
	_tmp31_ = _tmp30_;
	_g_variant_unref0 (_tmp28_);
	str_timestamp = _tmp31_;
	_tmp32_ = str_timestamp;
	if (g_strcmp0 (_tmp32_, "") == 0) {
		gint64 _tmp33_ = 0LL;
		_tmp33_ = zeitgeist_timestamp_now ();
		zeitgeist_event_set_timestamp (self, _tmp33_);
	} else {
		const gchar* _tmp34_;
		gint64 _tmp35_ = 0LL;
		_tmp34_ = str_timestamp;
		_tmp35_ = int64_parse (_tmp34_);
		zeitgeist_event_set_timestamp (self, _tmp35_);
	}
	_tmp36_ = event_array;
	_tmp37_ = g_variant_iter_next_value (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_variant_get_string (_tmp38_, NULL);
	zeitgeist_event_set_interpretation (self, _tmp39_);
	_g_variant_unref0 (_tmp38_);
	_tmp40_ = event_array;
	_tmp41_ = g_variant_iter_next_value (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = g_variant_get_string (_tmp42_, NULL);
	zeitgeist_event_set_manifestation (self, _tmp43_);
	_g_variant_unref0 (_tmp42_);
	_tmp44_ = event_array;
	_tmp45_ = g_variant_iter_next_value (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = g_variant_get_string (_tmp46_, NULL);
	zeitgeist_event_set_actor (self, _tmp47_);
	_g_variant_unref0 (_tmp46_);
	_tmp48_ = event_props;
	if (_tmp48_ >= ((gsize) 6)) {
		GVariantIter* _tmp49_;
		GVariant* _tmp50_ = NULL;
		GVariant* _tmp51_;
		const gchar* _tmp52_ = NULL;
		_tmp49_ = event_array;
		_tmp50_ = g_variant_iter_next_value (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_variant_get_string (_tmp51_, NULL);
		zeitgeist_event_set_origin (self, _tmp52_);
		_g_variant_unref0 (_tmp51_);
	} else {
		zeitgeist_event_set_origin (self, "");
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp53_;
			_tmp53_ = TRUE;
			while (TRUE) {
				gboolean _tmp54_;
				gint _tmp56_;
				GVariantIter* _tmp57_;
				gsize _tmp58_ = 0UL;
				GVariantIter* _tmp59_;
				GVariant* _tmp60_ = NULL;
				GVariant* subject_variant;
				GPtrArray* _tmp61_;
				GVariant* _tmp62_;
				ZeitgeistSubject* _tmp63_;
				_tmp54_ = _tmp53_;
				if (!_tmp54_) {
					gint _tmp55_;
					_tmp55_ = i;
					i = _tmp55_ + 1;
				}
				_tmp53_ = FALSE;
				_tmp56_ = i;
				_tmp57_ = subjects_array;
				_tmp58_ = g_variant_iter_n_children (_tmp57_);
				if (!(((gsize) _tmp56_) < _tmp58_)) {
					break;
				}
				_tmp59_ = subjects_array;
				_tmp60_ = g_variant_iter_next_value (_tmp59_);
				subject_variant = _tmp60_;
				_tmp61_ = self->priv->_subjects;
				_tmp62_ = subject_variant;
				_tmp63_ = zeitgeist_subject_new_from_variant (_tmp62_);
				g_ptr_array_add (_tmp61_, _tmp63_);
				_g_variant_unref0 (subject_variant);
			}
		}
	}
	_tmp64_ = payload_variant;
	_tmp65_ = g_variant_n_children (_tmp64_);
	payload_length = (guint) _tmp65_;
	_tmp66_ = payload_length;
	if (_tmp66_ > ((guint) 0)) {
		guint _tmp67_;
		guint _tmp68_;
		GByteArray* _tmp69_;
		GByteArray* _tmp70_;
		GVariant* _tmp71_;
		void* _tmp72_ = NULL;
		guint8* data;
		gint data_length1;
		gint _data_size_;
		guint _tmp73_;
		gint _tmp74_;
		GByteArray* _tmp75_;
		guint8* _tmp76_;
		gint _tmp76__length1;
		_tmp67_ = payload_length;
		g_debug ("datamodel.vala:350: there was payload with length: %u", _tmp67_);
		_tmp68_ = payload_length;
		_tmp69_ = g_byte_array_sized_new (_tmp68_);
		_tmp70_ = _tmp69_;
		zeitgeist_event_set_payload (self, _tmp70_);
		_g_byte_array_unref0 (_tmp70_);
		_tmp71_ = payload_variant;
		_tmp72_ = g_variant_get_data (_tmp71_);
		data = (guint8*) _tmp72_;
		data_length1 = -1;
		_data_size_ = data_length1;
		_tmp73_ = payload_length;
		data_length1 = (gint) _tmp73_;
		_tmp74_ = data_length1;
		_tmp75_ = self->priv->_payload;
		_tmp76_ = data;
		_tmp76__length1 = data_length1;
		g_byte_array_append (_tmp75_, _tmp76_, _tmp76__length1);
	}
	_g_free0 (str_timestamp);
	_g_variant_unref0 (payload_variant);
	_g_variant_iter_free0 (subjects_array);
	_g_variant_iter_free0 (event_array);
	_g_variant_iter_free0 (iter);
	return self;
}


ZeitgeistEvent* zeitgeist_event_new_from_variant (GVariant* event_variant) {
	return zeitgeist_event_construct_from_variant (ZEITGEIST_TYPE_EVENT, event_variant);
}


static gpointer _g_byte_array_ref0 (gpointer self) {
	return self ? g_byte_array_ref (self) : NULL;
}


GVariant* zeitgeist_event_to_variant (ZeitgeistEvent* self) {
	GVariant* result = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* vb;
	GVariantBuilder* _tmp4_;
	GVariantType* _tmp5_;
	GVariantType* _tmp6_;
	gchar* _tmp7_ = NULL;
	guint32 _tmp8_;
	GVariantBuilder* _tmp12_;
	const gchar* _tmp13_;
	GVariantBuilder* _tmp14_;
	gint64 _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_;
	GVariantBuilder* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_;
	GVariantBuilder* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_;
	GVariantBuilder* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	GVariantBuilder* _tmp38_;
	const gchar* _tmp39_;
	GVariantBuilder* _tmp40_;
	GVariantBuilder* _tmp41_;
	GVariantType* _tmp42_;
	GVariantType* _tmp43_;
	GVariantBuilder* _tmp57_;
	GByteArray* _tmp58_;
	GVariantBuilder* _tmp74_;
	GVariant* _tmp75_ = NULL;
	GVariant* _tmp76_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_variant_type_new ("(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = vb;
	_tmp5_ = g_variant_type_new ("as");
	_tmp6_ = _tmp5_;
	g_variant_builder_open (_tmp4_, _tmp6_);
	_g_variant_type_free0 (_tmp6_);
	_tmp8_ = self->priv->_id;
	if (_tmp8_ == ((guint32) 0)) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp9_;
	} else {
		guint32 _tmp10_;
		gchar* _tmp11_ = NULL;
		_tmp10_ = self->priv->_id;
		_tmp11_ = g_strdup_printf ("%u", _tmp10_);
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp11_;
	}
	_tmp12_ = vb;
	_tmp13_ = _tmp7_;
	g_variant_builder_add (_tmp12_, "s", _tmp13_, NULL);
	_tmp14_ = vb;
	_tmp15_ = self->priv->_timestamp;
	_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp15_);
	_tmp17_ = _tmp16_;
	g_variant_builder_add (_tmp14_, "s", _tmp17_, NULL);
	_g_free0 (_tmp17_);
	_tmp19_ = self->priv->_interpretation;
	if (_tmp19_ != NULL) {
		const gchar* _tmp20_;
		_tmp20_ = self->priv->_interpretation;
		_tmp18_ = _tmp20_;
	} else {
		_tmp18_ = "";
	}
	_tmp21_ = vb;
	_tmp22_ = _tmp18_;
	g_variant_builder_add (_tmp21_, "s", _tmp22_, NULL);
	_tmp24_ = self->priv->_manifestation;
	if (_tmp24_ != NULL) {
		const gchar* _tmp25_;
		_tmp25_ = self->priv->_manifestation;
		_tmp23_ = _tmp25_;
	} else {
		_tmp23_ = "";
	}
	_tmp26_ = vb;
	_tmp27_ = _tmp23_;
	g_variant_builder_add (_tmp26_, "s", _tmp27_, NULL);
	_tmp29_ = self->priv->_actor;
	if (_tmp29_ != NULL) {
		const gchar* _tmp30_;
		_tmp30_ = self->priv->_actor;
		_tmp28_ = _tmp30_;
	} else {
		_tmp28_ = "";
	}
	_tmp31_ = vb;
	_tmp32_ = _tmp28_;
	g_variant_builder_add (_tmp31_, "s", _tmp32_, NULL);
	_tmp33_ = self->priv->_origin;
	_tmp34_ = g_strdup (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_;
	if (_tmp36_ == NULL) {
		gchar* _tmp37_;
		_tmp37_ = g_strdup ("");
		_g_free0 (_tmp35_);
		_tmp35_ = _tmp37_;
	}
	_tmp38_ = vb;
	_tmp39_ = _tmp35_;
	g_variant_builder_add (_tmp38_, "s", _tmp39_, NULL);
	_tmp40_ = vb;
	g_variant_builder_close (_tmp40_);
	_tmp41_ = vb;
	_tmp42_ = g_variant_type_new ("aas");
	_tmp43_ = _tmp42_;
	g_variant_builder_open (_tmp41_, _tmp43_);
	_g_variant_type_free0 (_tmp43_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp44_;
			_tmp44_ = TRUE;
			while (TRUE) {
				gboolean _tmp45_;
				gint _tmp47_;
				GPtrArray* _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				GVariantBuilder* _tmp51_;
				GPtrArray* _tmp52_;
				gint _tmp53_;
				gconstpointer _tmp54_ = NULL;
				GVariant* _tmp55_ = NULL;
				GVariant* _tmp56_;
				_tmp45_ = _tmp44_;
				if (!_tmp45_) {
					gint _tmp46_;
					_tmp46_ = i;
					i = _tmp46_ + 1;
				}
				_tmp44_ = FALSE;
				_tmp47_ = i;
				_tmp48_ = self->priv->_subjects;
				_tmp49_ = g_ptr_array_get_length (_tmp48_);
				_tmp50_ = _tmp49_;
				if (!(_tmp47_ < _tmp50_)) {
					break;
				}
				_tmp51_ = vb;
				_tmp52_ = self->priv->_subjects;
				_tmp53_ = i;
				_tmp54_ = g_ptr_array_index (_tmp52_, (guint) _tmp53_);
				_tmp55_ = zeitgeist_subject_to_variant ((ZeitgeistSubject*) _tmp54_);
				_tmp56_ = _tmp55_;
				g_variant_builder_add_value (_tmp51_, _tmp56_);
				_g_variant_unref0 (_tmp56_);
			}
		}
	}
	_tmp57_ = vb;
	g_variant_builder_close (_tmp57_);
	_tmp58_ = self->priv->_payload;
	if (_tmp58_ != NULL) {
		GVariantType* _tmp59_;
		GVariantType* _tmp60_;
		GByteArray* _tmp61_;
		guint8* _tmp62_;
		gint _tmp62__length1;
		GByteArray* _tmp63_;
		GByteArray* _tmp64_;
		GVariant* _tmp65_ = NULL;
		GVariant* _tmp66_;
		GVariant* _tmp67_;
		GVariant* payload_variant;
		GVariantBuilder* _tmp68_;
		GVariant* _tmp69_;
		_tmp59_ = g_variant_type_new ("ay");
		_tmp60_ = _tmp59_;
		_tmp61_ = self->priv->_payload;
		_tmp62_ = _tmp61_->data;
		_tmp62__length1 = (gint) _tmp61_->len;
		_tmp63_ = self->priv->_payload;
		_tmp64_ = _g_byte_array_ref0 (_tmp63_);
		_tmp65_ = g_variant_new_from_data (_tmp60_, _tmp62_, _tmp62__length1, FALSE, g_byte_array_unref, _tmp64_);
		_tmp66_ = g_variant_ref_sink (_tmp65_);
		_tmp67_ = _tmp66_;
		_g_variant_type_free0 (_tmp60_);
		payload_variant = _tmp67_;
		_tmp68_ = vb;
		_tmp69_ = payload_variant;
		g_variant_builder_add_value (_tmp68_, _tmp69_);
		_g_variant_unref0 (payload_variant);
	} else {
		GVariantBuilder* _tmp70_;
		GVariantType* _tmp71_;
		GVariantType* _tmp72_;
		GVariantBuilder* _tmp73_;
		_tmp70_ = vb;
		_tmp71_ = g_variant_type_new ("ay");
		_tmp72_ = _tmp71_;
		g_variant_builder_open (_tmp70_, _tmp72_);
		_g_variant_type_free0 (_tmp72_);
		_tmp73_ = vb;
		g_variant_builder_close (_tmp73_);
	}
	_tmp74_ = vb;
	_tmp75_ = g_variant_builder_end (_tmp74_);
	_tmp76_ = g_variant_ref_sink (_tmp75_);
	result = _tmp76_;
	_g_free0 (_tmp35_);
	_g_free0 (_tmp7_);
	_g_variant_builder_unref0 (vb);
	return result;
}


void zeitgeist_event_debug_print (ZeitgeistEvent* self) {
	FILE* _tmp0_;
	guint32 _tmp1_;
	gint64 _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GPtrArray* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	_tmp1_ = self->priv->_id;
	_tmp2_ = self->priv->_timestamp;
	_tmp3_ = self->priv->_actor;
	_tmp4_ = self->priv->_interpretation;
	_tmp5_ = self->priv->_manifestation;
	_tmp6_ = self->priv->_origin;
	_tmp7_ = self->priv->_subjects;
	_tmp8_ = g_ptr_array_get_length (_tmp7_);
	_tmp9_ = _tmp8_;
	fprintf (_tmp0_, "id: %d\t" "timestamp: %" G_GINT64_FORMAT "\n" "actor: %s\n" "interpretation: %s\n" "manifestation: %s\n" "origin: %s\n" "num subjects: %d\n", _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp9_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_;
				gint _tmp13_;
				GPtrArray* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				GPtrArray* _tmp17_;
				gint _tmp18_;
				gconstpointer _tmp19_ = NULL;
				ZeitgeistSubject* _tmp20_;
				ZeitgeistSubject* s;
				FILE* _tmp21_;
				gint _tmp22_;
				ZeitgeistSubject* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				ZeitgeistSubject* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				ZeitgeistSubject* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				ZeitgeistSubject* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				ZeitgeistSubject* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				ZeitgeistSubject* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				ZeitgeistSubject* _tmp41_;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				ZeitgeistSubject* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				_tmp11_ = _tmp10_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp13_ = i;
				_tmp14_ = self->priv->_subjects;
				_tmp15_ = g_ptr_array_get_length (_tmp14_);
				_tmp16_ = _tmp15_;
				if (!(_tmp13_ < _tmp16_)) {
					break;
				}
				_tmp17_ = self->priv->_subjects;
				_tmp18_ = i;
				_tmp19_ = g_ptr_array_index (_tmp17_, (guint) _tmp18_);
				_tmp20_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp19_);
				s = _tmp20_;
				_tmp21_ = stdout;
				_tmp22_ = i;
				_tmp23_ = s;
				_tmp24_ = zeitgeist_subject_get_uri (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = s;
				_tmp27_ = zeitgeist_subject_get_interpretation (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = s;
				_tmp30_ = zeitgeist_subject_get_manifestation (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = s;
				_tmp33_ = zeitgeist_subject_get_mimetype (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = s;
				_tmp36_ = zeitgeist_subject_get_origin (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = s;
				_tmp39_ = zeitgeist_subject_get_text (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = s;
				_tmp42_ = zeitgeist_subject_get_current_uri (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = s;
				_tmp45_ = zeitgeist_subject_get_storage (_tmp44_);
				_tmp46_ = _tmp45_;
				fprintf (_tmp21_, "  Subject #%d:\n" "    uri: %s\n" "    interpretation: %s\n" "    manifestation: %s\n" "    mimetype: %s\n" "    origin: %s\n" "    text: %s\n" "    current_uri: %s\n" "    storage: %s\n", _tmp22_, _tmp25_, _tmp28_, _tmp31_, _tmp34_, _tmp37_, _tmp40_, _tmp43_, _tmp46_);
				_g_object_unref0 (s);
			}
		}
	}
}


gboolean zeitgeist_event_matches_template (ZeitgeistEvent* self, ZeitgeistEvent* template_event) {
	gboolean result = FALSE;
	guint32 _tmp0_;
	ZeitgeistEvent* _tmp1_;
	guint32 _tmp2_;
	const gchar* _tmp3_;
	ZeitgeistEvent* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	ZeitgeistEvent* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	ZeitgeistEvent* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	ZeitgeistEvent* _tmp16_;
	const gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	ZeitgeistEvent* _tmp19_;
	GPtrArray* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (template_event != NULL, FALSE);
	_tmp0_ = self->priv->_id;
	_tmp1_ = template_event;
	_tmp2_ = _tmp1_->priv->_id;
	g_debug ("datamodel.vala:438: Checking if event %u matches template_event %u\n", (guint) _tmp0_, (guint) _tmp2_);
	_tmp3_ = self->priv->_interpretation;
	_tmp4_ = template_event;
	_tmp5_ = _tmp4_->priv->_interpretation;
	_tmp6_ = zeitgeist_check_field_match (_tmp3_, _tmp5_, TRUE, FALSE);
	if (!_tmp6_) {
		result = FALSE;
		return result;
	}
	_tmp7_ = self->priv->_manifestation;
	_tmp8_ = template_event;
	_tmp9_ = _tmp8_->priv->_manifestation;
	_tmp10_ = zeitgeist_check_field_match (_tmp7_, _tmp9_, TRUE, FALSE);
	if (!_tmp10_) {
		result = FALSE;
		return result;
	}
	_tmp11_ = self->priv->_actor;
	_tmp12_ = template_event;
	_tmp13_ = _tmp12_->priv->_actor;
	_tmp14_ = zeitgeist_check_field_match (_tmp11_, _tmp13_, FALSE, TRUE);
	if (!_tmp14_) {
		result = FALSE;
		return result;
	}
	_tmp15_ = self->priv->_origin;
	_tmp16_ = template_event;
	_tmp17_ = _tmp16_->priv->_origin;
	_tmp18_ = zeitgeist_check_field_match (_tmp15_, _tmp17_, FALSE, TRUE);
	if (!_tmp18_) {
		result = FALSE;
		return result;
	}
	_tmp19_ = template_event;
	_tmp20_ = _tmp19_->priv->_subjects;
	_tmp21_ = g_ptr_array_get_length (_tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ == 0) {
		result = TRUE;
		return result;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp23_;
			_tmp23_ = TRUE;
			while (TRUE) {
				gboolean _tmp24_;
				gint _tmp26_;
				GPtrArray* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				_tmp24_ = _tmp23_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp23_ = FALSE;
				_tmp26_ = i;
				_tmp27_ = self->priv->_subjects;
				_tmp28_ = g_ptr_array_get_length (_tmp27_);
				_tmp29_ = _tmp28_;
				if (!(_tmp26_ < _tmp29_)) {
					break;
				}
				{
					gint j;
					j = 0;
					{
						gboolean _tmp30_;
						_tmp30_ = TRUE;
						while (TRUE) {
							gboolean _tmp31_;
							gint _tmp33_;
							ZeitgeistEvent* _tmp34_;
							GPtrArray* _tmp35_;
							gint _tmp36_;
							gint _tmp37_;
							GPtrArray* _tmp38_;
							gint _tmp39_;
							gconstpointer _tmp40_ = NULL;
							ZeitgeistEvent* _tmp41_;
							GPtrArray* _tmp42_;
							gint _tmp43_;
							gconstpointer _tmp44_ = NULL;
							gboolean _tmp45_ = FALSE;
							_tmp31_ = _tmp30_;
							if (!_tmp31_) {
								gint _tmp32_;
								_tmp32_ = j;
								j = _tmp32_ + 1;
							}
							_tmp30_ = FALSE;
							_tmp33_ = j;
							_tmp34_ = template_event;
							_tmp35_ = _tmp34_->priv->_subjects;
							_tmp36_ = g_ptr_array_get_length (_tmp35_);
							_tmp37_ = _tmp36_;
							if (!(_tmp33_ < _tmp37_)) {
								break;
							}
							_tmp38_ = self->priv->_subjects;
							_tmp39_ = i;
							_tmp40_ = g_ptr_array_index (_tmp38_, (guint) _tmp39_);
							_tmp41_ = template_event;
							_tmp42_ = _tmp41_->priv->_subjects;
							_tmp43_ = j;
							_tmp44_ = g_ptr_array_index (_tmp42_, (guint) _tmp43_);
							_tmp45_ = zeitgeist_subject_matches_template ((ZeitgeistSubject*) _tmp40_, (ZeitgeistSubject*) _tmp44_);
							if (_tmp45_) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


ZeitgeistEvent* zeitgeist_event_construct (GType object_type) {
	ZeitgeistEvent * self = NULL;
	self = (ZeitgeistEvent*) g_object_new (object_type, NULL);
	return self;
}


ZeitgeistEvent* zeitgeist_event_new (void) {
	return zeitgeist_event_construct (ZEITGEIST_TYPE_EVENT);
}


guint32 zeitgeist_event_get_id (ZeitgeistEvent* self) {
	guint32 result;
	guint32 _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_id (ZeitgeistEvent* self, guint32 value) {
	guint32 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


gint64 zeitgeist_event_get_timestamp (ZeitgeistEvent* self) {
	gint64 result;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_timestamp;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_timestamp (ZeitgeistEvent* self, gint64 value) {
	gint64 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_timestamp = _tmp0_;
	g_object_notify ((GObject *) self, "timestamp");
}


const gchar* zeitgeist_event_get_interpretation (ZeitgeistEvent* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_interpretation;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_interpretation (ZeitgeistEvent* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_interpretation);
	self->priv->_interpretation = _tmp1_;
	g_object_notify ((GObject *) self, "interpretation");
}


const gchar* zeitgeist_event_get_manifestation (ZeitgeistEvent* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manifestation;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_manifestation (ZeitgeistEvent* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_manifestation);
	self->priv->_manifestation = _tmp1_;
	g_object_notify ((GObject *) self, "manifestation");
}


const gchar* zeitgeist_event_get_actor (ZeitgeistEvent* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actor;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_actor (ZeitgeistEvent* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_actor);
	self->priv->_actor = _tmp1_;
	g_object_notify ((GObject *) self, "actor");
}


const gchar* zeitgeist_event_get_origin (ZeitgeistEvent* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_origin;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_origin (ZeitgeistEvent* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_origin);
	self->priv->_origin = _tmp1_;
	g_object_notify ((GObject *) self, "origin");
}


GPtrArray* zeitgeist_event_get_subjects (ZeitgeistEvent* self) {
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_subjects;
	result = _tmp0_;
	return result;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


void zeitgeist_event_set_subjects (ZeitgeistEvent* self, GPtrArray* value) {
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_ptr_array_ref0 (_tmp0_);
	_g_ptr_array_unref0 (self->priv->_subjects);
	self->priv->_subjects = _tmp1_;
	g_object_notify ((GObject *) self, "subjects");
}


GByteArray* zeitgeist_event_get_payload (ZeitgeistEvent* self) {
	GByteArray* result;
	GByteArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_payload;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_payload (ZeitgeistEvent* self, GByteArray* value) {
	GByteArray* _tmp0_;
	GByteArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_byte_array_ref0 (_tmp0_);
	_g_byte_array_unref0 (self->priv->_payload);
	self->priv->_payload = _tmp1_;
	g_object_notify ((GObject *) self, "payload");
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static GObject * zeitgeist_event_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistEvent * self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	parent_class = G_OBJECT_CLASS (zeitgeist_event_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ZEITGEIST_EVENT (obj);
	_tmp0_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_tmp1_ = _tmp0_;
	zeitgeist_event_set_subjects (self, _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	return obj;
}


static void zeitgeist_event_class_init (ZeitgeistEventClass * klass) {
	zeitgeist_event_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistEventPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_event_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_event_set_property;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_event_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_event_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_ID, g_param_spec_uint ("id", "id", "id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_TIMESTAMP, g_param_spec_int64 ("timestamp", "timestamp", "timestamp", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_INTERPRETATION, g_param_spec_string ("interpretation", "interpretation", "interpretation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_MANIFESTATION, g_param_spec_string ("manifestation", "manifestation", "manifestation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_ACTOR, g_param_spec_string ("actor", "actor", "actor", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_ORIGIN, g_param_spec_string ("origin", "origin", "origin", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_SUBJECTS, g_param_spec_boxed ("subjects", "subjects", "subjects", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_PAYLOAD, g_param_spec_boxed ("payload", "payload", "payload", G_TYPE_BYTE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void zeitgeist_event_instance_init (ZeitgeistEvent * self) {
	self->priv = ZEITGEIST_EVENT_GET_PRIVATE (self);
}


static void zeitgeist_event_finalize (GObject* obj) {
	ZeitgeistEvent * self;
	self = ZEITGEIST_EVENT (obj);
	_g_free0 (self->priv->_interpretation);
	_g_free0 (self->priv->_manifestation);
	_g_free0 (self->priv->_actor);
	_g_free0 (self->priv->_origin);
	_g_ptr_array_unref0 (self->priv->_subjects);
	_g_byte_array_unref0 (self->priv->_payload);
	G_OBJECT_CLASS (zeitgeist_event_parent_class)->finalize (obj);
}


GType zeitgeist_event_get_type (void) {
	static volatile gsize zeitgeist_event_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistEvent), 0, (GInstanceInitFunc) zeitgeist_event_instance_init, NULL };
		GType zeitgeist_event_type_id;
		zeitgeist_event_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistEvent", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_event_type_id__volatile, zeitgeist_event_type_id);
	}
	return zeitgeist_event_type_id__volatile;
}


static void _vala_zeitgeist_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistEvent * self;
	self = ZEITGEIST_EVENT (object);
	switch (property_id) {
		case ZEITGEIST_EVENT_ID:
		g_value_set_uint (value, zeitgeist_event_get_id (self));
		break;
		case ZEITGEIST_EVENT_TIMESTAMP:
		g_value_set_int64 (value, zeitgeist_event_get_timestamp (self));
		break;
		case ZEITGEIST_EVENT_INTERPRETATION:
		g_value_set_string (value, zeitgeist_event_get_interpretation (self));
		break;
		case ZEITGEIST_EVENT_MANIFESTATION:
		g_value_set_string (value, zeitgeist_event_get_manifestation (self));
		break;
		case ZEITGEIST_EVENT_ACTOR:
		g_value_set_string (value, zeitgeist_event_get_actor (self));
		break;
		case ZEITGEIST_EVENT_ORIGIN:
		g_value_set_string (value, zeitgeist_event_get_origin (self));
		break;
		case ZEITGEIST_EVENT_SUBJECTS:
		g_value_set_boxed (value, zeitgeist_event_get_subjects (self));
		break;
		case ZEITGEIST_EVENT_PAYLOAD:
		g_value_set_boxed (value, zeitgeist_event_get_payload (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistEvent * self;
	self = ZEITGEIST_EVENT (object);
	switch (property_id) {
		case ZEITGEIST_EVENT_ID:
		zeitgeist_event_set_id (self, g_value_get_uint (value));
		break;
		case ZEITGEIST_EVENT_TIMESTAMP:
		zeitgeist_event_set_timestamp (self, g_value_get_int64 (value));
		break;
		case ZEITGEIST_EVENT_INTERPRETATION:
		zeitgeist_event_set_interpretation (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_MANIFESTATION:
		zeitgeist_event_set_manifestation (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_ACTOR:
		zeitgeist_event_set_actor (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_ORIGIN:
		zeitgeist_event_set_origin (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_SUBJECTS:
		zeitgeist_event_set_subjects (self, g_value_get_boxed (value));
		break;
		case ZEITGEIST_EVENT_PAYLOAD:
		zeitgeist_event_set_payload (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GPtrArray* zeitgeist_events_from_variant (GVariant* vevents) {
	GPtrArray* result = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* events;
	GVariant* _tmp1_;
	const gchar* _tmp2_ = NULL;
	g_return_val_if_fail (vevents != NULL, NULL);
	_tmp0_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	events = _tmp0_;
	_tmp1_ = vevents;
	_tmp2_ = g_variant_get_type_string (_tmp1_);
	g_assert (g_strcmp0 (_tmp2_, "a(" ZEITGEIST_UTILS_SIG_EVENT ")") == 0);
	{
		GVariant* _tmp3_;
		GVariantIter* _tmp4_ = NULL;
		GVariantIter* _event_it;
		GVariant* event = NULL;
		_tmp3_ = vevents;
		_tmp4_ = g_variant_iter_new (_tmp3_);
		_event_it = _tmp4_;
		while (TRUE) {
			GVariantIter* _tmp5_;
			GVariant* _tmp6_ = NULL;
			GVariant* _tmp7_;
			GPtrArray* _tmp8_;
			GVariant* _tmp9_;
			ZeitgeistEvent* _tmp10_;
			_tmp5_ = _event_it;
			_tmp6_ = g_variant_iter_next_value (_tmp5_);
			_g_variant_unref0 (event);
			event = _tmp6_;
			_tmp7_ = event;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = events;
			_tmp9_ = event;
			_tmp10_ = zeitgeist_event_new_from_variant (_tmp9_);
			g_ptr_array_add (_tmp8_, _tmp10_);
		}
		_g_variant_unref0 (event);
		_g_variant_iter_free0 (_event_it);
	}
	result = events;
	return result;
}


GVariant* zeitgeist_events_to_variant (GPtrArray* events) {
	GVariant* result = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* vb;
	GVariantBuilder* _tmp23_;
	GVariant* _tmp24_ = NULL;
	GVariant* _tmp25_;
	g_return_val_if_fail (events != NULL, NULL);
	_tmp0_ = g_variant_type_new ("a(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				GPtrArray* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				GPtrArray* _tmp11_;
				gint _tmp12_;
				gconstpointer _tmp13_ = NULL;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = events;
				_tmp9_ = g_ptr_array_get_length (_tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp7_ < _tmp10_)) {
					break;
				}
				_tmp11_ = events;
				_tmp12_ = i;
				_tmp13_ = g_ptr_array_index (_tmp11_, (guint) _tmp12_);
				if (((ZeitgeistEvent*) _tmp13_) != NULL) {
					GVariantBuilder* _tmp14_;
					GPtrArray* _tmp15_;
					gint _tmp16_;
					gconstpointer _tmp17_ = NULL;
					GVariant* _tmp18_ = NULL;
					GVariant* _tmp19_;
					_tmp14_ = vb;
					_tmp15_ = events;
					_tmp16_ = i;
					_tmp17_ = g_ptr_array_index (_tmp15_, (guint) _tmp16_);
					_tmp18_ = zeitgeist_event_to_variant ((ZeitgeistEvent*) _tmp17_);
					_tmp19_ = _tmp18_;
					g_variant_builder_add_value (_tmp14_, _tmp19_);
					_g_variant_unref0 (_tmp19_);
				} else {
					GVariantBuilder* _tmp20_;
					GVariant* _tmp21_ = NULL;
					GVariant* _tmp22_;
					_tmp20_ = vb;
					_tmp21_ = zeitgeist_events_get_null_event_variant ();
					_tmp22_ = _tmp21_;
					g_variant_builder_add_value (_tmp20_, _tmp22_);
					_g_variant_unref0 (_tmp22_);
				}
			}
		}
	}
	_tmp23_ = vb;
	_tmp24_ = g_variant_builder_end (_tmp23_);
	_tmp25_ = g_variant_ref_sink (_tmp24_);
	result = _tmp25_;
	_g_variant_builder_unref0 (vb);
	return result;
}


GVariant* zeitgeist_events_get_null_event_variant (void) {
	GVariant* result = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* vb;
	GVariantType* _tmp4_;
	GVariantType* _tmp5_;
	GVariantType* _tmp6_;
	GVariantType* _tmp7_;
	GVariantType* _tmp8_;
	GVariantType* _tmp9_;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_;
	_tmp0_ = g_variant_type_new ("(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = g_variant_type_new ("as");
	_tmp5_ = _tmp4_;
	g_variant_builder_open (vb, _tmp5_);
	_g_variant_type_free0 (_tmp5_);
	g_variant_builder_close (vb);
	_tmp6_ = g_variant_type_new ("aas");
	_tmp7_ = _tmp6_;
	g_variant_builder_open (vb, _tmp7_);
	_g_variant_type_free0 (_tmp7_);
	g_variant_builder_close (vb);
	_tmp8_ = g_variant_type_new ("ay");
	_tmp9_ = _tmp8_;
	g_variant_builder_open (vb, _tmp9_);
	_g_variant_type_free0 (_tmp9_);
	g_variant_builder_close (vb);
	_tmp10_ = g_variant_builder_end (vb);
	_tmp11_ = g_variant_ref_sink (_tmp10_);
	result = _tmp11_;
	_g_variant_builder_unref0 (vb);
	return result;
}


ZeitgeistSubject* zeitgeist_subject_construct_from_variant (GType object_type, GVariant* subject_variant) {
	ZeitgeistSubject * self = NULL;
	GVariant* _tmp0_;
	GVariantIter* _tmp1_ = NULL;
	GVariantIter* iter;
	GVariantIter* _tmp2_;
	gsize _tmp3_ = 0UL;
	gsize subject_props;
	gsize _tmp4_;
	GVariantIter* _tmp5_;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_;
	const gchar* _tmp8_ = NULL;
	GVariantIter* _tmp9_;
	GVariant* _tmp10_ = NULL;
	GVariant* _tmp11_;
	const gchar* _tmp12_ = NULL;
	GVariantIter* _tmp13_;
	GVariant* _tmp14_ = NULL;
	GVariant* _tmp15_;
	const gchar* _tmp16_ = NULL;
	GVariantIter* _tmp17_;
	GVariant* _tmp18_ = NULL;
	GVariant* _tmp19_;
	const gchar* _tmp20_ = NULL;
	GVariantIter* _tmp21_;
	GVariant* _tmp22_ = NULL;
	GVariant* _tmp23_;
	const gchar* _tmp24_ = NULL;
	GVariantIter* _tmp25_;
	GVariant* _tmp26_ = NULL;
	GVariant* _tmp27_;
	const gchar* _tmp28_ = NULL;
	GVariantIter* _tmp29_;
	GVariant* _tmp30_ = NULL;
	GVariant* _tmp31_;
	const gchar* _tmp32_ = NULL;
	gsize _tmp33_;
	g_return_val_if_fail (subject_variant != NULL, NULL);
	self = (ZeitgeistSubject*) g_object_new (object_type, NULL);
	_tmp0_ = subject_variant;
	_tmp1_ = g_variant_iter_new (_tmp0_);
	iter = _tmp1_;
	_tmp2_ = iter;
	_tmp3_ = g_variant_iter_n_children (_tmp2_);
	subject_props = _tmp3_;
	_tmp4_ = subject_props;
	g_assert (_tmp4_ >= ((gsize) 7));
	_tmp5_ = iter;
	_tmp6_ = g_variant_iter_next_value (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_get_string (_tmp7_, NULL);
	zeitgeist_subject_set_uri (self, _tmp8_);
	_g_variant_unref0 (_tmp7_);
	_tmp9_ = iter;
	_tmp10_ = g_variant_iter_next_value (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_variant_get_string (_tmp11_, NULL);
	zeitgeist_subject_set_interpretation (self, _tmp12_);
	_g_variant_unref0 (_tmp11_);
	_tmp13_ = iter;
	_tmp14_ = g_variant_iter_next_value (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_variant_get_string (_tmp15_, NULL);
	zeitgeist_subject_set_manifestation (self, _tmp16_);
	_g_variant_unref0 (_tmp15_);
	_tmp17_ = iter;
	_tmp18_ = g_variant_iter_next_value (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_variant_get_string (_tmp19_, NULL);
	zeitgeist_subject_set_origin (self, _tmp20_);
	_g_variant_unref0 (_tmp19_);
	_tmp21_ = iter;
	_tmp22_ = g_variant_iter_next_value (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_variant_get_string (_tmp23_, NULL);
	zeitgeist_subject_set_mimetype (self, _tmp24_);
	_g_variant_unref0 (_tmp23_);
	_tmp25_ = iter;
	_tmp26_ = g_variant_iter_next_value (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_variant_get_string (_tmp27_, NULL);
	zeitgeist_subject_set_text (self, _tmp28_);
	_g_variant_unref0 (_tmp27_);
	_tmp29_ = iter;
	_tmp30_ = g_variant_iter_next_value (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_variant_get_string (_tmp31_, NULL);
	zeitgeist_subject_set_storage (self, _tmp32_);
	_g_variant_unref0 (_tmp31_);
	_tmp33_ = subject_props;
	if (_tmp33_ >= ((gsize) 8)) {
		GVariantIter* _tmp34_;
		GVariant* _tmp35_ = NULL;
		GVariant* _tmp36_;
		const gchar* _tmp37_ = NULL;
		_tmp34_ = iter;
		_tmp35_ = g_variant_iter_next_value (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_variant_get_string (_tmp36_, NULL);
		zeitgeist_subject_set_current_uri (self, _tmp37_);
		_g_variant_unref0 (_tmp36_);
	} else {
		zeitgeist_subject_set_current_uri (self, "");
	}
	_g_variant_iter_free0 (iter);
	return self;
}


ZeitgeistSubject* zeitgeist_subject_new_from_variant (GVariant* subject_variant) {
	return zeitgeist_subject_construct_from_variant (ZEITGEIST_TYPE_SUBJECT, subject_variant);
}


GVariant* zeitgeist_subject_to_variant (ZeitgeistSubject* self) {
	GVariant* result = NULL;
	gchar* ptr_arr[8] = {0};
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_ = NULL;
	const gchar* _tmp36_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	GVariant* _tmp40_;
	GVariant* _tmp41_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_uri;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_uri;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	ptr_arr[0] = _tmp3_;
	_tmp4_ = ptr_arr[0];
	_tmp6_ = self->priv->_interpretation;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = self->priv->_interpretation;
		_tmp5_ = _tmp7_;
	} else {
		_tmp5_ = "";
	}
	_tmp8_ = _tmp5_;
	ptr_arr[1] = _tmp8_;
	_tmp9_ = ptr_arr[1];
	_tmp11_ = self->priv->_manifestation;
	if (_tmp11_ != NULL) {
		const gchar* _tmp12_;
		_tmp12_ = self->priv->_manifestation;
		_tmp10_ = _tmp12_;
	} else {
		_tmp10_ = "";
	}
	_tmp13_ = _tmp10_;
	ptr_arr[2] = _tmp13_;
	_tmp14_ = ptr_arr[2];
	_tmp16_ = self->priv->_origin;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		_tmp17_ = self->priv->_origin;
		_tmp15_ = _tmp17_;
	} else {
		_tmp15_ = "";
	}
	_tmp18_ = _tmp15_;
	ptr_arr[3] = _tmp18_;
	_tmp19_ = ptr_arr[3];
	_tmp21_ = self->priv->_mimetype;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		_tmp22_ = self->priv->_mimetype;
		_tmp20_ = _tmp22_;
	} else {
		_tmp20_ = "";
	}
	_tmp23_ = _tmp20_;
	ptr_arr[4] = _tmp23_;
	_tmp24_ = ptr_arr[4];
	_tmp26_ = self->priv->_text;
	if (_tmp26_ != NULL) {
		const gchar* _tmp27_;
		_tmp27_ = self->priv->_text;
		_tmp25_ = _tmp27_;
	} else {
		_tmp25_ = "";
	}
	_tmp28_ = _tmp25_;
	ptr_arr[5] = _tmp28_;
	_tmp29_ = ptr_arr[5];
	_tmp31_ = self->priv->_storage;
	if (_tmp31_ != NULL) {
		const gchar* _tmp32_;
		_tmp32_ = self->priv->_storage;
		_tmp30_ = _tmp32_;
	} else {
		_tmp30_ = "";
	}
	_tmp33_ = _tmp30_;
	ptr_arr[6] = _tmp33_;
	_tmp34_ = ptr_arr[6];
	_tmp36_ = self->priv->_current_uri;
	if (_tmp36_ != NULL) {
		const gchar* _tmp37_;
		_tmp37_ = self->priv->_current_uri;
		_tmp35_ = _tmp37_;
	} else {
		_tmp35_ = "";
	}
	_tmp38_ = _tmp35_;
	ptr_arr[7] = _tmp38_;
	_tmp39_ = ptr_arr[7];
	_tmp40_ = g_variant_new_strv ((gchar**) ptr_arr, 8);
	_tmp41_ = g_variant_ref_sink (_tmp40_);
	result = _tmp41_;
	return result;
}


gboolean zeitgeist_subject_matches_template (ZeitgeistSubject* self, ZeitgeistSubject* template_subject) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	ZeitgeistSubject* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	ZeitgeistSubject* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	ZeitgeistSubject* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	ZeitgeistSubject* _tmp13_;
	const gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	ZeitgeistSubject* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_;
	ZeitgeistSubject* _tmp21_;
	const gchar* _tmp22_;
	gboolean _tmp23_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (template_subject != NULL, FALSE);
	_tmp0_ = self->priv->_uri;
	_tmp1_ = template_subject;
	_tmp2_ = _tmp1_->priv->_uri;
	_tmp3_ = zeitgeist_check_field_match (_tmp0_, _tmp2_, FALSE, TRUE);
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_current_uri;
	_tmp5_ = template_subject;
	_tmp6_ = _tmp5_->priv->_current_uri;
	_tmp7_ = zeitgeist_check_field_match (_tmp4_, _tmp6_, FALSE, TRUE);
	if (!_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = self->priv->_interpretation;
	_tmp9_ = template_subject;
	_tmp10_ = _tmp9_->priv->_interpretation;
	_tmp11_ = zeitgeist_check_field_match (_tmp8_, _tmp10_, TRUE, FALSE);
	if (!_tmp11_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = self->priv->_manifestation;
	_tmp13_ = template_subject;
	_tmp14_ = _tmp13_->priv->_manifestation;
	_tmp15_ = zeitgeist_check_field_match (_tmp12_, _tmp14_, TRUE, FALSE);
	if (!_tmp15_) {
		result = FALSE;
		return result;
	}
	_tmp16_ = self->priv->_origin;
	_tmp17_ = template_subject;
	_tmp18_ = _tmp17_->priv->_origin;
	_tmp19_ = zeitgeist_check_field_match (_tmp16_, _tmp18_, FALSE, TRUE);
	if (!_tmp19_) {
		result = FALSE;
		return result;
	}
	_tmp20_ = self->priv->_mimetype;
	_tmp21_ = template_subject;
	_tmp22_ = _tmp21_->priv->_mimetype;
	_tmp23_ = zeitgeist_check_field_match (_tmp20_, _tmp22_, FALSE, TRUE);
	if (!_tmp23_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


ZeitgeistSubject* zeitgeist_subject_construct (GType object_type) {
	ZeitgeistSubject * self = NULL;
	self = (ZeitgeistSubject*) g_object_new (object_type, NULL);
	return self;
}


ZeitgeistSubject* zeitgeist_subject_new (void) {
	return zeitgeist_subject_construct (ZEITGEIST_TYPE_SUBJECT);
}


const gchar* zeitgeist_subject_get_uri (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_uri (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp1_;
	g_object_notify ((GObject *) self, "uri");
}


const gchar* zeitgeist_subject_get_interpretation (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_interpretation;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_interpretation (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_interpretation);
	self->priv->_interpretation = _tmp1_;
	g_object_notify ((GObject *) self, "interpretation");
}


const gchar* zeitgeist_subject_get_manifestation (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manifestation;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_manifestation (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_manifestation);
	self->priv->_manifestation = _tmp1_;
	g_object_notify ((GObject *) self, "manifestation");
}


const gchar* zeitgeist_subject_get_mimetype (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mimetype;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_mimetype (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mimetype);
	self->priv->_mimetype = _tmp1_;
	g_object_notify ((GObject *) self, "mimetype");
}


const gchar* zeitgeist_subject_get_origin (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_origin;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_origin (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_origin);
	self->priv->_origin = _tmp1_;
	g_object_notify ((GObject *) self, "origin");
}


const gchar* zeitgeist_subject_get_text (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_text (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_text);
	self->priv->_text = _tmp1_;
	g_object_notify ((GObject *) self, "text");
}


const gchar* zeitgeist_subject_get_storage (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_storage;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_storage (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_storage);
	self->priv->_storage = _tmp1_;
	g_object_notify ((GObject *) self, "storage");
}


const gchar* zeitgeist_subject_get_current_uri (ZeitgeistSubject* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_uri;
	result = _tmp0_;
	return result;
}


void zeitgeist_subject_set_current_uri (ZeitgeistSubject* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_current_uri);
	self->priv->_current_uri = _tmp1_;
	g_object_notify ((GObject *) self, "current-uri");
}


static void zeitgeist_subject_class_init (ZeitgeistSubjectClass * klass) {
	zeitgeist_subject_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistSubjectPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_subject_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_subject_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_subject_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_INTERPRETATION, g_param_spec_string ("interpretation", "interpretation", "interpretation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_MANIFESTATION, g_param_spec_string ("manifestation", "manifestation", "manifestation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_MIMETYPE, g_param_spec_string ("mimetype", "mimetype", "mimetype", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_ORIGIN, g_param_spec_string ("origin", "origin", "origin", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_STORAGE, g_param_spec_string ("storage", "storage", "storage", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_SUBJECT_CURRENT_URI, g_param_spec_string ("current-uri", "current-uri", "current-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void zeitgeist_subject_instance_init (ZeitgeistSubject * self) {
	self->priv = ZEITGEIST_SUBJECT_GET_PRIVATE (self);
}


static void zeitgeist_subject_finalize (GObject* obj) {
	ZeitgeistSubject * self;
	self = ZEITGEIST_SUBJECT (obj);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_interpretation);
	_g_free0 (self->priv->_manifestation);
	_g_free0 (self->priv->_mimetype);
	_g_free0 (self->priv->_origin);
	_g_free0 (self->priv->_text);
	_g_free0 (self->priv->_storage);
	_g_free0 (self->priv->_current_uri);
	G_OBJECT_CLASS (zeitgeist_subject_parent_class)->finalize (obj);
}


GType zeitgeist_subject_get_type (void) {
	static volatile gsize zeitgeist_subject_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_subject_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSubjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_subject_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSubject), 0, (GInstanceInitFunc) zeitgeist_subject_instance_init, NULL };
		GType zeitgeist_subject_type_id;
		zeitgeist_subject_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistSubject", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_subject_type_id__volatile, zeitgeist_subject_type_id);
	}
	return zeitgeist_subject_type_id__volatile;
}


static void _vala_zeitgeist_subject_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistSubject * self;
	self = ZEITGEIST_SUBJECT (object);
	switch (property_id) {
		case ZEITGEIST_SUBJECT_URI:
		g_value_set_string (value, zeitgeist_subject_get_uri (self));
		break;
		case ZEITGEIST_SUBJECT_INTERPRETATION:
		g_value_set_string (value, zeitgeist_subject_get_interpretation (self));
		break;
		case ZEITGEIST_SUBJECT_MANIFESTATION:
		g_value_set_string (value, zeitgeist_subject_get_manifestation (self));
		break;
		case ZEITGEIST_SUBJECT_MIMETYPE:
		g_value_set_string (value, zeitgeist_subject_get_mimetype (self));
		break;
		case ZEITGEIST_SUBJECT_ORIGIN:
		g_value_set_string (value, zeitgeist_subject_get_origin (self));
		break;
		case ZEITGEIST_SUBJECT_TEXT:
		g_value_set_string (value, zeitgeist_subject_get_text (self));
		break;
		case ZEITGEIST_SUBJECT_STORAGE:
		g_value_set_string (value, zeitgeist_subject_get_storage (self));
		break;
		case ZEITGEIST_SUBJECT_CURRENT_URI:
		g_value_set_string (value, zeitgeist_subject_get_current_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_subject_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistSubject * self;
	self = ZEITGEIST_SUBJECT (object);
	switch (property_id) {
		case ZEITGEIST_SUBJECT_URI:
		zeitgeist_subject_set_uri (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_INTERPRETATION:
		zeitgeist_subject_set_interpretation (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_MANIFESTATION:
		zeitgeist_subject_set_manifestation (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_MIMETYPE:
		zeitgeist_subject_set_mimetype (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_ORIGIN:
		zeitgeist_subject_set_origin (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_TEXT:
		zeitgeist_subject_set_text (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_STORAGE:
		zeitgeist_subject_set_storage (self, g_value_get_string (value));
		break;
		case ZEITGEIST_SUBJECT_CURRENT_URI:
		zeitgeist_subject_set_current_uri (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



