/*
		       MIDI IO Wrapper Functions
 */

#ifndef MIDIIOW_H
#define MIDIIOW_H

#include <sys/types.h>


/*
 *	MIDI device settings and resources, used in the Audio
 *	structure (see ysound.h).
 */
typedef struct {

	/* Pointer to external MIDI device module resources. */
	void *ptr;

#ifdef ALSA_RUN_CONFORM
	/* ALSA MIDI device port number (needed by libkmid). */
	int midi_device_number;
#endif	/* ALSA_RUN_CONFORM */

} MIDIAudio;


extern int MIDIIOWInit(MIDIAudio *midi_audio);
extern pid_t MIDIIOWPlay(MIDIAudio *midi_audio, const char *path);
extern void MIDIIOWStop(MIDIAudio *midi_audio);
extern pid_t MIDIIOWIsPlaying(MIDIAudio *midi_audio);
extern void MIDIIOWShutdown(MIDIAudio *midi_audio);


#endif	/* MIDIIOW_H */
