/* <<< Start of information >>>                                             */
/* This file is part of the xwatch package.                                 */
/* Copyright (C) 1995 Karel Kubat.  All rights reserved.                    */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */
#include "xwatch.h"

#ifndef RGB_FILE
#define RGB_FILE "/usr/lib/X11/rgb.txt"
#endif

int colorname2rgb (char *name, int *r, int *g, int *b)
{
    FILE 
        *fp = NULL;
    char 
        dummy[256],
	line [256];
    int 
        red,
	green,
	blue,
	retval = 0;
        
    if (! name || ! *name)                      /* need a real name arg */
        return (0);
    
    if (! (fp = fopen(RGB_FILE, "r")) )         /* open database file */
    {
        warning ("Cannot read RGB database %s", RGB_FILE);
        warning ("(%s)", strerror (errno));
        return (0);
    }
        
    while (1)                                   /* scan whole file */
    {
        fgets (line, 256, fp);                  /* read one line */
        if (feof (fp))                          /* eof? done.. */
        {
            warning ("Couldn't find color %s in RGB database %s", 
	             name, RGB_FILE);
            break;
        }
                  
        /* convert to number number number name */
        if (sscanf (line, "%d %d %d %[^\n]", &red, &green, &blue, dummy) > 3)
        {
            while (isspace (dummy[0])) 
	        strcpy (dummy, dummy + 1);
            if (! strcasecmp (dummy, name))
            {
                *r = red;
                *g = green;
                *b = blue;
                retval = 1;
                break;
            }
        }
    }
    
    fclose (fp);
    return (retval);
}
