/* --------------------------------------------------------------------------
 * ``SPARCstation'' specific audio driver interface. (very poor)
 * (SunOS and Solaris)
 * --------------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef AUDIODRIVERSUN_H
#define AUDIODRIVERSUN_H

#include "AudioBase.h"

class AudioDriverSun : public AudioBase
{
	
 public:  // --------------------------------------------------------- public

    AudioDriverSun();
    ~AudioDriverSun();

    bool open(const AudioConfig&);
	
    // Free and close opened audio device and reset any variables that
    // reflect the current state of the driver.
    void close();
   
    void unload();
	
    void play(void* buffer, unsigned long int bufferSize);

    bool reset();
	
    const char* getName() const
    {
        return "Sun Audio";
    }
   
 private:  // ------------------------------------------------------- private

    static const char AUDIODEVICE[];
    int audioHd;
	
    void outOfOrder();
	
    // Check device availability and write permissions.
    bool isThere();
};

#endif  /* AUDIODRIVER_H */

