/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "PicButton.h"

#include <qpainter.h>
#include <qpixmap.h>

PicButton::PicButton(QWidget* parent, const char* name)
: QButton(parent,name)
{
    pixmap = 0;
}

PicButton::~PicButton()
{
    delete pixmap;
}

void PicButton::drawButton(QPainter* painter)
{
    if (pixmap != 0)
        painter->drawPixmap(0,0,*pixmap);
}

void PicButton::setPixmap(const QPixmap & newPixmap)
{
    if (pixmap != 0)
        delete pixmap;
    pixmap = new QPixmap(newPixmap);
    repaint(false);
}
