/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <qfiledialog.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>

#include "HVSC_Dialog.h"
#include "GlobalIcon.h"

HVSC_Dialog::HVSC_Dialog(QWidget* parent, const char* name)
: HVSC_DialogData(parent,name)
{
    setIcon(*mainIcon);
    setButtons();
}

void HVSC_Dialog::setConfig(const HVSC_Config& inConfig)
{
    config = inConfig;
    backupConfig = inConfig;
    setButtons();
}

const HVSC_Config& HVSC_Dialog::getConfig() const
{
    return config;
}

void HVSC_Dialog::setButtons()
{
    hvscPathLineEdit->setText(config.hvscRootPath.path());
    globalCommentBox->setChecked(config.showGlobalComments);
    stilEntryBox->setChecked(config.showStilEntries);
    bugListEntryBox->setChecked(config.showBugListEntries);
    showCurrentSongBtn->setChecked(config.showForCurrentSong);
    showFileBtn->setChecked(config.showForFile);
    autoResizeBtn->setChecked(config.autoResize);
    maxHeightLineEdit->setText(config.maxHeight);
}

void HVSC_Dialog::okButtonClicked()
{
    hide();
    config.hvscRootPath.setPath(hvscPathLineEdit->text());
    config.showGlobalComments = globalCommentBox->isChecked();
    config.showStilEntries = stilEntryBox->isChecked();
    config.showBugListEntries = bugListEntryBox->isChecked();
    config.showForCurrentSong = showCurrentSongBtn->isChecked();
    config.showForFile = showFileBtn->isChecked();
    config.autoResize = autoResizeBtn->isChecked();
    config.maxHeight = maxHeightLineEdit->text();
    backupConfig = config;
    setButtons();
    emit changed(config);
}

void HVSC_Dialog::cancelButtonClicked()
{
    hide();
    config = backupConfig;
    setButtons();
}

void HVSC_Dialog::browseButtonClicked()
{
    QString dirName = 
        QFileDialog::getExistingDirectory(hvscPathLineEdit->text(),this,0,
                                          "Select HVSC root directory");
    if ( !dirName.isEmpty() )
        hvscPathLineEdit->setText(dirName);
}
