// file      : xsde/cxx/serializer/validating/name.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/pre.hxx>

#include <xsde/cxx/xml/char-table.hxx>

#include <xsde/cxx/serializer/validating/name.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace serializer
    {
      namespace validating
      {
        void name_simpl::
        _serialize_content ()
        {
          const char* s = value_;
          bool ok = (*s != '\0');

          // For now we are only checking the US-ASCII characters.
          //
          if (ok)
          {
            // First character.
            //
            unsigned char c = static_cast<unsigned char> (*s);

            ok = c >= 0x80 || (xml::char_table[c] & xml::name_first_char_mask);

            for (++s; ok && *s != '\0'; ++s)
            {
              c = static_cast<unsigned char> (*s);

              if (c < 0x80 && !(xml::char_table[c] & xml::name_char_mask))
                ok = false;
            }
          }

          if (ok)
            _characters (value_);
          else
            _schema_error (schema_error::invalid_name_value);

          if (free_)
          {
            delete[] const_cast<char*> (value_);
            value_ = 0;
          }
        }
      }
    }
  }
}

#include <xsde/cxx/post.hxx>
