// file      : xsde/cxx/serializer/context.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/config.hxx>

#ifdef XSDE_EXCEPTIONS
#  include <new> // std::bad_alloc
#  include <xsde/cxx/serializer/exceptions.hxx>
#endif

#include <xsde/cxx/serializer/context.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace serializer
    {
#ifdef XSDE_EXCEPTIONS
      void context::
      throw_xml_error (genx::xml_error e)
      {
        switch (e)
        {
        case GENX_ALLOC_FAILED:
          {
            throw std::bad_alloc ();
          }
        case GENX_IO_ERROR:
          {
            // This should never happen with consistent exception
            // handling usage since the write/flush functions
            // throw exceptions to indicate write failures.
            //
            throw xml (e);
          }
        default:
          {
            throw xml (e);
          }
        }
      }
#endif
    }
  }
}
