// file      : xsd-frontend/semantic-graph/schema.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2008 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsd-frontend/semantic-graph/schema.hxx>

namespace XSDFrontend
{
  namespace SemanticGraph
  {
    namespace RTTI = Cult::RTTI;

    using RTTI::Access;
    using RTTI::TypeInfo;

    namespace
    {
      // Uses
      //
      struct UsesInit
      {
        UsesInit ()
        {
          TypeInfo ti (typeid (Uses));
          ti.add_base (Access::public_, true, typeid (Edge));
          RTTI::insert (ti);
        }

      } uses_init_;


      // Implies
      //
      struct ImpliesInit
      {
        ImpliesInit ()
        {
          TypeInfo ti (typeid (Implies));
          ti.add_base (Access::public_, true, typeid (Uses));
          RTTI::insert (ti);
        }

      } implies_init_;


      // Sources
      //
      struct SourcesInit
      {
        SourcesInit ()
        {
          TypeInfo ti (typeid (Sources));
          ti.add_base (Access::public_, true, typeid (Uses));
          RTTI::insert (ti);
        }

      } sources_init_;


      // Includes
      //
      struct IncludesInit
      {
        IncludesInit ()
        {
          TypeInfo ti (typeid (Includes));
          ti.add_base (Access::public_, true, typeid (Uses));
          RTTI::insert (ti);
        }

      } includes_init_;


      // Imports
      //
      struct ImportsInit
      {
        ImportsInit ()
        {
          TypeInfo ti (typeid (Imports));
          ti.add_base (Access::public_, true, typeid (Uses));
          RTTI::insert (ti);
        }

      } imports_init_;


      // Schema
      //
      struct SchemaInit
      {
        SchemaInit ()
        {
          TypeInfo ti (typeid (Schema));
          ti.add_base (Access::public_, true, typeid (Scope));
          RTTI::insert (ti);
        }

      } schema_init_;
    }


    // Schema
    //

    Schema::NamesIteratorPair Schema::
    find (Name const& name) const
    {
      // Here we are going to create an illusion that
      // the namespace hierarchy is flat.

      names_.clear ();

      // Check our own namespace first so it will end up first in the list.
      //
      NamesIteratorPair pair (Scope::find (name));
      names_.insert (names_.end (), pair.first.base (), pair.second.base ());

      for (UsesIterator i (uses_begin ()), end (uses_end ()); i != end; ++i)
      {
        Schema& s (i->schema ());

        if (!s.context ().count ("schema::find::seen"))
        {
          s.context ().set ("schema::find::seen", true);
          pair  = s.find (name);
          s.context ().remove ("schema::find::seen");

          names_.insert (
            names_.end (), pair.first.base (), pair.second.base ());
        }
      }

      return NamesIteratorPair (NamesConstIterator (names_.begin ()),
                                NamesConstIterator (names_.end ()));
    }
  }
}
