// file      : xsd-frontend/semantic-graph/particle.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2006-2008 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSD_FRONTEND_SEMANTIC_GRAPH_PARTICLE_HXX
#define XSD_FRONTEND_SEMANTIC_GRAPH_PARTICLE_HXX

#include <xsd-frontend/semantic-graph/elements.hxx>

namespace XSDFrontend
{
  namespace SemanticGraph
  {
    //
    //
    class ContainsParticle;

    //
    //
    class Particle: public virtual Node
    {
    public:
      Boolean
      contained_particle_p ()
      {
        return contained_particle_ != 0;
      }

      ContainsParticle&
      contained_particle ()
      {
        assert (contained_particle_ != 0);
        return *contained_particle_;
      }

    protected:
      friend class Bits::Graph<Node, Edge>;

      Particle ();

      Void
      add_edge_right (ContainsParticle& e);

    private:
      ContainsParticle* contained_particle_;
    };
  }
}

#endif  // XSD_FRONTEND_SEMANTIC_GRAPH_PARTICLE_HXX
