/*
 *  Copyright (c) 2006 Jean-François Wauthy (pollux@xfce.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PRINT_DIALOG_H
#define PRINT_DIALOG_H

#include <gtk/gtk.h>

G_BEGIN_DECLS
#define PRINT_DIALOG_TYPE         (print_dialog_get_type ())
#define PRINT_DIALOG(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), PRINT_DIALOG_TYPE, PrintDialog))
#define PRINT_DIALOG_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), PRINT_DIALOG_TYPE, PrintDialogClass))
#define PRINT_IS_DIALOG(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), PRINT_DIALOG_TYPE))
#define PRINT_IS_DIALOG_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), PRINT_DIALOG_TYPE))
#define PRINT_DIALOG_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), PRINT_DIALOG_TYPE, PrintDialogClass))
typedef struct PrintDialogPrivate PrintDialogPrivate;

typedef struct
{
  GtkDialog parent;
  
  PrintDialogPrivate *priv;
} PrintDialog;

typedef struct
{
  GtkDialogClass parent_class;
} PrintDialogClass;

GType print_dialog_get_type ();

GtkWidget *print_dialog_new (PrintingSystem *ps, const gchar *input_file);

G_END_DECLS
#endif /* PRINT_DIALOG_H */
