/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XFMEDIA_REMOTE_COMMON_H__
#define __XFMEDIA_REMOTE_COMMON_H__

#include <glib.h>

G_BEGIN_DECLS

#define XFMEDIA_REMOTE_IS_RUNNING         "Ping"
#define XFMEDIA_REMOTE_CLEAR_PLAYLIST     "ClearPlaylist"
#define XFMEDIA_REMOTE_LOAD_PLAYLIST      "LoadPlaylist"
#define XFMEDIA_REMOTE_SAVE_PLAYLIST      "SavePlaylist"
#define XFMEDIA_REMOTE_GET_PLAYLIST_ENTRY "GetPlaylistEntry"
#define XFMEDIA_REMOTE_GET_PLAYLIST       "GetPlaylist"
#define XFMEDIA_REMOTE_ADD_FILE           "AddFile"
#define XFMEDIA_REMOTE_REMOVE_FILE        "RemoveFile"
#define XFMEDIA_REMOTE_PLAY               "Play"
#define XFMEDIA_REMOTE_PAUSE              "Pause"
#define XFMEDIA_REMOTE_TOGGLE_PLAY        "TogglePlay"
#define XFMEDIA_REMOTE_STOP               "Stop"
#define XFMEDIA_REMOTE_PREV               "Prev"
#define XFMEDIA_REMOTE_NEXT               "Next"
#define XFMEDIA_REMOTE_QUIT               "Quit"
#define XFMEDIA_REMOTE_NOW_PLAYING        "NowPlaying"

#define XFMEDIA_REMOTE_TRIGGER_JTF        "TriggerJumpToFile"

typedef enum {
    XFMEDIA_REMOTE_UNKNOWN_ERROR     = -6,
	XFMEDIA_REMOTE_NO_SESSION_BUS    = -5,
	XFMEDIA_REMOTE_NO_INSTANCE       = -4,
    XFMEDIA_REMOTE_BAD_ARGUMENTS     = -3,
	XFMEDIA_REMOTE_BAD_COMMAND       = -2,
	XFMEDIA_REMOTE_COMMAND_FAILED    = -1,
	XFMEDIA_REMOTE_COMMAND_SUCCEEDED =  0
} XfmediaRemoteStatus;

#define MAX_INSTANCES             1024
#define XFMEDIA_DBUS_VERSION      "1"
#define XFMEDIA_DBUS_BASENAME     "org.spuriousinterrupt.Xfmedia"
#define XFMEDIA_DBUS_INTERFACE    XFMEDIA_DBUS_BASENAME XFMEDIA_DBUS_VERSION
#define XFMEDIA_DBUS_SERVICE_FMT  XFMEDIA_DBUS_BASENAME "%d"
#define XFMEDIA_DBUS_ERROR        XFMEDIA_DBUS_BASENAME XFMEDIA_DBUS_VERSION ".Error"
#define XFMEDIA_DBUS_PATH_FMT     "/org/spuriousinterrupt/Xfmedia/%d"

G_END_DECLS

#endif
