/* xfkc.h
 * Copyright (C) 2006 Gauvain Pocentek <gauvainpocentek@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef __XFKC_H__
#define __XFKC_H__

#include <gtk/gtk.h>
#include <libxklavier/xklavier.h>
#include <libxfce4util/libxfce4util.h>

// Structs
typedef struct _xfkcConfig
{
	int use_X_config; // 1 if we use the default xserver conf, 0 if we use custom settings
	
	gchar *model;
	gchar *layouts;
	gchar *variants;
} xfkcConfig;

xfkcConfig * xfkc_settings;

// Variables
Display * dsp;
gchar * config_file;
XfceRc * rc_file;
XklEngine * engine;
XklConfigRegistry * registry;
XklConfigRec *user_rec_config;

// Functions
void define_dialog ();
void read_settings_in_rc_file ();
void write_settings_in_rc_file ();

#endif
