/**************************************************
 holiday.c -- Copyright(c) 1999 Jiro Sekiba <jir@hello.to>
 **************************************************/
#include <time.h>

/* default */
int C_holiday(int year, int month , int day)
{
  return 0;
}

/* holidays of  Japan */
int ja_JP_holiday(int year,int month,int day)
{
  if(month == 1 && day == 1) /* new year */
      return 1;
  else if(month == 2 && day == 11) /* Kenkoku Kinenbi */
      return 1;
  else if(month == 4 && day == 29) /* Midori no hi */
      return 1;
  else if(month == 5 && day == 3) /* Kenpo Kinenbi */
      return 1;
  else if(month == 5 && day == 4) /* Kokumin no kyujitsu */
      return 1;
  else if(month == 5 && day == 5) /* Kodomo no hi */
      return 1;
  else if(month == 7 && day == 20) /* Umi no hi */
      return 1;
  else if(month == 9 && day == 15) /* Keiro no hi */
      return 1;
  else if(month == 11 && day == 3) /* Bunka no hi */
      return 1;
  else if(month == 11 && day == 23) /* Kinro Kansha no hi */
      return 1; 
  else if(month == 12 && day == 23) /* Tenno Tanjobi */
      return 1;
  else if(month == 3 && 1980 < year && year < 2099 )
  {                                 /* shunbun no hi */
    int x;                          /* This is lazy calculation */

    x = (int)(20.8431+0.242194*(year-1980) - (int)((year-1980)/4));
    if(day == x)
        return 1;
    else
        return 0;
  }
  else if(month == 9 && 1980 < year && year < 2099 )
  {                                /* shubun no hi */
    int x;                         /* This is lazy calculation */

    x = (int)(23.2488+0.242194*(year-1980) - (int)((year-1980)/4));
    if(day == x)
        return 1;
    else
        return 0;
  }
  else if( (month == 1 || month == 10) && 7 < day && day < 14)
  {                           /* seijin no hi -- 2nd Monday of January
                                 taiku no hi  -- 2nd Monday of October*/
    time_t t;                 
    struct tm lt;
    struct tm *llt;
    
    time(&t);
    llt = localtime(&t);
    
    lt.tm_year = year - 1900;
    lt.tm_mon = month -1;
    lt.tm_mday = day;
    lt.tm_sec = 0;
    lt.tm_min = 0;
    lt.tm_hour = 0;
    
    t = mktime(&lt);
    llt = localtime(&t);

    if (llt->tm_wday == 1) /* if 2nd monday */
        return 1;
    else
        return 0;
  }
  return 0;
} /* end  ja_JP_holiday */

/* holidays of  Spain */
int es_ES_holiday(int year,int month,int day)
{
  if(month == 1 && day == 1) /* new year */
      return 1;
  else if(month == 1 && day == 6) /* Epiphany (the Magi feast) */
      return 1;
  else if(month == 5 && day == 1) /* Labour Day */
      return 1;
  else if(month == 10 && day == 12)/*Columbus Day (fiesta de la Hispanidad)*/
      return 1;
  else if(month == 11 && day == 1) /* Saint's Day */
      return 1;
  else if(month == 12 && day == 6) /* Spanish Constitution Day */
      return 1;
  else if(month == 12 && day == 9) /* the Inmaculate Conception */
      return 1;
  else if(month == 12 && day == 25) /* Christmas Day */
      return 1;
  return 0;
} /* end  es_ES_holiday */
