 /*
 *  file      : main.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifdef HAVE_CONFIG_H
	#include "../config.h"
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
// /usr/include/gtk-2.0/gdk/gdkkeysyms.h
#include <gdk/gdkkeysyms.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <unistd.h>
#include <sys/types.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "options.h"
#include "configuser.h"
#include "file.h"
#include "notify_send.h"
#include "parse.h"
#include "scan.h"
#include "cd_audio.h"
#include "dvd.h"
#include "web.h"
#include "poche.h"
#include "treeview.h"
#include "get_info.h"
#include "mplayer.h"
#include "win_about.h"
#include "process.h"
#include "split.h"
#include "alsa_play.h"
#include "win_info.h"
#include "popup_systray.h"
#include "statusbar.h"
#include "cd_curl.h"
#include "global.h"

// FIXME
// TODO

GtkBuilder	*GtkXcfaProjet = NULL;
GtkWidget	*WindMain = NULL;
HOST_CONF	 HostConf;
GtkWidget	*AdrLabelStatusbarGlobal = NULL;

KEYS keys = {
	FALSE,		// gboolean	BoolGDKPress
	FALSE,		// gboolean	BoolGDK_Control_L_R
	FALSE,		// gboolean	BoolGDK_Control_A
	0,		// guint	keyval
};


// 
// 
void on_label_statusbar_global_realize (GtkWidget *widget, gpointer user_data)
{
	AdrLabelStatusbarGlobal = widget;
}
// -RECUPERATION DES DATAS
// -SAUVEGARDE DES DATAS
// 
void remove_memory_apply (void)
{
	static gboolean BoolDoEnterRemove = FALSE;
	
	if (TRUE == BoolDoEnterRemove) return;
	BoolDoEnterRemove = TRUE;
	
	g_print ("\n--------------------------------------------------\n");
	PRINT_FUNC_LF();
	g_print ("--------------------------------------------------\n");
	
	g_print ("AlsaPlay_stop ()\n");
	AlsaPlay_stop ();
	
	g_print ("split_set_stop ()\n");
	split_set_stop ();
	
	g_print ("Recuperation position et taille de la fenetre\n");
	gdk_window_get_root_origin (WindMain->window, &Config.WinPos_X, &Config.WinPos_Y);
	gdk_window_get_size (WindMain->window, &Config.WinWidth, &Config.WinHeight);	
	
	g_print ("Sauvegarde l'etat de l'expander CD\n");
	Config.BoolEtatExpanderCd = gtk_expander_get_expanded (GTK_EXPANDER (var_cd.Adr_Expander));
	
	g_print ("Sauvegarde de la configuration\n");
	config_save ();
	
	g_print ("config_remove ()\n");
	config_remove ();
	
	g_print ("fileanalyze_remove_entetefile ()\n");
	fileanalyze_remove_entetefile ();

	g_print ("dvdaudio_remove_GtkTree ()\n");
	dvd_remove_GtkTree ();
	g_print ("dvdread_remove_list ()\n");
	dvdread_remove_list ();

	g_print ("cdaudio_deallocate_glist ()\n");
	cdaudio_deallocate_glist ();

	g_print ("NotifySend_remove ()\n");
	NotifySend_remove ();
	
	g_print ("Parse_remove (PARSE_TYPE_STOCKAGE_CD)\n");
	Parse_remove (PARSE_TYPE_STOCKAGE_CD);
	g_print ("Parse_remove (PARSE_TYPE_TITLE_CD)\n");
	Parse_remove (PARSE_TYPE_TITLE_CD);
	
	g_print ("poche_remove_view()\n");
	poche_remove_view();
	
	g_print ("poche_remove_ListImage()\n");
	poche_remove_ListImage();

	g_print ("libcombo_remove ()\n");
	libcombo_remove ();

	g_print ("scan_remove_glist_media ()\n");
	scan_remove_glist_media ();

	g_print ("web_remove_temporary_rep ()\n");
	web_remove_temporary_rep ();
	
	g_print ("CdCurl_remove_struct_all ()\n");
	CdCurl_remove_struct_all();
	
	g_print ("mplayer_remove_list_args ()\n");
	mplayer_remove_list_args ();
	
	g_print ("SplitSpectre_remove ()\n");
	SplitSpectre_remove ();
	
	g_print ("AlsaPlay_remove ()\n");
	AlsaPlay_remove ();
		
	if (TRUE == libutils_test_file_exist (XCFA_FILE_LOAD)) {
		g_print ("g_unlink (%s)\n", XCFA_FILE_LOAD);
		g_unlink (XCFA_FILE_LOAD);
	}
	if (TRUE == libutils_test_file_exist (SPLIT_FILE_TMP_WAV)) {
		g_print ("g_unlink (%s)\n", SPLIT_FILE_TMP_WAV);
		g_unlink (SPLIT_FILE_TMP_WAV);
	}
	g_print ("StatusBar_remove ()\n");
	StatusBar_remove();

	Config.PathPochette = libutils_remove_temporary_rep( Config.PathPochette );
	
	if( NULL != Config.PathLoadImg ) {
		g_free( Config.PathLoadImg );
		Config.PathLoadImg = NULL;
	}
	if( Config.PathSaveImg ) {
		g_free( Config.PathSaveImg );
		Config.PathSaveImg = NULL;
	}

	g_print ("\n");
}
// 
// 
void on_notebook_general_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (TRUE == Config.BoolConfigOk) {
		Config.NotebookGeneral = page_num;
		
		if (NOTEBOOK_SPLIT == Config.NotebookGeneral) {
			split_set_name_file ();
		}
		else {
			StatusBar_puts();
		}
	}
}
// 
// 
void on_notebook_expander_cd_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (TRUE == Config.BoolConfigOk)
		Config.NotebookExpanderCd = page_num;
}
// 
// 
void on_notebook_in_file_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (TRUE == Config.BoolConfigOk) {
		Config.NotebookFile = page_num;
		switch (Config.NotebookFile) {
		case NOTEBOOK_FICHIERS_CONVERSION :
			gtk_combo_box_remove_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), 2);
			gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.PathDestinationFileAll);
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.TabIndiceComboDestFile[ NOTEBOOK_FICHIERS_CONVERSION ]);
			break;
		case NOTEBOOK_FICHIERS_WAV :
			gtk_combo_box_remove_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), 2);
			gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.PathDestinationFileWav);
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.TabIndiceComboDestFile[ NOTEBOOK_FICHIERS_WAV ]);
			break;
		case NOTEBOOK_FICHIERS_MP3OGG :
			gtk_combo_box_remove_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), 2);
			gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.PathDestinationFileMp3Ogg);
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.TabIndiceComboDestFile[ NOTEBOOK_FICHIERS_MP3OGG ]);
			break;
		case NOTEBOOK_FICHIERS_TAGS :
			gtk_combo_box_remove_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), 2);
			gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.PathDestinationFileTags);
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.TabIndiceComboDestFile[ NOTEBOOK_FICHIERS_TAGS ]);
			break;
		}
		StatusBar_set_mess( NOTEBOOK_FICHIERS, _STATUSBAR_SIMPLE_, "" );
		StatusBar_puts();
	}
}
// 
// 
void on_notebook_options_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (TRUE == Config.BoolConfigOk)
		Config.NotebookOptions = page_num;
}
// 
// 
void on_notebook_app_externes_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (TRUE == Config.BoolConfigOk)
		Config.NotebookAppExterns = page_num;
}
// 
// 
gboolean on_wind_main_key_press_event( GtkWidget *widget, GdkEventKey *kevent, gpointer user_data )
{
	keys.BoolGDKPress = TRUE;
	keys.keyval       = kevent->keyval;
	
	if( kevent->keyval == GDK_Control_L || kevent->keyval == GDK_Control_R ) {
		keys.BoolGDK_Control_L_R = TRUE;
	}		
	else if( kevent->state == 20 || kevent->state == 21 ) {
		if( kevent->keyval == 65 || kevent->keyval == 97 ) {
			keys.BoolGDK_Control_A = TRUE;
		}
	}
	
	if( NOTEBOOK_POCHETTE == Config.NotebookGeneral ) {
		if( TRUE == keys.BoolGDK_Control_L_R ) {
			pochedir_set_ctrl( TRUE );
		}
		else if( kevent->keyval == GDK_Delete) {
			// poche_remove_image();
		}
	}
	else if( NOTEBOOK_SPLIT == Config.NotebookGeneral ) {
		if( kevent->keyval == GDK_Delete ) {
			SplitSelector_cut ();
		}
		else if( kevent->keyval == GDK_space ) {
			// Une action sur la barre espace agit sur sur le play/pause
			split_play ();
		}
	}

	return FALSE;
}
// 
// 
gboolean on_wind_main_key_release_event( GtkWidget *widget, GdkEventKey *kevent, gpointer user_data )
{
	keys.BoolGDKPress        = FALSE;
	keys.BoolGDK_Control_L_R = FALSE;
	keys.BoolGDK_Control_A   = FALSE;
	keys.keyval              = 0;
	
	if( NOTEBOOK_POCHETTE == Config.NotebookGeneral ) {
		pochedir_set_ctrl( FALSE );
	}
	
	return FALSE;
}
// 
// 
gboolean on_wind_main_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	remove_memory_apply ();
	gtk_main_quit ();
	return FALSE;
}
// 
// 
gboolean on_wind_main_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	remove_memory_apply ();
	gtk_main_quit ();
	return FALSE;
}
// 
// 
void on_quitter1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	remove_memory_apply ();
	gtk_main_quit ();
}
// 
// 
void on_a_propos1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gchar	*StrAboutXcfa = g_strdup_printf ("About XCFA  -  %s", VERSION);
	WinAbout_open (StrAboutXcfa);
	g_free (StrAboutXcfa);
	StrAboutXcfa = NULL;
}
// 
// 
void on_show_fields_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	treeview_open_window ();
}
/* Install un 'handler' sur une mauvaise allocation memoire
*  --
*  entree : int sig :
*  retour : -
*/
void segfault_handler(int sig)
{
	g_unlink (XCFA_FILE_LOAD);
	remove_memory_apply ();
	
	g_print ("\n=========================================================\n");
	g_print ("=  Segmentation fault\n");
	g_print (_("=  Adressage memoire invalide\n"));
	g_print ("=-------------------------------------------------------=\n");
	g_print ("=      You've probably found a bug in XCFA\n");
	g_print (_("=      Vous avez probablement trouve un bug dans XCFA\n"));
	g_print ("=========================================================\n\n");
		
	exit (EXIT_FAILURE);
}
// 
// 
void AnalyseCommandLine_set_argv (int argc, gchar *argv[])
{
	gint	 i;
	gchar	*str_current_dir = NULL;
	FILE	*fp = NULL;
	
	if (optind < argc) {
		str_current_dir = g_get_current_dir ();
		fp = fopen (XCFA_FILE_LOAD, "a");
		for (i = optind; i < argc; i++)
		{
			if (argv[i][0] == '/') {

				fprintf (fp, "%s\n", argv[ i ]);
			}
			else {
				gchar *str = NULL;
				
				str = g_strdup_printf ("%s/%s", str_current_dir, argv[i]);
				fprintf (fp, "%s\n", str);
				g_free (str);
				str = NULL;
			}
		}
		fclose (fp);
	}
	g_free (str_current_dir);
	str_current_dir = NULL;
}
/* gint main (gint argc, gchar *argv[], gchar **envp)
 *
 * argc  designe le nombre d'arguments transmis au moment du lancement de l'executable
 * argv  designe le vecteur contenant les differents arguments
 * envp  designe le vecteur contenant les informations sur l'environnement
 */
gint main (gint argc, gchar *argv[], gchar **envp)
{
	GError	*p_err = NULL;
	gchar	*CurrentDir = g_get_current_dir ();
	gchar	*PathCurrentDir = NULL;
	gchar	*PathShareProjet = NULL;
	gchar	*Path = NULL;
	gchar	*PackageVersion = NULL;

	
	if (TRUE == process_exist_file ()) {
		
		AnalyseCommandLine_set_argv (argc, &argv[0]);		// Get and save param-file
		return (EXIT_SUCCESS);					// Quit process with success
	}
	else {
		g_unlink (XCFA_FILE_LOAD);				// Del paramter file if exist
		AnalyseCommandLine_set_argv (argc, &argv[0]);		// Get and save param-file
		
		// PLACER CET APPEL JUSTE AVANT: gtk_main ();
		// 
		// process_goto_timeout ();
	}
	
	g_print ("%s :: %s (line = %d)\n", __FILE__, __FUNCTION__, __LINE__);
	g_print ("\n");
	g_print ("***************************\n");
	g_print ("%s %s\n", PACKAGE, VERSION);
	g_print ("***************************\n");
	g_print ("%s %s compiled at %s %s\n", PACKAGE_NAME, VERSION, __DATE__, __TIME__);
	g_print ("Compiler: gcc %s\n", __VERSION__);
	g_print ("***************************\n");
	g_print ("Gtk version  = %d.%d.%d\n", GTK_MAJOR_VERSION, GTK_MICRO_VERSION, GTK_MINOR_VERSION);
	g_print ("Glib version = %d.%d.%d\n", GLIB_MAJOR_VERSION, GLIB_MICRO_VERSION, GLIB_MINOR_VERSION);
	g_print ("***************************\n\n");
#ifdef ENABLE_NLS
	g_print ("ENABLE_NLS OK\n");
	g_print ("\tGETTEXT_PACKAGE    = %s\n", GETTEXT_PACKAGE);
	g_print ("\tLOCALE_DIR         = %s\n", LOCALE_DIR);

	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#else
	// g_error ("ENABLE_NLS IS NOT OK\n\n");
#endif
	GetInfo_cpu_print ();
	g_print ("\n");
	g_print ("HostConf.NbCpu   = %d CPU\n", HostConf.NbCpu);
	g_print ("HostConf.TypeCpu = %d Bits\n", HostConf.TypeCpu);
	g_print ("HostConf.Machine = %s\n", HostConf.Machine);
	g_print ("\n");
	
	/* IF Segmentation fault */
	signal (SIGSEGV, segfault_handler);
	
	config_read();
	
	gtk_set_locale ();
	gtk_init (&argc, &argv);
	gdk_threads_enter ();
	
	if (NULL == (GtkXcfaProjet = gtk_builder_new ())) {
		return (EXIT_FAILURE);
	}
	gtk_builder_set_translation_domain (GtkXcfaProjet, NULL);

	PathCurrentDir = g_strdup_printf ("%s/glade/%s", CurrentDir, PACKAGE_NAME_GLADE);
	g_free (CurrentDir);
	CurrentDir = NULL;
	PathShareProjet = g_strdup_printf ("%s/%s/glade/%s", DATA_DIR, PACKAGE_NAME, PACKAGE_NAME_GLADE);

	if (FALSE == g_file_test (PathCurrentDir, G_FILE_TEST_EXISTS) && FALSE == g_file_test (PathShareProjet, G_FILE_TEST_EXISTS)) {
		g_print("!---------------------------------------------------------------------------------------------------\n");
		g_print("! LE FICHIER XML: [ %s ] N'EXISTE PAS !!!\n", PathCurrentDir);
		g_print("!---------------------------------------------------------------------------------------------------\n");
		g_print("! LE FICHIER XML: [ %s ] N'EXISTE PAS !!!\n", PathShareProjet);
		g_print("!---------------------------------------------------------------------------------------------------\n");

		g_free (PathCurrentDir);
		PathCurrentDir = NULL;
		g_free (PathShareProjet);
		PathShareProjet = NULL;

		gdk_threads_leave ();
		return (EXIT_FAILURE);
	}
	else if (TRUE == g_file_test (PathCurrentDir, G_FILE_TEST_EXISTS)) {

		Path = PathCurrentDir;
	}
	else if (TRUE == g_file_test (PathShareProjet, G_FILE_TEST_EXISTS)) {

		Path = PathShareProjet;
	}
	g_print("\nPATHNAME FILE %s: %s\n\n", PACKAGE_NAME_GLADE, Path);
	if (gtk_builder_add_from_file (GtkXcfaProjet, Path, &p_err) <= 0) {
		g_warning ("Couldn't load builder file: %s", p_err->message);
		g_error_free (p_err);

		g_free (PathCurrentDir);
		PathCurrentDir = NULL;
		g_free (PathShareProjet);
		PathShareProjet = NULL;
		Path = NULL;

		gdk_threads_leave ();
		return (EXIT_FAILURE);
	}
	g_free (PathCurrentDir);
	PathCurrentDir = NULL;
	g_free (PathShareProjet);
	PathShareProjet = NULL;
	Path = NULL;

	gtk_builder_set_translation_domain  (GtkXcfaProjet, gtk_set_locale ());
	gtk_builder_connect_signals (GtkXcfaProjet, NULL);
	WindMain = GTK_WIDGET (GLADE_GET_OBJECT("wind_main"));
	
	// REDIMENSIONNER LA FENETRE
	gtk_window_resize(GTK_WINDOW(WindMain), Config.WinWidth, Config.WinHeight);
	// PLACER LA FENETRE
	gtk_window_move(GTK_WINDOW(WindMain), Config.WinPos_X, Config.WinPos_Y);
	
	PackageVersion = g_strdup_printf ("X Convert File Audio  -  %s", VERSION);
	gtk_window_set_title (GTK_WINDOW (WindMain), PackageVersion);
	g_free (PackageVersion);
	PackageVersion = NULL;
	
	libutils_set_default_icone_to_win (WindMain);
	
	// SYSTRAY: CREATION DE L'ICONE DE STATUS + INFO-BULLE
	PopupSystray_init ();
	
	gtk_widget_show (WindMain);
	
	// NOTEBOOK
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_PRGEXTERNES);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_app_externes")), NOTEBOOK_OPTIONS_EXTRA);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_app_externes")), NOTEBOOK_OPTIONS_PRGEXTERNES);
		
	// OPTIONS
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_OPTIONS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_EXPORT_TAGS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_AACPLUSENC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_FAAC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_MUSEPACK);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_WAVPACK);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_MAC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_FLAC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_OGGENC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_LAME);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_CD_AUDIO);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_GENERAL);

	// POCHETTE
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_POCHETTE);

	// SPLIT
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_SPLIT);

	// FICHIERS
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_FICHIERS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_in_file")), NOTEBOOK_FICHIERS_TAGS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_in_file")), NOTEBOOK_FICHIERS_MP3OGG);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_in_file")), NOTEBOOK_FICHIERS_WAV);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_in_file")), NOTEBOOK_FICHIERS_CONVERSION);

	// CD-AUDIO
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_CD_AUDIO);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_expander_cd")), NOTEBOOK_CD_AUDIO_CUE);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_expander_cd")), NOTEBOOK_CD_AUDIO_TITRE_CD);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_expander_cd")), NOTEBOOK_CD_AUDIO_TAGS);

	// DVD-AUDIO
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_DVD_AUDIO);
	
	var_options.ColorLineCommand = COLOR_INIT;
	options_set_all_interne ();
	var_options.ColorLineCommand = COLOR_NONE;
	
	Config.BoolConfigOk = TRUE;
	
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), Config.NotebookGeneral);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_expander_cd")), Config.NotebookExpanderCd);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_in_file")), Config.NotebookFile);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), Config.NotebookOptions);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_app_externes")), Config.NotebookAppExterns);
	if (NOTEBOOK_SPLIT == Config.NotebookGeneral) {
		split_set_name_file ();
	}
	
	cdaudio_set_flag_buttons ();
	file_set_flag_buttons ();
	FileWav_set_flag_buttons ();
	FileMp3Ogg_set_flag_buttons ();
	FileTags_set_flag_buttons ();
	gtk_widget_set_sensitive (GTK_WIDGET (var_file_tags.Adr_table_tag), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_tag_appliquer")), FALSE);
	
	gtk_widget_hide( GTK_WIDGET (GLADE_GET_OBJECT("frame_discid")));
	
	treeview_set_etat_fields ();
	treeview_radiobutton_set_PosFieldsName ();
	
	filetrash_test_trash_is_ok ();
	poche_set_flag_buttons();
	
	// SI CHARGEMENT DE FICHIERS DEPUIS LE BUREAU AVEC LE MENU CONTEXTUEL
	process_goto_timeout ();
	
	// ADMINISTRATOR MODE ?
	if (0 == getuid()) {
		wininfo_create (
			_("MODE ADMINISTRATEUR"),
			_("Vous ne devriez pas utiliser XCFA sous ROOT !"),
			"");
	}
	
	gtk_main ();
	gdk_threads_leave ();

	exit(EXIT_SUCCESS);
}


