// $Id: World.h,v 1.15 2003/02/07 20:55:30 mrq Exp $
#ifndef WE_WORLD_H
#define WE_WORLD_H

#include <string>
#include <vector>
#include <list>

#include <Ark/ArkConfig.h>
#include <Modules/HeightField/HFWorld.h>

// We use gtk+
#define WE_GUI_GTK

#include "GroundList.h"

// Cannot include TerrainView.h because of circular inclusion
class TerrainView;
class ViewWidget;


class World : public Ark::HeightField
{
  private:
    // Ground types. Useful ?
    GroundList m_GroundList;
   public:
      World(Ark::Cache *cache);
      ~World();

      bool LoadED(const std::string& path);
      void Write() const;

      bool IsChanged() const { return m_IsChanged; }
      void Changed() const;

      const std::string& GetFileName() const { return m_Path; }
      void SetFileName(const std::string& path) { m_Path = path + "/"; }

      std::string m_Path;

      // Ground materials
      bool LoadGround(const std::string& name);

      void DebugDump();

   private:
      void Unchanged() const;
      mutable bool m_IsChanged;
};


#endif

