/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.calc;

import java.util.BitSet;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;

public class MarchingSquares {
    public static final int CONTOUR_POINT = -1;
    public static final int VERTEX_POINT = -2;
    public static final int EDGE_POINT = -3;
    private boolean logMessages = false;
    private VertexDataServer surfaceReader;
    private VolumeData volumeData;
    private static final int nContourMax = 100;
    public static final int defaultContourCount = 9;
    private int nContourSegments;
    private int nContoursSpecified;
    private int contourType;
    private Point4f thePlane;
    private boolean is3DContour;
    private int thisContour = 0;
    private float valueMin;
    private float valueMax;
    private int nVertices;
    private final Vector3f pointVector = new Vector3f();
    private final Point3f pointA = new Point3f();
    private final Point3f pointB = new Point3f();
    private final Vector3f edgeVector = new Vector3f();
    private final Point3f planarOrigin = new Point3f();
    private final Vector3f[] planarVectors = new Vector3f[3];
    private final Vector3f[] unitPlanarVectors = new Vector3f[3];
    private final float[] planarVectorLengths = new float[2];
    private final Matrix3f matXyzToPlane = new Matrix3f();
    private boolean contourFromZero;
    private float[] contoursDiscrete;
    private static final Point3i[] squareVertexOffsets = new Point3i[]{new Point3i(0, 0, 0), new Point3i(1, 0, 0), new Point3i(1, 1, 0), new Point3i(0, 1, 0)};
    private static final Vector3f[] squareVertexVectors = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)};
    private static final byte[] edgeVertexes2d = new byte[]{0, 1, 1, 2, 2, 3, 3, 0};
    private static final byte[] insideMaskTable2d = new byte[]{0, 9, 3, 10, 6, 15, 5, 12, 12, 5, 15, 6, 10, 3, 9, 0};
    private int contourVertexCount;
    protected ContourVertex[] contourVertexes;
    private final int[] pixelCounts;
    private final Matrix3f planarMatrix;
    private float[][] pixelData;
    private final float[] vertexValues2d;
    private final Point3f[] contourPoints;
    private int squareCountX;
    private int squareCountY;
    private PlanarSquare[] planarSquares;
    private int nSquares;
    private float contourPlaneMinimumValue;
    private float contourPlaneMaximumValue;
    private int contourIndex;
    private float[] contourValuesUsed;
    private float[] squareFractions;
    private final Point3f pixelOrigin;
    private Vector3f[] pixelVertexVectors;
    private final int[] triangleVertexList;
    private final BitSet bsMesh0;
    private final BitSet bsMesh1;
    private final BitSet bsMesh2;
    private final Point3i ptiTemp;

    public MarchingSquares(VertexDataServer vertexDataServer, VolumeData volumeData, Point4f point4f, float[] fArray, int n, int n2, boolean bl) {
        this.planarVectors[0] = new Vector3f();
        this.planarVectors[1] = new Vector3f();
        this.planarVectors[2] = new Vector3f();
        this.unitPlanarVectors[0] = new Vector3f();
        this.unitPlanarVectors[1] = new Vector3f();
        this.unitPlanarVectors[2] = new Vector3f();
        this.contourFromZero = true;
        this.pixelCounts = new int[2];
        this.planarMatrix = new Matrix3f();
        this.vertexValues2d = new float[4];
        this.contourPoints = new Point3f[4];
        int n3 = 4;
        while (--n3 >= 0) {
            this.contourPoints[n3] = new Point3f();
        }
        this.pixelOrigin = new Point3f();
        this.pixelVertexVectors = new Vector3f[4];
        this.triangleVertexList = new int[20];
        this.bsMesh0 = new BitSet();
        this.bsMesh1 = new BitSet();
        this.bsMesh2 = new BitSet();
        this.ptiTemp = new Point3i();
        this.surfaceReader = vertexDataServer;
        this.volumeData = volumeData;
        this.thePlane = point4f;
        this.thisContour = n2;
        this.is3DContour = point4f == null;
        this.contoursDiscrete = fArray;
        this.nContoursSpecified = n;
        this.contourFromZero = bl;
        if (fArray == null) {
            n3 = 0;
            this.nContourSegments = (n == 0 ? 9 : n) + n3;
            if (this.nContourSegments > 100) {
                this.nContourSegments = 100;
            }
        } else {
            this.nContourSegments = n = fArray.length;
            this.contourFromZero = false;
        }
        this.setContourType();
    }

    public int getContourType() {
        return this.contourType;
    }

    public void setMinMax(float f, float f2) {
        this.valueMin = f;
        this.valueMax = f2;
    }

    private void setContourType() {
        if (this.is3DContour) {
            this.planarVectors[0].set(this.volumeData.volumetricVectors[0]);
            this.planarVectors[1].set(this.volumeData.volumetricVectors[1]);
            this.pixelCounts[0] = this.volumeData.voxelCounts[0];
            this.pixelCounts[1] = this.volumeData.voxelCounts[1];
            this.contourType = 2;
            return;
        }
        this.contourType = MarchingSquares.getContourType(this.thePlane, this.volumeData.volumetricVectors);
    }

    private static int getContourType(Point4f point4f, Vector3f[] vector3fArray) {
        Vector3f vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
        float f = vector3f.dot(vector3fArray[0]);
        float f2 = vector3f.dot(vector3fArray[1]);
        float f3 = vector3f.dot(vector3fArray[2]);
        f *= f;
        f2 *= f2;
        f3 *= f3;
        float f4 = Math.max(f, f2);
        int n = f4 < f3 ? 2 : (f4 == f2 ? 1 : 0);
        return n;
    }

    public int generateContourData(boolean bl) {
        int n;
        Logger.info("generateContours: " + this.nContourSegments + " segments");
        if (!this.is3DContour) {
            this.getPlanarVectors();
        }
        this.setPlanarTransform();
        this.getPlanarOrigin();
        MarchingSquares.setupMatrix(this.planarMatrix, this.planarVectors);
        this.calcPixelVertexVectors();
        if (!this.is3DContour) {
            this.getPixelCounts();
        }
        this.createPlanarSquares();
        this.loadPixelData(bl);
        this.nVertices = 0;
        if (this.logMessages) {
            n = this.pixelCounts[0] / 2;
            Logger.info(ArrayUtil.dumpArray("generateContourData", this.pixelData, n - 4, n + 4, n - 4, n + 4));
        }
        n = this.createContours(this.valueMin, this.valueMax) ? 1 : 0;
        this.triangulateContours(n != 0);
        Logger.info("generateContours: " + this.nVertices + " vertices");
        return this.contourVertexCount;
    }

    private void getPlanarVectors() {
        this.planarVectors[2].set(0.0f, 0.0f, 0.0f);
        Vector3f vector3f = new Vector3f(this.thePlane.x, this.thePlane.y, this.thePlane.z);
        Vector3f[] vector3fArray = this.volumeData.volumetricVectors;
        Vector3f vector3f2 = vector3fArray[this.contourType];
        float f = vector3f2.dot(vector3f);
        switch (this.contourType) {
            case 0: {
                this.planarVectors[0].scaleAdd(-vector3fArray[1].dot(vector3f) / f, vector3f2, vector3fArray[1]);
                this.planarVectors[1].scaleAdd(-vector3fArray[2].dot(vector3f) / f, vector3f2, vector3fArray[2]);
                break;
            }
            case 1: {
                this.planarVectors[0].scaleAdd(-vector3fArray[2].dot(vector3f) / f, vector3f2, vector3fArray[2]);
                this.planarVectors[1].scaleAdd(-vector3fArray[0].dot(vector3f) / f, vector3f2, vector3fArray[0]);
                break;
            }
            case 2: {
                this.planarVectors[0].scaleAdd(-vector3fArray[0].dot(vector3f) / f, vector3f2, vector3fArray[0]);
                this.planarVectors[1].scaleAdd(-vector3fArray[1].dot(vector3f) / f, vector3f2, vector3fArray[1]);
            }
        }
    }

    private void setPlanarTransform() {
        int n;
        this.planarVectorLengths[0] = this.planarVectors[0].length();
        this.planarVectorLengths[1] = this.planarVectors[1].length();
        this.unitPlanarVectors[0].normalize(this.planarVectors[0]);
        this.unitPlanarVectors[1].normalize(this.planarVectors[1]);
        this.unitPlanarVectors[2].cross(this.unitPlanarVectors[0], this.unitPlanarVectors[1]);
        MarchingSquares.setupMatrix(this.matXyzToPlane, this.unitPlanarVectors);
        this.matXyzToPlane.invert();
        float f = this.planarVectors[0].angle(this.planarVectors[1]);
        Logger.info("planar axes type " + this.contourType + " axis angle = " + (double)f / Math.PI * 180.0 + " normal=" + this.unitPlanarVectors[2]);
        for (n = 0; n < 2; ++n) {
            Logger.info("planar vectors / lengths:" + this.planarVectors[n] + " / " + this.planarVectorLengths[n]);
        }
        for (n = 0; n < 3; ++n) {
            Logger.info("unit orthogonal plane vectors:" + this.unitPlanarVectors[n]);
        }
    }

    private void getPlanarOrigin() {
        if (this.contourVertexCount == 0) {
            this.planarOrigin.set(0.0f, 0.0f, 0.0f);
            return;
        }
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        this.planarOrigin.set(this.contourVertexes[0]);
        for (int i = 0; i < this.contourVertexCount; ++i) {
            this.pointVector.set(this.contourVertexes[i]);
            this.xyzToPixelVector(this.pointVector);
            if (this.pointVector.x < f) {
                f = this.pointVector.x;
            }
            if (!(this.pointVector.y < f2)) continue;
            f2 = this.pointVector.y;
        }
        this.planarOrigin.set(this.pixelPtToXYZ((int)(f * 1.0001f), (int)(f2 * 1.0001f)));
    }

    public int addContourVertex(int n, int n2, int n3, Point3i point3i, Point3f point3f, float f) {
        if (this.contourVertexes == null) {
            this.contourVertexes = new ContourVertex[256];
        }
        if (this.contourVertexCount == this.contourVertexes.length) {
            this.contourVertexes = (ContourVertex[])ArrayUtil.doubleLength(this.contourVertexes);
        }
        int n4 = this.surfaceReader.addVertexCopy(point3f, f, -2);
        this.contourVertexes[this.contourVertexCount++] = new ContourVertex(n += point3i.x, n2 += point3i.y, n3 += point3i.z, point3f, n4);
        return n4;
    }

    public void setContourData(int n, float f) {
        this.contourVertexes[n].setValue(f, this.volumeData);
    }

    private void loadPixelData(boolean bl) {
        int n;
        this.pixelData = new float[this.pixelCounts[0]][this.pixelCounts[1]];
        this.contourPlaneMinimumValue = Float.MAX_VALUE;
        this.contourPlaneMaximumValue = -3.4028235E38f;
        for (n = 0; n < this.contourVertexCount; ++n) {
            int n2;
            int n3;
            float f;
            ContourVertex contourVertex = this.contourVertexes[n];
            Point3i point3i = this.locatePixel(contourVertex);
            contourVertex.setPixelLocation(point3i);
            if (bl) {
                f = contourVertex.value;
            } else {
                f = this.volumeData.lookupInterpolatedVoxelValue(contourVertex);
                contourVertex.setValue(f, null);
            }
            if (f < this.contourPlaneMinimumValue) {
                this.contourPlaneMinimumValue = f;
            }
            if (f > this.contourPlaneMaximumValue) {
                this.contourPlaneMaximumValue = f;
            }
            if ((n3 = point3i.x) >= 0 && n3 < this.pixelCounts[0] && (n2 = point3i.y) >= 0 && n2 < this.pixelCounts[1]) {
                int n4;
                this.pixelData[n3][n2] = f;
                int n5 = 0;
                if (n3 != this.squareCountX && n2 != this.squareCountY) {
                    ++n5;
                }
                if (n3 != 0 && n2 != this.squareCountY) {
                    ++n5;
                }
                if (n2 != 0 && n3 != this.squareCountX) {
                    ++n5;
                }
                if (n2 != 0 && n3 != 0) {
                    ++n5;
                }
                if (n5 == 0) continue;
                int n6 = n4 = n5 < 2 ? -1 : contourVertex.vertexIndex;
                if (n3 != this.squareCountX && n2 != this.squareCountY) {
                    this.planarSquares[n3 * this.squareCountY + n2].setVertex(0, n4, n);
                }
                if (n3 != 0 && n2 != this.squareCountY) {
                    this.planarSquares[(n3 - 1) * this.squareCountY + n2].setVertex(1, n4, n);
                }
                if (n2 != 0 && n3 != this.squareCountX) {
                    this.planarSquares[n3 * this.squareCountY + n2 - 1].setVertex(3, n4, n);
                }
                if (n2 == 0 || n3 == 0) continue;
                this.planarSquares[(n3 - 1) * this.squareCountY + n2 - 1].setVertex(2, n4, n);
                continue;
            }
            Logger.error("loadPixelData out of bounds: " + point3i.x + " " + point3i.y + "?");
        }
        for (n = 0; n < this.nSquares; ++n) {
            this.planarSquares[n].checkVertices();
        }
    }

    public float getInterpolatedPixelValue(Point3f point3f) {
        int n;
        this.pointVector.set(point3f);
        this.xyzToPixelVector(this.pointVector);
        float f = this.pointVector.x;
        float f2 = this.pointVector.y;
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        int n2 = f >= (float)this.pixelCounts[0] ? this.pixelCounts[0] - 1 : (n = f < 0.0f ? 0 : (int)f);
        int n3 = f2 >= (float)this.pixelCounts[1] ? this.pixelCounts[1] - 1 : (f2 < 0.0f ? 0 : (int)f2);
        int n4 = n + (n == this.pixelCounts[0] - 1 ? 0 : 1);
        int n5 = n3 + (n3 == this.pixelCounts[1] - 1 ? 0 : 1);
        float f3 = VolumeData.getFractional2DValue(f - (float)n, f2 - (float)n3, this.pixelData[n][n3], this.pixelData[n4][n3], this.pixelData[n][n5], this.pixelData[n4][n5]);
        return f3;
    }

    private void getPixelCounts() {
        int n = 1;
        for (int i = 0; i < 3; ++i) {
            if (i == this.contourType) continue;
            n = Math.max(n, this.volumeData.voxelCounts[i]);
        }
        this.pixelCounts[0] = this.pixelCounts[1] = n;
    }

    private void createPlanarSquares() {
        this.squareCountX = this.pixelCounts[0] - 1;
        this.squareCountY = this.pixelCounts[1] - 1;
        this.planarSquares = new PlanarSquare[this.squareCountX * this.squareCountY];
        this.nSquares = 0;
        for (int i = 0; i < this.squareCountX; ++i) {
            for (int j = 0; j < this.squareCountY; ++j) {
                int n;
                ++this.nSquares;
                this.planarSquares[n] = new PlanarSquare(n, this.nContourSegments);
            }
        }
        Logger.info("nSquares = " + this.nSquares);
    }

    public float[] getContourValues() {
        return this.contourValuesUsed;
    }

    public boolean createContours(float f, float f2) {
        float f3 = f2 - f;
        boolean bl = true;
        int n = -1;
        Logger.info("generateContourData min=" + f + " max=" + f2 + " nContours=" + this.nContourSegments + " (" + this.nContoursSpecified + " specified) contourFromZero=" + this.contourFromZero);
        this.contourValuesUsed = new float[this.nContourSegments];
        for (int i = 0; i < this.nContourSegments; ++i) {
            float f4;
            this.contourIndex = i;
            float f5 = this.contoursDiscrete != null ? this.contoursDiscrete[i] : (this.contourFromZero ? f + (float)i * 1.0f / (float)this.nContourSegments * f3 : (i == 0 ? -3.4028235E38f : (f4 = i == this.nContourSegments - 1 ? Float.MAX_VALUE : f + (float)(i - 1) * 1.0f / (float)(this.nContourSegments - 1) * f3)));
            if (this.contoursDiscrete == null && (double)Math.abs(f4) < 1.0E-4) {
                f4 = f4 < 0.0f ? -1.0E-4f : 1.0E-4f;
            }
            this.contourValuesUsed[i] = f4;
            int n2 = this.generateContourData(i, f4);
            Logger.debug("contour " + (i + 1) + " cutoff=" + f4 + " insideCount=" + n2 + " centerIsLow=" + bl);
            if (n < 0) {
                n = n2;
                continue;
            }
            if (n <= n2) continue;
            bl = false;
            n = 0;
        }
        return bl;
    }

    private int generateContourData(int n, float f) {
        int[][] nArray = new int[this.squareCountY][4];
        float[][] fArray = new float[this.squareCountY][4];
        int n2 = this.squareCountY;
        while (--n2 >= 0) {
            nArray[n2][3] = -1;
            nArray[n2][2] = -1;
            nArray[n2][1] = -1;
            nArray[n2][0] = -1;
        }
        n2 = 0;
        int n3 = 0;
        int n4 = this.squareCountX;
        while (--n4 >= 0) {
            int n5 = this.squareCountY;
            while (--n5 >= 0) {
                int n6 = n4 * this.squareCountY + n5;
                PlanarSquare planarSquare = this.planarSquares[n6];
                int[] nArray2 = this.propagateNeighborPointIndexes2d(n4, n5, nArray, fArray);
                int n7 = 0;
                int n8 = 4;
                while (--n8 >= 0) {
                    Point3i point3i = squareVertexOffsets[n8];
                    this.vertexValues2d[n8] = this.pixelData[n4 + point3i.x][n5 + point3i.y];
                }
                n8 = 4;
                while (--n8 >= 0) {
                    if (planarSquare.vertexes[n8] == -1) {
                        this.vertexValues2d[n8] = Float.NaN;
                    }
                    planarSquare.values[n8] = this.vertexValues2d[n8];
                    if (!this.isInside2d(this.vertexValues2d[n8], f)) continue;
                    n7 |= 1 << n8;
                    ++n2;
                }
                if (n7 == 15) {
                    planarSquare.addEdgeMask(this.contourIndex, 0, 15);
                    continue;
                }
                ++n3;
                this.processOneQuadrilateral(planarSquare, n7, f, nArray2, n4, n5);
            }
        }
        return n2;
    }

    private boolean isInside2d(float f, float f2) {
        return this.contourFromZero ? f2 > 0.0f && f >= f2 || f2 <= 0.0f && f <= f2 : f < f2;
    }

    private int[] propagateNeighborPointIndexes2d(int n, int n2, int[][] nArray, float[][] fArray) {
        boolean bl;
        boolean bl2;
        int[] nArray2 = nArray[n2];
        this.squareFractions = fArray[n2];
        boolean bl3 = bl2 = n == this.squareCountX - 1;
        if (bl2) {
            nArray2[0] = -1;
            nArray2[1] = -1;
            nArray2[2] = -1;
            nArray2[3] = -1;
        } else {
            nArray2[1] = nArray2[3];
            this.squareFractions[1] = 1.0f - this.squareFractions[3];
        }
        boolean bl4 = bl = n2 == this.squareCountY - 1;
        if (bl) {
            nArray2[2] = -1;
        } else {
            nArray2[2] = nArray[n2 + 1][0];
            this.squareFractions[2] = 1.0f - fArray[n2 + 1][0];
        }
        nArray2[0] = -1;
        nArray2[3] = -1;
        return nArray2;
    }

    private void processOneQuadrilateral(PlanarSquare planarSquare, int n, float f, int[] nArray, int n2, int n3) {
        byte by = insideMaskTable2d[n];
        planarSquare.addEdgeMask(this.contourIndex, by, n);
        int n4 = 4;
        while (--n4 >= 0) {
            if ((by & 1 << n4) == 0 || nArray[n4] >= 0) continue;
            byte by2 = edgeVertexes2d[2 * n4];
            byte by3 = edgeVertexes2d[2 * n4 + 1];
            float f2 = this.vertexValues2d[by2];
            float f3 = this.vertexValues2d[by3];
            if (this.is3DContour) {
                this.calcVertexPoints3d(n2, n3, by2, by3);
            } else {
                this.calcVertexPoints2d(n2, n3, by2, by3);
            }
            this.squareFractions[n4] = this.calcContourPoint(f, f2, f3, this.contourPoints[n4]);
            nArray[n4] = this.surfaceReader.addVertexCopy(this.contourPoints[n4], f, -1);
            ++this.nVertices;
        }
        planarSquare.setIntersectionPoints(this.contourIndex, nArray, this.squareFractions);
    }

    private void calcVertexPoints2d(int n, int n2, int n3, int n4) {
        this.pixelOrigin.scaleAdd(n, this.planarVectors[0], this.planarOrigin);
        this.pixelOrigin.scaleAdd(n2, this.planarVectors[1], this.pixelOrigin);
        this.pointA.add(this.pixelOrigin, this.pixelVertexVectors[n3]);
        this.pointB.add(this.pixelOrigin, this.pixelVertexVectors[n4]);
    }

    private void calcVertexPoints3d(int n, int n2, int n3, int n4) {
        this.contourLocateXYZ(n + MarchingSquares.squareVertexOffsets[n3].x, n2 + MarchingSquares.squareVertexOffsets[n3].y, this.pointA);
        this.contourLocateXYZ(n + MarchingSquares.squareVertexOffsets[n4].x, n2 + MarchingSquares.squareVertexOffsets[n4].y, this.pointB);
    }

    private void contourLocateXYZ(int n, int n2, Point3f point3f) {
        int n3 = this.findContourVertex(n, n2);
        if (n3 < 0) {
            point3f.x = Float.NaN;
            return;
        }
        ContourVertex contourVertex = this.contourVertexes[n3];
        point3f.set(contourVertex);
    }

    private int findContourVertex(int n, int n2) {
        for (int i = 0; i < this.contourVertexCount; ++i) {
            if (this.contourVertexes[i].pixelLocation[0] != n || this.contourVertexes[i].pixelLocation[1] != n2) continue;
            return i;
        }
        return -1;
    }

    private float calcContourPoint(float f, float f2, float f3, Point3f point3f) {
        float f4 = (f - f2) / (f3 - f2);
        this.edgeVector.sub(this.pointB, this.pointA);
        point3f.scaleAdd(f4, this.edgeVector, this.pointA);
        return f4;
    }

    private void calcPixelVertexVectors() {
        int n = 4;
        while (--n >= 0) {
            this.pixelVertexVectors[n] = new Vector3f();
            this.planarMatrix.transform(squareVertexVectors[n], this.pixelVertexVectors[n]);
        }
    }

    private void triangulateContours(boolean bl) {
        int n = bl ? -1 : 1;
        for (int i = 0; i < this.nContourSegments; ++i) {
            if (this.thisContour > 0 && this.thisContour != i + 1) continue;
            for (int j = 0; j < this.nSquares; ++j) {
                boolean bl2;
                PlanarSquare planarSquare = this.planarSquares[j];
                int n2 = planarSquare.edgeMask12[i];
                boolean bl3 = bl2 = i + n < 0 || i + n == this.nContourSegments;
                if ((n2 &= 0xFF) == 0 && !bl2 && planarSquare.edgeMask12[i + n] == 0 || n2 == 15 && !bl2 && planarSquare.edgeMask12[i + n] == 15) continue;
                boolean bl4 = false;
                int n3 = n2;
                if (!bl2 && (n2 = planarSquare.edgeMask12[i + n]) != 0) {
                    int n4 = (n3 & n2 & 0xF0) >> 4;
                    if (n4 != 0) {
                        for (int k = 0; k < 4; ++k) {
                            if ((n4 & 1 << k) == 0) continue;
                            bl4 = planarSquare.fractions[i][k] > planarSquare.fractions[i + n][k];
                            break;
                        }
                    }
                    n3 ^= n2 & 0xF0F;
                }
                if (n3 == 0) continue;
                this.fillSquare(planarSquare, j, i, n3, bl4, n);
            }
        }
    }

    private void fillSquare(PlanarSquare planarSquare, int n, int n2, int n3, boolean bl, int n4) {
        int n5;
        int n6 = 0;
        int n7 = 0;
        this.bsMesh0.clear();
        this.bsMesh1.clear();
        this.bsMesh2.clear();
        int n8 = 4;
        int n9 = 0;
        for (n5 = 0; n5 < 4; ++n5) {
            if (planarSquare.vertexes[n5] >= 0) continue;
            --n8;
        }
        if (n8 < 3) {
            return;
        }
        n5 = n3 >> 4 & 0xF;
        int n10 = n3 >> 8 & 0xF;
        int n11 = n3 & 0xF;
        boolean bl2 = (n11 & 1) != 0;
        int n12 = 0;
        switch (n5) {
            case 15: {
                n12 = planarSquare.iOption < 0 ? (bl2 ? -2 : -1) : (bl2 ? 1 : 2);
                planarSquare.iOption = n12;
                break;
            }
            case 0: {
                if (n10 == 15) {
                    switch (planarSquare.iOption) {
                        case -1: {
                            n12 = -2;
                            break;
                        }
                        case 1: {
                            n12 = 2;
                            break;
                        }
                        case -2: {
                            n12 = -1;
                            break;
                        }
                        case 2: {
                            n12 = 1;
                        }
                    }
                }
                planarSquare.iOption = n12;
                break;
            }
            case 6: 
            case 9: {
                planarSquare.iOption = -1;
                break;
            }
            case 3: 
            case 12: {
                planarSquare.iOption = 1;
                break;
            }
            default: {
                planarSquare.iOption = 0;
            }
        }
        for (int i = 0; i < 4; ++i) {
            boolean bl3;
            bl2 = (n11 & 1 << i) != 0;
            boolean bl4 = (n5 & 1 << i) != 0;
            boolean bl5 = bl3 = (n10 & 1 << i) != 0;
            if (bl2) {
                this.triangleVertexList[n7++] = planarSquare.vertexes[i];
            }
            if (bl && bl3) {
                this.bsMesh2.set(n7);
                this.triangleVertexList[n7++] = planarSquare.intersectionPoints[n2 + n4][i];
                ++n6;
            }
            if (bl4) {
                this.bsMesh1.set(n7);
                this.triangleVertexList[n7++] = planarSquare.intersectionPoints[n2][i];
                ++n6;
            }
            if (!bl && bl3) {
                this.bsMesh2.set(n7);
                this.triangleVertexList[n7++] = planarSquare.intersectionPoints[n2 + n4][i];
                ++n6;
            }
            if (bl3 && bl4) {
                boolean bl6 = bl = !bl;
            }
            if (i == 0 && n12 == -2) {
                BitSetUtil.copy(this.bsMesh1, this.bsMesh0);
                n9 = n7;
            }
            if (i == 2 && n12 == -2) {
                this.createTriangleSet(n9, n7, n8, n2, n2 + n4);
                n7 = n9;
                n9 = 0;
                BitSetUtil.copy(this.bsMesh0, this.bsMesh1);
            }
            if (i != 1 || n12 != 2) continue;
            this.createTriangleSet(n9, n7, n8, n2, n2 + n4);
            n7 = 0;
            this.bsMesh1.clear();
        }
        if (n7 > 2) {
            this.createTriangleSet(n9, n7, n8, n2, n2 + n4);
        }
    }

    private void createTriangleSet(int n, int n2, int n3, int n4, int n5) {
        int n6 = n;
        int n7 = n + 1;
        int n8 = n + 2;
        if (n3 == 3) {
            if (this.triangleVertexList[n] < 0) {
                ++n6;
                n7 = n8++;
            } else if (this.triangleVertexList[n7] < 0) {
                n7 = n8++;
            }
        }
        for (int i = n8; i < n2; ++i) {
            int n9 = this.triangleVertexList[n6];
            int n10 = this.triangleVertexList[n7];
            int n11 = this.triangleVertexList[i];
            if (n9 >= 0 && n10 >= 0 && n11 >= 0) {
                int n12;
                int n13 = this.bsMesh1.get(n6) && this.bsMesh1.get(n7) ? 1 : (this.bsMesh1.get(n7) && this.bsMesh1.get(i) ? 2 : (n12 = this.bsMesh1.get(i) && this.bsMesh1.get(n6) ? 4 : 0));
                int n14 = n12 > 0 ? 0 : (this.bsMesh2.get(n6) && this.bsMesh2.get(n7) ? 1 : (this.bsMesh2.get(n7) && this.bsMesh2.get(i) ? 2 : (this.bsMesh2.get(i) && this.bsMesh2.get(n6) ? 4 : 0)));
                this.surfaceReader.addTriangleCheck(n9, n10, n11, Math.max(n12, n14), n12 > 0 ? n4 : n5, false, 0);
            }
            if (n11 < 0) continue;
            n7 = i;
        }
    }

    private static void setupMatrix(Matrix3f matrix3f, Vector3f[] vector3fArray) {
        for (int i = 0; i < 3; ++i) {
            matrix3f.setColumn(i, vector3fArray[i]);
        }
    }

    private void xyzToPixelVector(Vector3f vector3f) {
        vector3f.sub(vector3f, this.planarOrigin);
        this.matXyzToPlane.transform(vector3f);
        vector3f.x /= this.planarVectorLengths[0];
        vector3f.y /= this.planarVectorLengths[1];
    }

    private Point3f pixelPtToXYZ(int n, int n2) {
        Point3f point3f = new Point3f();
        point3f.scaleAdd(n, this.planarVectors[0], this.planarOrigin);
        point3f.scaleAdd(n2, this.planarVectors[1], point3f);
        return point3f;
    }

    private Point3i locatePixel(Point3f point3f) {
        this.pointVector.set(point3f);
        this.xyzToPixelVector(this.pointVector);
        this.ptiTemp.x = (int)(this.pointVector.x + 0.5f);
        this.ptiTemp.y = (int)(this.pointVector.y + 0.5f);
        return this.ptiTemp;
    }

    private static class PlanarSquare {
        int[] edgeMask12;
        int edgeMask12All;
        int nInside;
        int nOutside;
        int nThrough;
        int index;
        final int[] vertexes = new int[]{-1, -1, -1, -1};
        final int[] contourIndexes = new int[4];
        final float[] values = new float[4];
        float[][] fractions;
        int[][] intersectionPoints;
        int iOption;

        PlanarSquare(int n, int n2) {
            this.index = n;
            this.edgeMask12 = new int[n2];
            this.intersectionPoints = new int[n2][4];
            this.fractions = new float[n2][4];
            this.edgeMask12All = 0;
        }

        void setIntersectionPoints(int n, int[] nArray, float[] fArray) {
            for (int i = 0; i < 4; ++i) {
                this.intersectionPoints[n][i] = nArray[i];
                this.fractions[n][i] = fArray[i];
            }
        }

        void setVertex(int n, int n2, int n3) {
            if (this.vertexes[n] != -1 && this.vertexes[n] != n2) {
                Logger.error("iV IS NOT -1 or pt:" + n + " " + this.vertexes[n] + "!=" + n2);
            }
            this.vertexes[n] = n2;
            this.contourIndexes[n] = n3;
        }

        void checkVertices() {
        }

        void addEdgeMask(int n, int n2, int n3) {
            this.edgeMask12[n] = ((n2 << 4) + n2 << 4) + n3;
            this.edgeMask12All |= this.edgeMask12[n];
            if (n3 == 0) {
                ++this.nOutside;
            } else if (n3 == 15) {
                ++this.nInside;
            } else {
                ++this.nThrough;
            }
        }
    }

    private static class ContourVertex
    extends Point3f {
        Point3i voxelLocation;
        int[] pixelLocation = new int[2];
        float value;
        int vertexIndex;

        ContourVertex(int n, int n2, int n3, Point3f point3f, int n4) {
            this.set(point3f);
            this.voxelLocation = new Point3i(n, n2, n3);
            this.vertexIndex = n4;
        }

        void setValue(float f, VolumeData volumeData) {
            this.value = f;
            if (volumeData != null && volumeData.voxelData != null) {
                volumeData.voxelData[this.voxelLocation.x][this.voxelLocation.y][this.voxelLocation.z] = f;
            }
        }

        void setPixelLocation(Point3i point3i) {
            this.pixelLocation[0] = point3i.x;
            this.pixelLocation[1] = point3i.y;
        }
    }
}

