/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.SharpTools;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

class SharpDialog
extends JDialog {
    public static final int CLOSED_OPTION = -1;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 2;
    final ImageIcon okIcon = new ImageIcon(this.getClass().getResource("/images/ok.gif"));
    final ImageIcon cancelIcon = new ImageIcon(this.getClass().getResource("/images/cancel.gif"));
    final ImageIcon noIcon = new ImageIcon(this.getClass().getResource("/images/no.gif"));
    private final JButton okButton = new JButton(UIManager.get("OptionPane.okButtonText").toString(), this.okIcon);
    private final JButton cancelButton = new JButton(UIManager.get("OptionPane.cancelButtonText").toString(), this.cancelIcon);
    private final JButton yesButton = new JButton(SharpTools.translation.getProperty("yes").toString(), this.okIcon);
    private final JButton noButton = new JButton(SharpTools.translation.getProperty("no").toString(), this.noIcon);
    private final Object[] ok = new Object[]{this.okButton};
    private final Object[] yesno = new Object[]{this.yesButton, this.noButton};
    private final Object[] yesnocancel = new Object[]{this.yesButton, this.noButton, this.cancelButton};
    private final Object[] okcancel = new Object[]{this.okButton, this.cancelButton};
    private int choice = -1;

    SharpDialog(Dialog c) {
        super(c);
    }

    SharpDialog(Dialog c, boolean modal) {
        super(c, modal);
    }

    SharpDialog(Dialog c, String title) {
        super(c, title);
    }

    SharpDialog(Dialog c, String title, boolean modal) {
        super(c, title, modal);
    }

    SharpDialog(Frame c) {
        super(c);
    }

    SharpDialog(Frame c, boolean modal) {
        super(c, modal);
    }

    SharpDialog(Frame c, String title) {
        super(c, title);
    }

    SharpDialog(Frame c, String title, boolean modal) {
        super(c, title, modal);
    }

    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (SharpDialog.this.onClose()) {
                    SharpDialog.this.choice = -1;
                    SharpDialog.this.setVisible(false);
                }
            }
        }, stroke, 2);
        return rootPane;
    }

    protected void onOpen() {
    }

    protected boolean onClose() {
        return this.onCancel();
    }

    protected boolean onOK() {
        return true;
    }

    protected boolean onCancel() {
        return true;
    }

    protected boolean onYes() {
        return true;
    }

    protected boolean onNo() {
        return true;
    }

    protected void setOptionPane(Object message, int messageType, int optionType, Icon icon) {
        this.setOptionPane(message, messageType, optionType, icon, 0);
    }

    protected void setOptionPane(Object message, int messageType, int optionType, Icon icon, int defaultIndex) {
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent we) {
                SharpDialog.this.onOpen();
            }

            public void windowClosing(WindowEvent we) {
                if (SharpDialog.this.onClose()) {
                    SharpDialog.this.choice = -1;
                    SharpDialog.this.setVisible(false);
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (SharpDialog.this.onOK()) {
                    SharpDialog.this.choice = 0;
                    SharpDialog.this.setVisible(false);
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (SharpDialog.this.onCancel()) {
                    SharpDialog.this.choice = 2;
                    SharpDialog.this.setVisible(false);
                }
            }
        });
        this.yesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (SharpDialog.this.onYes()) {
                    SharpDialog.this.choice = 0;
                    SharpDialog.this.setVisible(false);
                }
            }
        });
        this.noButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (SharpDialog.this.onNo()) {
                    SharpDialog.this.choice = 1;
                    SharpDialog.this.setVisible(false);
                }
            }
        });
        this.okButton.setMnemonic(79);
        this.cancelButton.setMnemonic(67);
        this.yesButton.setMnemonic(89);
        this.noButton.setMnemonic(78);
        Object[] buttons = this.setButtons(optionType);
        JOptionPane optionPane = new JOptionPane(message, messageType, optionType, icon, buttons, buttons[defaultIndex]);
        this.setContentPane(optionPane);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private Object[] setButtons(int type) {
        Object[] buttons;
        switch (type) {
            case 1: {
                buttons = this.yesnocancel;
                break;
            }
            case 0: {
                buttons = this.yesno;
                break;
            }
            case 2: {
                buttons = this.okcancel;
                break;
            }
            default: {
                buttons = this.ok;
            }
        }
        return buttons;
    }

    public int getChoice() {
        return this.choice;
    }

    public boolean isCancelled() {
        return this.choice == 2 || this.choice == -1;
    }
}

