/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.BitInputStream;

public class ByteOrderInputStream
extends BitInputStream
implements DataInput {
    protected boolean little;

    public ByteOrderInputStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public ByteOrderInputStream(InputStream inputStream, boolean bl2) {
        super(inputStream);
        this.little = bl2;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i2 = 0; i2 < n3; i2 += n4) {
            n4 = this.read(byArray, n2 + i2, n3 - i2);
            if (n4 >= 0) continue;
            throw new EOFException();
        }
    }

    public int skipBytes(int n2) throws IOException {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n2 && (n4 = (int)this.skip(n2 - n3)) > 0; n3 += n4) {
        }
        return n3;
    }

    public boolean readBoolean() throws IOException {
        int n2 = this.readUnsignedByte();
        return n2 != 0;
    }

    public char readChar() throws IOException {
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        return this.little ? (char)((n2 << 8) + n3) : (char)((n3 << 8) + n2);
    }

    public byte readByte() throws IOException {
        this.byteAlign();
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    public byte[] readByte(int n2) throws IOException {
        this.byteAlign();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.read();
            if (n3 < 0) {
                throw new EOFException();
            }
            byArray[i2] = (byte)n3;
        }
        return byArray;
    }

    public int readUnsignedByte() throws IOException {
        this.byteAlign();
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    public int[] readUnsignedByte(int n2) throws IOException {
        this.byteAlign();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.read();
            if (n3 < 0) {
                throw new EOFException();
            }
            nArray[i2] = n3;
        }
        return nArray;
    }

    public short readShort() throws IOException {
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        return this.little ? (short)((n3 << 8) + n2) : (short)((n2 << 8) + n3);
    }

    public short[] readShort(int n2) throws IOException {
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = this.readShort();
        }
        return sArray;
    }

    public int readUnsignedShort() throws IOException {
        this.byteAlign();
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        return this.little ? (n3 << 8) + n2 : (n2 << 8) + n3;
    }

    public int[] readUnsignedShort(int n2) throws IOException {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.readUnsignedShort();
        }
        return nArray;
    }

    public int readInt() throws IOException {
        int n2 = this.readUnsignedByte();
        int n3 = this.readUnsignedByte();
        int n4 = this.readUnsignedByte();
        int n5 = this.readUnsignedByte();
        return this.little ? (n5 << 24) + (n4 << 16) + (n3 << 8) + n2 : (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    public int[] readInt(int n2) throws IOException {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.readInt();
        }
        return nArray;
    }

    public long readUnsignedInt() throws IOException {
        long l2 = this.readUnsignedByte();
        long l3 = this.readUnsignedByte();
        long l4 = this.readUnsignedByte();
        long l5 = this.readUnsignedByte();
        return this.little ? (l5 << 24) + (l4 << 16) + (l3 << 8) + l2 : (l2 << 24) + (l3 << 16) + (l4 << 8) + l5;
    }

    public long[] readUnsignedInt(int n2) throws IOException {
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = this.readUnsignedInt();
        }
        return lArray;
    }

    public long readLong() throws IOException {
        long l2 = this.readInt();
        long l3 = this.readInt();
        return this.little ? (l3 << 32) + (l2 & 0xFFFFFFFFL) : (l2 << 32) + (l3 & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        throw new IOException("ByteOrderInputStream.readLine() is deprecated and not implemented.");
    }

    public String readString() throws IOException {
        return this.readUTF();
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public String readAsciiZString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = (char)this.readUnsignedByte();
        while (c2 != '\u0000') {
            stringBuffer.append(c2);
            c2 = (char)this.readUnsignedByte();
        }
        return stringBuffer.toString();
    }
}

