/*
 * RenderState.cpp
 *
 * Copyright (C) 2000 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include "stdafx.h"

#include "DuneApp.h"
#include "RenderState.h"

RenderState::RenderState()
{
}

Vec3f
RenderState::project(const Vec3f &point)
{
    Vec3f	w = _projectionMatrix * (_modelviewMatrix * point);
    Vec3f	r;

      r.x = _viewport[0] + (w.x + 1.0f) * _viewport[2] * 0.5f;
      r.y = _viewport[1] + (w.y + 1.0f) * _viewport[3] * 0.5f;
      r.z = (w.z + 1.0f) * 0.5f;
    
    return r;
}

void
RenderState::startDrawHandles()
{
    glGetFloatv(GL_MODELVIEW_MATRIX, (GLfloat *) _modelviewMatrix);
    glGetFloatv(GL_PROJECTION_MATRIX, (GLfloat *) _projectionMatrix);
    glGetFloatv(GL_VIEWPORT, (GLfloat *) _viewport);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho(_viewport[0], _viewport[0] + _viewport[2],
    	    _viewport[1], _viewport[1] + _viewport[3],
	    -1.0f, 1.0f);
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glLoadIdentity();
}

void
RenderState::drawHandle(const Vec3f &pos)
{
    Vec3f	w = project(pos);

    float handleSize = TheApp->GetHandleSize();

    glBegin(GL_POLYGON);
    glVertex3f(w.x - handleSize, w.y - handleSize, w.z);
    glVertex3f(w.x - handleSize, w.y + handleSize, w.z);
    glVertex3f(w.x + handleSize, w.y + handleSize, w.z);
    glVertex3f(w.x + handleSize, w.y - handleSize, w.z);
    glEnd();
}

void
RenderState::endDrawHandles()
{
    glPopMatrix();
    glMatrixMode(GL_PROJECTION);
    glLoadMatrixf((GLfloat *) _projectionMatrix);
    glMatrixMode(GL_MODELVIEW);
}
