/*
 * MFNode.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _MFNODE_H
#define _MFNODE_H

#ifndef _FIELDVALUE_H
#include "FieldValue.h"
#endif
#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _NODELIST_H
#include "NodeList.h"
#endif

class MFNode : public MFieldValue {
public:
			MFNode();
			MFNode(NodeList *value);
			MFNode(const MFNode &other);
    virtual	       ~MFNode();

    virtual int     	getType() const { return MFNODE; }
    virtual const char *getTypeName() const { return "MFNode"; }
    virtual int		write(int filedes, int indent) const;
//    virtual int		writeCC(int filedes, char* variableName) const;
    virtual bool	equals(const FieldValue *value) const;
    int			getSize() const { return _value->size(); }
    NodeList	       *getValues() const { return _value; }
    Node	       *getValue(int index) const 
                           { 
                           assert(index >= 0 && index < _value->size()); 
                           return _value->get(index); 
                           }

    virtual int		getSFSize() const 
                           { 
                           if (_value==NULL) 
                               return 0;
                           else 
                               return _value->size(); 
                           }
    virtual FieldValue *getSFValue(int index) const;
    virtual void	setSFValue(int index, FieldValue *value);
    virtual void	setSFValue(int index, const Node* value);

    virtual FieldValue *addNode(Node *node) const;
    virtual FieldValue *removeNode(Node *node) const;
    virtual FieldValue *copy() { return new MFNode(*this); }

    MyString	        getEcmaScriptComment(MyString name, int flags) const;

    bool                isAnimateable() const { return false; }

private:
    NodeList	       *_value;
};

#endif // _MFNODE_H
