#!/usr/bin/perl -w
# Parse http://standards.ieee.org/regauth/oui/oui_public.txt
# to produce a .cc file.

use strict;

my ($prefix1,$prefix2,$prefix3,$name);

print "/* File generated by mkmacvendor.pl. Do not edit! */\n\n";
print "static struct wf_mac_vendor mac_vendor[] = {\n";

while (<STDIN>) {
  next unless /\(hex\)/;

  ($prefix1,$prefix2,$prefix3,$name) = ($_ =~ m|^([0-9a-zA-F]{2})-([0-9a-zA-F]{2})-([0-9a-zA-F]{2})\s+\(hex\)\s+(.*)|);
  die "name \`$name' contains '\"'" if ($name =~ /\"/);

  print "  { 0x$prefix1, 0x$prefix2, 0x$prefix3, \"$name\" },\n";
}
print "};\n";
exit 0;
