/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef VIEWFACTORY_H
#define VIEWFACTORY_H

class QObject;
class QWidget;

class View;

/**
* Factory for creating views.
*/
class ViewFactory
{
public:
    /**
    * Create a view of the given class.
    *
    * @param className Name of the view's class.
    *
    * @param parent The parent object of the view.
    *
    * @param parentWidget The parent widget of the view's main widget.
    *
    * @return The created view.
    */
    static View* createView( const char* className, QObject* parent, QWidget* parentWidget );
};

#endif
