<?php
/**************************************************************************
* This file is part of the WebIssues Server program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

require_once( 'database.inc.php' );

function wi_check_config()
{
    global $config, $body;

    if ( !wi_check_database() ) {
        $body .= "<p><strong>ERROR:</strong> No database engine selected or engine is not available.</p>\n";
        return false;
    }

    if ( !wi_open_database() ) {
        $body .= "<p><strong>ERROR:</strong> Could not connect to the database server.</p>\n";
        return false;
    }

    if ( $config[ 'storage_path' ] != '' ) {
        if ( !is_dir( $config[ 'storage_path' ] ) ) {
            $body .= "<p><strong>ERROR:</strong> The storage path does not exist or is not accessible.</p>\n";
            return false;
        }
        $path = $config[ 'storage_path' ] . '/' . uniqid( mt_rand() ) . '.tmp';
        $fh = @fopen( $path, 'a' );
        if ( !$fh ) {
            $body .= "<p><strong>ERROR:</strong> The storage path is not writable.</p>\n";
            return false;
        }
        fclose( $fh );
        unlink( $path );
    }

    foreach ( array( 'errors', 'commands', 'sql' ) as $name ) {
        if ( isset( $config[ "log_$name" ] ) && $config[ "log_$name" ] != '' ) {
            if ( !wi_log_check( $name ) ) {
                $body .= "<p><strong>ERROR:</strong> The log path does not exist or is not writable.</p>\n";
                return false;
            }
        }
    }

    return true;
}
