/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/

#include <string>
#include <list>
#include <map>
#include <fstream>
#include <sstream>
/* -- */
#include "trace/values/Values.hpp"
#include "trace/EntityTypes.hpp"
#include "trace/Entitys.hpp"
#include "trace/Trace.hpp"
/* -- */
#include "common/Message.hpp"
/* -- */
#include "parser/Parser.hpp"
#include "parser/ParserPaje.hpp"
#include "parser/ParserVite.hpp"
#ifdef WITH_OTF
#include <otf.h>
#include "parser/ParserOTF.hpp"
#endif //WITH_OTF

#ifdef WITH_TAU
#include <TAU_tf.h>
#include "parser/ParserTau.hpp"
#endif //WITH_TAU

#include "ParserFactory.hpp"

using namespace std;

bool ParserFactory::create(Parser **parser,
			   const string &filename)
{
    size_t pos = filename.find_last_of('.');
    string ext = "";

    if (pos != string::npos) {
	ext = filename.substr(pos);

       if(ext == ".trace") {
	    *parser = new ParserPaje(filename);
	}
	else if(ext == ".ept") {
	    *parser = new ParserVite(filename);
	}
	else if(ext == ".otf") {
#ifdef WITH_OTF
	    *parser = new ParserOTF(filename);
#else
            *Message::get_instance() << "OTF parser was not compiled. Use parser Paje by default" << Message::endw;
#endif //WITH_OTF
        }
	else if( (ext == ".trc") || (ext == ".edf") ) {
#ifdef WITH_TAU
	    *parser = new ParserTau(filename);
#else
            *Message::get_instance() << "Tau parser was not compiled. Use parser Paje by default" << Message::endw;
#endif //WITH_TAU
	}
    }

    if(*parser == NULL) {
	*parser = new ParserPaje(filename);
	return false;
    }

    return true;
}
