/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
/*!
 *\file File.hpp
 */


#ifndef FILE_HPP
#define FILE_HPP

class Line;

/*! \class File File.hpp "../source/src/parser/File.hpp"
 *  \brief File object stand for paje format syntax unit .
 */

class File {

private:
    mutable std::ifstream _file; // mutable to get the size
    
    std::string  _filename;
    unsigned int _current_line;
    int          _filesize;

    File(const File &);
public:
    /*!
     *  \brief Constructor for the file
     */
    File();

    /*!
     *  \brief  Constructor for the file
     *  \param  filename : a filename
     */
    File(std::string &filename);

    /*!
     *  \brief Destructor
     *  Destroy the file
     */
    ~File();
        
    /*!
     *  \fn open(std::string &filename)
     *  \brief Open the file
     *  \param filename the file name
     */
    void open(std::string &filename);

    /*!
     *  \fn close()
     *  \brief Close the file if already opened
     */
    void close();

    /*!
     *  \fn get_line(Line &)
     *  \brief Get the next line.
     *  \return the next line
     */
    void get_line(Line &);

    /*!
     *  \fn is_eof() const
     *  \brief test if file ended
     *  \return true if more files are available
     */
    bool is_eof() const;

    /*!
     *  \fn is_opened()
     *  \brief test if file is opened
     *  \return true if the file is opened
     */
    bool is_opened();

    /*!
     *  \fn is_a_file()
     *  \brief test if file is a file
     *  \return true if the file is a file
     */
    bool is_a_file();

    /*!
     *  \fn get_size_loaded() const;
     *  \return the scale of the size already loaded of the file by the parser. (between 0 and 1)
     */
    float get_size_loaded() const;
    

};

#endif // FILE_HPP
