# Copyright (c) 2001, Stanford University
# All rights reserved.
#
# See the file LICENSE.txt for information on redistributing this software.

# This script generates include/cr_opcodes.h from the gl_header.parsed file.

import sys;
import cPickle;
import string;
import re;

import apiutil

apiutil.CopyrightC()

print ""
print "/* DO NOT EDIT - THIS FILE GENERATED BY THE opcodes.py SCRIPT */"
print ""
print "#ifndef CR_OPCODES_H"
print "#define CR_OPCODES_H"
print ""

keys = apiutil.GetDispatchedFunctions(sys.argv[1]+"/APIspec.txt")
assert len(keys) > 0

print "/* Functions with no return value and input-only parameters */"
print "typedef enum {"

enum_index = 0
for func in keys:
	if "pack" in apiutil.ChromiumProps(func):
		print "\t%s = %d," % ( apiutil.OpcodeName(func), enum_index )
		enum_index = enum_index + 1

if enum_index > 255:
	# This would have saved Mike some grief if it had been here earlier.
	print >> sys.stderr, "You have more than 255 opcodes!  You've been adding functions to"
	print >> sys.stderr, "glapi_parser/APIspec!  Each new function you add"
	print >> sys.stderr, "gets an opcode assigned to it.  Fortunately for you, we have"
	print >> sys.stderr, "an ``extend'' opcode.  Please mark the function as"
	print >> sys.stderr, "'extpack' in APIspec so as to keep the main opcode pool"
	print >> sys.stderr, "less than 255!  THIS IS A CATASTROPHIC FAILURE, and I WILL NOT CONTINUE!"
	print >> sys.stderr, "I'm putting an error in the generated header file so you won't miss"
	print >> sys.stderr, "this even if you're doing a 'make -k.'"
	print "#error -- more than 255 opcodes!"
	sys.exit(-1)
print "\tCR_EXTEND_OPCODE=%d" % enum_index
print "} CROpcode;\n"

# count up number of extended opcode commands
num_extends = 0
for func in keys:
	if "extpack" in apiutil.ChromiumProps(func):
		num_extends += 1

print "/* Functions with a return value or output parameters */"
print "typedef enum {"

enum_index = 0
for func in keys:
	if "extpack" in apiutil.ChromiumProps(func):
		opcodeName = apiutil.ExtendedOpcodeName(func)
		if enum_index != num_extends-1:
			print "\t%s = %d," % (opcodeName, enum_index )
		else:
			print "\t%s = %d" % (opcodeName, enum_index )
		enum_index = enum_index + 1
print "} CRExtendOpcode;\n"
print "#endif /* CR_OPCODES_H */"
