/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef FILEDIALOG_H
#define FILEDIALOG_H
#include <vdk/vdk.h>

// undef this and you can use regex library
// so in dialog filter: '*\.(cc|h)$'
#define _USE_FNMATCH

#ifndef _USE_FNMATCH
# include <regex.h>
#else
# include <fnmatch.h>
#endif

#include <dirent.h>
extern "C" {
#include <sys/stat.h>
}

//
typedef VDKArray<VDKString> FileStringArray;
typedef VDKValueList<VDKString> FileStringList;
typedef VDKValueListIterator<VDKString> FileStringListIterator;
/*!
  \class VDKFileDialog
  \brief Provides a file selection modal window that supports 
  multiple file selection. 
  \par Usage
  \code
  #include <vdk/FileDialog.h>
  FileStringArray selections;
  VDKFileDialog *child = new VDKFileDialog( Application()->MainForm, 
                             &selections, "File Open dialog");
  child->Filter = "*.cc";
  child->ShowModal();
  for( int t = 0; t < selections.size(); t++)
    {
    printf("\nselection:%s",(char*) selections[t]);
    fflush(stdout);
    } 
  \endcode
  On return selections will be an empty array if user presses "cancel" button.
  \par Tip
  #define _USE_FNMATCH
  Undefining above line into FileDialog.h and recompiling
  make possible to use regex library for filters.
  i.e:
  \code
  child->Filter = "*\.(cc|h)$"
  \endcode
 */
class VDKFileDialog: public VDKForm
{
  VDKBox* listbox;
  VDKString home;
  bool init();
  FileStringList* load_dir(char* dir, int mask);
  // mode == 0 filter dirs, 1 filters files
  FileStringList* filter(FileStringList* list, int mode = 0);
  void LoadFileList(FileStringList* list);
  void LoadDirList(FileStringList* list);
  void LoadDir(char* dir = (char*) NULL);
 protected:
  VDKString first_pcwd,pcwd;
  FileStringArray* selections;
  VDKCustomList *dirlist;
  VDKCustomList *filelist;
  VDKEntry *filetype;
  VDKCustomButton *open,*cancel;
  VDKLabel *dir_label,*filetypeLabel;
  VDKCheckButton *hiddenCb;
  bool DirListDoubleClick(VDKObject* sender);
  bool OpenClick(VDKObject*);
  bool CancelClick(VDKObject*);
  bool ToggleHidden(VDKObject*);
  bool SetFileMask(VDKObject*);
 public:
  /*!
    Sets/gets file filter
   */
  VDKReadWriteValueProp<VDKFileDialog,VDKString> Filter;
  VDKFileDialog(VDKForm* owner,
		FileStringArray* selections,
		char* title = "",
		GtkWindowType display = GTK_WINDOW_TOPLEVEL);
  virtual ~VDKFileDialog() {}
  bool CanClose();
  virtual void Setup(void) {}
  virtual void OnShow(VDKForm*);
  void SetFilter(VDKString f)
    { Filter(f); }
  VDKString GetFilter(void)
    {
      VDKString filter = Filter;
      return VDKString(filter);
    }
  DECLARE_SIGNAL_MAP(VDKFileDialog);
};

#endif
