%define prefix   /usr

#Uncomment these if they are not defined by your rpm macros file
#%define _prefix                /usr
#%define _exec_prefix           %{_prefix}
#%define _bindir                %{_exec_prefix}/bin
#%define _sbindir               %{_exec_prefix}/sbin
#%define _libexecdir            %{_exec_prefix}/libexec
#%define _datadir               %{_prefix}/share
#%define _sysconfdir            %{_prefix}/etc
#%define _sharedstatedir        %{_prefix}/com
#%define _localstatedir         %{_prefix}/var
#%define _lib                   lib
#%define _libdir                %{_exec_prefix}/%{_lib}
#%define _includedir            %{_prefix}/include
#%define _oldincludedir         /usr/include
#%define _infodir               %{_prefix}/info
#%define _mandir                %{_prefix}/man

Summary: Generic logging layer
Name: vanessa_logger
Version: 0.0.7
Release: 1
Copyright: GNU Lesser General Public Licence
URL: http://www.vergenet.net/linux/vanessa/
Packager: Horms <horms@verge.net.au>
Group: Development/Libraries
Source0: http://www.vergenet.net/linux/vanessa/download/vanessa_logger/%{version}/%{name}-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-root
Docdir: %{prefix}/doc
Provides: %{name}-%{version}
BuildPrereq: automake autoconf libtool

%description
Generic logging layer that may be used to log to one or more of syslog, an
open file handle or a file name. Though due to to limitations in the
implementation of syslog opening multiple syslog loggers doesn't makes
sense. Includes the ability to limit which messages will be logged based on
priorities.

%package devel
Summary: Headers and static libraries for development
Group: Development/Libraries
Requires: %{name}-%{version}
Provides: %{name}-devel-%{version}

%description devel
Headers and static libraries required to develop against vanessa_logger.

%package sample
Summary: Example programme that demonstrates vanessa_logger.
Group: Development/Libraries
Requires: %{name}-devel-%{version}

%description sample
Sample programme with source that demonstrates various features of
vanessa_logger.


%prep
%setup

%build

# I am providing my own configure macro replacement. Hopefully this
# will result in fewer portability problems than using the one supplied
# by various vendours. I fear that I hope in vein.
CFLAGS="${CFLAGS:-%optflags}" ; export CFLAGS
if [ -f confgure.in ]; then
	aclocal
	libtoolize --force --copy
	autoheader
	automake
	autoconf
fi
./configure %{_target_platform} \
       --prefix=%{_prefix} \
       --exec-prefix=%{_exec_prefix} \
       --bindir=%{_bindir} \
       --sbindir=%{_sbindir} \
       --sysconfdir=%{_sysconfdir} \
       --datadir=%{_datadir} \
       --includedir=%{_includedir} \
       --libdir=%{_libdir} \
       --libexecdir=%{_libexecdir} \
       --localstatedir=%{_localstatedir} \
       --sharedstatedir=%{_sharedstatedir} \
       --mandir=%{_mandir} \
       --infodir=%{_infodir}

make

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/%{prefix}/doc
make DESTDIR=$RPM_BUILD_ROOT install


%clean
rm -rf $RPM_BUILD_ROOT


%post

%postun

%preun

%files
%defattr(-, root, root)
%{_libdir}/*.so*

%files devel
%defattr(-, root, root)
%{_libdir}/*.*a
%{_includedir}/*.h
%doc README COPYING ChangeLog

%files sample
%defattr(-, root, root)
%{_bindir}/*
%{_mandir}/man1/vanessa_logger_sample.*
%doc sample/*.c sample/*.h

%changelog
* Fri Dec 14 2001 Horms <horms@verge.net.au>
  Revamped configure to use %{_libdir} and friends. This should be more
  distribution indepentant. With thanks to Scot W. Hetzel <scot@genroco.com>
* Thu Apr 26 2001 Horms <horms@verge.net.au>
  Updated to "work" with Red Hat 7
* Sat Sep 15 2000 Horms <horms@verge.net.au>
  created for version 0.0.0
