/* genprojectdialog.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from genprojectdialog.vala, do not modify */

/* genprojectdialog.vala
 *
 * Copyright (C) 2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Andrea Del Signore <sejerpz@tin.it>
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gen-project.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_GEN_PROJECT_DIALOG (vala_gen_project_dialog_get_type ())
#define VALA_GEN_PROJECT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GEN_PROJECT_DIALOG, ValaGenProjectDialog))
#define VALA_GEN_PROJECT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GEN_PROJECT_DIALOG, ValaGenProjectDialogClass))
#define VALA_IS_GEN_PROJECT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GEN_PROJECT_DIALOG))
#define VALA_IS_GEN_PROJECT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GEN_PROJECT_DIALOG))
#define VALA_GEN_PROJECT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GEN_PROJECT_DIALOG, ValaGenProjectDialogClass))

typedef struct _ValaGenProjectDialog ValaGenProjectDialog;
typedef struct _ValaGenProjectDialogClass ValaGenProjectDialogClass;
typedef struct _ValaGenProjectDialogPrivate ValaGenProjectDialogPrivate;

#define VALA_TYPE_TAG_CLOUD (vala_tag_cloud_get_type ())
#define VALA_TAG_CLOUD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TAG_CLOUD, ValaTagCloud))
#define VALA_TAG_CLOUD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TAG_CLOUD, ValaTagCloudClass))
#define VALA_IS_TAG_CLOUD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TAG_CLOUD))
#define VALA_IS_TAG_CLOUD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TAG_CLOUD))
#define VALA_TAG_CLOUD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TAG_CLOUD, ValaTagCloudClass))

typedef struct _ValaTagCloud ValaTagCloud;
typedef struct _ValaTagCloudClass ValaTagCloudClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))

#define VALA_TYPE_TAG_CLOUD_ITEM (vala_tag_cloud_item_get_type ())
#define VALA_TAG_CLOUD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TAG_CLOUD_ITEM, ValaTagCloudItem))
#define VALA_TAG_CLOUD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TAG_CLOUD_ITEM, ValaTagCloudItemClass))
#define VALA_IS_TAG_CLOUD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TAG_CLOUD_ITEM))
#define VALA_IS_TAG_CLOUD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TAG_CLOUD_ITEM))
#define VALA_TAG_CLOUD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TAG_CLOUD_ITEM, ValaTagCloudItemClass))

typedef struct _ValaTagCloudItem ValaTagCloudItem;
typedef struct _ValaTagCloudItemClass ValaTagCloudItemClass;

#define VALA_TYPE_SELECT_STATUS (vala_select_status_get_type ())
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ValaParamSpecGenProjectDialog ValaParamSpecGenProjectDialog;

struct _ValaGenProjectDialog {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGenProjectDialogPrivate * priv;
};

struct _ValaGenProjectDialogClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGenProjectDialog *self);
};

struct _ValaGenProjectDialogPrivate {
	GtkDialog* config_dialog;
	GtkFileChooserButton* project_folder_button;
	GtkIconView* project_type_iconview;
	GtkComboBox* license_combobox;
	GtkComboBox* combobox_languages;
	GtkEntry* name_entry;
	GtkEntry* email_entry;
	GtkButton* button_create_project;
	ValaTagCloud* tag_cloud;
	GenProjectTemplates* templates;
};

typedef enum  {
	VALA_SELECT_STATUS_SELECTED,
	VALA_SELECT_STATUS_EXCLUDED,
	VALA_SELECT_STATUS_NOT_SELECTED
} ValaSelectStatus;

struct _ValaParamSpecGenProjectDialog {
	GParamSpec parent_instance;
};


static gpointer vala_gen_project_dialog_parent_class = NULL;
extern GenProjectProjectLicense option_project_license;

gpointer vala_gen_project_dialog_ref (gpointer instance);
void vala_gen_project_dialog_unref (gpointer instance);
GParamSpec* vala_param_spec_gen_project_dialog (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_gen_project_dialog (GValue* value, gpointer v_object);
void vala_value_take_gen_project_dialog (GValue* value, gpointer v_object);
gpointer vala_value_get_gen_project_dialog (const GValue* value);
GType vala_gen_project_dialog_get_type (void) G_GNUC_CONST;
GType vala_tag_cloud_get_type (void) G_GNUC_CONST;
#define VALA_GEN_PROJECT_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GEN_PROJECT_DIALOG, ValaGenProjectDialogPrivate))
enum  {
	VALA_GEN_PROJECT_DIALOG_DUMMY_PROPERTY
};
static void vala_gen_project_dialog_initialize_ui (ValaGenProjectDialog* self, GenProjectProjectOptions* options);
static void _lambda0_ (GtkTreePath* sender, ValaGenProjectDialog* self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static void __lambda0__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self);
ValaTagCloud* vala_tag_cloud_new (void);
ValaTagCloud* vala_tag_cloud_construct (GType object_type);
static void _lambda1_ (ValaTagCloud* sender, ValaGenProjectDialog* self);
static void vala_gen_project_dialog_refilter_projects (ValaGenProjectDialog* self);
static void __lambda1__vala_tag_cloud_selected_items_changed (ValaTagCloud* _sender, gpointer self);
static void _lambda2_ (GtkComboBox* sender, ValaGenProjectDialog* self);
static void __lambda2__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
GType vala_tag_cloud_item_get_type (void) G_GNUC_CONST;
ValaTagCloudItem* vala_tag_cloud_get_item_with_text (ValaTagCloud* self, const gchar* text);
GType vala_select_status_get_type (void) G_GNUC_CONST;
ValaTagCloudItem* vala_tag_cloud_item_new (const gchar* text, gint occourrences, ValaSelectStatus select_status);
ValaTagCloudItem* vala_tag_cloud_item_construct (GType object_type, const gchar* text, gint occourrences, ValaSelectStatus select_status);
void vala_tag_cloud_add_item (ValaTagCloud* self, ValaTagCloudItem* item);
gint vala_tag_cloud_item_get_occourrences (ValaTagCloudItem* self);
void vala_tag_cloud_item_set_occourrences (ValaTagCloudItem* self, gint value);
static gboolean _lambda3_ (GtkTreeModel* model, GtkTreeIter* iter, ValaGenProjectDialog* self);
ValaSelectStatus vala_tag_cloud_item_get_select_status (ValaTagCloudItem* self);
static gboolean __lambda3__gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
GtkResponseType vala_gen_project_dialog_ask_parameters (ValaGenProjectDialog* self, GenProjectProjectOptions* options);
ValaGenProjectDialog* vala_gen_project_dialog_new (void);
ValaGenProjectDialog* vala_gen_project_dialog_construct (GType object_type);
static void vala_gen_project_dialog_finalize (ValaGenProjectDialog* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static void _lambda0_ (GtkTreePath* sender, ValaGenProjectDialog* self) {
	GList* _tmp0_ = NULL;
	GList* _tmp1_;
	guint _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (sender != NULL);
	_tmp0_ = gtk_icon_view_get_selected_items (self->priv->project_type_iconview);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_list_length (_tmp1_);
	_tmp3_ = _tmp2_ > 0;
	__g_list_free__gtk_tree_path_free0_0 (_tmp1_);
	if (_tmp3_) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->button_create_project, TRUE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->button_create_project, FALSE);
	}
}


static void __lambda0__gtk_icon_view_item_activated (GtkIconView* _sender, GtkTreePath* path, gpointer self) {
	_lambda0_ (path, self);
}


static void _lambda1_ (ValaTagCloud* sender, ValaGenProjectDialog* self) {
	g_return_if_fail (sender != NULL);
	vala_gen_project_dialog_refilter_projects (self);
}


static void __lambda1__vala_tag_cloud_selected_items_changed (ValaTagCloud* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static void _lambda2_ (GtkComboBox* sender, ValaGenProjectDialog* self) {
	g_return_if_fail (sender != NULL);
	vala_gen_project_dialog_refilter_projects (self);
}


static void __lambda2__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	_lambda2_ (_sender, self);
}


static gboolean _lambda3_ (GtkTreeModel* model, GtkTreeIter* iter, ValaGenProjectDialog* self) {
	gboolean result = FALSE;
	gboolean visible;
	GenProjectTemplateDefinition* definition = NULL;
	GtkTreeIter language_iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_val_if_fail (model != NULL, FALSE);
	visible = FALSE;
	gtk_tree_model_get (model, iter, 1, &definition, -1);
	_tmp1_ = gtk_combo_box_get_active_iter (self->priv->combobox_languages, &_tmp0_);
	language_iter = _tmp0_;
	visible = _tmp1_;
	if (visible) {
		GtkTreeModel* _tmp2_ = NULL;
		GtkTreeModel* _tmp3_;
		GtkTreeModel* language_model;
		gchar* selected_language = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = gtk_combo_box_get_model (self->priv->combobox_languages);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		language_model = _tmp3_;
		gtk_tree_model_get (language_model, &language_iter, 0, &selected_language, -1);
		_tmp4_ = gen_project_template_definition_get_language (definition);
		visible = g_strcmp0 (selected_language, _tmp4_) == 0;
		_g_free0 (selected_language);
		_g_object_unref0 (language_model);
	}
	if (visible) {
		GList* _tmp5_ = NULL;
		_tmp5_ = gen_project_template_definition_get_tags (definition);
		{
			GList* tag_collection;
			GList* tag_it;
			tag_collection = _tmp5_;
			for (tag_it = tag_collection; tag_it != NULL; tag_it = tag_it->next) {
				gchar* _tmp6_;
				gchar* tag;
				_tmp6_ = g_strdup ((const gchar*) tag_it->data);
				tag = _tmp6_;
				{
					ValaTagCloudItem* _tmp7_ = NULL;
					ValaTagCloudItem* tag_item;
					_tmp7_ = vala_tag_cloud_get_item_with_text (self->priv->tag_cloud, tag);
					tag_item = _tmp7_;
					if (tag_item != NULL) {
						ValaSelectStatus _tmp8_;
						_tmp8_ = vala_tag_cloud_item_get_select_status (tag_item);
						if (_tmp8_ == VALA_SELECT_STATUS_EXCLUDED) {
							visible = FALSE;
							_g_object_unref0 (tag_item);
							_g_free0 (tag);
							break;
						} else {
							ValaSelectStatus _tmp9_;
							_tmp9_ = vala_tag_cloud_item_get_select_status (tag_item);
							if (_tmp9_ == VALA_SELECT_STATUS_SELECTED) {
								visible = TRUE;
							}
						}
					}
					_g_object_unref0 (tag_item);
					_g_free0 (tag);
				}
			}
		}
	}
	result = visible;
	_g_object_unref0 (definition);
	return result;
}


static gboolean __lambda3__gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = _lambda3_ (model, iter, self);
	return result;
}


static void vala_gen_project_dialog_initialize_ui (ValaGenProjectDialog* self, GenProjectProjectOptions* options) {
	GtkTreeIter item = {0};
	GenProjectTemplates* _tmp0_ = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GtkBuilder* builder;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GObject* _tmp4_ = NULL;
	GObject* _tmp5_;
	GtkDialog* _tmp6_;
	const gchar* _tmp7_ = NULL;
	GObject* _tmp8_ = NULL;
	GObject* _tmp9_;
	GtkButton* _tmp10_;
	GObject* _tmp11_ = NULL;
	GObject* _tmp12_;
	GtkFileChooserButton* _tmp13_;
	GtkHBox* hbox = NULL;
	GtkCellRendererPixbuf* _tmp17_ = NULL;
	GtkCellRenderer* renderer;
	GObject* _tmp18_ = NULL;
	GObject* _tmp19_;
	GtkIconView* _tmp20_;
	GtkCellRendererText* _tmp21_ = NULL;
	GObject* _tmp22_ = NULL;
	GObject* _tmp23_;
	GtkScrolledWindow* _tmp24_;
	GtkScrolledWindow* tags;
	ValaTagCloud* _tmp25_ = NULL;
	GObject* _tmp26_ = NULL;
	GObject* _tmp27_;
	GtkComboBox* _tmp28_;
	GtkTreeModel* _tmp29_ = NULL;
	GtkTreeModel* _tmp30_;
	GtkListStore* _tmp31_;
	GtkListStore* languages_model;
	GtkCellRendererText* _tmp32_ = NULL;
	GtkTreeModel* _tmp33_ = NULL;
	GtkTreeModel* _tmp34_;
	GtkListStore* _tmp35_;
	GtkListStore* model;
	gint selected_id;
	gint count;
	GList* _tmp36_ = NULL;
	GtkTreeModelFilter* _tmp60_ = NULL;
	GtkTreeModelFilter* filtered_model;
	gchar* _tmp61_ = NULL;
	gchar* _tmp62_;
	GtkTreePath* _tmp63_ = NULL;
	GtkTreePath* _tmp64_;
	GObject* _tmp65_ = NULL;
	GObject* _tmp66_;
	GtkComboBox* _tmp67_;
	GtkCellRendererText* _tmp68_ = NULL;
	GtkTreeModel* _tmp69_ = NULL;
	GtkTreeModel* _tmp70_;
	GtkListStore* _tmp71_;
	GtkTreeIter _tmp72_ = {0};
	const gchar* _tmp73_ = NULL;
	GtkTreeIter _tmp74_ = {0};
	const gchar* _tmp75_ = NULL;
	GtkTreeIter _tmp76_ = {0};
	const gchar* _tmp77_ = NULL;
	GtkTreeIter _tmp78_ = {0};
	const gchar* _tmp79_ = NULL;
	GObject* _tmp80_ = NULL;
	GObject* _tmp81_;
	GtkEntry* _tmp82_;
	GObject* _tmp83_ = NULL;
	GObject* _tmp84_;
	GtkEntry* _tmp85_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (options != NULL);
	_tmp0_ = gen_project_templates_load (NULL, 0);
	_g_object_unref0 (self->priv->templates);
	self->priv->templates = _tmp0_;
	_tmp1_ = gtk_builder_new ();
	builder = _tmp1_;
	_tmp2_ = g_build_filename (PACKAGE_DATADIR, "ui", "gen-project.ui", NULL);
	_tmp3_ = _tmp2_;
	gtk_builder_add_from_file (builder, _tmp3_, &_inner_error_);
	_g_free0 (_tmp3_);
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	_tmp4_ = gtk_builder_get_object (builder, "dialog-gen-project");
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (GTK_IS_DIALOG (_tmp5_) ? ((GtkDialog*) _tmp5_) : NULL);
	_g_object_unref0 (self->priv->config_dialog);
	self->priv->config_dialog = _tmp6_;
	g_assert (self->priv->config_dialog != NULL);
	_tmp7_ = _ ("Vala Project Generator");
	gtk_window_set_title ((GtkWindow*) self->priv->config_dialog, _tmp7_);
	_tmp8_ = gtk_builder_get_object (builder, "button-create-project");
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp9_) ? ((GtkButton*) _tmp9_) : NULL);
	_g_object_unref0 (self->priv->button_create_project);
	self->priv->button_create_project = _tmp10_;
	g_assert (self->priv->button_create_project != NULL);
	_tmp11_ = gtk_builder_get_object (builder, "filechooserbutton-project-folder");
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (GTK_IS_FILE_CHOOSER_BUTTON (_tmp12_) ? ((GtkFileChooserButton*) _tmp12_) : NULL);
	_g_object_unref0 (self->priv->project_folder_button);
	self->priv->project_folder_button = _tmp13_;
	g_assert (self->priv->project_folder_button != NULL);
	if (options->path != NULL) {
		GObject* _tmp14_ = NULL;
		GObject* _tmp15_;
		GtkHBox* _tmp16_;
		_tmp14_ = gtk_builder_get_object (builder, "hbox-project-folder");
		_tmp15_ = _tmp14_;
		_tmp16_ = _g_object_ref0 (GTK_IS_HBOX (_tmp15_) ? ((GtkHBox*) _tmp15_) : NULL);
		_g_object_unref0 (hbox);
		hbox = _tmp16_;
		g_assert (hbox != NULL);
		gtk_widget_set_visible ((GtkWidget*) hbox, FALSE);
	}
	_tmp17_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	renderer = (GtkCellRenderer*) g_object_ref_sink (_tmp17_);
	_tmp18_ = gtk_builder_get_object (builder, "iconview-project-type");
	_tmp19_ = _tmp18_;
	_tmp20_ = _g_object_ref0 (GTK_IS_ICON_VIEW (_tmp19_) ? ((GtkIconView*) _tmp19_) : NULL);
	_g_object_unref0 (self->priv->project_type_iconview);
	self->priv->project_type_iconview = _tmp20_;
	g_assert (self->priv->project_type_iconview != NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->project_type_iconview, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->project_type_iconview, renderer, "pixbuf", 2);
	_tmp21_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) g_object_ref_sink (_tmp21_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->project_type_iconview, renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->project_type_iconview, renderer, "text", 0);
	g_signal_connect (self->priv->project_type_iconview, "item-activated", (GCallback) __lambda0__gtk_icon_view_item_activated, self);
	_tmp22_ = gtk_builder_get_object (builder, "scrolledwindow-tags");
	_tmp23_ = _tmp22_;
	_tmp24_ = _g_object_ref0 (GTK_IS_SCROLLED_WINDOW (_tmp23_) ? ((GtkScrolledWindow*) _tmp23_) : NULL);
	tags = _tmp24_;
	g_assert (tags != NULL);
	_tmp25_ = vala_tag_cloud_new ();
	_g_object_unref0 (self->priv->tag_cloud);
	self->priv->tag_cloud = g_object_ref_sink (_tmp25_);
	g_signal_connect (self->priv->tag_cloud, "selected-items-changed", (GCallback) __lambda1__vala_tag_cloud_selected_items_changed, self);
	gtk_widget_show_all ((GtkWidget*) self->priv->tag_cloud);
	gtk_scrolled_window_add_with_viewport (tags, (GtkWidget*) self->priv->tag_cloud);
	_tmp26_ = gtk_builder_get_object (builder, "combobox-project-language");
	_tmp27_ = _tmp26_;
	_tmp28_ = _g_object_ref0 (GTK_IS_COMBO_BOX (_tmp27_) ? ((GtkComboBox*) _tmp27_) : NULL);
	_g_object_unref0 (self->priv->combobox_languages);
	self->priv->combobox_languages = _tmp28_;
	g_assert (self->priv->combobox_languages != NULL);
	g_signal_connect (self->priv->combobox_languages, "changed", (GCallback) __lambda2__gtk_combo_box_changed, self);
	_tmp29_ = gtk_combo_box_get_model (self->priv->combobox_languages);
	_tmp30_ = _tmp29_;
	_tmp31_ = _g_object_ref0 (GTK_IS_LIST_STORE (_tmp30_) ? ((GtkListStore*) _tmp30_) : NULL);
	languages_model = _tmp31_;
	_tmp32_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) g_object_ref_sink (_tmp32_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combobox_languages, renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->combobox_languages, renderer, "text", 0);
	_tmp33_ = gtk_icon_view_get_model (self->priv->project_type_iconview);
	_tmp34_ = _tmp33_;
	_tmp35_ = _g_object_ref0 (GTK_IS_LIST_STORE (_tmp34_) ? ((GtkListStore*) _tmp34_) : NULL);
	model = _tmp35_;
	g_assert (model != NULL);
	selected_id = 0;
	count = 0;
	_tmp36_ = gen_project_templates_get_definitions (self->priv->templates);
	{
		GList* definition_collection;
		GList* definition_it;
		definition_collection = _tmp36_;
		for (definition_it = definition_collection; definition_it != NULL; definition_it = definition_it->next) {
			GenProjectTemplateDefinition* _tmp37_;
			GenProjectTemplateDefinition* definition;
			_tmp37_ = _g_object_ref0 ((GenProjectTemplateDefinition*) definition_it->data);
			definition = _tmp37_;
			{
				GtkTreeIter _tmp38_ = {0};
				GdkPixbuf* icon;
				const gchar* _tmp39_ = NULL;
				const gchar* _tmp43_ = NULL;
				gboolean _tmp44_ = FALSE;
				GList* _tmp47_ = NULL;
				gboolean language_exists;
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp53_ = {0};
				gboolean _tmp54_;
				gtk_list_store_append (model, &_tmp38_);
				item = _tmp38_;
				icon = NULL;
				_tmp39_ = gen_project_template_definition_get_icon_filename (definition);
				if (_tmp39_ != NULL) {
					const gchar* _tmp40_ = NULL;
					GdkPixbuf* _tmp41_ = NULL;
					GdkPixbuf* _tmp42_;
					_tmp40_ = gen_project_template_definition_get_icon_filename (definition);
					_tmp41_ = gdk_pixbuf_new_from_file_at_size (_tmp40_, 24, 24, &_inner_error_);
					_tmp42_ = _tmp41_;
					if (_inner_error_ != NULL) {
						_g_object_unref0 (icon);
						_g_object_unref0 (definition);
						_g_object_unref0 (model);
						_g_object_unref0 (languages_model);
						_g_object_unref0 (tags);
						_g_object_unref0 (renderer);
						_g_object_unref0 (hbox);
						goto __catch1_g_error;
					}
					_g_object_unref0 (icon);
					icon = _tmp42_;
				}
				_tmp43_ = gen_project_template_definition_get_name (definition);
				gtk_list_store_set (model, &item, 0, _tmp43_, 1, definition, 2, icon, -1);
				if (options->template != NULL) {
					gint _tmp45_;
					gint _tmp46_;
					_tmp45_ = gen_project_template_definition_get_id (definition);
					_tmp46_ = gen_project_template_definition_get_id (options->template);
					_tmp44_ = _tmp45_ == _tmp46_;
				} else {
					_tmp44_ = FALSE;
				}
				if (_tmp44_) {
					selected_id = count;
				}
				_tmp47_ = gen_project_template_definition_get_tags (definition);
				{
					GList* tag_collection;
					GList* tag_it;
					tag_collection = _tmp47_;
					for (tag_it = tag_collection; tag_it != NULL; tag_it = tag_it->next) {
						gchar* _tmp48_;
						gchar* tag;
						_tmp48_ = g_strdup ((const gchar*) tag_it->data);
						tag = _tmp48_;
						{
							ValaTagCloudItem* _tmp49_ = NULL;
							ValaTagCloudItem* tag_item;
							gint _tmp51_;
							gint _tmp52_;
							_tmp49_ = vala_tag_cloud_get_item_with_text (self->priv->tag_cloud, tag);
							tag_item = _tmp49_;
							if (tag_item == NULL) {
								ValaTagCloudItem* _tmp50_ = NULL;
								_tmp50_ = vala_tag_cloud_item_new (tag, 0, VALA_SELECT_STATUS_SELECTED);
								_g_object_unref0 (tag_item);
								tag_item = _tmp50_;
								vala_tag_cloud_add_item (self->priv->tag_cloud, tag_item);
							}
							_tmp51_ = vala_tag_cloud_item_get_occourrences (tag_item);
							_tmp52_ = _tmp51_;
							vala_tag_cloud_item_set_occourrences (tag_item, _tmp52_ + 1);
							_g_object_unref0 (tag_item);
							_g_free0 (tag);
						}
					}
				}
				language_exists = FALSE;
				_tmp54_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) languages_model, &_tmp53_);
				iter = _tmp53_;
				if (_tmp54_) {
					{
						gboolean _tmp55_;
						_tmp55_ = TRUE;
						while (TRUE) {
							gchar* language = NULL;
							const gchar* _tmp57_ = NULL;
							if (!_tmp55_) {
								gboolean _tmp56_;
								_tmp56_ = gtk_tree_model_iter_next ((GtkTreeModel*) languages_model, &iter);
								if (!_tmp56_) {
									break;
								}
							}
							_tmp55_ = FALSE;
							gtk_tree_model_get ((GtkTreeModel*) languages_model, &iter, 0, &language, -1);
							_tmp57_ = gen_project_template_definition_get_language (definition);
							if (g_strcmp0 (language, _tmp57_) == 0) {
								language_exists = TRUE;
								_g_free0 (language);
								break;
							}
							_g_free0 (language);
						}
					}
				}
				if (!language_exists) {
					GtkTreeIter _tmp58_ = {0};
					const gchar* _tmp59_ = NULL;
					gtk_list_store_append (languages_model, &_tmp58_);
					item = _tmp58_;
					_tmp59_ = gen_project_template_definition_get_language (definition);
					gtk_list_store_set (languages_model, &item, 0, _tmp59_, -1);
				}
				count++;
				_g_object_unref0 (icon);
				_g_object_unref0 (definition);
			}
		}
	}
	gtk_combo_box_set_active (self->priv->combobox_languages, 0);
	_tmp60_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) model, NULL);
	filtered_model = _tmp60_;
	gtk_tree_model_filter_set_visible_func (filtered_model, __lambda3__gtk_tree_model_filter_visible_func, vala_gen_project_dialog_ref (self), vala_gen_project_dialog_unref);
	gtk_icon_view_set_model (self->priv->project_type_iconview, (GtkTreeModel*) filtered_model);
	_tmp61_ = g_strdup_printf ("%i", selected_id);
	_tmp62_ = _tmp61_;
	_tmp63_ = gtk_tree_path_new_from_string (_tmp62_);
	_tmp64_ = _tmp63_;
	gtk_icon_view_select_path (self->priv->project_type_iconview, _tmp64_);
	_gtk_tree_path_free0 (_tmp64_);
	_g_free0 (_tmp62_);
	_tmp65_ = gtk_builder_get_object (builder, "combobox-project-license");
	_tmp66_ = _tmp65_;
	_tmp67_ = _g_object_ref0 (GTK_IS_COMBO_BOX (_tmp66_) ? ((GtkComboBox*) _tmp66_) : NULL);
	_g_object_unref0 (self->priv->license_combobox);
	self->priv->license_combobox = _tmp67_;
	g_assert (self->priv->license_combobox != NULL);
	_tmp68_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) g_object_ref_sink (_tmp68_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->license_combobox, renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->license_combobox, renderer, "text", 0);
	_tmp69_ = gtk_combo_box_get_model (self->priv->license_combobox);
	_tmp70_ = _tmp69_;
	_tmp71_ = _g_object_ref0 (GTK_IS_LIST_STORE (_tmp70_) ? ((GtkListStore*) _tmp70_) : NULL);
	_g_object_unref0 (model);
	model = _tmp71_;
	g_assert (model != NULL);
	gtk_list_store_append (model, &_tmp72_);
	item = _tmp72_;
	_tmp73_ = _ ("GNU General Public License, version 2 or later");
	gtk_list_store_set (model, &item, 0, _tmp73_, 1, GEN_PROJECT_PROJECT_LICENSE_GPL2, -1);
	gtk_list_store_append (model, &_tmp74_);
	item = _tmp74_;
	_tmp75_ = _ ("GNU General Public License, version 3 or later");
	gtk_list_store_set (model, &item, 0, _tmp75_, 1, GEN_PROJECT_PROJECT_LICENSE_GPL3, -1);
	gtk_list_store_append (model, &_tmp76_);
	item = _tmp76_;
	_tmp77_ = _ ("GNU Lesser General Public License, version 2.1 or later");
	gtk_list_store_set (model, &item, 0, _tmp77_, 1, GEN_PROJECT_PROJECT_LICENSE_LGPL2, -1);
	gtk_list_store_append (model, &_tmp78_);
	item = _tmp78_;
	_tmp79_ = _ ("GNU Lesser General Public License, version 3 or later");
	gtk_list_store_set (model, &item, 0, _tmp79_, 1, GEN_PROJECT_PROJECT_LICENSE_LGPL3, -1);
	gtk_combo_box_set_active (self->priv->license_combobox, (gint) option_project_license);
	_tmp80_ = gtk_builder_get_object (builder, "entry-author-name");
	_tmp81_ = _tmp80_;
	_tmp82_ = _g_object_ref0 (GTK_IS_ENTRY (_tmp81_) ? ((GtkEntry*) _tmp81_) : NULL);
	_g_object_unref0 (self->priv->name_entry);
	self->priv->name_entry = _tmp82_;
	g_assert (self->priv->name_entry != NULL);
	if (options->author != NULL) {
		gtk_entry_set_text (self->priv->name_entry, options->author);
	}
	_tmp83_ = gtk_builder_get_object (builder, "entry-author-email");
	_tmp84_ = _tmp83_;
	_tmp85_ = _g_object_ref0 (GTK_IS_ENTRY (_tmp84_) ? ((GtkEntry*) _tmp84_) : NULL);
	_g_object_unref0 (self->priv->email_entry);
	self->priv->email_entry = _tmp85_;
	if (options->email != NULL) {
		gtk_entry_set_text (self->priv->email_entry, options->email);
	}
	_g_object_unref0 (filtered_model);
	_g_object_unref0 (model);
	_g_object_unref0 (languages_model);
	_g_object_unref0 (tags);
	_g_object_unref0 (renderer);
	_g_object_unref0 (hbox);
	goto __finally1;
	__catch1_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_error ("genprojectdialog.vala:216: can't build dialog ui: %s", err->message);
		_g_error_free0 (err);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (builder);
}


static void vala_gen_project_dialog_refilter_projects (ValaGenProjectDialog* self) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_;
	GtkTreeModelFilter* _tmp2_;
	GtkTreeModelFilter* model;
	GList* _tmp3_ = NULL;
	GList* _tmp4_;
	guint _tmp5_;
	gboolean _tmp6_;
	GList* _tmp9_ = NULL;
	GList* _tmp10_;
	guint _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_icon_view_get_model (self->priv->project_type_iconview);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (GTK_IS_TREE_MODEL_FILTER (_tmp1_) ? ((GtkTreeModelFilter*) _tmp1_) : NULL);
	model = _tmp2_;
	if (model != NULL) {
		gtk_tree_model_filter_refilter (model);
	}
	_tmp3_ = gtk_icon_view_get_selected_items (self->priv->project_type_iconview);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_list_length (_tmp4_);
	_tmp6_ = _tmp5_ <= 0;
	__g_list_free__gtk_tree_path_free0_0 (_tmp4_);
	if (_tmp6_) {
		GtkTreePath* _tmp7_ = NULL;
		GtkTreePath* _tmp8_;
		_tmp7_ = gtk_tree_path_new_from_string ("0");
		_tmp8_ = _tmp7_;
		gtk_icon_view_select_path (self->priv->project_type_iconview, _tmp8_);
		_gtk_tree_path_free0 (_tmp8_);
	}
	_tmp9_ = gtk_icon_view_get_selected_items (self->priv->project_type_iconview);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_list_length (_tmp10_);
	_tmp12_ = _tmp11_ > 0;
	__g_list_free__gtk_tree_path_free0_0 (_tmp10_);
	if (_tmp12_) {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->button_create_project, TRUE);
	} else {
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->button_create_project, FALSE);
	}
	_g_object_unref0 (model);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


GtkResponseType vala_gen_project_dialog_ask_parameters (ValaGenProjectDialog* self, GenProjectProjectOptions* options) {
	GtkResponseType result = 0;
	GtkResponseType response = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (options != NULL, 0);
	vala_gen_project_dialog_initialize_ui (self, options);
	_tmp0_ = gtk_dialog_run (self->priv->config_dialog);
	response = (GtkResponseType) _tmp0_;
	if (response == GTK_RESPONSE_OK) {
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gint _tmp7_;
		GList* _tmp8_ = NULL;
		GList* _tmp9_;
		guint _tmp10_;
		gboolean _tmp11_;
		if (options->path == NULL) {
			gchar* _tmp1_ = NULL;
			_tmp1_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) self->priv->project_folder_button);
			_g_free0 (options->path);
			options->path = _tmp1_;
		}
		_tmp2_ = g_path_get_basename (options->path);
		_g_free0 (options->name);
		options->name = _tmp2_;
		_tmp3_ = gtk_entry_get_text (self->priv->name_entry);
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (options->author);
		options->author = _tmp4_;
		_tmp5_ = gtk_entry_get_text (self->priv->email_entry);
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (options->email);
		options->email = _tmp6_;
		_tmp7_ = gtk_combo_box_get_active (self->priv->license_combobox);
		options->license = (GenProjectProjectLicense) _tmp7_;
		_tmp8_ = gtk_icon_view_get_selected_items (self->priv->project_type_iconview);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_list_length (_tmp9_);
		_tmp11_ = _tmp10_ > 0;
		__g_list_free__gtk_tree_path_free0_0 (_tmp9_);
		if (_tmp11_) {
			GtkTreeIter iter = {0};
			GList* _tmp12_ = NULL;
			GList* _tmp13_;
			gconstpointer _tmp14_ = NULL;
			GtkTreePath* _tmp15_;
			GtkTreePath* _tmp16_;
			GtkTreePath* path;
			GtkTreeModel* _tmp17_ = NULL;
			GtkTreeModel* _tmp18_;
			GtkTreeModelFilter* _tmp19_;
			GtkTreeModelFilter* model;
			GtkTreeIter _tmp20_ = {0};
			gboolean _tmp21_;
			_tmp12_ = gtk_icon_view_get_selected_items (self->priv->project_type_iconview);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_list_nth_data (_tmp13_, (guint) 0);
			_tmp15_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp14_);
			_tmp16_ = _tmp15_;
			__g_list_free__gtk_tree_path_free0_0 (_tmp13_);
			path = _tmp16_;
			_tmp17_ = gtk_icon_view_get_model (self->priv->project_type_iconview);
			_tmp18_ = _tmp17_;
			_tmp19_ = _g_object_ref0 (GTK_IS_TREE_MODEL_FILTER (_tmp18_) ? ((GtkTreeModelFilter*) _tmp18_) : NULL);
			model = _tmp19_;
			_tmp21_ = gtk_tree_model_get_iter ((GtkTreeModel*) model, &_tmp20_, path);
			iter = _tmp20_;
			if (_tmp21_) {
				GenProjectTemplateDefinition* template;
				GenProjectTemplateDefinition* _tmp22_;
				template = NULL;
				gtk_tree_model_get ((GtkTreeModel*) model, &iter, 1, &template, -1);
				_tmp22_ = _g_object_ref0 (template);
				_g_object_unref0 (options->template);
				options->template = _tmp22_;
				_g_object_unref0 (template);
			}
			_g_object_unref0 (model);
			_gtk_tree_path_free0 (path);
		}
	}
	result = response;
	return result;
}


ValaGenProjectDialog* vala_gen_project_dialog_construct (GType object_type) {
	ValaGenProjectDialog* self = NULL;
	self = (ValaGenProjectDialog*) g_type_create_instance (object_type);
	return self;
}


ValaGenProjectDialog* vala_gen_project_dialog_new (void) {
	return vala_gen_project_dialog_construct (VALA_TYPE_GEN_PROJECT_DIALOG);
}


static void vala_value_gen_project_dialog_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_gen_project_dialog_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_gen_project_dialog_unref (value->data[0].v_pointer);
	}
}


static void vala_value_gen_project_dialog_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gen_project_dialog_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_gen_project_dialog_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_gen_project_dialog_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaGenProjectDialog* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gen_project_dialog_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_gen_project_dialog_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaGenProjectDialog** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gen_project_dialog_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_gen_project_dialog (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecGenProjectDialog* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_GEN_PROJECT_DIALOG), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_gen_project_dialog (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_GEN_PROJECT_DIALOG), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_gen_project_dialog (GValue* value, gpointer v_object) {
	ValaGenProjectDialog* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_GEN_PROJECT_DIALOG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_GEN_PROJECT_DIALOG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gen_project_dialog_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gen_project_dialog_unref (old);
	}
}


void vala_value_take_gen_project_dialog (GValue* value, gpointer v_object) {
	ValaGenProjectDialog* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_GEN_PROJECT_DIALOG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_GEN_PROJECT_DIALOG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gen_project_dialog_unref (old);
	}
}


static void vala_gen_project_dialog_class_init (ValaGenProjectDialogClass * klass) {
	vala_gen_project_dialog_parent_class = g_type_class_peek_parent (klass);
	VALA_GEN_PROJECT_DIALOG_CLASS (klass)->finalize = vala_gen_project_dialog_finalize;
	g_type_class_add_private (klass, sizeof (ValaGenProjectDialogPrivate));
}


static void vala_gen_project_dialog_instance_init (ValaGenProjectDialog * self) {
	self->priv = VALA_GEN_PROJECT_DIALOG_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_gen_project_dialog_finalize (ValaGenProjectDialog* obj) {
	ValaGenProjectDialog * self;
	self = VALA_GEN_PROJECT_DIALOG (obj);
	_g_object_unref0 (self->priv->config_dialog);
	_g_object_unref0 (self->priv->project_folder_button);
	_g_object_unref0 (self->priv->project_type_iconview);
	_g_object_unref0 (self->priv->license_combobox);
	_g_object_unref0 (self->priv->combobox_languages);
	_g_object_unref0 (self->priv->name_entry);
	_g_object_unref0 (self->priv->email_entry);
	_g_object_unref0 (self->priv->button_create_project);
	_g_object_unref0 (self->priv->tag_cloud);
	_g_object_unref0 (self->priv->templates);
}


GType vala_gen_project_dialog_get_type (void) {
	static volatile gsize vala_gen_project_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gen_project_dialog_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_gen_project_dialog_init, vala_value_gen_project_dialog_free_value, vala_value_gen_project_dialog_copy_value, vala_value_gen_project_dialog_peek_pointer, "p", vala_value_gen_project_dialog_collect_value, "p", vala_value_gen_project_dialog_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGenProjectDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gen_project_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGenProjectDialog), 0, (GInstanceInitFunc) vala_gen_project_dialog_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gen_project_dialog_type_id;
		vala_gen_project_dialog_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGenProjectDialog", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gen_project_dialog_type_id__volatile, vala_gen_project_dialog_type_id);
	}
	return vala_gen_project_dialog_type_id__volatile;
}


gpointer vala_gen_project_dialog_ref (gpointer instance) {
	ValaGenProjectDialog* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_gen_project_dialog_unref (gpointer instance) {
	ValaGenProjectDialog* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GEN_PROJECT_DIALOG_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



