/* utils.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from utils.vala, do not modify */

/* utils.vala
 *
 * Copyright (C) 2009  Andrea Del Signore
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Andrea Del Signore <sejerpz@tin.it>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <vala.h>
#include <valagee.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS (afrodite_utils_symbols_predefined_symbols_get_type ())
#define AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS, AfroditeUtilsSymbolsPredefinedSymbols))
#define AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS, AfroditeUtilsSymbolsPredefinedSymbolsClass))
#define AFRODITE_UTILS_SYMBOLS_IS_PREDEFINED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS))
#define AFRODITE_UTILS_SYMBOLS_IS_PREDEFINED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS))
#define AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS, AfroditeUtilsSymbolsPredefinedSymbolsClass))

typedef struct _AfroditeUtilsSymbolsPredefinedSymbols AfroditeUtilsSymbolsPredefinedSymbols;
typedef struct _AfroditeUtilsSymbolsPredefinedSymbolsClass AfroditeUtilsSymbolsPredefinedSymbolsClass;
#define _afrodite_utils_symbols_predefined_symbols_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_utils_symbols_predefined_symbols_unref (var), NULL)))

#define AFRODITE_TYPE_MEMBER_TYPE (afrodite_member_type_get_type ())
typedef struct _AfroditeUtilsSymbolsPredefinedSymbolsPrivate AfroditeUtilsSymbolsPredefinedSymbolsPrivate;

#define AFRODITE_TYPE_DATA_TYPE (afrodite_data_type_get_type ())
#define AFRODITE_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataType))
#define AFRODITE_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))
#define AFRODITE_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))

typedef struct _AfroditeDataType AfroditeDataType;
typedef struct _AfroditeDataTypeClass AfroditeDataTypeClass;

#define AFRODITE_TYPE_SYMBOL (afrodite_symbol_get_type ())
#define AFRODITE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbol))
#define AFRODITE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))
#define AFRODITE_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))

typedef struct _AfroditeSymbol AfroditeSymbol;
typedef struct _AfroditeSymbolClass AfroditeSymbolClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _afrodite_data_type_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_data_type_unref (var), NULL)))

#define AFRODITE_TYPE_VOID_TYPE (afrodite_void_type_get_type ())
#define AFRODITE_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_VOID_TYPE, AfroditeVoidType))
#define AFRODITE_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_VOID_TYPE, AfroditeVoidTypeClass))
#define AFRODITE_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_VOID_TYPE))
#define AFRODITE_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_VOID_TYPE))
#define AFRODITE_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_VOID_TYPE, AfroditeVoidTypeClass))

typedef struct _AfroditeVoidType AfroditeVoidType;
typedef struct _AfroditeVoidTypeClass AfroditeVoidTypeClass;

#define AFRODITE_TYPE_SYMBOL_ACCESSIBILITY (afrodite_symbol_accessibility_get_type ())

#define AFRODITE_TYPE_MEMBER_BINDING (afrodite_member_binding_get_type ())
typedef struct _AfroditeSymbolPrivate AfroditeSymbolPrivate;
typedef struct _AfroditeUtilsSymbolsParamSpecPredefinedSymbols AfroditeUtilsSymbolsParamSpecPredefinedSymbols;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))

typedef enum  {
	AFRODITE_MEMBER_TYPE_NONE,
	AFRODITE_MEMBER_TYPE_VOID,
	AFRODITE_MEMBER_TYPE_CONSTANT,
	AFRODITE_MEMBER_TYPE_ENUM,
	AFRODITE_MEMBER_TYPE_ENUM_VALUE,
	AFRODITE_MEMBER_TYPE_FIELD,
	AFRODITE_MEMBER_TYPE_PROPERTY,
	AFRODITE_MEMBER_TYPE_LOCAL_VARIABLE,
	AFRODITE_MEMBER_TYPE_SIGNAL,
	AFRODITE_MEMBER_TYPE_CREATION_METHOD,
	AFRODITE_MEMBER_TYPE_CONSTRUCTOR,
	AFRODITE_MEMBER_TYPE_DESTRUCTOR,
	AFRODITE_MEMBER_TYPE_METHOD,
	AFRODITE_MEMBER_TYPE_DELEGATE,
	AFRODITE_MEMBER_TYPE_PARAMETER,
	AFRODITE_MEMBER_TYPE_TYPE_PARAMETER,
	AFRODITE_MEMBER_TYPE_ERROR_DOMAIN,
	AFRODITE_MEMBER_TYPE_ERROR_CODE,
	AFRODITE_MEMBER_TYPE_NAMESPACE,
	AFRODITE_MEMBER_TYPE_STRUCT,
	AFRODITE_MEMBER_TYPE_CLASS,
	AFRODITE_MEMBER_TYPE_INTERFACE,
	AFRODITE_MEMBER_TYPE_SCOPED_CODE_NODE
} AfroditeMemberType;

struct _AfroditeUtilsSymbolsPredefinedSymbols {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeUtilsSymbolsPredefinedSymbolsPrivate * priv;
	AfroditeDataType* signal_type;
};

struct _AfroditeUtilsSymbolsPredefinedSymbolsClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeUtilsSymbolsPredefinedSymbols *self);
};

struct _AfroditeUtilsSymbolsPredefinedSymbolsPrivate {
	AfroditeSymbol* _connect_method;
	AfroditeSymbol* _disconnect_method;
	AfroditeSymbol* _signal_symbol;
};

typedef enum  {
	AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE = 1,
	AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL = 1 << 1,
	AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED = 1 << 2,
	AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC = 1 << 3,
	AFRODITE_SYMBOL_ACCESSIBILITY_ANY = ((AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE | AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL) | AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED) | AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC
} AfroditeSymbolAccessibility;

typedef enum  {
	AFRODITE_MEMBER_BINDING_INSTANCE = 1,
	AFRODITE_MEMBER_BINDING_CLASS = 1 << 1,
	AFRODITE_MEMBER_BINDING_STATIC = 1 << 2,
	AFRODITE_MEMBER_BINDING_ANY = (AFRODITE_MEMBER_BINDING_INSTANCE | AFRODITE_MEMBER_BINDING_CLASS) | AFRODITE_MEMBER_BINDING_STATIC
} AfroditeMemberBinding;

struct _AfroditeSymbol {
	GObject parent_instance;
	AfroditeSymbolPrivate * priv;
	ValaList* _resolved_targets;
	ValaList* resolve_targets;
	AfroditeMemberBinding binding;
	gboolean is_virtual;
	gboolean is_abstract;
	gboolean overrides;
	gint _static_child_count;
	gint _creation_method_child_count;
};

struct _AfroditeSymbolClass {
	GObjectClass parent_class;
};

struct _AfroditeUtilsSymbolsParamSpecPredefinedSymbols {
	GParamSpec parent_instance;
};


extern AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols__predefined;
AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols__predefined = NULL;
static gpointer afrodite_utils_symbols_predefined_symbols_parent_class = NULL;
extern AfroditeVoidType* afrodite_symbol_VOID;

void afrodite_utils_log_message (const gchar* log_domain, const gchar* format, va_list args);
void afrodite_utils_trace (const gchar* format, ...);
ValaList* afrodite_utils_get_package_paths (const gchar* pkg, ValaCodeContext* context, gchar** vapi_dirs, int vapi_dirs_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
gpointer afrodite_utils_symbols_predefined_symbols_ref (gpointer instance);
void afrodite_utils_symbols_predefined_symbols_unref (gpointer instance);
GParamSpec* afrodite_utils_symbols_param_spec_predefined_symbols (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_utils_symbols_value_set_predefined_symbols (GValue* value, gpointer v_object);
void afrodite_utils_symbols_value_take_predefined_symbols (GValue* value, gpointer v_object);
gpointer afrodite_utils_symbols_value_get_predefined_symbols (const GValue* value);
GType afrodite_utils_symbols_predefined_symbols_get_type (void) G_GNUC_CONST;
AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols_get_predefined (void);
AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols_predefined_symbols_new (void);
AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols_predefined_symbols_construct (GType object_type);
GType afrodite_member_type_get_type (void) G_GNUC_CONST;
gchar* afrodite_utils_symbols_get_symbol_type_description (AfroditeMemberType type);
const gchar* afrodite_member_type_to_string (AfroditeMemberType self);
gpointer afrodite_data_type_ref (gpointer instance);
void afrodite_data_type_unref (gpointer instance);
GParamSpec* afrodite_param_spec_data_type (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_data_type (GValue* value, gpointer v_object);
void afrodite_value_take_data_type (GValue* value, gpointer v_object);
gpointer afrodite_value_get_data_type (const GValue* value);
GType afrodite_data_type_get_type (void) G_GNUC_CONST;
GType afrodite_symbol_get_type (void) G_GNUC_CONST;
#define AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS, AfroditeUtilsSymbolsPredefinedSymbolsPrivate))
enum  {
	AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_DUMMY_PROPERTY
};
AfroditeSymbol* afrodite_symbol_new (const gchar* symbol_name, AfroditeMemberType type);
AfroditeSymbol* afrodite_symbol_construct (GType object_type, const gchar* symbol_name, AfroditeMemberType type);
AfroditeDataType* afrodite_data_type_new (const gchar* type_name, const gchar* name);
AfroditeDataType* afrodite_data_type_construct (GType object_type, const gchar* type_name, const gchar* name);
void afrodite_symbol_set_return_type (AfroditeSymbol* self, AfroditeDataType* value);
AfroditeDataType* afrodite_symbol_get_return_type (AfroditeSymbol* self);
GType afrodite_void_type_get_type (void) G_GNUC_CONST;
void afrodite_data_type_set_symbol (AfroditeDataType* self, AfroditeSymbol* value);
GType afrodite_symbol_accessibility_get_type (void) G_GNUC_CONST;
void afrodite_symbol_set_access (AfroditeSymbol* self, AfroditeSymbolAccessibility value);
GType afrodite_member_binding_get_type (void) G_GNUC_CONST;
void afrodite_symbol_add_child (AfroditeSymbol* self, AfroditeSymbol* child);
static void afrodite_utils_symbols_predefined_symbols_finalize (AfroditeUtilsSymbolsPredefinedSymbols* obj);
gchar* afrodite_utils_unescape_xml_string (const gchar* text);
gchar* afrodite_utils_binary_operator_to_string (ValaBinaryOperator op);
gchar* afrodite_utils_unary_operator_to_string (ValaUnaryOperator op);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * This function shouldn't be used directly but just wrapped with a private one that
 * will specify the correct log domain. See the function trace (...) in this same source 
 */
inline void afrodite_utils_log_message (const gchar* log_domain, const gchar* format, va_list args) {
	g_return_if_fail (log_domain != NULL);
	g_return_if_fail (format != NULL);
	g_logv (log_domain, G_LOG_LEVEL_INFO, format, args);
}


inline void afrodite_utils_trace (const gchar* format, ...) {
	va_list va;
	va_list va2;
	g_return_if_fail (format != NULL);
	va_start (va, format);
	va_copy (va2, va);
	afrodite_utils_log_message ("Afrodite", format, va2);
	va_end (va2);
	va_end (va);
}


static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* afrodite_utils_get_package_paths (const gchar* pkg, ValaCodeContext* context, gchar** vapi_dirs, int vapi_dirs_length1) {
	ValaList* result = NULL;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* ctx;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* package_path;
	ValaArrayList* _tmp5_ = NULL;
	ValaArrayList* results;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* deps_filename;
	gboolean _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (pkg != NULL, NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	ctx = _tmp0_;
	if (ctx == NULL) {
		ValaCodeContext* _tmp1_ = NULL;
		_tmp1_ = vala_code_context_new ();
		_vala_code_context_unref0 (ctx);
		ctx = _tmp1_;
	}
	_tmp2_ = (_tmp3_ = vapi_dirs, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup1 (_tmp3_, vapi_dirs_length1));
	ctx->vapi_directories = (_vala_array_free (ctx->vapi_directories, ctx->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	ctx->vapi_directories = _tmp2_;
	ctx->vapi_directories_length1 = vapi_dirs_length1;
	_tmp4_ = vala_code_context_get_vapi_path (ctx, pkg);
	package_path = _tmp4_;
	if (package_path == NULL) {
		result = NULL;
		_g_free0 (package_path);
		_vala_code_context_unref0 (ctx);
		return result;
	}
	_tmp5_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	results = _tmp5_;
	_tmp6_ = g_path_get_dirname (package_path);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%s.deps", pkg);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_build_filename (_tmp7_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	deps_filename = _tmp11_;
	_tmp12_ = g_file_test (deps_filename, G_FILE_TEST_EXISTS);
	if (_tmp12_) {
		gchar* deps_content = NULL;
		gulong deps_len = 0UL;
		gchar* _tmp13_ = NULL;
		gsize _tmp14_;
		gchar** _tmp15_;
		gchar** _tmp16_ = NULL;
		g_file_get_contents (deps_filename, &_tmp13_, &_tmp14_, &_inner_error_);
		_g_free0 (deps_content);
		deps_content = _tmp13_;
		deps_len = (gulong) _tmp14_;
		if (_inner_error_ != NULL) {
			_g_free0 (deps_content);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			_g_free0 (deps_content);
			_g_free0 (deps_filename);
			_vala_iterable_unref0 (results);
			_g_free0 (package_path);
			_vala_code_context_unref0 (ctx);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp16_ = _tmp15_ = g_strsplit (deps_content, "\n", 0);
		{
			gchar** dep_collection;
			int dep_collection_length1;
			int dep_it;
			dep_collection = _tmp16_;
			dep_collection_length1 = _vala_array_length (_tmp15_);
			for (dep_it = 0; dep_it < _vala_array_length (_tmp15_); dep_it = dep_it + 1) {
				gchar* _tmp17_;
				gchar* dep;
				_tmp17_ = g_strdup (dep_collection[dep_it]);
				dep = _tmp17_;
				{
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_;
					_tmp18_ = string_strip (dep);
					_tmp19_ = _tmp18_;
					_g_free0 (_tmp19_);
					if (g_strcmp0 (dep, "") != 0) {
						ValaList* _tmp20_ = NULL;
						ValaList* deps;
						_tmp20_ = afrodite_utils_get_package_paths (dep, ctx, vapi_dirs, vapi_dirs_length1);
						deps = _tmp20_;
						if (deps == NULL) {
							gchar* _tmp21_ = NULL;
							gchar* _tmp22_;
							_tmp21_ = g_strdup_printf ("%s, dependency of %s, not found in specified Vala API directories", dep, pkg);
							_tmp22_ = _tmp21_;
							g_warning ("utils.vala:73: %s", _tmp22_);
							_g_free0 (_tmp22_);
						} else {
							{
								ValaList* _tmp23_;
								ValaList* _dep_package_list;
								gint _tmp24_;
								gint _dep_package_size;
								gint _dep_package_index;
								_tmp23_ = _vala_iterable_ref0 (deps);
								_dep_package_list = _tmp23_;
								_tmp24_ = vala_collection_get_size ((ValaCollection*) _dep_package_list);
								_dep_package_size = _tmp24_;
								_dep_package_index = -1;
								while (TRUE) {
									gpointer _tmp25_ = NULL;
									gchar* dep_package;
									_dep_package_index = _dep_package_index + 1;
									if (!(_dep_package_index < _dep_package_size)) {
										break;
									}
									_tmp25_ = vala_list_get (_dep_package_list, _dep_package_index);
									dep_package = (gchar*) _tmp25_;
									vala_collection_add ((ValaCollection*) results, dep_package);
									_g_free0 (dep_package);
								}
								_vala_iterable_unref0 (_dep_package_list);
							}
						}
						_vala_iterable_unref0 (deps);
					}
					_g_free0 (dep);
				}
			}
			dep_collection = (_vala_array_free (dep_collection, dep_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (deps_content);
		goto __finally1;
		__catch1_g_file_error:
		{
			GError * e;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp26_ = g_strdup_printf ("Unable to read dependency file: %s", e->message);
			_tmp27_ = _tmp26_;
			g_warning ("utils.vala:82: %s", _tmp27_);
			_g_free0 (_tmp27_);
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_free0 (deps_filename);
			_vala_iterable_unref0 (results);
			_g_free0 (package_path);
			_vala_code_context_unref0 (ctx);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	vala_collection_add ((ValaCollection*) results, package_path);
	result = (ValaList*) results;
	_g_free0 (deps_filename);
	_g_free0 (package_path);
	_vala_code_context_unref0 (ctx);
	return result;
}


static gpointer _afrodite_utils_symbols_predefined_symbols_ref0 (gpointer self) {
	return self ? afrodite_utils_symbols_predefined_symbols_ref (self) : NULL;
}


AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols_get_predefined (void) {
	AfroditeUtilsSymbolsPredefinedSymbols* result = NULL;
	AfroditeUtilsSymbolsPredefinedSymbols* _tmp1_;
	if (afrodite_utils_symbols__predefined == NULL) {
		AfroditeUtilsSymbolsPredefinedSymbols* _tmp0_ = NULL;
		_tmp0_ = afrodite_utils_symbols_predefined_symbols_new ();
		_afrodite_utils_symbols_predefined_symbols_unref0 (afrodite_utils_symbols__predefined);
		afrodite_utils_symbols__predefined = _tmp0_;
	}
	_tmp1_ = _afrodite_utils_symbols_predefined_symbols_ref0 (afrodite_utils_symbols__predefined);
	result = _tmp1_;
	return result;
}


gchar* afrodite_utils_symbols_get_symbol_type_description (AfroditeMemberType type) {
	gchar* result = NULL;
	switch (type) {
		case AFRODITE_MEMBER_TYPE_NONE:
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_;
			_tmp0_ = _ ("None");
			_tmp1_ = g_strdup (_tmp0_);
			result = _tmp1_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_VOID:
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			_tmp2_ = _ ("Void");
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_CONSTANT:
		{
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			_tmp4_ = _ ("Constant");
			_tmp5_ = g_strdup (_tmp4_);
			result = _tmp5_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_ENUM:
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp6_ = _ ("Enum");
			_tmp7_ = g_strdup (_tmp6_);
			result = _tmp7_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_ENUM_VALUE:
		{
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			_tmp8_ = _ ("Enum Value");
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_FIELD:
		{
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			_tmp10_ = _ ("Field");
			_tmp11_ = g_strdup (_tmp10_);
			result = _tmp11_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_PROPERTY:
		{
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp12_ = _ ("Property");
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_LOCAL_VARIABLE:
		{
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			_tmp14_ = _ ("Variable");
			_tmp15_ = g_strdup (_tmp14_);
			result = _tmp15_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_SIGNAL:
		{
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			_tmp16_ = _ ("Signal");
			_tmp17_ = g_strdup (_tmp16_);
			result = _tmp17_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_CREATION_METHOD:
		{
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			_tmp18_ = _ ("Creation Method");
			_tmp19_ = g_strdup (_tmp18_);
			result = _tmp19_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_CONSTRUCTOR:
		{
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			_tmp20_ = _ ("Constructor");
			_tmp21_ = g_strdup (_tmp20_);
			result = _tmp21_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_DESTRUCTOR:
		{
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			_tmp22_ = _ ("Destructor");
			_tmp23_ = g_strdup (_tmp22_);
			result = _tmp23_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_METHOD:
		{
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			_tmp24_ = _ ("Method");
			_tmp25_ = g_strdup (_tmp24_);
			result = _tmp25_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_DELEGATE:
		{
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			_tmp26_ = _ ("Delegate");
			_tmp27_ = g_strdup (_tmp26_);
			result = _tmp27_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_PARAMETER:
		{
			const gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			_tmp28_ = _ ("Parameter");
			_tmp29_ = g_strdup (_tmp28_);
			result = _tmp29_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_ERROR_DOMAIN:
		{
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_;
			_tmp30_ = _ ("Error Domain");
			_tmp31_ = g_strdup (_tmp30_);
			result = _tmp31_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_ERROR_CODE:
		{
			const gchar* _tmp32_ = NULL;
			gchar* _tmp33_;
			_tmp32_ = _ ("Error Code");
			_tmp33_ = g_strdup (_tmp32_);
			result = _tmp33_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_NAMESPACE:
		{
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_;
			_tmp34_ = _ ("Namespace");
			_tmp35_ = g_strdup (_tmp34_);
			result = _tmp35_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_STRUCT:
		{
			const gchar* _tmp36_ = NULL;
			gchar* _tmp37_;
			_tmp36_ = _ ("Struct");
			_tmp37_ = g_strdup (_tmp36_);
			result = _tmp37_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_CLASS:
		{
			const gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			_tmp38_ = _ ("Class");
			_tmp39_ = g_strdup (_tmp38_);
			result = _tmp39_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_INTERFACE:
		{
			const gchar* _tmp40_ = NULL;
			gchar* _tmp41_;
			_tmp40_ = _ ("Interface");
			_tmp41_ = g_strdup (_tmp40_);
			result = _tmp41_;
			return result;
		}
		case AFRODITE_MEMBER_TYPE_SCOPED_CODE_NODE:
		{
			const gchar* _tmp42_ = NULL;
			gchar* _tmp43_;
			_tmp42_ = _ ("Block");
			_tmp43_ = g_strdup (_tmp42_);
			result = _tmp43_;
			return result;
		}
		default:
		{
			GEnumValue* _tmp44_;
			gchar* _tmp45_ = NULL;
			gchar* des;
			_tmp44_ = g_enum_get_value (g_type_class_ref (AFRODITE_TYPE_MEMBER_TYPE), type);
			_tmp45_ = g_utf8_strup ((_tmp44_ != NULL) ? _tmp44_->value_name : NULL, (gssize) (-1));
			des = _tmp45_;
			g_warning ("utils.vala:172: Undefined description for symbol type: %s", des);
			result = des;
			return result;
		}
	}
}


AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols_predefined_symbols_construct (GType object_type) {
	AfroditeUtilsSymbolsPredefinedSymbols* self = NULL;
	AfroditeSymbol* _tmp0_ = NULL;
	AfroditeDataType* _tmp1_ = NULL;
	AfroditeDataType* _tmp2_;
	AfroditeDataType* _tmp3_ = NULL;
	AfroditeSymbol* _tmp4_ = NULL;
	AfroditeDataType* _tmp5_ = NULL;
	AfroditeDataType* _tmp6_;
	AfroditeDataType* _tmp7_ = NULL;
	AfroditeSymbol* _tmp8_ = NULL;
	AfroditeDataType* _tmp9_ = NULL;
	self = (AfroditeUtilsSymbolsPredefinedSymbols*) g_type_create_instance (object_type);
	_tmp0_ = afrodite_symbol_new ("connect", AFRODITE_MEMBER_TYPE_METHOD);
	_g_object_unref0 (self->priv->_connect_method);
	self->priv->_connect_method = _tmp0_;
	_tmp1_ = afrodite_data_type_new ("void", NULL);
	_tmp2_ = _tmp1_;
	afrodite_symbol_set_return_type (self->priv->_connect_method, _tmp2_);
	_afrodite_data_type_unref0 (_tmp2_);
	_tmp3_ = afrodite_symbol_get_return_type (self->priv->_connect_method);
	afrodite_data_type_set_symbol (_tmp3_, (AfroditeSymbol*) afrodite_symbol_VOID);
	afrodite_symbol_set_access (self->priv->_connect_method, AFRODITE_SYMBOL_ACCESSIBILITY_ANY);
	self->priv->_connect_method->binding = AFRODITE_MEMBER_BINDING_ANY;
	_tmp4_ = afrodite_symbol_new ("disconnect", AFRODITE_MEMBER_TYPE_METHOD);
	_g_object_unref0 (self->priv->_disconnect_method);
	self->priv->_disconnect_method = _tmp4_;
	_tmp5_ = afrodite_data_type_new ("void", NULL);
	_tmp6_ = _tmp5_;
	afrodite_symbol_set_return_type (self->priv->_disconnect_method, _tmp6_);
	_afrodite_data_type_unref0 (_tmp6_);
	_tmp7_ = afrodite_symbol_get_return_type (self->priv->_disconnect_method);
	afrodite_data_type_set_symbol (_tmp7_, (AfroditeSymbol*) afrodite_symbol_VOID);
	afrodite_symbol_set_access (self->priv->_disconnect_method, AFRODITE_SYMBOL_ACCESSIBILITY_ANY);
	self->priv->_disconnect_method->binding = AFRODITE_MEMBER_BINDING_ANY;
	_tmp8_ = afrodite_symbol_new ("#signal", AFRODITE_MEMBER_TYPE_CLASS);
	_g_object_unref0 (self->priv->_signal_symbol);
	self->priv->_signal_symbol = _tmp8_;
	afrodite_symbol_add_child (self->priv->_signal_symbol, self->priv->_connect_method);
	afrodite_symbol_add_child (self->priv->_signal_symbol, self->priv->_disconnect_method);
	_tmp9_ = afrodite_data_type_new ("#signal", NULL);
	_afrodite_data_type_unref0 (self->signal_type);
	self->signal_type = _tmp9_;
	afrodite_data_type_set_symbol (self->signal_type, self->priv->_signal_symbol);
	return self;
}


AfroditeUtilsSymbolsPredefinedSymbols* afrodite_utils_symbols_predefined_symbols_new (void) {
	return afrodite_utils_symbols_predefined_symbols_construct (AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS);
}


static void afrodite_utils_symbols_value_predefined_symbols_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void afrodite_utils_symbols_value_predefined_symbols_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		afrodite_utils_symbols_predefined_symbols_unref (value->data[0].v_pointer);
	}
}


static void afrodite_utils_symbols_value_predefined_symbols_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = afrodite_utils_symbols_predefined_symbols_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer afrodite_utils_symbols_value_predefined_symbols_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* afrodite_utils_symbols_value_predefined_symbols_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AfroditeUtilsSymbolsPredefinedSymbols* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = afrodite_utils_symbols_predefined_symbols_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* afrodite_utils_symbols_value_predefined_symbols_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AfroditeUtilsSymbolsPredefinedSymbols** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = afrodite_utils_symbols_predefined_symbols_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* afrodite_utils_symbols_param_spec_predefined_symbols (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	AfroditeUtilsSymbolsParamSpecPredefinedSymbols* spec;
	g_return_val_if_fail (g_type_is_a (object_type, AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer afrodite_utils_symbols_value_get_predefined_symbols (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS), NULL);
	return value->data[0].v_pointer;
}


void afrodite_utils_symbols_value_set_predefined_symbols (GValue* value, gpointer v_object) {
	AfroditeUtilsSymbolsPredefinedSymbols* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		afrodite_utils_symbols_predefined_symbols_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		afrodite_utils_symbols_predefined_symbols_unref (old);
	}
}


void afrodite_utils_symbols_value_take_predefined_symbols (GValue* value, gpointer v_object) {
	AfroditeUtilsSymbolsPredefinedSymbols* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, AFRODITE_UTILS_SYMBOLS_TYPE_PREDEFINED_SYMBOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		afrodite_utils_symbols_predefined_symbols_unref (old);
	}
}


static void afrodite_utils_symbols_predefined_symbols_class_init (AfroditeUtilsSymbolsPredefinedSymbolsClass * klass) {
	afrodite_utils_symbols_predefined_symbols_parent_class = g_type_class_peek_parent (klass);
	AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_CLASS (klass)->finalize = afrodite_utils_symbols_predefined_symbols_finalize;
	g_type_class_add_private (klass, sizeof (AfroditeUtilsSymbolsPredefinedSymbolsPrivate));
}


static void afrodite_utils_symbols_predefined_symbols_instance_init (AfroditeUtilsSymbolsPredefinedSymbols * self) {
	self->priv = AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void afrodite_utils_symbols_predefined_symbols_finalize (AfroditeUtilsSymbolsPredefinedSymbols* obj) {
	AfroditeUtilsSymbolsPredefinedSymbols * self;
	self = AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS (obj);
	_g_object_unref0 (self->priv->_connect_method);
	_g_object_unref0 (self->priv->_disconnect_method);
	_g_object_unref0 (self->priv->_signal_symbol);
	_afrodite_data_type_unref0 (self->signal_type);
}


GType afrodite_utils_symbols_predefined_symbols_get_type (void) {
	static volatile gsize afrodite_utils_symbols_predefined_symbols_type_id__volatile = 0;
	if (g_once_init_enter (&afrodite_utils_symbols_predefined_symbols_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { afrodite_utils_symbols_value_predefined_symbols_init, afrodite_utils_symbols_value_predefined_symbols_free_value, afrodite_utils_symbols_value_predefined_symbols_copy_value, afrodite_utils_symbols_value_predefined_symbols_peek_pointer, "p", afrodite_utils_symbols_value_predefined_symbols_collect_value, "p", afrodite_utils_symbols_value_predefined_symbols_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AfroditeUtilsSymbolsPredefinedSymbolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) afrodite_utils_symbols_predefined_symbols_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AfroditeUtilsSymbolsPredefinedSymbols), 0, (GInstanceInitFunc) afrodite_utils_symbols_predefined_symbols_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType afrodite_utils_symbols_predefined_symbols_type_id;
		afrodite_utils_symbols_predefined_symbols_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AfroditeUtilsSymbolsPredefinedSymbols", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&afrodite_utils_symbols_predefined_symbols_type_id__volatile, afrodite_utils_symbols_predefined_symbols_type_id);
	}
	return afrodite_utils_symbols_predefined_symbols_type_id__volatile;
}


gpointer afrodite_utils_symbols_predefined_symbols_ref (gpointer instance) {
	AfroditeUtilsSymbolsPredefinedSymbols* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void afrodite_utils_symbols_predefined_symbols_unref (gpointer instance) {
	AfroditeUtilsSymbolsPredefinedSymbols* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AFRODITE_UTILS_SYMBOLS_PREDEFINED_SYMBOLS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch2_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch2_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* afrodite_utils_unescape_xml_string (const gchar* text) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* res;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = g_strdup (text);
	res = _tmp0_;
	_tmp1_ = string_replace (res, "&lt;", "<");
	_tmp2_ = _tmp1_;
	_tmp3_ = string_replace (_tmp2_, "&gt;", ">");
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	_g_free0 (res);
	return result;
}


gchar* afrodite_utils_binary_operator_to_string (ValaBinaryOperator op) {
	gchar* result = NULL;
	gchar* res = NULL;
	switch (op) {
		case VALA_BINARY_OPERATOR_NONE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("");
			_g_free0 (res);
			res = _tmp0_;
			break;
		}
		case VALA_BINARY_OPERATOR_PLUS:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("+");
			_g_free0 (res);
			res = _tmp1_;
			break;
		}
		case VALA_BINARY_OPERATOR_MINUS:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("-");
			_g_free0 (res);
			res = _tmp2_;
			break;
		}
		case VALA_BINARY_OPERATOR_MUL:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("*");
			_g_free0 (res);
			res = _tmp3_;
			break;
		}
		case VALA_BINARY_OPERATOR_DIV:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("/");
			_g_free0 (res);
			res = _tmp4_;
			break;
		}
		case VALA_BINARY_OPERATOR_MOD:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("%");
			_g_free0 (res);
			res = _tmp5_;
			break;
		}
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("<<");
			_g_free0 (res);
			res = _tmp6_;
			break;
		}
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup (">>");
			_g_free0 (res);
			res = _tmp7_;
			break;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("<");
			_g_free0 (res);
			res = _tmp8_;
			break;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup (">");
			_g_free0 (res);
			res = _tmp9_;
			break;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("<=");
			_g_free0 (res);
			res = _tmp10_;
			break;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup (">=");
			_g_free0 (res);
			res = _tmp11_;
			break;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("==");
			_g_free0 (res);
			res = _tmp12_;
			break;
		}
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("!=");
			_g_free0 (res);
			res = _tmp13_;
			break;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		{
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("&");
			_g_free0 (res);
			res = _tmp14_;
			break;
		}
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		{
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("|");
			_g_free0 (res);
			res = _tmp15_;
			break;
		}
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			gchar* _tmp16_;
			_tmp16_ = g_strdup ("^");
			_g_free0 (res);
			res = _tmp16_;
			break;
		}
		case VALA_BINARY_OPERATOR_AND:
		{
			gchar* _tmp17_;
			_tmp17_ = g_strdup ("&&");
			_g_free0 (res);
			res = _tmp17_;
			break;
		}
		case VALA_BINARY_OPERATOR_OR:
		{
			gchar* _tmp18_;
			_tmp18_ = g_strdup ("||");
			_g_free0 (res);
			res = _tmp18_;
			break;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			gchar* _tmp19_;
			_tmp19_ = g_strdup ("in");
			_g_free0 (res);
			res = _tmp19_;
			break;
		}
		case VALA_BINARY_OPERATOR_COALESCE:
		{
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("??");
			_g_free0 (res);
			res = _tmp20_;
			break;
		}
		default:
		{
			GTypeClass* _tmp21_ = NULL;
			GEnumClass* cl;
			GEnumValue* _tmp22_ = NULL;
			gchar* _tmp23_;
			_tmp21_ = g_type_class_ref (VALA_TYPE_BINARY_OPERATOR);
			cl = (GEnumClass*) _tmp21_;
			_tmp22_ = g_enum_get_value (cl, (gint) op);
			_tmp23_ = g_strdup ((*_tmp22_).value_nick);
			_g_free0 (res);
			res = _tmp23_;
			_g_type_class_unref0 (cl);
			break;
		}
	}
	result = res;
	return result;
}


gchar* afrodite_utils_unary_operator_to_string (ValaUnaryOperator op) {
	gchar* result = NULL;
	gchar* res = NULL;
	switch (op) {
		case VALA_UNARY_OPERATOR_NONE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("");
			_g_free0 (res);
			res = _tmp0_;
			break;
		}
		case VALA_UNARY_OPERATOR_PLUS:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("+");
			_g_free0 (res);
			res = _tmp1_;
			break;
		}
		case VALA_UNARY_OPERATOR_MINUS:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("-");
			_g_free0 (res);
			res = _tmp2_;
			break;
		}
		case VALA_UNARY_OPERATOR_LOGICAL_NEGATION:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("^");
			_g_free0 (res);
			res = _tmp3_;
			break;
		}
		case VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("~");
			_g_free0 (res);
			res = _tmp4_;
			break;
		}
		case VALA_UNARY_OPERATOR_INCREMENT:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("++");
			_g_free0 (res);
			res = _tmp5_;
			break;
		}
		case VALA_UNARY_OPERATOR_DECREMENT:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("--");
			_g_free0 (res);
			res = _tmp6_;
			break;
		}
		case VALA_UNARY_OPERATOR_REF:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("ref");
			_g_free0 (res);
			res = _tmp7_;
			break;
		}
		case VALA_UNARY_OPERATOR_OUT:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("out");
			_g_free0 (res);
			res = _tmp8_;
			break;
		}
		default:
		{
			GTypeClass* _tmp9_ = NULL;
			GEnumClass* cl;
			GEnumValue* _tmp10_ = NULL;
			gchar* _tmp11_;
			_tmp9_ = g_type_class_ref (VALA_TYPE_UNARY_OPERATOR);
			cl = (GEnumClass*) _tmp9_;
			_tmp10_ = g_enum_get_value (cl, (gint) op);
			_tmp11_ = g_strdup ((*_tmp10_).value_nick);
			_g_free0 (res);
			res = _tmp11_;
			_g_type_class_unref0 (cl);
			break;
		}
	}
	result = res;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



