/* vtgsourceoutlinerview.c generated by valac 0.10.0, the Vala compiler
 * generated from vtgsourceoutlinerview.vala, do not modify */

/*
 *  vtgprojectmanagerview.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <afrodite.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gedit/gedit-view.h>
#include <glib/gi18n-lib.h>
#include <gedit/gedit-window.h>
#include <gedit/gedit-panel.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gedit/gedit-plugin.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <config.h>
#include <gedit/gedit-document.h>
#include <gedit/gedit-tab.h>
#include <valagee.h>


#define VTG_TYPE_COLUMNS (vtg_columns_get_type ())

#define VTG_TYPE_DATA (vtg_data_get_type ())
#define VTG_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_DATA, VtgData))
#define VTG_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_DATA, VtgDataClass))
#define VTG_IS_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_DATA))
#define VTG_IS_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_DATA))
#define VTG_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_DATA, VtgDataClass))

typedef struct _VtgData VtgData;
typedef struct _VtgDataClass VtgDataClass;
typedef struct _VtgDataPrivate VtgDataPrivate;
#define _afrodite_symbol_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_symbol_unref (var), NULL)))
#define _afrodite_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_reference_unref (var), NULL)))

#define VTG_TYPE_SOURCE_OUTLINER_VIEW (vtg_source_outliner_view_get_type ())
#define VTG_SOURCE_OUTLINER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SOURCE_OUTLINER_VIEW, VtgSourceOutlinerView))
#define VTG_SOURCE_OUTLINER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SOURCE_OUTLINER_VIEW, VtgSourceOutlinerViewClass))
#define VTG_IS_SOURCE_OUTLINER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SOURCE_OUTLINER_VIEW))
#define VTG_IS_SOURCE_OUTLINER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SOURCE_OUTLINER_VIEW))
#define VTG_SOURCE_OUTLINER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SOURCE_OUTLINER_VIEW, VtgSourceOutlinerViewClass))

typedef struct _VtgSourceOutlinerView VtgSourceOutlinerView;
typedef struct _VtgSourceOutlinerViewClass VtgSourceOutlinerViewClass;
typedef struct _VtgSourceOutlinerViewPrivate VtgSourceOutlinerViewPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VTG_TYPE_PLUGIN (vtg_plugin_get_type ())
#define VTG_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN, VtgPlugin))
#define VTG_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN, VtgPluginClass))
#define VTG_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN))
#define VTG_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN))
#define VTG_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN, VtgPluginClass))

typedef struct _VtgPlugin VtgPlugin;
typedef struct _VtgPluginClass VtgPluginClass;

#define VTG_TYPE_CONFIGURATION (vtg_configuration_get_type ())
#define VTG_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CONFIGURATION, VtgConfiguration))
#define VTG_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))
#define VTG_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CONFIGURATION))
#define VTG_IS_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CONFIGURATION))
#define VTG_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))

typedef struct _VtgConfiguration VtgConfiguration;
typedef struct _VtgConfigurationClass VtgConfigurationClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _afrodite_result_item_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_result_item_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _gdk_event_free0(var) ((var == NULL) ? NULL : (var = (gdk_event_free (var), NULL)))
#define __g_list_free_gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_gtk_tree_path_free (var), NULL)))

typedef enum  {
	VTG_COLUMNS_NAME = 0,
	VTG_COLUMNS_ICON,
	VTG_COLUMNS_DATA,
	VTG_COLUMNS_COLUMNS_COUNT
} VtgColumns;

struct _VtgData {
	GObject parent_instance;
	VtgDataPrivate * priv;
	AfroditeSymbol* symbol;
	AfroditeSourceReference* source_reference;
};

struct _VtgDataClass {
	GObjectClass parent_class;
};

struct _VtgSourceOutlinerView {
	GObject parent_instance;
	VtgSourceOutlinerViewPrivate * priv;
};

struct _VtgSourceOutlinerViewClass {
	GObjectClass parent_class;
};

struct _VtgSourceOutlinerViewPrivate {
	char** qualifiers;
	gint qualifiers_length1;
	gint _qualifiers_size_;
	VtgPluginInstance* _plugin_instance;
	GtkTreeView* _src_view;
	GtkTreeModelSort* _sorted;
	GtkToggleButton* _check_show_private_symbols;
	GtkToggleButton* _check_show_public_symbols;
	GtkToggleButton* _check_show_protected_symbols;
	GtkToggleButton* _check_show_internal_symbols;
	GtkTreeStore* _model;
	GtkMenu* _popup_symbols;
	gboolean _on_show_symbol_scope_toggled_flag;
	guint _popup_symbols_ui_id;
	char* _popup_symbols_ui_def;
	GtkActionGroup* _actions;
	GtkVBox* _side_panel;
	gint _current_line;
	gint _current_column;
	guint _idle_id;
	GeditView* _active_view;
	GtkHBox* _top_ui;
	GtkComboBox* _combo_groups;
	GtkComboBox* _combo_items;
	char* _current_source_path;
	gboolean _updating_combos;
};


static gpointer vtg_data_parent_class = NULL;
static GType vtg_data_type_id = 0;
extern VtgPlugin* vtg_plugin_main_instance;
static gpointer vtg_source_outliner_view_parent_class = NULL;
static GType vtg_source_outliner_view_type_id = 0;

GType vtg_columns_get_type (void) G_GNUC_CONST;
GType vtg_data_get_type (void) G_GNUC_CONST;
GType vtg_data_register_type (GTypeModule * module);
enum  {
	VTG_DATA_DUMMY_PROPERTY
};
VtgData* vtg_data_new (AfroditeSymbol* symbol, AfroditeSourceReference* source_reference);
VtgData* vtg_data_construct (GType object_type, AfroditeSymbol* symbol, AfroditeSourceReference* source_reference);
static void vtg_data_finalize (GObject* obj);
GType vtg_source_outliner_view_get_type (void) G_GNUC_CONST;
GType vtg_source_outliner_view_register_type (GTypeModule * module);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
#define VTG_SOURCE_OUTLINER_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_SOURCE_OUTLINER_VIEW, VtgSourceOutlinerViewPrivate))
enum  {
	VTG_SOURCE_OUTLINER_VIEW_DUMMY_PROPERTY,
	VTG_SOURCE_OUTLINER_VIEW_ACTIVE_VIEW,
	VTG_SOURCE_OUTLINER_VIEW_SHOW_PRIVATE_SYMBOLS,
	VTG_SOURCE_OUTLINER_VIEW_CURRENT_LINE,
	VTG_SOURCE_OUTLINER_VIEW_CURRENT_COLUMN
};
static void vtg_source_outliner_view_on_source_outliner_goto (VtgSourceOutlinerView* self, GtkAction* action);
static void _vtg_source_outliner_view_on_source_outliner_goto_gtk_action_callback (GtkAction* action, gpointer self);
void vtg_source_outliner_view_set_current_position (VtgSourceOutlinerView* self, gint line, gint column);
static void vtg_source_outliner_view_idle_highlight_current_position (VtgSourceOutlinerView* self);
VtgSourceOutlinerView* vtg_source_outliner_view_new (VtgPluginInstance* plugin_instance);
VtgSourceOutlinerView* vtg_source_outliner_view_construct (GType object_type, VtgPluginInstance* plugin_instance);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
static void vtg_source_outliner_view_on_source_outliner_view_row_activated (VtgSourceOutlinerView* self, GtkWidget* sender, GtkTreePath* path, GtkTreeViewColumn* column);
static void _vtg_source_outliner_view_on_source_outliner_view_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static gboolean vtg_source_outliner_view_on_source_outliner_view_button_press (VtgSourceOutlinerView* self, GtkWidget* sender, GdkEventButton* event);
static gboolean _vtg_source_outliner_view_on_source_outliner_view_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
char* vtg_utils_get_image_path (const char* id);
GType vtg_plugin_get_type (void) G_GNUC_CONST;
GType vtg_plugin_register_type (GTypeModule * module);
GType vtg_configuration_get_type (void) G_GNUC_CONST;
GType vtg_configuration_register_type (GTypeModule * module);
VtgConfiguration* vtg_plugin_get_config (VtgPlugin* self);
gboolean vtg_configuration_get_outliner_show_public_symbols (VtgConfiguration* self);
static void vtg_source_outliner_view_on_show_symbol_scope_toggled (VtgSourceOutlinerView* self, GtkWidget* sender);
static void _vtg_source_outliner_view_on_show_symbol_scope_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
gboolean vtg_configuration_get_outliner_show_internal_symbols (VtgConfiguration* self);
gboolean vtg_configuration_get_outliner_show_protected_symbols (VtgConfiguration* self);
gboolean vtg_configuration_get_outliner_show_private_symbols (VtgConfiguration* self);
GdkPixbuf* vtg_utils_get_icon_for_type_name (const char* type_name);
static GtkTreeStore* vtg_source_outliner_view_build_tree_model (VtgSourceOutlinerView* self);
static GtkTreeModelSort* vtg_source_outliner_view_build_sort_model (VtgSourceOutlinerView* self, GtkTreeStore* child_model);
static GtkListStore* vtg_source_outliner_view_build_combo_model (VtgSourceOutlinerView* self);
static void vtg_source_outliner_view_on_combo_groups_changed (VtgSourceOutlinerView* self, GtkWidget* sender);
static void _vtg_source_outliner_view_on_combo_groups_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void vtg_source_outliner_view_on_combo_items_changed (VtgSourceOutlinerView* self, GtkWidget* sender);
static void _vtg_source_outliner_view_on_combo_items_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
void vtg_source_outliner_view_deactivate (VtgSourceOutlinerView* self);
static void vtg_source_outliner_view_cleanup_view_ui (VtgSourceOutlinerView* self);
static void vtg_source_outliner_view_populate_combo_items_model (VtgSourceOutlinerView* self);
static void vtg_source_outliner_view_initialize_view_ui (VtgSourceOutlinerView* self);
gboolean vtg_utils_is_vala_doc (GeditDocument* doc);
static gint vtg_source_outliner_view_sort_model (VtgSourceOutlinerView* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b);
static gint _vtg_source_outliner_view_sort_model_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
void vtg_source_outliner_view_clear_view (VtgSourceOutlinerView* self);
void vtg_source_outliner_view_update_view (VtgSourceOutlinerView* self, const char* source_path, AfroditeQueryResult* _result_);
static void vtg_source_outliner_view_populate_treeview_model (VtgSourceOutlinerView* self, GtkTreeStore* model, const char* source_path, ValaList* items, GtkTreeIter* parent_iter);
static void vtg_source_outliner_view_populate_combo_groups_model (VtgSourceOutlinerView* self, GtkListStore* combo_model, ValaList* items);
static void vtg_source_outliner_view_goto_line (VtgSourceOutlinerView* self, AfroditeSymbol* symbol);
void vtg_configuration_set_outliner_show_private_symbols (VtgConfiguration* self, gboolean value);
void vtg_configuration_set_outliner_show_public_symbols (VtgConfiguration* self, gboolean value);
void vtg_configuration_set_outliner_show_protected_symbols (VtgConfiguration* self, gboolean value);
void vtg_configuration_set_outliner_show_internal_symbols (VtgConfiguration* self, gboolean value);
static void _g_list_free_gtk_tree_path_free (GList* self);
static AfroditeSymbolAccessibility vtg_source_outliner_view_get_symbol_accessibility (VtgSourceOutlinerView* self, AfroditeSymbol* symbol);
gint vtg_utils_symbol_type_compare (AfroditeSymbol* vala, AfroditeSymbol* valb);
static gboolean vtg_source_outliner_view_highlight_current_position (VtgSourceOutlinerView* self);
static gboolean _vtg_source_outliner_view_highlight_current_position_gsource_func (gpointer self);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
GeditView* vtg_source_outliner_view_get_active_view (VtgSourceOutlinerView* self);
void vtg_source_outliner_view_set_active_view (VtgSourceOutlinerView* self, GeditView* value);
gboolean vtg_source_outliner_view_get_show_private_symbols (VtgSourceOutlinerView* self);
gint vtg_source_outliner_view_get_current_line (VtgSourceOutlinerView* self);
gint vtg_source_outliner_view_get_current_column (VtgSourceOutlinerView* self);
void vtg_utils_trace (const char* format, ...);
static void vtg_source_outliner_view_finalize (GObject* obj);
static void vtg_source_outliner_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void vtg_source_outliner_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GtkActionEntry VTG_SOURCE_OUTLINER_VIEW__action_entries[1] = {{"source-outliner-goto", GTK_STOCK_OPEN, N_ ("Goto definition..."), NULL, N_ ("Goto symbol definition"), (GCallback) _vtg_source_outliner_view_on_source_outliner_goto_gtk_action_callback}};

static void g_cclosure_user_marshal_VOID__INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

GType vtg_columns_get_type (void) {
	static volatile gsize vtg_columns_type_id__volatile = 0;
	if (g_once_init_enter (&vtg_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{VTG_COLUMNS_NAME, "VTG_COLUMNS_NAME", "name"}, {VTG_COLUMNS_ICON, "VTG_COLUMNS_ICON", "icon"}, {VTG_COLUMNS_DATA, "VTG_COLUMNS_DATA", "data"}, {VTG_COLUMNS_COLUMNS_COUNT, "VTG_COLUMNS_COLUMNS_COUNT", "columns-count"}, {0, NULL, NULL}};
		GType vtg_columns_type_id;
		vtg_columns_type_id = g_enum_register_static ("VtgColumns", values);
		g_once_init_leave (&vtg_columns_type_id__volatile, vtg_columns_type_id);
	}
	return vtg_columns_type_id__volatile;
}


static gpointer _afrodite_symbol_ref0 (gpointer self) {
	return self ? afrodite_symbol_ref (self) : NULL;
}


static gpointer _afrodite_source_reference_ref0 (gpointer self) {
	return self ? afrodite_source_reference_ref (self) : NULL;
}


VtgData* vtg_data_construct (GType object_type, AfroditeSymbol* symbol, AfroditeSourceReference* source_reference) {
	VtgData * self;
	AfroditeSymbol* _tmp0_;
	AfroditeSourceReference* _tmp1_;
	g_return_val_if_fail (symbol != NULL, NULL);
	self = (VtgData*) g_object_new (object_type, NULL);
	self->symbol = (_tmp0_ = _afrodite_symbol_ref0 (symbol), _afrodite_symbol_unref0 (self->symbol), _tmp0_);
	self->source_reference = (_tmp1_ = _afrodite_source_reference_ref0 (source_reference), _afrodite_source_reference_unref0 (self->source_reference), _tmp1_);
	return self;
}


VtgData* vtg_data_new (AfroditeSymbol* symbol, AfroditeSourceReference* source_reference) {
	return vtg_data_construct (VTG_TYPE_DATA, symbol, source_reference);
}


static void vtg_data_class_init (VtgDataClass * klass) {
	vtg_data_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = vtg_data_finalize;
}


static void vtg_data_instance_init (VtgData * self) {
}


static void vtg_data_finalize (GObject* obj) {
	VtgData * self;
	self = VTG_DATA (obj);
	_afrodite_symbol_unref0 (self->symbol);
	_afrodite_source_reference_unref0 (self->source_reference);
	G_OBJECT_CLASS (vtg_data_parent_class)->finalize (obj);
}


GType vtg_data_get_type (void) {
	return vtg_data_type_id;
}


GType vtg_data_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgData), 0, (GInstanceInitFunc) vtg_data_instance_init, NULL };
	vtg_data_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgData", &g_define_type_info, 0);
	return vtg_data_type_id;
}


static void _vtg_source_outliner_view_on_source_outliner_goto_gtk_action_callback (GtkAction* action, gpointer self) {
	vtg_source_outliner_view_on_source_outliner_goto (self, action);
}


void vtg_source_outliner_view_set_current_position (VtgSourceOutlinerView* self, gint line, gint column) {
	g_return_if_fail (self != NULL);
	self->priv->_current_line = line;
	self->priv->_current_column = column;
	vtg_source_outliner_view_idle_highlight_current_position (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vtg_source_outliner_view_on_source_outliner_view_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	vtg_source_outliner_view_on_source_outliner_view_row_activated (self, _sender, path, column);
}


static gboolean _vtg_source_outliner_view_on_source_outliner_view_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = vtg_source_outliner_view_on_source_outliner_view_button_press (self, _sender, event);
	return result;
}


static void _vtg_source_outliner_view_on_show_symbol_scope_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	vtg_source_outliner_view_on_show_symbol_scope_toggled (self, _sender);
}


static void _vtg_source_outliner_view_on_combo_groups_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	vtg_source_outliner_view_on_combo_groups_changed (self, _sender);
}


static void _vtg_source_outliner_view_on_combo_items_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	vtg_source_outliner_view_on_combo_items_changed (self, _sender);
}


VtgSourceOutlinerView* vtg_source_outliner_view_construct (GType object_type, VtgPluginInstance* plugin_instance) {
	VtgSourceOutlinerView * self;
	GeditPanel* panel;
	GtkVBox* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeViewColumn* column;
	GtkCellRenderer* renderer;
	GtkCellRenderer* _tmp2_;
	GtkScrolledWindow* scroll;
	GtkHBox* hbox;
	GtkLabel* label;
	GtkToggleButton* _tmp3_;
	char* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* image;
	GtkToggleButton* _tmp6_;
	char* _tmp7_;
	GtkImage* _tmp8_;
	GtkToggleButton* _tmp9_;
	char* _tmp10_;
	GtkImage* _tmp11_;
	GtkToggleButton* _tmp12_;
	char* _tmp13_;
	GtkImage* _tmp14_;
	GdkPixbuf* _tmp15_;
	GtkImage* _tmp16_;
	GtkImage* icon;
	GtkActionGroup* _tmp17_;
	GtkUIManager* manager;
	GtkTreeStore* _tmp20_;
	GtkTreeModelSort* _tmp21_;
	GtkHBox* _tmp22_;
	GtkComboBox* _tmp23_;
	GtkListStore* model;
	GtkCellRenderer* _tmp24_;
	GtkCellRenderer* _tmp25_;
	GtkComboBox* _tmp26_;
	GtkListStore* _tmp27_;
	GtkCellRenderer* _tmp28_;
	GtkCellRenderer* _tmp29_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (plugin_instance != NULL, NULL);
	self = (VtgSourceOutlinerView*) g_object_new (object_type, NULL);
	self->priv->_plugin_instance = plugin_instance;
	panel = _g_object_ref0 (gedit_window_get_side_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
	self->priv->_side_panel = (_tmp0_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 8)), _g_object_unref0 (self->priv->_side_panel), _tmp0_);
	self->priv->_src_view = (_tmp1_ = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new ()), _g_object_unref0 (self->priv->_src_view), _tmp1_);
	column = g_object_ref_sink (gtk_tree_view_column_new ());
	renderer = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ());
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "pixbuf", (gint) VTG_COLUMNS_ICON);
	renderer = (_tmp2_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp2_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, renderer, "markup", (gint) VTG_COLUMNS_NAME);
	gtk_tree_view_append_column (self->priv->_src_view, column);
	gtk_tree_view_set_headers_visible (self->priv->_src_view, FALSE);
	g_signal_connect_object (self->priv->_src_view, "row-activated", (GCallback) _vtg_source_outliner_view_on_source_outliner_view_row_activated_gtk_tree_view_row_activated, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->_src_view, "button-press-event", (GCallback) _vtg_source_outliner_view_on_source_outliner_view_button_press_gtk_widget_button_press_event, self, 0);
	scroll = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL));
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) self->priv->_src_view);
	gtk_box_pack_start ((GtkBox*) self->priv->_side_panel, (GtkWidget*) scroll, TRUE, TRUE, (guint) 4);
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0));
	gtk_box_pack_start ((GtkBox*) self->priv->_side_panel, (GtkWidget*) hbox, FALSE, FALSE, (guint) 4);
	label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Filter by scope:")));
	g_object_set ((GtkMisc*) label, "xalign", (float) 0, NULL);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 4);
	self->priv->_check_show_public_symbols = (_tmp3_ = g_object_ref_sink ((GtkToggleButton*) gtk_toggle_button_new ()), _g_object_unref0 (self->priv->_check_show_public_symbols), _tmp3_);
	image = (_tmp5_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_file (_tmp4_ = vtg_utils_get_image_path ("public-symbols-22.png"))), _g_free0 (_tmp4_), _tmp5_);
	gtk_button_set_image ((GtkButton*) self->priv->_check_show_public_symbols, (GtkWidget*) image);
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->_check_show_public_symbols, _ ("Show public symbols"));
	gtk_toggle_button_set_active (self->priv->_check_show_public_symbols, vtg_configuration_get_outliner_show_public_symbols (vtg_plugin_get_config (vtg_plugin_main_instance)));
	g_signal_connect_object (self->priv->_check_show_public_symbols, "toggled", (GCallback) _vtg_source_outliner_view_on_show_symbol_scope_toggled_gtk_toggle_button_toggled, self, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->_check_show_public_symbols, FALSE, TRUE, (guint) 4);
	self->priv->_check_show_internal_symbols = (_tmp6_ = g_object_ref_sink ((GtkToggleButton*) gtk_toggle_button_new ()), _g_object_unref0 (self->priv->_check_show_internal_symbols), _tmp6_);
	image = (_tmp8_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_file (_tmp7_ = vtg_utils_get_image_path ("internal-symbols-22.png"))), _g_object_unref0 (image), _tmp8_);
	_g_free0 (_tmp7_);
	gtk_button_set_image ((GtkButton*) self->priv->_check_show_internal_symbols, (GtkWidget*) image);
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->_check_show_internal_symbols, _ ("Show internal symbols"));
	gtk_toggle_button_set_active (self->priv->_check_show_internal_symbols, vtg_configuration_get_outliner_show_internal_symbols (vtg_plugin_get_config (vtg_plugin_main_instance)));
	g_signal_connect_object (self->priv->_check_show_internal_symbols, "toggled", (GCallback) _vtg_source_outliner_view_on_show_symbol_scope_toggled_gtk_toggle_button_toggled, self, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->_check_show_internal_symbols, FALSE, TRUE, (guint) 4);
	self->priv->_check_show_protected_symbols = (_tmp9_ = g_object_ref_sink ((GtkToggleButton*) gtk_toggle_button_new ()), _g_object_unref0 (self->priv->_check_show_protected_symbols), _tmp9_);
	image = (_tmp11_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_file (_tmp10_ = vtg_utils_get_image_path ("protected-symbols-22.png"))), _g_object_unref0 (image), _tmp11_);
	_g_free0 (_tmp10_);
	gtk_button_set_image ((GtkButton*) self->priv->_check_show_protected_symbols, (GtkWidget*) image);
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->_check_show_protected_symbols, _ ("Show protected symbols"));
	gtk_toggle_button_set_active (self->priv->_check_show_protected_symbols, vtg_configuration_get_outliner_show_protected_symbols (vtg_plugin_get_config (vtg_plugin_main_instance)));
	g_signal_connect_object (self->priv->_check_show_protected_symbols, "toggled", (GCallback) _vtg_source_outliner_view_on_show_symbol_scope_toggled_gtk_toggle_button_toggled, self, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->_check_show_protected_symbols, FALSE, TRUE, (guint) 4);
	self->priv->_check_show_private_symbols = (_tmp12_ = g_object_ref_sink ((GtkToggleButton*) gtk_toggle_button_new ()), _g_object_unref0 (self->priv->_check_show_private_symbols), _tmp12_);
	image = (_tmp14_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_file (_tmp13_ = vtg_utils_get_image_path ("private-symbols-22.png"))), _g_object_unref0 (image), _tmp14_);
	_g_free0 (_tmp13_);
	gtk_button_set_image ((GtkButton*) self->priv->_check_show_private_symbols, (GtkWidget*) image);
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->_check_show_private_symbols, _ ("Show private symbols"));
	gtk_toggle_button_set_active (self->priv->_check_show_private_symbols, vtg_configuration_get_outliner_show_private_symbols (vtg_plugin_get_config (vtg_plugin_main_instance)));
	g_signal_connect_object (self->priv->_check_show_private_symbols, "toggled", (GCallback) _vtg_source_outliner_view_on_show_symbol_scope_toggled_gtk_toggle_button_toggled, self, 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->priv->_check_show_private_symbols, FALSE, TRUE, (guint) 4);
	gtk_widget_show_all ((GtkWidget*) self->priv->_side_panel);
	icon = (_tmp16_ = g_object_ref_sink ((GtkImage*) gtk_image_new_from_pixbuf (_tmp15_ = vtg_utils_get_icon_for_type_name ("Class"))), _g_object_unref0 (_tmp15_), _tmp16_);
	gedit_panel_add_item (panel, (GtkWidget*) self->priv->_side_panel, _ ("Source"), (GtkWidget*) icon);
	gedit_panel_activate_item (panel, (GtkWidget*) self->priv->_side_panel);
	self->priv->_actions = (_tmp17_ = gtk_action_group_new ("SourceOutlinerActionGroup"), _g_object_unref0 (self->priv->_actions), _tmp17_);
	gtk_action_group_set_translation_domain (self->priv->_actions, GETTEXT_PACKAGE);
	gtk_action_group_add_actions (self->priv->_actions, VTG_SOURCE_OUTLINER_VIEW__action_entries, G_N_ELEMENTS (VTG_SOURCE_OUTLINER_VIEW__action_entries), self);
	manager = _g_object_ref0 (gedit_window_get_ui_manager (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
	gtk_ui_manager_insert_action_group (manager, self->priv->_actions, -1);
	{
		guint _tmp18_;
		GtkMenu* _tmp19_;
		_tmp18_ = gtk_ui_manager_add_ui_from_string (manager, self->priv->_popup_symbols_ui_def, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch62_g_error;
		}
		self->priv->_popup_symbols_ui_id = _tmp18_;
		self->priv->_popup_symbols = (_tmp19_ = _g_object_ref0 (GTK_MENU (gtk_ui_manager_get_widget (manager, "/SourceOutlinerPopupGoto"))), _g_object_unref0 (self->priv->_popup_symbols), _tmp19_);
		g_assert (self->priv->_popup_symbols != NULL);
	}
	goto __finally62;
	__catch62_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("vtgsourceoutlinerview.vala:211: Error %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally62:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (manager);
		_g_object_unref0 (icon);
		_g_object_unref0 (image);
		_g_object_unref0 (label);
		_g_object_unref0 (hbox);
		_g_object_unref0 (scroll);
		_g_object_unref0 (renderer);
		_g_object_unref0 (column);
		_g_object_unref0 (panel);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->_model = (_tmp20_ = vtg_source_outliner_view_build_tree_model (self), _g_object_unref0 (self->priv->_model), _tmp20_);
	self->priv->_sorted = (_tmp21_ = vtg_source_outliner_view_build_sort_model (self, self->priv->_model), _g_object_unref0 (self->priv->_sorted), _tmp21_);
	gtk_tree_view_set_model (self->priv->_src_view, (GtkTreeModel*) self->priv->_sorted);
	self->priv->_top_ui = (_tmp22_ = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (TRUE, 0)), _g_object_unref0 (self->priv->_top_ui), _tmp22_);
	self->priv->_combo_groups = (_tmp23_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new ()), _g_object_unref0 (self->priv->_combo_groups), _tmp23_);
	model = vtg_source_outliner_view_build_combo_model (self);
	model->sort_column_id = (gint) VTG_COLUMNS_NAME;
	gtk_combo_box_set_model (self->priv->_combo_groups, (GtkTreeModel*) model);
	renderer = (_tmp24_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ()), _g_object_unref0 (renderer), _tmp24_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->_combo_groups, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->_combo_groups, renderer, "pixbuf", (gint) VTG_COLUMNS_ICON);
	renderer = (_tmp25_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp25_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->_combo_groups, renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->_combo_groups, renderer, "markup", (gint) VTG_COLUMNS_NAME);
	g_signal_connect_object (self->priv->_combo_groups, "changed", (GCallback) _vtg_source_outliner_view_on_combo_groups_changed_gtk_combo_box_changed, self, 0);
	self->priv->_combo_items = (_tmp26_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new ()), _g_object_unref0 (self->priv->_combo_items), _tmp26_);
	model = (_tmp27_ = vtg_source_outliner_view_build_combo_model (self), _g_object_unref0 (model), _tmp27_);
	model->sort_column_id = (gint) VTG_COLUMNS_NAME;
	gtk_combo_box_set_model (self->priv->_combo_items, (GtkTreeModel*) model);
	renderer = (_tmp28_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ()), _g_object_unref0 (renderer), _tmp28_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->_combo_items, renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->_combo_items, renderer, "pixbuf", (gint) VTG_COLUMNS_ICON);
	renderer = (_tmp29_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (renderer), _tmp29_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->_combo_items, renderer, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->_combo_items, renderer, "markup", (gint) VTG_COLUMNS_NAME);
	g_signal_connect_object (self->priv->_combo_items, "changed", (GCallback) _vtg_source_outliner_view_on_combo_items_changed_gtk_combo_box_changed, self, 0);
	gtk_box_pack_start ((GtkBox*) self->priv->_top_ui, (GtkWidget*) self->priv->_combo_groups, FALSE, TRUE, (guint) 2);
	gtk_box_pack_end ((GtkBox*) self->priv->_top_ui, (GtkWidget*) self->priv->_combo_items, FALSE, TRUE, (guint) 2);
	_g_object_unref0 (model);
	_g_object_unref0 (manager);
	_g_object_unref0 (icon);
	_g_object_unref0 (image);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox);
	_g_object_unref0 (scroll);
	_g_object_unref0 (renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (panel);
	return self;
}


VtgSourceOutlinerView* vtg_source_outliner_view_new (VtgPluginInstance* plugin_instance) {
	return vtg_source_outliner_view_construct (VTG_TYPE_SOURCE_OUTLINER_VIEW, plugin_instance);
}


void vtg_source_outliner_view_deactivate (VtgSourceOutlinerView* self) {
	GtkUIManager* manager;
	GeditPanel* panel;
	GtkComboBox* _tmp0_;
	GtkComboBox* _tmp1_;
	GtkHBox* _tmp2_;
	g_return_if_fail (self != NULL);
	manager = _g_object_ref0 (gedit_window_get_ui_manager (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
	gtk_ui_manager_remove_ui (manager, self->priv->_popup_symbols_ui_id);
	gtk_ui_manager_remove_action_group (manager, self->priv->_actions);
	panel = _g_object_ref0 (gedit_window_get_side_panel (vtg_plugin_instance_get_window (self->priv->_plugin_instance)));
	gedit_panel_remove_item (panel, (GtkWidget*) self->priv->_side_panel);
	vtg_source_outliner_view_cleanup_view_ui (self);
	if (self->priv->_idle_id != 0) {
		g_source_remove (self->priv->_idle_id);
		self->priv->_idle_id = (guint) 0;
	}
	self->priv->_combo_groups = (_tmp0_ = NULL, _g_object_unref0 (self->priv->_combo_groups), _tmp0_);
	self->priv->_combo_items = (_tmp1_ = NULL, _g_object_unref0 (self->priv->_combo_items), _tmp1_);
	self->priv->_top_ui = (_tmp2_ = NULL, _g_object_unref0 (self->priv->_top_ui), _tmp2_);
	_g_object_unref0 (panel);
	_g_object_unref0 (manager);
}


static void vtg_source_outliner_view_on_combo_groups_changed (VtgSourceOutlinerView* self, GtkWidget* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	vtg_source_outliner_view_populate_combo_items_model (self);
}


static void vtg_source_outliner_view_on_combo_items_changed (VtgSourceOutlinerView* self, GtkWidget* sender) {
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	if (self->priv->_updating_combos) {
		return;
	}
	if (gtk_combo_box_get_active_iter (self->priv->_combo_items, &iter)) {
		VtgData* data;
		data = NULL;
		gtk_tree_model_get (gtk_combo_box_get_model (self->priv->_combo_items), &iter, VTG_COLUMNS_DATA, &data, -1);
		g_signal_emit_by_name (self, "goto-source", data->source_reference->first_line, data->source_reference->first_column, data->source_reference->last_column);
		_g_object_unref0 (data);
	}
}


static void vtg_source_outliner_view_initialize_view_ui (VtgSourceOutlinerView* self) {
	GeditDocument* doc;
	GeditTab* tab;
	g_return_if_fail (self != NULL);
	if (self->priv->_active_view == NULL) {
		return;
	}
	doc = _g_object_ref0 (GEDIT_DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) self->priv->_active_view)));
	if (!vtg_utils_is_vala_doc (doc)) {
		_g_object_unref0 (doc);
		return;
	}
	tab = _g_object_ref0 (gedit_tab_get_from_document (doc));
	gtk_widget_show_all ((GtkWidget*) self->priv->_top_ui);
	gtk_box_pack_start ((GtkBox*) tab, (GtkWidget*) self->priv->_top_ui, FALSE, FALSE, (guint) 2);
	_g_object_unref0 (tab);
	_g_object_unref0 (doc);
}


static void vtg_source_outliner_view_cleanup_view_ui (VtgSourceOutlinerView* self) {
	GeditDocument* doc;
	GeditTab* tab;
	g_return_if_fail (self != NULL);
	if (self->priv->_active_view == NULL) {
		return;
	}
	doc = _g_object_ref0 (GEDIT_DOCUMENT (gtk_text_view_get_buffer ((GtkTextView*) self->priv->_active_view)));
	if (!vtg_utils_is_vala_doc (doc)) {
		_g_object_unref0 (doc);
		return;
	}
	tab = _g_object_ref0 (gedit_tab_get_from_document (doc));
	if (tab != NULL) {
		GtkListStore* combo_model;
		GtkListStore* _tmp0_;
		combo_model = _g_object_ref0 (GTK_LIST_STORE (gtk_combo_box_get_model (self->priv->_combo_groups)));
		gtk_list_store_clear (combo_model);
		combo_model = (_tmp0_ = _g_object_ref0 (GTK_LIST_STORE (gtk_combo_box_get_model (self->priv->_combo_items))), _g_object_unref0 (combo_model), _tmp0_);
		gtk_list_store_clear (combo_model);
		gtk_container_remove ((GtkContainer*) tab, (GtkWidget*) self->priv->_top_ui);
		_g_object_unref0 (combo_model);
	}
	_g_object_unref0 (tab);
	_g_object_unref0 (doc);
}


static GtkTreeStore* vtg_source_outliner_view_build_tree_model (VtgSourceOutlinerView* self) {
	GtkTreeStore* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = gtk_tree_store_new ((gint) VTG_COLUMNS_COLUMNS_COUNT, G_TYPE_STRING, GDK_TYPE_PIXBUF, G_TYPE_OBJECT);
	return result;
}


static gint _vtg_source_outliner_view_sort_model_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = vtg_source_outliner_view_sort_model (self, model, a, b);
	return result;
}


static GtkListStore* vtg_source_outliner_view_build_combo_model (VtgSourceOutlinerView* self) {
	GtkListStore* result = NULL;
	GtkListStore* model;
	g_return_val_if_fail (self != NULL, NULL);
	model = gtk_list_store_new ((gint) VTG_COLUMNS_COLUMNS_COUNT, G_TYPE_STRING, GDK_TYPE_PIXBUF, G_TYPE_OBJECT);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) model, 0, GTK_SORT_ASCENDING);
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) model, 0, _vtg_source_outliner_view_sort_model_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	gtk_tree_sortable_set_default_sort_func ((GtkTreeSortable*) model, _vtg_source_outliner_view_sort_model_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	result = model;
	return result;
}


static GtkTreeModelSort* vtg_source_outliner_view_build_sort_model (VtgSourceOutlinerView* self, GtkTreeStore* child_model) {
	GtkTreeModelSort* result = NULL;
	GtkTreeModelSort* sorted;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (child_model != NULL, NULL);
	sorted = (GtkTreeModelSort*) gtk_tree_model_sort_new_with_model ((GtkTreeModel*) child_model);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) sorted, 0, GTK_SORT_ASCENDING);
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) sorted, 0, _vtg_source_outliner_view_sort_model_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	gtk_tree_sortable_set_default_sort_func ((GtkTreeSortable*) sorted, _vtg_source_outliner_view_sort_model_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	result = sorted;
	return result;
}


void vtg_source_outliner_view_clear_view (VtgSourceOutlinerView* self) {
	g_return_if_fail (self != NULL);
	gtk_tree_store_clear (self->priv->_model);
}


void vtg_source_outliner_view_update_view (VtgSourceOutlinerView* self, const char* source_path, AfroditeQueryResult* _result_) {
	GtkTreeStore* model;
	GtkTreeModelSort* sorted;
	GtkListStore* combo_model;
	char* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GtkTreeStore* _tmp2_;
	GtkTreeModelSort* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_path != NULL);
	model = vtg_source_outliner_view_build_tree_model (self);
	sorted = vtg_source_outliner_view_build_sort_model (self, model);
	combo_model = _g_object_ref0 (GTK_LIST_STORE (gtk_combo_box_get_model (self->priv->_combo_groups)));
	self->priv->_current_source_path = (_tmp0_ = g_strdup (source_path), _g_free0 (self->priv->_current_source_path), _tmp0_);
	self->priv->_updating_combos = TRUE;
	gtk_combo_box_set_model (self->priv->_combo_groups, NULL);
	gtk_list_store_clear (combo_model);
	if (_result_ != NULL) {
		_tmp1_ = !afrodite_query_result_get_is_empty (_result_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		AfroditeResultItem* first;
		first = (AfroditeResultItem*) vala_list_get (afrodite_query_result_get_children (_result_), 0);
		vtg_source_outliner_view_populate_treeview_model (self, model, source_path, afrodite_result_item_get_children (first), NULL);
		vtg_source_outliner_view_populate_combo_groups_model (self, combo_model, afrodite_result_item_get_children (first));
		_afrodite_result_item_unref0 (first);
	}
	self->priv->_model = (_tmp2_ = _g_object_ref0 (model), _g_object_unref0 (self->priv->_model), _tmp2_);
	self->priv->_sorted = (_tmp3_ = _g_object_ref0 (sorted), _g_object_unref0 (self->priv->_sorted), _tmp3_);
	gtk_tree_view_set_model (self->priv->_src_view, (GtkTreeModel*) self->priv->_sorted);
	gtk_tree_view_expand_all (self->priv->_src_view);
	self->priv->_updating_combos = FALSE;
	gtk_combo_box_set_model (self->priv->_combo_groups, (GtkTreeModel*) combo_model);
	gtk_widget_queue_draw ((GtkWidget*) self->priv->_combo_groups);
	gtk_widget_queue_draw ((GtkWidget*) self->priv->_combo_items);
	vtg_source_outliner_view_idle_highlight_current_position (self);
	_g_object_unref0 (combo_model);
	_g_object_unref0 (sorted);
	_g_object_unref0 (model);
}


static void vtg_source_outliner_view_populate_combo_items_model (VtgSourceOutlinerView* self) {
	gint count;
	GtkTreeIter iter = {0};
	VtgData* data;
	GtkListStore* model;
	g_return_if_fail (self != NULL);
	count = 0;
	data = NULL;
	model = _g_object_ref0 (GTK_LIST_STORE (gtk_combo_box_get_model (self->priv->_combo_items)));
	gtk_list_store_clear (model);
	gtk_combo_box_set_model (self->priv->_combo_items, NULL);
	if (gtk_combo_box_get_active_iter (self->priv->_combo_groups, &iter)) {
		gboolean _tmp0_ = FALSE;
		gtk_tree_model_get (gtk_combo_box_get_model (self->priv->_combo_groups), &iter, VTG_COLUMNS_DATA, &data, -1);
		if (data->symbol != NULL) {
			_tmp0_ = afrodite_symbol_get_has_children (data->symbol);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			{
				ValaIterator* _child_it;
				_child_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_children (data->symbol));
				while (TRUE) {
					AfroditeSymbol* child;
					if (!vala_iterator_next (_child_it)) {
						break;
					}
					child = (AfroditeSymbol*) vala_iterator_get (_child_it);
					if (!g_str_has_prefix (afrodite_symbol_get_name (child), "!")) {
						AfroditeSourceReference* sr;
						sr = _afrodite_source_reference_ref0 (afrodite_symbol_lookup_source_reference_filename (child, self->priv->_current_source_path));
						if (sr != NULL) {
							GdkPixbuf* _tmp1_;
							VtgData* _tmp2_;
							gtk_list_store_append (model, &iter);
							gtk_list_store_set (model, &iter, VTG_COLUMNS_NAME, afrodite_symbol_get_name (child), VTG_COLUMNS_ICON, _tmp1_ = vtg_utils_get_icon_for_type_name (afrodite_symbol_get_type_name (child)), VTG_COLUMNS_DATA, _tmp2_ = vtg_data_new (child, sr), -1);
							_g_object_unref0 (_tmp2_);
							_g_object_unref0 (_tmp1_);
						}
						count++;
						_afrodite_source_reference_unref0 (sr);
					}
					_afrodite_symbol_unref0 (child);
				}
				_vala_collection_object_unref0 (_child_it);
			}
		}
	}
	gtk_combo_box_set_model (self->priv->_combo_items, (GtkTreeModel*) model);
	_g_object_unref0 (model);
	_g_object_unref0 (data);
}


static void vtg_source_outliner_view_goto_line (VtgSourceOutlinerView* self, AfroditeSymbol* symbol) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	if (afrodite_symbol_get_has_source_references (symbol)) {
		AfroditeSourceReference* sr;
		gint line;
		gint start_col;
		gint end_col;
		sr = (AfroditeSourceReference*) vala_list_get (afrodite_symbol_get_source_references (symbol), 0);
		line = sr->first_line;
		start_col = sr->first_column;
		end_col = sr->last_column;
		g_signal_emit_by_name (self, "goto-source", line, start_col, end_col);
		_afrodite_source_reference_unref0 (sr);
	}
}


static void vtg_source_outliner_view_on_show_symbol_scope_toggled (VtgSourceOutlinerView* self, GtkWidget* sender) {
	GdkEvent* event;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	if (self->priv->_on_show_symbol_scope_toggled_flag) {
		return;
	}
	event = gtk_get_current_event ();
	if ((event->button.state & GDK_SHIFT_MASK) != 0) {
		gboolean active;
		active = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (sender));
		self->priv->_on_show_symbol_scope_toggled_flag = TRUE;
		if (GTK_WIDGET (self->priv->_check_show_internal_symbols) != sender) {
			gtk_toggle_button_set_active (self->priv->_check_show_internal_symbols, !active);
		}
		if (GTK_WIDGET (self->priv->_check_show_private_symbols) != sender) {
			gtk_toggle_button_set_active (self->priv->_check_show_private_symbols, !active);
		}
		if (GTK_WIDGET (self->priv->_check_show_protected_symbols) != sender) {
			gtk_toggle_button_set_active (self->priv->_check_show_protected_symbols, !active);
		}
		if (GTK_WIDGET (self->priv->_check_show_public_symbols) != sender) {
			gtk_toggle_button_set_active (self->priv->_check_show_public_symbols, !active);
		}
		self->priv->_on_show_symbol_scope_toggled_flag = FALSE;
	}
	vtg_configuration_set_outliner_show_private_symbols (vtg_plugin_get_config (vtg_plugin_main_instance), gtk_toggle_button_get_active (self->priv->_check_show_private_symbols));
	vtg_configuration_set_outliner_show_public_symbols (vtg_plugin_get_config (vtg_plugin_main_instance), gtk_toggle_button_get_active (self->priv->_check_show_public_symbols));
	vtg_configuration_set_outliner_show_protected_symbols (vtg_plugin_get_config (vtg_plugin_main_instance), gtk_toggle_button_get_active (self->priv->_check_show_protected_symbols));
	vtg_configuration_set_outliner_show_internal_symbols (vtg_plugin_get_config (vtg_plugin_main_instance), gtk_toggle_button_get_active (self->priv->_check_show_internal_symbols));
	g_signal_emit_by_name (self, "filter-changed");
	_gdk_event_free0 (event);
}


static void vtg_source_outliner_view_on_source_outliner_view_row_activated (VtgSourceOutlinerView* self, GtkWidget* sender, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeView* tw;
	GtkTreeModelSort* model;
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	tw = _g_object_ref0 (GTK_TREE_VIEW (sender));
	model = _g_object_ref0 (GTK_TREE_MODEL_SORT (gtk_tree_view_get_model (tw)));
	if (gtk_tree_model_get_iter ((GtkTreeModel*) model, &iter, path)) {
		VtgData* data;
		data = NULL;
		gtk_tree_model_get ((GtkTreeModel*) model, &iter, VTG_COLUMNS_DATA, &data, -1);
		vtg_source_outliner_view_goto_line (self, data->symbol);
		_g_object_unref0 (data);
	}
	_g_object_unref0 (model);
	_g_object_unref0 (tw);
}


static void vtg_source_outliner_view_on_source_outliner_goto (VtgSourceOutlinerView* self, GtkAction* action) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model;
	GtkTreeModel* _tmp0_ = NULL;
	gboolean _tmp1_;
	GtkTreeModel* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	model = NULL;
	if ((_tmp1_ = gtk_tree_selection_get_selected (gtk_tree_view_get_selection (self->priv->_src_view), &_tmp0_, &iter), model = (_tmp2_ = _g_object_ref0 (_tmp0_), _g_object_unref0 (model), _tmp2_), _tmp1_)) {
		VtgData* data;
		data = NULL;
		gtk_tree_model_get (model, &iter, VTG_COLUMNS_DATA, &data, -1);
		vtg_source_outliner_view_goto_line (self, data->symbol);
		_g_object_unref0 (data);
	}
	_g_object_unref0 (model);
}


static void _g_list_free_gtk_tree_path_free (GList* self) {
	g_list_foreach (self, (GFunc) gtk_tree_path_free, NULL);
	g_list_free (self);
}


static gboolean vtg_source_outliner_view_on_source_outliner_view_button_press (VtgSourceOutlinerView* self, GtkWidget* sender, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	if ((*event).button == 3) {
		GtkTreeModel* model;
		GList* rows;
		model = NULL;
		rows = gtk_tree_selection_get_selected_rows (gtk_tree_view_get_selection (self->priv->_src_view), &model);
		if (g_list_length (rows) == 1) {
			GtkTreeIter iter = {0};
			VtgData* obj;
			GtkTreePath* path;
			obj = NULL;
			path = (GtkTreePath*) g_list_nth_data (rows, (guint) 0);
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (model, &iter, VTG_COLUMNS_DATA, &obj, -1);
			if (AFRODITE_IS_SYMBOL (obj->symbol)) {
				gtk_menu_popup (self->priv->_popup_symbols, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
			}
			_g_object_unref0 (obj);
		}
		__g_list_free_gtk_tree_path_free0 (rows);
	}
	result = FALSE;
	return result;
}


static AfroditeSymbolAccessibility vtg_source_outliner_view_get_symbol_accessibility (VtgSourceOutlinerView* self, AfroditeSymbol* symbol) {
	AfroditeSymbolAccessibility result = 0;
	AfroditeSymbolAccessibility sym_access = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (symbol != NULL, 0);
	if (afrodite_symbol_get_has_children (symbol)) {
		_tmp1_ = !g_str_has_prefix (afrodite_symbol_get_name (symbol), "!");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		if (_vala_strcmp0 (afrodite_symbol_get_type_name (symbol), "Class") == 0) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = _vala_strcmp0 (afrodite_symbol_get_type_name (symbol), "Struct") == 0;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = _vala_strcmp0 (afrodite_symbol_get_type_name (symbol), "Namespace") == 0;
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		sym_access = afrodite_symbol_get_access (symbol);
		{
			ValaIterator* _child_it;
			_child_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_children (symbol));
			while (TRUE) {
				AfroditeSymbol* child;
				if (!vala_iterator_next (_child_it)) {
					break;
				}
				child = (AfroditeSymbol*) vala_iterator_get (_child_it);
				sym_access = sym_access | vtg_source_outliner_view_get_symbol_accessibility (self, child);
				if (sym_access == AFRODITE_SYMBOL_ACCESSIBILITY_ANY) {
					_afrodite_symbol_unref0 (child);
					break;
				}
				_afrodite_symbol_unref0 (child);
			}
			_vala_collection_object_unref0 (_child_it);
		}
	} else {
		sym_access = afrodite_symbol_get_access (symbol);
	}
	result = sym_access;
	return result;
}


static void vtg_source_outliner_view_populate_combo_groups_model (VtgSourceOutlinerView* self, GtkListStore* combo_model, ValaList* items) {
	gboolean root_namespace_added;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo_model != NULL);
	root_namespace_added = FALSE;
	{
		ValaIterator* _item_it;
		_item_it = vala_iterable_iterator ((ValaIterable*) items);
		while (TRUE) {
			AfroditeResultItem* item;
			AfroditeSymbol* symbol;
			GtkTreeIter iter_group = {0};
			gboolean _tmp0_ = FALSE;
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
			if (!vala_iterator_next (_item_it)) {
				break;
			}
			item = (AfroditeResultItem*) vala_iterator_get (_item_it);
			symbol = _afrodite_symbol_ref0 (afrodite_result_item_get_symbol (item));
			if (_vala_strcmp0 (afrodite_symbol_get_type_name (symbol), "Namespace") == 0) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = _vala_strcmp0 (afrodite_symbol_get_type_name (symbol), "Class") == 0;
			}
			if (_tmp3_) {
				_tmp2_ = TRUE;
			} else {
				_tmp2_ = _vala_strcmp0 (afrodite_symbol_get_type_name (symbol), "Interface") == 0;
			}
			if (_tmp2_) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = _vala_strcmp0 (afrodite_symbol_get_type_name (symbol), "Struct") == 0;
			}
			if (_tmp1_) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = _vala_strcmp0 (afrodite_symbol_get_type_name (symbol), "Enum") == 0;
			}
			if (_tmp0_) {
				AfroditeSourceReference* sr;
				sr = _afrodite_source_reference_ref0 (afrodite_symbol_lookup_source_reference_filename (symbol, self->priv->_current_source_path));
				if (sr != NULL) {
					GdkPixbuf* _tmp4_;
					VtgData* _tmp5_;
					gtk_list_store_append (combo_model, &iter_group);
					gtk_list_store_set (combo_model, &iter_group, VTG_COLUMNS_NAME, afrodite_symbol_get_fully_qualified_name (symbol), VTG_COLUMNS_ICON, _tmp4_ = vtg_utils_get_icon_for_type_name (afrodite_symbol_get_type_name (symbol)), VTG_COLUMNS_DATA, _tmp5_ = vtg_data_new (symbol, sr), -1);
					_g_object_unref0 (_tmp5_);
					_g_object_unref0 (_tmp4_);
				}
				if (vala_collection_get_size ((ValaCollection*) afrodite_result_item_get_children (item)) > 0) {
					vtg_source_outliner_view_populate_combo_groups_model (self, combo_model, afrodite_result_item_get_children (item));
				}
				_afrodite_source_reference_unref0 (sr);
			} else {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				if (root_namespace_added == FALSE) {
					_tmp7_ = afrodite_symbol_get_parent (symbol) != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = afrodite_symbol_get_is_root (afrodite_symbol_get_parent (symbol));
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					GdkPixbuf* _tmp8_;
					VtgData* _tmp9_;
					gtk_list_store_append (combo_model, &iter_group);
					gtk_list_store_set (combo_model, &iter_group, VTG_COLUMNS_NAME, _ ("(none)"), VTG_COLUMNS_ICON, _tmp8_ = vtg_utils_get_icon_for_type_name ("Namespace"), VTG_COLUMNS_DATA, _tmp9_ = vtg_data_new (afrodite_symbol_get_parent (symbol), NULL), -1);
					_g_object_unref0 (_tmp9_);
					_g_object_unref0 (_tmp8_);
					root_namespace_added = TRUE;
				}
			}
			_afrodite_symbol_unref0 (symbol);
			_afrodite_result_item_unref0 (item);
		}
		_vala_collection_object_unref0 (_item_it);
	}
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = string_get_length (self);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void vtg_source_outliner_view_populate_treeview_model (VtgSourceOutlinerView* self, GtkTreeStore* model, const char* source_path, ValaList* items, GtkTreeIter* parent_iter) {
	gboolean _tmp0_ = FALSE;
	AfroditeSymbolAccessibility accessibility;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (source_path != NULL);
	if (items == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_collection_get_size ((ValaCollection*) items) == 0;
	}
	if (_tmp0_) {
		return;
	}
	accessibility = 0;
	if (gtk_toggle_button_get_active (self->priv->_check_show_private_symbols)) {
		accessibility = AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE;
	}
	if (gtk_toggle_button_get_active (self->priv->_check_show_public_symbols)) {
		accessibility = accessibility | AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC;
	}
	if (gtk_toggle_button_get_active (self->priv->_check_show_protected_symbols)) {
		accessibility = accessibility | AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED;
	}
	if (gtk_toggle_button_get_active (self->priv->_check_show_internal_symbols)) {
		accessibility = accessibility | AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL;
	}
	{
		ValaIterator* _item_it;
		_item_it = vala_iterable_iterator ((ValaIterable*) items);
		while (TRUE) {
			AfroditeResultItem* item;
			GtkTreeIter iter = {0};
			AfroditeSymbol* symbol;
			AfroditeSymbolAccessibility sym_access;
			if (!vala_iterator_next (_item_it)) {
				break;
			}
			item = (AfroditeResultItem*) vala_iterator_get (_item_it);
			symbol = _afrodite_symbol_ref0 (afrodite_result_item_get_symbol (item));
			sym_access = vtg_source_outliner_view_get_symbol_accessibility (self, symbol);
			if (!g_str_has_prefix (afrodite_symbol_get_name (symbol), "!")) {
				if ((sym_access & accessibility) != 0) {
					char* des;
					AfroditeSourceReference* sr;
					GdkPixbuf* _tmp2_;
					VtgData* _tmp3_;
					des = g_strdup (afrodite_symbol_get_markup_description (symbol));
					{
						char** qualifier_collection;
						int qualifier_collection_length1;
						int qualifier_it;
						qualifier_collection = self->priv->qualifiers;
						qualifier_collection_length1 = self->priv->qualifiers_length1;
						for (qualifier_it = 0; qualifier_it < self->priv->qualifiers_length1; qualifier_it = qualifier_it + 1) {
							char* qualifier;
							qualifier = g_strdup (qualifier_collection[qualifier_it]);
							{
								if (g_str_has_prefix (des, qualifier)) {
									char* _tmp1_;
									des = (_tmp1_ = string_substring (des, string_get_length (qualifier), -1), _g_free0 (des), _tmp1_);
									_g_free0 (qualifier);
									break;
								}
								_g_free0 (qualifier);
							}
						}
					}
					gtk_tree_store_append (model, &iter, parent_iter);
					sr = _afrodite_source_reference_ref0 (afrodite_symbol_lookup_source_reference_filename (symbol, source_path));
					gtk_tree_store_set (model, &iter, VTG_COLUMNS_NAME, des, VTG_COLUMNS_ICON, _tmp2_ = vtg_utils_get_icon_for_type_name (afrodite_symbol_get_type_name (symbol)), VTG_COLUMNS_DATA, _tmp3_ = vtg_data_new (symbol, sr), -1);
					_g_object_unref0 (_tmp3_);
					_g_object_unref0 (_tmp2_);
					if (vala_collection_get_size ((ValaCollection*) afrodite_result_item_get_children (item)) > 0) {
						vtg_source_outliner_view_populate_treeview_model (self, model, source_path, afrodite_result_item_get_children (item), &iter);
					}
					_afrodite_source_reference_unref0 (sr);
					_g_free0 (des);
				}
			}
			_afrodite_symbol_unref0 (symbol);
			_afrodite_result_item_unref0 (item);
		}
		_vala_collection_object_unref0 (_item_it);
	}
}


static gint vtg_source_outliner_view_sort_model (VtgSourceOutlinerView* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b) {
	gint result = 0;
	VtgData* vala;
	VtgData* valb;
	AfroditeSymbol* _tmp0_;
	AfroditeSymbol* sa;
	AfroditeSymbol* _tmp1_;
	AfroditeSymbol* sb;
	gint _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	vala = NULL;
	valb = NULL;
	gtk_tree_model_get (model, a, VTG_COLUMNS_DATA, &vala, -1);
	gtk_tree_model_get (model, b, VTG_COLUMNS_DATA, &valb, -1);
	_tmp0_ = NULL;
	if (vala == NULL) {
		_tmp0_ = NULL;
	} else {
		_tmp0_ = vala->symbol;
	}
	sa = _afrodite_symbol_ref0 (_tmp0_);
	_tmp1_ = NULL;
	if (valb == NULL) {
		_tmp1_ = NULL;
	} else {
		_tmp1_ = valb->symbol;
	}
	sb = _afrodite_symbol_ref0 (_tmp1_);
	_result_ = vtg_utils_symbol_type_compare (sa, sb);
	result = _result_;
	_afrodite_symbol_unref0 (sb);
	_afrodite_symbol_unref0 (sa);
	_g_object_unref0 (valb);
	_g_object_unref0 (vala);
	return result;
}


static gboolean _vtg_source_outliner_view_highlight_current_position_gsource_func (gpointer self) {
	gboolean result;
	result = vtg_source_outliner_view_highlight_current_position (self);
	return result;
}


static void vtg_source_outliner_view_idle_highlight_current_position (VtgSourceOutlinerView* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_idle_id == 0) {
		self->priv->_idle_id = g_idle_add_full (G_PRIORITY_LOW, _vtg_source_outliner_view_highlight_current_position_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static gboolean vtg_source_outliner_view_highlight_current_position (VtgSourceOutlinerView* self) {
	gboolean result = FALSE;
	AfroditeSymbol* symbol;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	symbol = NULL;
	model = _g_object_ref0 (gtk_combo_box_get_model (self->priv->_combo_groups));
	self->priv->_updating_combos = TRUE;
	if (gtk_tree_model_get_iter_first (model, &iter)) {
		GtkTreeIter* found;
		found = NULL;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				VtgData* data;
				if (!_tmp0_) {
					gboolean _tmp1_ = FALSE;
					if (symbol == NULL) {
						_tmp1_ = gtk_tree_model_iter_next (model, &iter);
					} else {
						_tmp1_ = FALSE;
					}
					if (!_tmp1_) {
						break;
					}
				}
				_tmp0_ = FALSE;
				data = NULL;
				gtk_tree_model_get (model, &iter, VTG_COLUMNS_DATA, &data, -1);
				if (afrodite_symbol_get_has_children (data->symbol)) {
					{
						ValaIterator* _child_it;
						_child_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_children (data->symbol));
						while (TRUE) {
							AfroditeSymbol* child;
							AfroditeSourceReference* sr;
							gboolean _tmp2_ = FALSE;
							if (!vala_iterator_next (_child_it)) {
								break;
							}
							child = (AfroditeSymbol*) vala_iterator_get (_child_it);
							sr = _afrodite_source_reference_ref0 (afrodite_symbol_lookup_source_reference_filename (child, self->priv->_current_source_path));
							if (sr != NULL) {
								_tmp2_ = afrodite_source_reference_contains_position (sr, self->priv->_current_line + 1, self->priv->_current_column);
							} else {
								_tmp2_ = FALSE;
							}
							if (_tmp2_) {
								AfroditeSymbol* _tmp3_;
								GtkTreeIter* _tmp4_;
								symbol = (_tmp3_ = _afrodite_symbol_ref0 (child), _afrodite_symbol_unref0 (symbol), _tmp3_);
								found = (_tmp4_ = __gtk_tree_iter_dup0 (&iter), _g_free0 (found), _tmp4_);
								_afrodite_source_reference_unref0 (sr);
								_afrodite_symbol_unref0 (child);
								break;
							}
							_afrodite_source_reference_unref0 (sr);
							_afrodite_symbol_unref0 (child);
						}
						_vala_collection_object_unref0 (_child_it);
					}
				}
				_g_object_unref0 (data);
			}
		}
		if (found == NULL) {
			gtk_combo_box_set_active (self->priv->_combo_groups, -1);
		} else {
			gtk_combo_box_set_active_iter (self->priv->_combo_groups, found);
		}
		_g_free0 (found);
	}
	if (symbol != NULL) {
		GtkTreeModel* _tmp5_;
		model = (_tmp5_ = _g_object_ref0 (gtk_combo_box_get_model (self->priv->_combo_items)), _g_object_unref0 (model), _tmp5_);
		if (gtk_tree_model_get_iter_first (model, &iter)) {
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					VtgData* data;
					if (!_tmp6_) {
						if (!gtk_tree_model_iter_next (model, &iter)) {
							break;
						}
					}
					_tmp6_ = FALSE;
					data = NULL;
					gtk_tree_model_get (model, &iter, VTG_COLUMNS_DATA, &data, -1);
					if (data->symbol == symbol) {
						gtk_combo_box_set_active_iter (self->priv->_combo_items, &iter);
						_g_object_unref0 (data);
						break;
					}
					_g_object_unref0 (data);
				}
			}
		}
	}
	self->priv->_updating_combos = FALSE;
	self->priv->_idle_id = (guint) 0;
	result = FALSE;
	_g_object_unref0 (model);
	_afrodite_symbol_unref0 (symbol);
	return result;
}


GeditView* vtg_source_outliner_view_get_active_view (VtgSourceOutlinerView* self) {
	GeditView* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_active_view;
	return result;
}


void vtg_source_outliner_view_set_active_view (VtgSourceOutlinerView* self, GeditView* value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_active_view != value) {
		GeditView* _tmp0_;
		vtg_source_outliner_view_cleanup_view_ui (self);
		self->priv->_active_view = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_active_view), _tmp0_);
		vtg_source_outliner_view_initialize_view_ui (self);
	}
	g_object_notify ((GObject *) self, "active-view");
}


gboolean vtg_source_outliner_view_get_show_private_symbols (VtgSourceOutlinerView* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = gtk_toggle_button_get_active (self->priv->_check_show_private_symbols);
	return result;
}


gint vtg_source_outliner_view_get_current_line (VtgSourceOutlinerView* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_current_line;
	return result;
}


gint vtg_source_outliner_view_get_current_column (VtgSourceOutlinerView* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_current_column;
	return result;
}


static void vtg_source_outliner_view_class_init (VtgSourceOutlinerViewClass * klass) {
	vtg_source_outliner_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgSourceOutlinerViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = vtg_source_outliner_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = vtg_source_outliner_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_source_outliner_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_SOURCE_OUTLINER_VIEW_ACTIVE_VIEW, g_param_spec_object ("active-view", "active-view", "active-view", GEDIT_TYPE_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_SOURCE_OUTLINER_VIEW_SHOW_PRIVATE_SYMBOLS, g_param_spec_boolean ("show-private-symbols", "show-private-symbols", "show-private-symbols", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_SOURCE_OUTLINER_VIEW_CURRENT_LINE, g_param_spec_int ("current-line", "current-line", "current-line", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_SOURCE_OUTLINER_VIEW_CURRENT_COLUMN, g_param_spec_int ("current-column", "current-column", "current-column", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("goto_source", VTG_TYPE_SOURCE_OUTLINER_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT, G_TYPE_NONE, 3, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("filter_changed", VTG_TYPE_SOURCE_OUTLINER_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void vtg_source_outliner_view_instance_init (VtgSourceOutlinerView * self) {
	char** _tmp0_ = NULL;
	self->priv = VTG_SOURCE_OUTLINER_VIEW_GET_PRIVATE (self);
	self->priv->qualifiers = (_tmp0_ = g_new0 (char*, 4 + 1), _tmp0_[0] = g_strdup ("public "), _tmp0_[1] = g_strdup ("private "), _tmp0_[2] = g_strdup ("internal "), _tmp0_[3] = g_strdup ("protected "), _tmp0_);
	self->priv->qualifiers_length1 = 4;
	self->priv->_qualifiers_size_ = self->priv->qualifiers_length1;
	self->priv->_plugin_instance = NULL;
	self->priv->_model = NULL;
	self->priv->_on_show_symbol_scope_toggled_flag = FALSE;
	self->priv->_popup_symbols_ui_def = g_strdup ("\n" \
"                                        <ui>\n" \
"                                        <popup name='SourceOutlinerPop" \
"upGoto'>\n" \
"                                            <menuitem action='source-o" \
"utliner-goto'/>\n" \
"                                        </popup>\n" \
"                                        </ui>");
	self->priv->_current_line = -1;
	self->priv->_current_column = -1;
	self->priv->_idle_id = (guint) 0;
	self->priv->_active_view = NULL;
	self->priv->_updating_combos = FALSE;
}


static void vtg_source_outliner_view_finalize (GObject* obj) {
	VtgSourceOutlinerView * self;
	self = VTG_SOURCE_OUTLINER_VIEW (obj);
	{
		vtg_utils_trace ("vtgsourceoutlinerview.vala:254: SourceOutlinerView destroying");
		gtk_tree_view_set_model (self->priv->_src_view, NULL);
		vtg_source_outliner_view_deactivate (self);
		vtg_utils_trace ("vtgsourceoutlinerview.vala:258: SourceOutlinerView destroyed");
	}
	self->priv->qualifiers = (_vala_array_free (self->priv->qualifiers, self->priv->qualifiers_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_src_view);
	_g_object_unref0 (self->priv->_sorted);
	_g_object_unref0 (self->priv->_check_show_private_symbols);
	_g_object_unref0 (self->priv->_check_show_public_symbols);
	_g_object_unref0 (self->priv->_check_show_protected_symbols);
	_g_object_unref0 (self->priv->_check_show_internal_symbols);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->_popup_symbols);
	_g_free0 (self->priv->_popup_symbols_ui_def);
	_g_object_unref0 (self->priv->_actions);
	_g_object_unref0 (self->priv->_side_panel);
	_g_object_unref0 (self->priv->_active_view);
	_g_object_unref0 (self->priv->_top_ui);
	_g_object_unref0 (self->priv->_combo_groups);
	_g_object_unref0 (self->priv->_combo_items);
	_g_free0 (self->priv->_current_source_path);
	G_OBJECT_CLASS (vtg_source_outliner_view_parent_class)->finalize (obj);
}


GType vtg_source_outliner_view_get_type (void) {
	return vtg_source_outliner_view_type_id;
}


GType vtg_source_outliner_view_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgSourceOutlinerViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_source_outliner_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgSourceOutlinerView), 0, (GInstanceInitFunc) vtg_source_outliner_view_instance_init, NULL };
	vtg_source_outliner_view_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgSourceOutlinerView", &g_define_type_info, 0);
	return vtg_source_outliner_view_type_id;
}


static void vtg_source_outliner_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgSourceOutlinerView * self;
	self = VTG_SOURCE_OUTLINER_VIEW (object);
	switch (property_id) {
		case VTG_SOURCE_OUTLINER_VIEW_ACTIVE_VIEW:
		g_value_set_object (value, vtg_source_outliner_view_get_active_view (self));
		break;
		case VTG_SOURCE_OUTLINER_VIEW_SHOW_PRIVATE_SYMBOLS:
		g_value_set_boolean (value, vtg_source_outliner_view_get_show_private_symbols (self));
		break;
		case VTG_SOURCE_OUTLINER_VIEW_CURRENT_LINE:
		g_value_set_int (value, vtg_source_outliner_view_get_current_line (self));
		break;
		case VTG_SOURCE_OUTLINER_VIEW_CURRENT_COLUMN:
		g_value_set_int (value, vtg_source_outliner_view_get_current_column (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vtg_source_outliner_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	VtgSourceOutlinerView * self;
	self = VTG_SOURCE_OUTLINER_VIEW (object);
	switch (property_id) {
		case VTG_SOURCE_OUTLINER_VIEW_ACTIVE_VIEW:
		vtg_source_outliner_view_set_active_view (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__INT_INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), data2);
}



