/* symbolresolver.c generated by valac 0.10.0, the Vala compiler
 * generated from symbolresolver.vala, do not modify */

/* symbolresolver.vala
 *
 * Copyright (C) 2009  Andrea Del Signore
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Andrea Del Signore <sejerpz@tin.it>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <gobject/gvaluecollector.h>


#define AFRODITE_TYPE_SYMBOL_RESOLVER (afrodite_symbol_resolver_get_type ())
#define AFRODITE_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SYMBOL_RESOLVER, AfroditeSymbolResolver))
#define AFRODITE_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SYMBOL_RESOLVER, AfroditeSymbolResolverClass))
#define AFRODITE_IS_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SYMBOL_RESOLVER))
#define AFRODITE_IS_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SYMBOL_RESOLVER))
#define AFRODITE_SYMBOL_RESOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SYMBOL_RESOLVER, AfroditeSymbolResolverClass))

typedef struct _AfroditeSymbolResolver AfroditeSymbolResolver;
typedef struct _AfroditeSymbolResolverClass AfroditeSymbolResolverClass;
typedef struct _AfroditeSymbolResolverPrivate AfroditeSymbolResolverPrivate;

#define AFRODITE_TYPE_AST (afrodite_ast_get_type ())
#define AFRODITE_AST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_AST, AfroditeAst))
#define AFRODITE_AST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_AST, AfroditeAstClass))
#define AFRODITE_IS_AST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_AST))
#define AFRODITE_IS_AST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_AST))
#define AFRODITE_AST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_AST, AfroditeAstClass))

typedef struct _AfroditeAst AfroditeAst;
typedef struct _AfroditeAstClass AfroditeAstClass;
#define _afrodite_ast_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_ast_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define AFRODITE_TYPE_SOURCE_FILE (afrodite_source_file_get_type ())
#define AFRODITE_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFile))
#define AFRODITE_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))
#define AFRODITE_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))

typedef struct _AfroditeSourceFile AfroditeSourceFile;
typedef struct _AfroditeSourceFileClass AfroditeSourceFileClass;

#define AFRODITE_TYPE_DATA_TYPE (afrodite_data_type_get_type ())
#define AFRODITE_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataType))
#define AFRODITE_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))
#define AFRODITE_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_DATA_TYPE))
#define AFRODITE_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_DATA_TYPE, AfroditeDataTypeClass))

typedef struct _AfroditeDataType AfroditeDataType;
typedef struct _AfroditeDataTypeClass AfroditeDataTypeClass;

#define AFRODITE_TYPE_SYMBOL (afrodite_symbol_get_type ())
#define AFRODITE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbol))
#define AFRODITE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))
#define AFRODITE_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SYMBOL))
#define AFRODITE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SYMBOL, AfroditeSymbolClass))

typedef struct _AfroditeSymbol AfroditeSymbol;
typedef struct _AfroditeSymbolClass AfroditeSymbolClass;
#define _afrodite_symbol_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_symbol_unref (var), NULL)))
#define _afrodite_data_type_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_data_type_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _afrodite_source_file_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_file_unref (var), NULL)))
typedef struct _AfroditeAstPrivate AfroditeAstPrivate;

#define AFRODITE_TYPE_VOID_TYPE (afrodite_void_type_get_type ())
#define AFRODITE_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_VOID_TYPE, AfroditeVoidType))
#define AFRODITE_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_VOID_TYPE, AfroditeVoidTypeClass))
#define AFRODITE_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_VOID_TYPE))
#define AFRODITE_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_VOID_TYPE))
#define AFRODITE_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_VOID_TYPE, AfroditeVoidTypeClass))

typedef struct _AfroditeVoidType AfroditeVoidType;
typedef struct _AfroditeVoidTypeClass AfroditeVoidTypeClass;

#define AFRODITE_TYPE_SOURCE_REFERENCE (afrodite_source_reference_get_type ())
#define AFRODITE_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReference))
#define AFRODITE_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReferenceClass))
#define AFRODITE_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_REFERENCE))
#define AFRODITE_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_REFERENCE))
#define AFRODITE_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_REFERENCE, AfroditeSourceReferenceClass))

typedef struct _AfroditeSourceReference AfroditeSourceReference;
typedef struct _AfroditeSourceReferenceClass AfroditeSourceReferenceClass;
typedef struct _AfroditeSourceReferencePrivate AfroditeSourceReferencePrivate;
#define _afrodite_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_reference_unref (var), NULL)))
typedef struct _AfroditeParamSpecSymbolResolver AfroditeParamSpecSymbolResolver;

struct _AfroditeSymbolResolver {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeSymbolResolverPrivate * priv;
};

struct _AfroditeSymbolResolverClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeSymbolResolver *self);
};

struct _AfroditeSymbolResolverPrivate {
	AfroditeAst* _ast;
	char* _vala_symbol_fqn;
};

struct _AfroditeAst {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeAstPrivate * priv;
	ValaHashMap* symbols;
	ValaList* unresolved_symbols;
};

struct _AfroditeAstClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeAst *self);
};

struct _AfroditeSourceReference {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeSourceReferencePrivate * priv;
	AfroditeSourceFile* file;
	gint first_line;
	gint last_line;
	gint first_column;
	gint last_column;
};

struct _AfroditeSourceReferenceClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeSourceReference *self);
};

struct _AfroditeParamSpecSymbolResolver {
	GParamSpec parent_instance;
};


extern AfroditeVoidType* afrodite_symbol_VOID;
static gpointer afrodite_symbol_resolver_parent_class = NULL;

gpointer afrodite_symbol_resolver_ref (gpointer instance);
void afrodite_symbol_resolver_unref (gpointer instance);
GParamSpec* afrodite_param_spec_symbol_resolver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_symbol_resolver (GValue* value, gpointer v_object);
void afrodite_value_take_symbol_resolver (GValue* value, gpointer v_object);
gpointer afrodite_value_get_symbol_resolver (const GValue* value);
GType afrodite_symbol_resolver_get_type (void) G_GNUC_CONST;
gpointer afrodite_ast_ref (gpointer instance);
void afrodite_ast_unref (gpointer instance);
GParamSpec* afrodite_param_spec_ast (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_ast (GValue* value, gpointer v_object);
void afrodite_value_take_ast (GValue* value, gpointer v_object);
gpointer afrodite_value_get_ast (const GValue* value);
GType afrodite_ast_get_type (void) G_GNUC_CONST;
#define AFRODITE_SYMBOL_RESOLVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AFRODITE_TYPE_SYMBOL_RESOLVER, AfroditeSymbolResolverPrivate))
enum  {
	AFRODITE_SYMBOL_RESOLVER_DUMMY_PROPERTY
};
void afrodite_symbol_resolver_resolve (AfroditeSymbolResolver* self, AfroditeAst* ast);
gboolean afrodite_ast_get_has_source_files (AfroditeAst* self);
gpointer afrodite_source_file_ref (gpointer instance);
void afrodite_source_file_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_file (GValue* value, gpointer v_object);
void afrodite_value_take_source_file (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_file (const GValue* value);
GType afrodite_source_file_get_type (void) G_GNUC_CONST;
ValaList* afrodite_ast_get_source_files (AfroditeAst* self);
gboolean afrodite_source_file_get_has_using_directives (AfroditeSourceFile* self);
gpointer afrodite_data_type_ref (gpointer instance);
void afrodite_data_type_unref (gpointer instance);
GParamSpec* afrodite_param_spec_data_type (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_data_type (GValue* value, gpointer v_object);
void afrodite_value_take_data_type (GValue* value, gpointer v_object);
gpointer afrodite_value_get_data_type (const GValue* value);
GType afrodite_data_type_get_type (void) G_GNUC_CONST;
ValaList* afrodite_source_file_get_using_directives (AfroditeSourceFile* self);
gboolean afrodite_data_type_get_unresolved (AfroditeDataType* self);
gpointer afrodite_symbol_ref (gpointer instance);
void afrodite_symbol_unref (gpointer instance);
GParamSpec* afrodite_param_spec_symbol (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_symbol (GValue* value, gpointer v_object);
void afrodite_value_take_symbol (GValue* value, gpointer v_object);
gpointer afrodite_value_get_symbol (const GValue* value);
GType afrodite_symbol_get_type (void) G_GNUC_CONST;
AfroditeSymbol* afrodite_ast_lookup (AfroditeAst* self, const char* fully_qualified_name);
const char* afrodite_data_type_get_type_name (AfroditeDataType* self);
void afrodite_data_type_set_symbol (AfroditeDataType* self, AfroditeSymbol* value);
const char* afrodite_source_file_get_filename (AfroditeSourceFile* self);
void afrodite_utils_trace (const char* format, ...);
static void afrodite_symbol_resolver_visit_symbols (AfroditeSymbolResolver* self, ValaList* symbols);
static AfroditeSymbol* afrodite_symbol_resolver_resolve_type (AfroditeSymbolResolver* self, AfroditeSymbol* symbol, AfroditeDataType* type);
GType afrodite_void_type_get_type (void) G_GNUC_CONST;
AfroditeSymbol* afrodite_ast_get_root (AfroditeAst* self);
const char* afrodite_symbol_get_name (AfroditeSymbol* self);
gboolean afrodite_symbol_get_has_generic_type_arguments (AfroditeSymbol* self);
ValaList* afrodite_symbol_get_generic_type_arguments (AfroditeSymbol* self);
const char* afrodite_symbol_get_fully_qualified_name (AfroditeSymbol* self);
AfroditeSymbol* afrodite_symbol_get_parent (AfroditeSymbol* self);
gpointer afrodite_source_reference_ref (gpointer instance);
void afrodite_source_reference_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_reference (GValue* value, gpointer v_object);
void afrodite_value_take_source_reference (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_reference (const GValue* value);
GType afrodite_source_reference_get_type (void) G_GNUC_CONST;
ValaList* afrodite_symbol_get_source_references (AfroditeSymbol* self);
const char* afrodite_data_type_get_name (AfroditeDataType* self);
gboolean afrodite_data_type_get_has_generic_types (AfroditeDataType* self);
ValaList* afrodite_data_type_get_generic_types (AfroditeDataType* self);
static AfroditeSymbol* afrodite_symbol_resolver_specialize_generic_symbol (AfroditeSymbolResolver* self, AfroditeDataType* type, AfroditeSymbol* symbol);
void afrodite_symbol_add_resolved_target (AfroditeSymbol* self, AfroditeSymbol* resolve_target);
AfroditeSymbol* afrodite_symbol_copy (AfroditeSymbol* self);
static gboolean afrodite_symbol_resolver_visit_symbol (AfroditeSymbolResolver* self, AfroditeSymbol* symbol);
void afrodite_symbol_specialize_generic_symbol (AfroditeSymbol* self, ValaList* types);
gboolean afrodite_symbol_get_has_base_types (AfroditeSymbol* self);
ValaList* afrodite_symbol_get_base_types (AfroditeSymbol* self);
AfroditeSymbol* afrodite_data_type_get_symbol (AfroditeDataType* self);
const char* afrodite_symbol_get_description (AfroditeSymbol* self);
void afrodite_symbol_add_specialized_symbol (AfroditeSymbol* self, AfroditeSymbol* item);
static void afrodite_symbol_resolver_resolve_symbol (AfroditeSymbolResolver* self, AfroditeSymbol* symbol, AfroditeDataType* type);
AfroditeDataType* afrodite_symbol_get_return_type (AfroditeSymbol* self);
void afrodite_data_type_set_type_name (AfroditeDataType* self, const char* value);
gboolean afrodite_data_type_get_is_iterator (AfroditeDataType* self);
gboolean afrodite_symbol_get_has_parameters (AfroditeSymbol* self);
ValaList* afrodite_symbol_get_parameters (AfroditeSymbol* self);
gboolean afrodite_symbol_get_has_local_variables (AfroditeSymbol* self);
ValaList* afrodite_symbol_get_local_variables (AfroditeSymbol* self);
AfroditeSymbolResolver* afrodite_symbol_resolver_new (void);
AfroditeSymbolResolver* afrodite_symbol_resolver_construct (GType object_type);
static void afrodite_symbol_resolver_finalize (AfroditeSymbolResolver* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _afrodite_ast_ref0 (gpointer self) {
	return self ? afrodite_ast_ref (self) : NULL;
}


void afrodite_symbol_resolver_resolve (AfroditeSymbolResolver* self, AfroditeAst* ast) {
	char* _tmp0_;
	AfroditeAst* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ast != NULL);
	self->priv->_vala_symbol_fqn = (_tmp0_ = NULL, _g_free0 (self->priv->_vala_symbol_fqn), _tmp0_);
	self->priv->_ast = (_tmp1_ = _afrodite_ast_ref0 (ast), _afrodite_ast_unref0 (self->priv->_ast), _tmp1_);
	if (afrodite_ast_get_has_source_files (self->priv->_ast)) {
		{
			ValaIterator* _file_it;
			_file_it = vala_iterable_iterator ((ValaIterable*) afrodite_ast_get_source_files (self->priv->_ast));
			while (TRUE) {
				AfroditeSourceFile* file;
				if (!vala_iterator_next (_file_it)) {
					break;
				}
				file = (AfroditeSourceFile*) vala_iterator_get (_file_it);
				if (afrodite_source_file_get_has_using_directives (file)) {
					{
						ValaIterator* _using_directive_it;
						_using_directive_it = vala_iterable_iterator ((ValaIterable*) afrodite_source_file_get_using_directives (file));
						while (TRUE) {
							AfroditeDataType* using_directive;
							if (!vala_iterator_next (_using_directive_it)) {
								break;
							}
							using_directive = (AfroditeDataType*) vala_iterator_get (_using_directive_it);
							if (afrodite_data_type_get_unresolved (using_directive)) {
								AfroditeSymbol* _tmp2_;
								afrodite_data_type_set_symbol (using_directive, _tmp2_ = afrodite_ast_lookup (self->priv->_ast, afrodite_data_type_get_type_name (using_directive)));
								_afrodite_symbol_unref0 (_tmp2_);
								if (afrodite_data_type_get_unresolved (using_directive)) {
									g_message ("symbolresolver.vala:54: file %s - can't resolve using directive: %s", afrodite_source_file_get_filename (file), afrodite_data_type_get_type_name (using_directive));
								}
							}
							_afrodite_data_type_unref0 (using_directive);
						}
						_vala_collection_object_unref0 (_using_directive_it);
					}
				}
				_afrodite_source_file_unref0 (file);
			}
			_vala_collection_object_unref0 (_file_it);
		}
	}
	if (vala_collection_get_size ((ValaCollection*) ast->unresolved_symbols) > 0) {
		afrodite_utils_trace ("symbolresolver.vala:62: (symbol resolver): symbols to resolve %d", vala_collection_get_size ((ValaCollection*) ast->unresolved_symbols));
		afrodite_symbol_resolver_visit_symbols (self, ast->unresolved_symbols);
		afrodite_utils_trace ("symbolresolver.vala:64: (symbol resolver): unresolved symbol after res" \
"olve process %d", vala_collection_get_size ((ValaCollection*) ast->unresolved_symbols));
	}
}


static gpointer _afrodite_symbol_ref0 (gpointer self) {
	return self ? afrodite_symbol_ref (self) : NULL;
}


static gpointer _afrodite_source_file_ref0 (gpointer self) {
	return self ? afrodite_source_file_ref (self) : NULL;
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static AfroditeSymbol* afrodite_symbol_resolver_resolve_type (AfroditeSymbolResolver* self, AfroditeSymbol* symbol, AfroditeDataType* type) {
	AfroditeSymbol* result = NULL;
	AfroditeSymbol* res;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	res = NULL;
	if (_vala_strcmp0 (afrodite_data_type_get_type_name (type), "void") == 0) {
		AfroditeSymbol* _tmp0_;
		res = (_tmp0_ = _afrodite_symbol_ref0 ((AfroditeSymbol*) afrodite_symbol_VOID), _afrodite_symbol_unref0 (res), _tmp0_);
	} else {
		if (_vala_strcmp0 (afrodite_data_type_get_type_name (type), "...") == 0) {
			AfroditeSymbol* _tmp1_;
			res = (_tmp1_ = _afrodite_symbol_ref0 ((AfroditeSymbol*) afrodite_symbol_VOID), _afrodite_symbol_unref0 (res), _tmp1_);
		}
	}
	if (res == NULL) {
		AfroditeSymbol* s;
		gboolean _tmp2_ = FALSE;
		s = _afrodite_symbol_ref0 ((AfroditeSymbol*) vala_map_get ((ValaMap*) self->priv->_ast->symbols, afrodite_data_type_get_type_name (type)));
		if (s != NULL) {
			_tmp2_ = s != symbol;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			AfroditeSymbol* _tmp3_;
			res = (_tmp3_ = _afrodite_symbol_ref0 (s), _afrodite_symbol_unref0 (res), _tmp3_);
		} else {
			AfroditeSymbol* curr_symbol;
			gboolean _tmp23_ = FALSE;
			curr_symbol = _afrodite_symbol_ref0 (symbol);
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				AfroditeSymbol* _tmp7_;
				if (curr_symbol != NULL) {
					_tmp4_ = curr_symbol != afrodite_ast_get_root (self->priv->_ast);
				} else {
					_tmp4_ = FALSE;
				}
				if (!_tmp4_) {
					break;
				}
				if (g_str_has_prefix (afrodite_symbol_get_name (curr_symbol), "!") == FALSE) {
					_tmp5_ = afrodite_symbol_get_has_generic_type_arguments (curr_symbol);
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					{
						ValaIterator* _arg_it;
						_arg_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_generic_type_arguments (curr_symbol));
						while (TRUE) {
							AfroditeSymbol* arg;
							if (!vala_iterator_next (_arg_it)) {
								break;
							}
							arg = (AfroditeSymbol*) vala_iterator_get (_arg_it);
							if (_vala_strcmp0 (afrodite_data_type_get_type_name (type), afrodite_symbol_get_fully_qualified_name (arg)) == 0) {
								AfroditeSymbol* _tmp6_;
								res = (_tmp6_ = _afrodite_symbol_ref0 (arg), _afrodite_symbol_unref0 (res), _tmp6_);
								_afrodite_symbol_unref0 (arg);
								break;
							}
							_afrodite_symbol_unref0 (arg);
						}
						_vala_collection_object_unref0 (_arg_it);
					}
				}
				if (res != NULL) {
					break;
				}
				curr_symbol = (_tmp7_ = _afrodite_symbol_ref0 (afrodite_symbol_get_parent (curr_symbol)), _afrodite_symbol_unref0 (curr_symbol), _tmp7_);
			}
			if (res == NULL) {
				AfroditeSymbol* _tmp8_;
				curr_symbol = (_tmp8_ = _afrodite_symbol_ref0 (symbol), _afrodite_symbol_unref0 (curr_symbol), _tmp8_);
				while (TRUE) {
					gboolean _tmp9_ = FALSE;
					AfroditeSymbol* _tmp14_;
					if (curr_symbol != NULL) {
						_tmp9_ = curr_symbol != afrodite_ast_get_root (self->priv->_ast);
					} else {
						_tmp9_ = FALSE;
					}
					if (!_tmp9_) {
						break;
					}
					if (g_str_has_prefix (afrodite_symbol_get_name (curr_symbol), "!") == FALSE) {
						char* _tmp10_;
						AfroditeSymbol* _tmp11_;
						gboolean _tmp12_ = FALSE;
						s = (_tmp11_ = _afrodite_symbol_ref0 ((AfroditeSymbol*) vala_map_get ((ValaMap*) self->priv->_ast->symbols, _tmp10_ = g_strdup_printf ("%s.%s", afrodite_symbol_get_fully_qualified_name (curr_symbol), afrodite_data_type_get_type_name (type)))), _afrodite_symbol_unref0 (s), _tmp11_);
						_g_free0 (_tmp10_);
						if (s != NULL) {
							_tmp12_ = s != symbol;
						} else {
							_tmp12_ = FALSE;
						}
						if (_tmp12_) {
							AfroditeSymbol* _tmp13_;
							res = (_tmp13_ = _afrodite_symbol_ref0 (s), _afrodite_symbol_unref0 (res), _tmp13_);
							break;
						}
					}
					curr_symbol = (_tmp14_ = _afrodite_symbol_ref0 (afrodite_symbol_get_parent (curr_symbol)), _afrodite_symbol_unref0 (curr_symbol), _tmp14_);
				}
			}
			if (res == NULL) {
				gboolean has_glib_using;
				has_glib_using = FALSE;
				{
					ValaIterator* _reference_it;
					_reference_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_source_references (symbol));
					while (TRUE) {
						AfroditeSourceReference* reference;
						AfroditeSourceFile* file;
						if (!vala_iterator_next (_reference_it)) {
							break;
						}
						reference = (AfroditeSourceReference*) vala_iterator_get (_reference_it);
						file = _afrodite_source_file_ref0 (reference->file);
						if (!afrodite_source_file_get_has_using_directives (file)) {
							_afrodite_source_file_unref0 (file);
							_afrodite_source_reference_unref0 (reference);
							continue;
						}
						{
							ValaIterator* _using_directive_it;
							_using_directive_it = vala_iterable_iterator ((ValaIterable*) afrodite_source_file_get_using_directives (file));
							while (TRUE) {
								AfroditeDataType* using_directive;
								char* _tmp15_;
								AfroditeSymbol* _tmp16_;
								gboolean _tmp17_ = FALSE;
								if (!vala_iterator_next (_using_directive_it)) {
									break;
								}
								using_directive = (AfroditeDataType*) vala_iterator_get (_using_directive_it);
								if (afrodite_data_type_get_unresolved (using_directive)) {
									_afrodite_data_type_unref0 (using_directive);
									continue;
								}
								if (_vala_strcmp0 (afrodite_data_type_get_name (using_directive), "GLib") == 0) {
									has_glib_using = TRUE;
								}
								s = (_tmp16_ = _afrodite_symbol_ref0 ((AfroditeSymbol*) vala_map_get ((ValaMap*) self->priv->_ast->symbols, _tmp15_ = g_strdup_printf ("%s.%s", afrodite_data_type_get_type_name (using_directive), afrodite_data_type_get_type_name (type)))), _afrodite_symbol_unref0 (s), _tmp16_);
								_g_free0 (_tmp15_);
								if (s != NULL) {
									_tmp17_ = s != symbol;
								} else {
									_tmp17_ = FALSE;
								}
								if (_tmp17_) {
									AfroditeSymbol* _tmp18_;
									res = (_tmp18_ = _afrodite_symbol_ref0 (s), _afrodite_symbol_unref0 (res), _tmp18_);
									_afrodite_data_type_unref0 (using_directive);
									break;
								}
								_afrodite_data_type_unref0 (using_directive);
							}
							_vala_collection_object_unref0 (_using_directive_it);
						}
						if (res != NULL) {
							_afrodite_source_file_unref0 (file);
							_afrodite_source_reference_unref0 (reference);
							break;
						}
						_afrodite_source_file_unref0 (file);
						_afrodite_source_reference_unref0 (reference);
					}
					_vala_collection_object_unref0 (_reference_it);
				}
				if (res == NULL) {
					if (!has_glib_using) {
						char* _tmp19_;
						AfroditeSymbol* _tmp20_;
						gboolean _tmp21_ = FALSE;
						s = (_tmp20_ = _afrodite_symbol_ref0 ((AfroditeSymbol*) vala_map_get ((ValaMap*) self->priv->_ast->symbols, _tmp19_ = g_strdup_printf ("GLib.%s", afrodite_data_type_get_type_name (type)))), _afrodite_symbol_unref0 (s), _tmp20_);
						_g_free0 (_tmp19_);
						if (s != NULL) {
							_tmp21_ = s != symbol;
						} else {
							_tmp21_ = FALSE;
						}
						if (_tmp21_) {
							AfroditeSymbol* _tmp22_;
							res = (_tmp22_ = _afrodite_symbol_ref0 (s), _afrodite_symbol_unref0 (res), _tmp22_);
						}
					}
				}
			}
			if (res == NULL) {
				_tmp23_ = string_contains (afrodite_data_type_get_type_name (type), ".");
			} else {
				_tmp23_ = FALSE;
			}
			if (_tmp23_) {
				AfroditeSymbol* _tmp24_;
				gboolean _tmp25_ = FALSE;
				s = (_tmp24_ = _afrodite_symbol_ref0 ((AfroditeSymbol*) vala_map_get ((ValaMap*) self->priv->_ast->symbols, afrodite_data_type_get_type_name (type))), _afrodite_symbol_unref0 (s), _tmp24_);
				if (s != NULL) {
					_tmp25_ = s != symbol;
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					AfroditeSymbol* _tmp26_;
					res = (_tmp26_ = _afrodite_symbol_ref0 (s), _afrodite_symbol_unref0 (res), _tmp26_);
				}
			}
			_afrodite_symbol_unref0 (curr_symbol);
		}
		_afrodite_symbol_unref0 (s);
	}
	if (res != NULL) {
		if (afrodite_data_type_get_has_generic_types (type)) {
			gboolean _tmp27_ = FALSE;
			if (afrodite_symbol_get_has_generic_type_arguments (res)) {
				_tmp27_ = vala_collection_get_size ((ValaCollection*) afrodite_data_type_get_generic_types (type)) == vala_collection_get_size ((ValaCollection*) afrodite_symbol_get_generic_type_arguments (res));
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				gboolean need_specialization;
				need_specialization = FALSE;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp28_;
						_tmp28_ = TRUE;
						while (TRUE) {
							AfroditeSymbol* _tmp29_;
							char* _tmp30_;
							char* _tmp31_;
							char* name;
							AfroditeDataType* _tmp34_;
							gboolean _tmp35_;
							if (!_tmp28_) {
								i++;
							}
							_tmp28_ = FALSE;
							if (!(i < vala_collection_get_size ((ValaCollection*) afrodite_data_type_get_generic_types (type)))) {
								break;
							}
							_tmp31_ = (_tmp30_ = g_strdup (afrodite_symbol_get_fully_qualified_name (_tmp29_ = (AfroditeSymbol*) vala_list_get (afrodite_symbol_get_generic_type_arguments (res), i))), _afrodite_symbol_unref0 (_tmp29_), _tmp30_);
							if (_tmp31_ == NULL) {
								AfroditeSymbol* _tmp32_;
								char* _tmp33_;
								_tmp31_ = (_tmp33_ = g_strdup (afrodite_symbol_get_name (_tmp32_ = (AfroditeSymbol*) vala_list_get (afrodite_symbol_get_generic_type_arguments (res), i))), _g_free0 (_tmp31_), _tmp33_);
								_afrodite_symbol_unref0 (_tmp32_);
							}
							name = g_strdup (_tmp31_);
							if ((_tmp35_ = _vala_strcmp0 (afrodite_data_type_get_type_name (_tmp34_ = (AfroditeDataType*) vala_list_get (afrodite_data_type_get_generic_types (type), i)), name) != 0, _afrodite_data_type_unref0 (_tmp34_), _tmp35_)) {
								need_specialization = TRUE;
								_g_free0 (name);
								_g_free0 (_tmp31_);
								break;
							}
							_g_free0 (name);
							_g_free0 (_tmp31_);
						}
					}
				}
				if (need_specialization) {
					AfroditeSymbol* _tmp36_;
					res = (_tmp36_ = afrodite_symbol_resolver_specialize_generic_symbol (self, type, res), _afrodite_symbol_unref0 (res), _tmp36_);
				}
			} else {
				{
					ValaIterator* _generic_type_it;
					_generic_type_it = vala_iterable_iterator ((ValaIterable*) afrodite_data_type_get_generic_types (type));
					while (TRUE) {
						AfroditeDataType* generic_type;
						if (!vala_iterator_next (_generic_type_it)) {
							break;
						}
						generic_type = (AfroditeDataType*) vala_iterator_get (_generic_type_it);
						if (afrodite_data_type_get_unresolved (generic_type)) {
							AfroditeSymbol* _tmp37_;
							afrodite_data_type_set_symbol (generic_type, _tmp37_ = afrodite_symbol_resolver_resolve_type (self, res, generic_type));
							_afrodite_symbol_unref0 (_tmp37_);
						}
						_afrodite_data_type_unref0 (generic_type);
					}
					_vala_collection_object_unref0 (_generic_type_it);
				}
			}
		}
		if (res != AFRODITE_SYMBOL (afrodite_symbol_VOID)) {
			afrodite_symbol_add_resolved_target (res, symbol);
		}
	}
	result = res;
	return result;
}


static AfroditeSymbol* afrodite_symbol_resolver_specialize_generic_symbol (AfroditeSymbolResolver* self, AfroditeDataType* type, AfroditeSymbol* symbol) {
	AfroditeSymbol* result = NULL;
	AfroditeSymbol* c;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	c = afrodite_symbol_copy (symbol);
	afrodite_symbol_resolver_visit_symbol (self, c);
	afrodite_symbol_specialize_generic_symbol (c, afrodite_data_type_get_generic_types (type));
	afrodite_symbol_resolver_visit_symbol (self, c);
	if (afrodite_symbol_get_has_base_types (c)) {
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_base_types (c));
			while (TRUE) {
				AfroditeDataType* item;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (AfroditeDataType*) vala_iterator_get (_item_it);
				if (!afrodite_data_type_get_unresolved (item)) {
					if (afrodite_symbol_get_has_generic_type_arguments (afrodite_data_type_get_symbol (item))) {
						AfroditeSymbol* _tmp0_;
						if (afrodite_data_type_get_symbol (item) == symbol) {
							g_critical ("symbolresolver.vala:274: Skipping same instance reference cycle: %s %s", afrodite_symbol_get_description (symbol), afrodite_data_type_get_type_name (item));
							_afrodite_data_type_unref0 (item);
							continue;
						}
						if (_vala_strcmp0 (afrodite_symbol_get_fully_qualified_name (afrodite_data_type_get_symbol (item)), afrodite_symbol_get_fully_qualified_name (symbol)) == 0) {
							g_critical ("symbolresolver.vala:278: Skipping same name reference cycle: %s", afrodite_symbol_get_description (afrodite_data_type_get_symbol (item)));
							_afrodite_data_type_unref0 (item);
							continue;
						}
						afrodite_data_type_set_symbol (item, _tmp0_ = afrodite_symbol_resolver_specialize_generic_symbol (self, type, afrodite_data_type_get_symbol (item)));
						_afrodite_symbol_unref0 (_tmp0_);
					}
				}
				_afrodite_data_type_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
	}
	afrodite_symbol_add_specialized_symbol (symbol, c);
	result = c;
	return result;
}


static gpointer _afrodite_data_type_ref0 (gpointer self) {
	return self ? afrodite_data_type_ref (self) : NULL;
}


static void afrodite_symbol_resolver_resolve_symbol (AfroditeSymbolResolver* self, AfroditeSymbol* symbol, AfroditeDataType* type) {
	AfroditeSymbol* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (type != NULL);
	afrodite_data_type_set_symbol (type, _tmp0_ = afrodite_symbol_resolver_resolve_type (self, symbol, type));
	_afrodite_symbol_unref0 (_tmp0_);
	if (!afrodite_data_type_get_unresolved (type)) {
		if (afrodite_symbol_get_return_type (afrodite_data_type_get_symbol (type)) != NULL) {
			AfroditeDataType* dt;
			dt = _afrodite_data_type_ref0 (afrodite_symbol_get_return_type (afrodite_data_type_get_symbol (type)));
			afrodite_data_type_set_type_name (type, afrodite_data_type_get_type_name (dt));
			if (afrodite_data_type_get_is_iterator (type)) {
				gboolean _tmp1_ = FALSE;
				if (afrodite_data_type_get_has_generic_types (dt)) {
					_tmp1_ = vala_collection_get_size ((ValaCollection*) afrodite_data_type_get_generic_types (dt)) == 1;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					AfroditeDataType* _tmp2_;
					AfroditeDataType* _tmp3_;
					afrodite_data_type_set_type_name (type, afrodite_data_type_get_type_name (_tmp2_ = (AfroditeDataType*) vala_list_get (afrodite_data_type_get_generic_types (dt), 0)));
					_afrodite_data_type_unref0 (_tmp2_);
					afrodite_data_type_set_symbol (type, afrodite_data_type_get_symbol (_tmp3_ = (AfroditeDataType*) vala_list_get (afrodite_data_type_get_generic_types (dt), 0)));
					_afrodite_data_type_unref0 (_tmp3_);
				}
			}
			_afrodite_data_type_unref0 (dt);
		}
	}
}


static gboolean afrodite_symbol_resolver_visit_symbol (AfroditeSymbolResolver* self, AfroditeSymbol* symbol) {
	gboolean result = FALSE;
	gboolean resolved;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (symbol != NULL, FALSE);
	resolved = TRUE;
	if (afrodite_symbol_get_has_base_types (symbol)) {
		{
			ValaIterator* _type_it;
			_type_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_base_types (symbol));
			while (TRUE) {
				AfroditeDataType* type;
				if (!vala_iterator_next (_type_it)) {
					break;
				}
				type = (AfroditeDataType*) vala_iterator_get (_type_it);
				if (afrodite_data_type_get_unresolved (type)) {
					AfroditeSymbol* _tmp0_;
					afrodite_data_type_set_symbol (type, _tmp0_ = afrodite_symbol_resolver_resolve_type (self, symbol, type));
					_afrodite_symbol_unref0 (_tmp0_);
					resolved = resolved & (!afrodite_data_type_get_unresolved (type));
				}
				_afrodite_data_type_unref0 (type);
			}
			_vala_collection_object_unref0 (_type_it);
		}
	}
	if (afrodite_symbol_get_return_type (symbol) != NULL) {
		if (afrodite_data_type_get_unresolved (afrodite_symbol_get_return_type (symbol))) {
			AfroditeSymbol* _tmp1_;
			afrodite_data_type_set_symbol (afrodite_symbol_get_return_type (symbol), _tmp1_ = afrodite_symbol_resolver_resolve_type (self, symbol, afrodite_symbol_get_return_type (symbol)));
			_afrodite_symbol_unref0 (_tmp1_);
			resolved = resolved & (!afrodite_data_type_get_unresolved (afrodite_symbol_get_return_type (symbol)));
		}
	}
	if (afrodite_symbol_get_has_parameters (symbol)) {
		{
			ValaIterator* _type_it;
			_type_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_parameters (symbol));
			while (TRUE) {
				AfroditeDataType* type;
				if (!vala_iterator_next (_type_it)) {
					break;
				}
				type = (AfroditeDataType*) vala_iterator_get (_type_it);
				if (afrodite_data_type_get_unresolved (type)) {
					AfroditeSymbol* _tmp2_;
					afrodite_data_type_set_symbol (type, _tmp2_ = afrodite_symbol_resolver_resolve_type (self, symbol, type));
					_afrodite_symbol_unref0 (_tmp2_);
					resolved = resolved & (!afrodite_data_type_get_unresolved (type));
				}
				_afrodite_data_type_unref0 (type);
			}
			_vala_collection_object_unref0 (_type_it);
		}
	}
	if (afrodite_symbol_get_has_local_variables (symbol)) {
		{
			ValaIterator* _type_it;
			_type_it = vala_iterable_iterator ((ValaIterable*) afrodite_symbol_get_local_variables (symbol));
			while (TRUE) {
				AfroditeDataType* type;
				if (!vala_iterator_next (_type_it)) {
					break;
				}
				type = (AfroditeDataType*) vala_iterator_get (_type_it);
				if (afrodite_data_type_get_unresolved (type)) {
					afrodite_symbol_resolver_resolve_symbol (self, symbol, type);
					resolved = resolved & (!afrodite_data_type_get_unresolved (type));
				}
				_afrodite_data_type_unref0 (type);
			}
			_vala_collection_object_unref0 (_type_it);
		}
	}
	result = resolved;
	return result;
}


static void afrodite_symbol_resolver_visit_symbols (AfroditeSymbolResolver* self, ValaList* symbols) {
	ValaList* resolved;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbols != NULL);
	resolved = (ValaList*) vala_array_list_new (AFRODITE_TYPE_SYMBOL, NULL, NULL, g_direct_equal);
	{
		ValaIterator* _symbol_it;
		_symbol_it = vala_iterable_iterator ((ValaIterable*) symbols);
		while (TRUE) {
			AfroditeSymbol* symbol;
			if (!vala_iterator_next (_symbol_it)) {
				break;
			}
			symbol = _afrodite_symbol_ref0 ((AfroditeSymbol*) vala_iterator_get (_symbol_it));
			if (afrodite_symbol_resolver_visit_symbol (self, symbol)) {
				vala_collection_add ((ValaCollection*) resolved, symbol);
			}
			_afrodite_symbol_unref0 (symbol);
		}
		_vala_collection_object_unref0 (_symbol_it);
	}
	{
		ValaIterator* _symbol_it;
		_symbol_it = vala_iterable_iterator ((ValaIterable*) resolved);
		while (TRUE) {
			AfroditeSymbol* symbol;
			if (!vala_iterator_next (_symbol_it)) {
				break;
			}
			symbol = _afrodite_symbol_ref0 ((AfroditeSymbol*) vala_iterator_get (_symbol_it));
			vala_collection_remove ((ValaCollection*) symbols, symbol);
			_afrodite_symbol_unref0 (symbol);
		}
		_vala_collection_object_unref0 (_symbol_it);
	}
	_vala_collection_object_unref0 (resolved);
}


AfroditeSymbolResolver* afrodite_symbol_resolver_construct (GType object_type) {
	AfroditeSymbolResolver* self;
	self = (AfroditeSymbolResolver*) g_type_create_instance (object_type);
	return self;
}


AfroditeSymbolResolver* afrodite_symbol_resolver_new (void) {
	return afrodite_symbol_resolver_construct (AFRODITE_TYPE_SYMBOL_RESOLVER);
}


static void afrodite_value_symbol_resolver_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void afrodite_value_symbol_resolver_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		afrodite_symbol_resolver_unref (value->data[0].v_pointer);
	}
}


static void afrodite_value_symbol_resolver_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = afrodite_symbol_resolver_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer afrodite_value_symbol_resolver_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* afrodite_value_symbol_resolver_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AfroditeSymbolResolver* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = afrodite_symbol_resolver_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* afrodite_value_symbol_resolver_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AfroditeSymbolResolver** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = afrodite_symbol_resolver_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* afrodite_param_spec_symbol_resolver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	AfroditeParamSpecSymbolResolver* spec;
	g_return_val_if_fail (g_type_is_a (object_type, AFRODITE_TYPE_SYMBOL_RESOLVER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer afrodite_value_get_symbol_resolver (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_TYPE_SYMBOL_RESOLVER), NULL);
	return value->data[0].v_pointer;
}


void afrodite_value_set_symbol_resolver (GValue* value, gpointer v_object) {
	AfroditeSymbolResolver* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_TYPE_SYMBOL_RESOLVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, AFRODITE_TYPE_SYMBOL_RESOLVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		afrodite_symbol_resolver_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		afrodite_symbol_resolver_unref (old);
	}
}


void afrodite_value_take_symbol_resolver (GValue* value, gpointer v_object) {
	AfroditeSymbolResolver* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, AFRODITE_TYPE_SYMBOL_RESOLVER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, AFRODITE_TYPE_SYMBOL_RESOLVER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		afrodite_symbol_resolver_unref (old);
	}
}


static void afrodite_symbol_resolver_class_init (AfroditeSymbolResolverClass * klass) {
	afrodite_symbol_resolver_parent_class = g_type_class_peek_parent (klass);
	AFRODITE_SYMBOL_RESOLVER_CLASS (klass)->finalize = afrodite_symbol_resolver_finalize;
	g_type_class_add_private (klass, sizeof (AfroditeSymbolResolverPrivate));
}


static void afrodite_symbol_resolver_instance_init (AfroditeSymbolResolver * self) {
	self->priv = AFRODITE_SYMBOL_RESOLVER_GET_PRIVATE (self);
	self->priv->_ast = NULL;
	self->priv->_vala_symbol_fqn = NULL;
	self->ref_count = 1;
}


static void afrodite_symbol_resolver_finalize (AfroditeSymbolResolver* obj) {
	AfroditeSymbolResolver * self;
	self = AFRODITE_SYMBOL_RESOLVER (obj);
	_afrodite_ast_unref0 (self->priv->_ast);
	_g_free0 (self->priv->_vala_symbol_fqn);
}


GType afrodite_symbol_resolver_get_type (void) {
	static volatile gsize afrodite_symbol_resolver_type_id__volatile = 0;
	if (g_once_init_enter (&afrodite_symbol_resolver_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { afrodite_value_symbol_resolver_init, afrodite_value_symbol_resolver_free_value, afrodite_value_symbol_resolver_copy_value, afrodite_value_symbol_resolver_peek_pointer, "p", afrodite_value_symbol_resolver_collect_value, "p", afrodite_value_symbol_resolver_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AfroditeSymbolResolverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) afrodite_symbol_resolver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AfroditeSymbolResolver), 0, (GInstanceInitFunc) afrodite_symbol_resolver_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType afrodite_symbol_resolver_type_id;
		afrodite_symbol_resolver_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AfroditeSymbolResolver", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&afrodite_symbol_resolver_type_id__volatile, afrodite_symbol_resolver_type_id);
	}
	return afrodite_symbol_resolver_type_id__volatile;
}


gpointer afrodite_symbol_resolver_ref (gpointer instance) {
	AfroditeSymbolResolver* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void afrodite_symbol_resolver_unref (gpointer instance) {
	AfroditeSymbolResolver* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		AFRODITE_SYMBOL_RESOLVER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




