/* completionengine.c generated by valac 0.10.0, the Vala compiler
 * generated from completionengine.vala, do not modify */

/* sourcereference.vala
 *
 * Copyright (C) 2009  Andrea Del Signore
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Andrea Del Signore <sejerpz@tin.it>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <vala.h>
#include <gio/gio.h>


#define AFRODITE_TYPE_COMPLETION_ENGINE (afrodite_completion_engine_get_type ())
#define AFRODITE_COMPLETION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_COMPLETION_ENGINE, AfroditeCompletionEngine))
#define AFRODITE_COMPLETION_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_COMPLETION_ENGINE, AfroditeCompletionEngineClass))
#define AFRODITE_IS_COMPLETION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_COMPLETION_ENGINE))
#define AFRODITE_IS_COMPLETION_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_COMPLETION_ENGINE))
#define AFRODITE_COMPLETION_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_COMPLETION_ENGINE, AfroditeCompletionEngineClass))

typedef struct _AfroditeCompletionEngine AfroditeCompletionEngine;
typedef struct _AfroditeCompletionEngineClass AfroditeCompletionEngineClass;
typedef struct _AfroditeCompletionEnginePrivate AfroditeCompletionEnginePrivate;

#define AFRODITE_TYPE_SOURCE_ITEM (afrodite_source_item_get_type ())
#define AFRODITE_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_ITEM, AfroditeSourceItem))
#define AFRODITE_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_ITEM, AfroditeSourceItemClass))
#define AFRODITE_IS_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_ITEM))
#define AFRODITE_IS_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_ITEM))
#define AFRODITE_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_ITEM, AfroditeSourceItemClass))

typedef struct _AfroditeSourceItem AfroditeSourceItem;
typedef struct _AfroditeSourceItemClass AfroditeSourceItemClass;

#define AFRODITE_TYPE_AST (afrodite_ast_get_type ())
#define AFRODITE_AST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_AST, AfroditeAst))
#define AFRODITE_AST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_AST, AfroditeAstClass))
#define AFRODITE_IS_AST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_AST))
#define AFRODITE_IS_AST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_AST))
#define AFRODITE_AST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_AST, AfroditeAstClass))

typedef struct _AfroditeAst AfroditeAst;
typedef struct _AfroditeAstClass AfroditeAstClass;

#define AFRODITE_TYPE_PARSE_RESULT (afrodite_parse_result_get_type ())
#define AFRODITE_PARSE_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_PARSE_RESULT, AfroditeParseResult))
#define AFRODITE_PARSE_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_PARSE_RESULT, AfroditeParseResultClass))
#define AFRODITE_IS_PARSE_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_PARSE_RESULT))
#define AFRODITE_IS_PARSE_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_PARSE_RESULT))
#define AFRODITE_PARSE_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_PARSE_RESULT, AfroditeParseResultClass))

typedef struct _AfroditeParseResult AfroditeParseResult;
typedef struct _AfroditeParseResultClass AfroditeParseResultClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_mutex_free0(var) ((var == NULL) ? NULL : (var = (g_mutex_free (var), NULL)))
#define _afrodite_ast_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_ast_unref (var), NULL)))
#define _afrodite_source_item_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_item_unref (var), NULL)))
typedef struct _AfroditeSourceItemPrivate AfroditeSourceItemPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define AFRODITE_TYPE_SOURCE_FILE (afrodite_source_file_get_type ())
#define AFRODITE_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFile))
#define AFRODITE_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))
#define AFRODITE_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SOURCE_FILE))
#define AFRODITE_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SOURCE_FILE, AfroditeSourceFileClass))

typedef struct _AfroditeSourceFile AfroditeSourceFile;
typedef struct _AfroditeSourceFileClass AfroditeSourceFileClass;
#define _afrodite_source_file_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define AFRODITE_TYPE_PARSER (afrodite_parser_get_type ())
#define AFRODITE_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_PARSER, AfroditeParser))
#define AFRODITE_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_PARSER, AfroditeParserClass))
#define AFRODITE_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_PARSER))
#define AFRODITE_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_PARSER))
#define AFRODITE_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_PARSER, AfroditeParserClass))

typedef struct _AfroditeParser AfroditeParser;
typedef struct _AfroditeParserClass AfroditeParserClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _AfroditeParseResultPrivate AfroditeParseResultPrivate;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
typedef struct _AfroditeCompletionEngineMergeAndResolveData AfroditeCompletionEngineMergeAndResolveData;
typedef struct _AfroditeCompletionEnginePerformMergeAndResolveData AfroditeCompletionEnginePerformMergeAndResolveData;

#define AFRODITE_TYPE_AST_MERGER (afrodite_ast_merger_get_type ())
#define AFRODITE_AST_MERGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_AST_MERGER, AfroditeAstMerger))
#define AFRODITE_AST_MERGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_AST_MERGER, AfroditeAstMergerClass))
#define AFRODITE_IS_AST_MERGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_AST_MERGER))
#define AFRODITE_IS_AST_MERGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_AST_MERGER))
#define AFRODITE_AST_MERGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_AST_MERGER, AfroditeAstMergerClass))

typedef struct _AfroditeAstMerger AfroditeAstMerger;
typedef struct _AfroditeAstMergerClass AfroditeAstMergerClass;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
typedef struct _AfroditeCompletionEngineMergeValaSourceData AfroditeCompletionEngineMergeValaSourceData;

#define AFRODITE_TYPE_SYMBOL_RESOLVER (afrodite_symbol_resolver_get_type ())
#define AFRODITE_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AFRODITE_TYPE_SYMBOL_RESOLVER, AfroditeSymbolResolver))
#define AFRODITE_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AFRODITE_TYPE_SYMBOL_RESOLVER, AfroditeSymbolResolverClass))
#define AFRODITE_IS_SYMBOL_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AFRODITE_TYPE_SYMBOL_RESOLVER))
#define AFRODITE_IS_SYMBOL_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AFRODITE_TYPE_SYMBOL_RESOLVER))
#define AFRODITE_SYMBOL_RESOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AFRODITE_TYPE_SYMBOL_RESOLVER, AfroditeSymbolResolverClass))

typedef struct _AfroditeSymbolResolver AfroditeSymbolResolver;
typedef struct _AfroditeSymbolResolverClass AfroditeSymbolResolverClass;
#define _afrodite_symbol_resolver_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_symbol_resolver_unref (var), NULL)))
typedef struct _AfroditeCompletionEngineResolveAstData AfroditeCompletionEngineResolveAstData;

struct _AfroditeCompletionEngine {
	GObject parent_instance;
	AfroditeCompletionEnginePrivate * priv;
	char* id;
};

struct _AfroditeCompletionEngineClass {
	GObjectClass parent_class;
};

struct _AfroditeCompletionEnginePrivate {
	ValaList* _vapidirs;
	ValaList* _source_queue;
	ValaList* _merge_queue;
	GMutex* _source_queue_mutex;
	GMutex* _merge_queue_mutex;
	GThread* _parser_thread;
	gint _parser_stamp;
	gint _parser_remaining_files;
	gint _current_parsing_total_file_count;
	gboolean _glib_init;
	gboolean _is_parsing;
	AfroditeAst* _ast;
	ValaList* _parse_result_list;
	GStaticRecMutex __lock__parse_result_list;
	guint _idle_id;
};

struct _AfroditeSourceItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AfroditeSourceItemPrivate * priv;
	char* path;
	char* content;
	gboolean is_glib;
	ValaCodeContext* context;
};

struct _AfroditeSourceItemClass {
	GTypeClass parent_class;
	void (*finalize) (AfroditeSourceItem *self);
};

struct _AfroditeParseResult {
	ValaReport parent_instance;
	AfroditeParseResultPrivate * priv;
	ValaList* warnings;
	ValaList* errors;
	ValaList* notes;
	char* source_path;
	gboolean is_glib;
	ValaCodeContext* context;
	gboolean is_edited;
};

struct _AfroditeParseResultClass {
	ValaReportClass parent_class;
};

struct _AfroditeCompletionEngineMergeAndResolveData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AfroditeCompletionEngine* self;
	AfroditeParseResult* _result_;
	AfroditeParseResult* result;
	ValaIterator* _s_it;
	ValaList* _tmp0_;
	ValaIterator* _tmp1_;
	ValaSourceFile* s;
	AfroditeSourceFile* ast_source;
	gboolean source_exists;
	gboolean need_update;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	AfroditeSourceFile* _tmp5_;
};

struct _AfroditeCompletionEnginePerformMergeAndResolveData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AfroditeCompletionEngine* self;
	ValaSourceFile* s;
	AfroditeParseResult* _result_;
	gboolean source_exists;
};

struct _AfroditeCompletionEngineMergeValaSourceData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AfroditeCompletionEngine* self;
	ValaSourceFile* s;
	AfroditeParseResult* _result_;
	gboolean source_exists;
	AfroditeAstMerger* merger;
	ValaCodeContext* _tmp0_;
	AfroditeAstMerger* _tmp1_;
};

struct _AfroditeCompletionEngineResolveAstData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AfroditeCompletionEngine* self;
	AfroditeSymbolResolver* resolver;
};


static gpointer afrodite_completion_engine_parent_class = NULL;

GType afrodite_completion_engine_get_type (void) G_GNUC_CONST;
gpointer afrodite_source_item_ref (gpointer instance);
void afrodite_source_item_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_item (GValue* value, gpointer v_object);
void afrodite_value_take_source_item (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_item (const GValue* value);
GType afrodite_source_item_get_type (void) G_GNUC_CONST;
gpointer afrodite_ast_ref (gpointer instance);
void afrodite_ast_unref (gpointer instance);
GParamSpec* afrodite_param_spec_ast (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_ast (GValue* value, gpointer v_object);
void afrodite_value_take_ast (GValue* value, gpointer v_object);
gpointer afrodite_value_get_ast (const GValue* value);
GType afrodite_ast_get_type (void) G_GNUC_CONST;
GType afrodite_parse_result_get_type (void) G_GNUC_CONST;
#define AFRODITE_COMPLETION_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AFRODITE_TYPE_COMPLETION_ENGINE, AfroditeCompletionEnginePrivate))
enum  {
	AFRODITE_COMPLETION_ENGINE_DUMMY_PROPERTY,
	AFRODITE_COMPLETION_ENGINE_IS_PARSING,
	AFRODITE_COMPLETION_ENGINE_AST
};
AfroditeCompletionEngine* afrodite_completion_engine_new (const char* id);
AfroditeCompletionEngine* afrodite_completion_engine_construct (GType object_type, const char* id);
AfroditeAst* afrodite_ast_new (void);
AfroditeAst* afrodite_ast_construct (GType object_type);
void afrodite_completion_engine_add_vapi_dir (AfroditeCompletionEngine* self, const char* path);
void afrodite_completion_engine_remove_vapi_dir (AfroditeCompletionEngine* self, const char* path);
void afrodite_completion_engine_queue_source (AfroditeCompletionEngine* self, AfroditeSourceItem* item);
AfroditeSourceItem* afrodite_source_item_copy (AfroditeSourceItem* self);
gboolean afrodite_completion_engine_queue_sources (AfroditeCompletionEngine* self, ValaList* sources, gboolean no_update_check);
static AfroditeSourceItem* afrodite_completion_engine_source_queue_contains (AfroditeCompletionEngine* self, AfroditeSourceItem* value);
ValaList* afrodite_utils_get_package_paths (const char* pkg, ValaCodeContext* context, char** vapi_dirs, int vapi_dirs_length1);
AfroditeSourceItem* afrodite_source_item_new (void);
AfroditeSourceItem* afrodite_source_item_construct (GType object_type);
gpointer afrodite_source_file_ref (gpointer instance);
void afrodite_source_file_unref (gpointer instance);
GParamSpec* afrodite_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_source_file (GValue* value, gpointer v_object);
void afrodite_value_take_source_file (GValue* value, gpointer v_object);
gpointer afrodite_value_get_source_file (const GValue* value);
GType afrodite_source_file_get_type (void) G_GNUC_CONST;
AfroditeSourceFile* afrodite_ast_lookup_source_file (AfroditeAst* self, const char* filename);
gboolean afrodite_source_file_update_last_modification_time (AfroditeSourceFile* self);
void afrodite_utils_trace (const char* format, ...);
static void afrodite_completion_engine_create_parser_thread (AfroditeCompletionEngine* self);
void afrodite_completion_engine_queue_sourcefile (AfroditeCompletionEngine* self, const char* path, const char* content, gboolean is_vapi, gboolean is_glib);
void afrodite_completion_engine_queue_sourcefiles (AfroditeCompletionEngine* self, ValaList* paths, const char* content, gboolean is_vapi, gboolean is_glib);
static void* afrodite_completion_engine_parse_sources (AfroditeCompletionEngine* self);
static void* _afrodite_completion_engine_parse_sources_gthread_func (gpointer self);
AfroditeParser* afrodite_parser_new_with_source (AfroditeSourceItem* source_item);
AfroditeParser* afrodite_parser_construct_with_source (GType object_type, AfroditeSourceItem* source_item);
GType afrodite_parser_get_type (void) G_GNUC_CONST;
AfroditeParseResult* afrodite_parser_parse (AfroditeParser* self);
static gboolean afrodite_completion_engine_on_parse_results (AfroditeCompletionEngine* self);
static gboolean _afrodite_completion_engine_on_parse_results_gsource_func (gpointer self);
static void afrodite_completion_engine_on_begin_parsing (AfroditeCompletionEngine* self);
static void afrodite_completion_engine_on_end_parsing (AfroditeCompletionEngine* self);
static void afrodite_completion_engine_merge_and_resolve (AfroditeCompletionEngine* self, AfroditeParseResult* _result_, GAsyncReadyCallback _callback_, gpointer _user_data_);
static AfroditeParseResult* afrodite_completion_engine_merge_and_resolve_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_);
static void afrodite_completion_engine_on_merge_and_resolve_ended (AfroditeCompletionEngine* self, GObject* source, GAsyncResult* r);
static void _afrodite_completion_engine_on_merge_and_resolve_ended_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void afrodite_completion_engine_merge_and_resolve_data_free (gpointer _data);
static void afrodite_completion_engine_merge_and_resolve_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean afrodite_completion_engine_merge_and_resolve_co (AfroditeCompletionEngineMergeAndResolveData* data);
static void afrodite_completion_engine_perform_merge_and_resolve (AfroditeCompletionEngine* self, ValaSourceFile* s, AfroditeParseResult* _result_, gboolean source_exists, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void afrodite_completion_engine_perform_merge_and_resolve_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_);
static void afrodite_completion_engine_perform_merge_and_resolve_data_free (gpointer _data);
static void afrodite_completion_engine_perform_merge_and_resolve_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean afrodite_completion_engine_perform_merge_and_resolve_co (AfroditeCompletionEnginePerformMergeAndResolveData* data);
static void afrodite_completion_engine_merge_vala_source (AfroditeCompletionEngine* self, ValaSourceFile* s, AfroditeParseResult* _result_, gboolean source_exists, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void afrodite_completion_engine_merge_vala_source_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_);
static void afrodite_completion_engine_resolve_ast (AfroditeCompletionEngine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void afrodite_completion_engine_resolve_ast_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_);
static void afrodite_completion_engine_merge_vala_source_data_free (gpointer _data);
static void afrodite_completion_engine_merge_vala_source_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean afrodite_completion_engine_merge_vala_source_co (AfroditeCompletionEngineMergeValaSourceData* data);
AfroditeAstMerger* afrodite_ast_merger_new (AfroditeAst* ast);
AfroditeAstMerger* afrodite_ast_merger_construct (GType object_type, AfroditeAst* ast);
GType afrodite_ast_merger_get_type (void) G_GNUC_CONST;
void afrodite_ast_merger_remove_source_filename (AfroditeAstMerger* self, const char* filename, GAsyncReadyCallback _callback_, gpointer _user_data_);
void afrodite_ast_merger_remove_source_filename_finish (AfroditeAstMerger* self, GAsyncResult* _res_);
void afrodite_ast_merger_merge_vala_context (AfroditeAstMerger* self, ValaSourceFile* source, ValaCodeContext* context, gboolean merge_glib, GAsyncReadyCallback _callback_, gpointer _user_data_);
void afrodite_ast_merger_merge_vala_context_finish (AfroditeAstMerger* self, GAsyncResult* _res_);
static void afrodite_completion_engine_resolve_ast_data_free (gpointer _data);
static void afrodite_completion_engine_resolve_ast_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean afrodite_completion_engine_resolve_ast_co (AfroditeCompletionEngineResolveAstData* data);
AfroditeSymbolResolver* afrodite_symbol_resolver_new (void);
AfroditeSymbolResolver* afrodite_symbol_resolver_construct (GType object_type);
gpointer afrodite_symbol_resolver_ref (gpointer instance);
void afrodite_symbol_resolver_unref (gpointer instance);
GParamSpec* afrodite_param_spec_symbol_resolver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void afrodite_value_set_symbol_resolver (GValue* value, gpointer v_object);
void afrodite_value_take_symbol_resolver (GValue* value, gpointer v_object);
gpointer afrodite_value_get_symbol_resolver (const GValue* value);
GType afrodite_symbol_resolver_get_type (void) G_GNUC_CONST;
void afrodite_symbol_resolver_resolve (AfroditeSymbolResolver* self, AfroditeAst* ast);
gboolean afrodite_completion_engine_get_is_parsing (AfroditeCompletionEngine* self);
AfroditeAst* afrodite_completion_engine_get_ast (AfroditeCompletionEngine* self);
static void afrodite_completion_engine_finalize (GObject* obj);
static void afrodite_completion_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__OBJECT_STRING_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

AfroditeCompletionEngine* afrodite_completion_engine_construct (GType object_type, const char* id) {
	AfroditeCompletionEngine * self;
	char* _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	GMutex* _tmp4_;
	GMutex* _tmp5_;
	AfroditeAst* _tmp6_;
	self = (AfroditeCompletionEngine*) g_object_new (object_type, NULL);
	if (id == NULL) {
		id = "";
	}
	self->id = (_tmp0_ = g_strdup (id), _g_free0 (self->id), _tmp0_);
	self->priv->_vapidirs = (_tmp1_ = (ValaList*) vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal), _vala_collection_object_unref0 (self->priv->_vapidirs), _tmp1_);
	self->priv->_source_queue = (_tmp2_ = (ValaList*) vala_array_list_new (AFRODITE_TYPE_SOURCE_ITEM, (GBoxedCopyFunc) afrodite_source_item_ref, afrodite_source_item_unref, g_direct_equal), _vala_collection_object_unref0 (self->priv->_source_queue), _tmp2_);
	self->priv->_merge_queue = (_tmp3_ = (ValaList*) vala_array_list_new (AFRODITE_TYPE_SOURCE_ITEM, (GBoxedCopyFunc) afrodite_source_item_ref, afrodite_source_item_unref, g_direct_equal), _vala_collection_object_unref0 (self->priv->_merge_queue), _tmp3_);
	self->priv->_source_queue_mutex = (_tmp4_ = g_mutex_new (), _g_mutex_free0 (self->priv->_source_queue_mutex), _tmp4_);
	self->priv->_merge_queue_mutex = (_tmp5_ = g_mutex_new (), _g_mutex_free0 (self->priv->_merge_queue_mutex), _tmp5_);
	self->priv->_ast = (_tmp6_ = afrodite_ast_new (), _afrodite_ast_unref0 (self->priv->_ast), _tmp6_);
	return self;
}


AfroditeCompletionEngine* afrodite_completion_engine_new (const char* id) {
	return afrodite_completion_engine_construct (AFRODITE_TYPE_COMPLETION_ENGINE, id);
}


void afrodite_completion_engine_add_vapi_dir (AfroditeCompletionEngine* self, const char* path) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	vala_collection_add ((ValaCollection*) self->priv->_vapidirs, path);
}


void afrodite_completion_engine_remove_vapi_dir (AfroditeCompletionEngine* self, const char* path) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	if (!vala_collection_remove ((ValaCollection*) self->priv->_vapidirs, path)) {
		g_warning ("completionengine.vala:100: remove_vapi_dir: vapidir %s not found", path);
	}
}


void afrodite_completion_engine_queue_source (AfroditeCompletionEngine* self, AfroditeSourceItem* item) {
	ValaArrayList* sources;
	AfroditeSourceItem* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	sources = vala_array_list_new (AFRODITE_TYPE_SOURCE_ITEM, (GBoxedCopyFunc) afrodite_source_item_ref, afrodite_source_item_unref, g_direct_equal);
	vala_collection_add ((ValaCollection*) sources, _tmp0_ = afrodite_source_item_copy (item));
	_afrodite_source_item_unref0 (_tmp0_);
	afrodite_completion_engine_queue_sources (self, (ValaList*) sources, FALSE);
	_vala_collection_object_unref0 (sources);
}


static AfroditeSourceItem* afrodite_completion_engine_source_queue_contains (AfroditeCompletionEngine* self, AfroditeSourceItem* value) {
	AfroditeSourceItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	{
		ValaIterator* _source_it;
		_source_it = vala_iterable_iterator ((ValaIterable*) self->priv->_source_queue);
		while (TRUE) {
			AfroditeSourceItem* source;
			if (!vala_iterator_next (_source_it)) {
				break;
			}
			source = (AfroditeSourceItem*) vala_iterator_get (_source_it);
			if (_vala_strcmp0 (source->path, value->path) == 0) {
				result = source;
				_vala_collection_object_unref0 (_source_it);
				return result;
			}
			_afrodite_source_item_unref0 (source);
		}
		_vala_collection_object_unref0 (_source_it);
	}
	result = NULL;
	return result;
}


gboolean afrodite_completion_engine_queue_sources (AfroditeCompletionEngine* self, ValaList* sources, gboolean no_update_check) {
	gboolean result = FALSE;
	gboolean _result_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sources != NULL, FALSE);
	_result_ = FALSE;
	g_mutex_lock (self->priv->_source_queue_mutex);
	if (!self->priv->_glib_init) {
		gint packages_length1;
		gint _packages_size_;
		char** _tmp1_;
		char** _tmp0_ = NULL;
		char** packages;
		ValaCodeContext* context;
		self->priv->_glib_init = TRUE;
		packages = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("glib-2.0"), _tmp0_[1] = g_strdup ("gobject-2.0"), _tmp0_), packages_length1 = 2, _packages_size_ = packages_length1, _tmp1_);
		context = vala_code_context_new ();
		{
			char** package_collection;
			int package_collection_length1;
			int package_it;
			package_collection = packages;
			package_collection_length1 = packages_length1;
			for (package_it = 0; package_it < packages_length1; package_it = package_it + 1) {
				char* package;
				package = g_strdup (package_collection[package_it]);
				{
					ValaList* paths;
					paths = afrodite_utils_get_package_paths (package, context, NULL, 0);
					if (paths != NULL) {
						{
							ValaIterator* _path_it;
							_path_it = vala_iterable_iterator ((ValaIterable*) paths);
							while (TRUE) {
								char* path;
								AfroditeSourceItem* item;
								char* _tmp2_;
								char* _tmp3_;
								if (!vala_iterator_next (_path_it)) {
									break;
								}
								path = (char*) vala_iterator_get (_path_it);
								item = afrodite_source_item_new ();
								item->path = (_tmp2_ = g_strdup (path), _g_free0 (item->path), _tmp2_);
								item->content = (_tmp3_ = NULL, _g_free0 (item->content), _tmp3_);
								item->is_glib = TRUE;
								vala_list_insert (sources, 0, item);
								_afrodite_source_item_unref0 (item);
								_g_free0 (path);
							}
							_vala_collection_object_unref0 (_path_it);
						}
					}
					_vala_collection_object_unref0 (paths);
					_g_free0 (package);
				}
			}
		}
		_vala_code_context_unref0 (context);
		packages = (_vala_array_free (packages, packages_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		ValaIterator* _source_it;
		_source_it = vala_iterable_iterator ((ValaIterable*) sources);
		while (TRUE) {
			AfroditeSourceItem* source;
			gboolean skip_unchanged_file;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			if (!vala_iterator_next (_source_it)) {
				break;
			}
			source = (AfroditeSourceItem*) vala_iterator_get (_source_it);
			skip_unchanged_file = FALSE;
			if (no_update_check == FALSE) {
				_tmp5_ = source->content == NULL;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				_tmp4_ = self->priv->_ast != NULL;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				AfroditeSourceFile* sf;
				gboolean _tmp6_ = FALSE;
				sf = afrodite_ast_lookup_source_file (self->priv->_ast, source->path);
				if (sf != NULL) {
					_tmp6_ = afrodite_source_file_update_last_modification_time (sf);
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					afrodite_utils_trace ("completionengine.vala:152: engine %s: skip unchanged source %s", self->id, source->path);
					skip_unchanged_file = TRUE;
				}
				_afrodite_source_file_unref0 (sf);
			}
			if (!skip_unchanged_file) {
				AfroditeSourceItem* item;
				gboolean _tmp7_ = FALSE;
				item = afrodite_completion_engine_source_queue_contains (self, source);
				if (item == NULL) {
					_tmp7_ = TRUE;
				} else {
					_tmp7_ = _vala_strcmp0 (item->content, source->content) != 0;
				}
				if (_tmp7_) {
					AfroditeSourceItem* _tmp8_;
					if (item != NULL) {
						vala_collection_remove ((ValaCollection*) self->priv->_source_queue, item);
					}
					vala_collection_add ((ValaCollection*) self->priv->_source_queue, _tmp8_ = afrodite_source_item_copy (source));
					_afrodite_source_item_unref0 (_tmp8_);
				} else {
					gboolean _tmp9_ = FALSE;
					if (item->content == NULL) {
						_tmp9_ = source->content != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						char* _tmp10_;
						item->content = (_tmp10_ = g_strdup (source->content), _g_free0 (item->content), _tmp10_);
					}
				}
				_afrodite_source_item_unref0 (item);
			}
			_afrodite_source_item_unref0 (source);
		}
		_vala_collection_object_unref0 (_source_it);
	}
	g_mutex_unlock (self->priv->_source_queue_mutex);
	if (g_atomic_int_compare_and_exchange (&self->priv->_parser_stamp, 0, 1)) {
		afrodite_completion_engine_create_parser_thread (self);
	} else {
		g_atomic_int_inc (&self->priv->_parser_stamp);
	}
	result = _result_;
	return result;
}


void afrodite_completion_engine_queue_sourcefile (AfroditeCompletionEngine* self, const char* path, const char* content, gboolean is_vapi, gboolean is_glib) {
	ValaArrayList* sources;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	sources = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	vala_collection_add ((ValaCollection*) sources, path);
	afrodite_completion_engine_queue_sourcefiles (self, (ValaList*) sources, content, is_vapi, FALSE);
	_vala_collection_object_unref0 (sources);
}


void afrodite_completion_engine_queue_sourcefiles (AfroditeCompletionEngine* self, ValaList* paths, const char* content, gboolean is_vapi, gboolean is_glib) {
	ValaArrayList* sources;
	g_return_if_fail (self != NULL);
	g_return_if_fail (paths != NULL);
	sources = vala_array_list_new (AFRODITE_TYPE_SOURCE_ITEM, (GBoxedCopyFunc) afrodite_source_item_ref, afrodite_source_item_unref, g_direct_equal);
	{
		ValaIterator* _path_it;
		_path_it = vala_iterable_iterator ((ValaIterable*) paths);
		while (TRUE) {
			char* path;
			AfroditeSourceItem* item;
			char* _tmp0_;
			char* _tmp1_;
			if (!vala_iterator_next (_path_it)) {
				break;
			}
			path = (char*) vala_iterator_get (_path_it);
			item = afrodite_source_item_new ();
			item->path = (_tmp0_ = g_strdup (path), _g_free0 (item->path), _tmp0_);
			item->content = (_tmp1_ = g_strdup (content), _g_free0 (item->content), _tmp1_);
			item->is_glib = is_glib;
			vala_collection_add ((ValaCollection*) sources, item);
			_afrodite_source_item_unref0 (item);
			_g_free0 (path);
		}
		_vala_collection_object_unref0 (_path_it);
	}
	afrodite_completion_engine_queue_sources (self, (ValaList*) sources, FALSE);
	_vala_collection_object_unref0 (sources);
}


static void* _afrodite_completion_engine_parse_sources_gthread_func (gpointer self) {
	void* result;
	result = afrodite_completion_engine_parse_sources (self);
	return result;
}


static void afrodite_completion_engine_create_parser_thread (AfroditeCompletionEngine* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GThread* _tmp0_;
		if (self->priv->_parser_thread != NULL) {
			g_thread_join (self->priv->_parser_thread);
		}
		_tmp0_ = g_thread_create_full (_afrodite_completion_engine_parse_sources_gthread_func, self, (gulong) 0, TRUE, FALSE, G_THREAD_PRIORITY_LOW, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch6_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->_parser_thread = _tmp0_;
	}
	goto __finally6;
	__catch6_g_thread_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_error ("completionengine.vala:227: %s: can't create parser thread: %s", self->id, err->message);
			_g_error_free0 (err);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean _afrodite_completion_engine_on_parse_results_gsource_func (gpointer self) {
	gboolean result;
	result = afrodite_completion_engine_on_parse_results (self);
	return result;
}


static void* afrodite_completion_engine_parse_sources (AfroditeCompletionEngine* self) {
	void* result = NULL;
	ValaList* sources;
	ValaList* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	afrodite_utils_trace ("completionengine.vala:238: engine %s: parser thread *** starting ***.." \
".", self->id);
	sources = (ValaList*) vala_array_list_new (AFRODITE_TYPE_SOURCE_ITEM, (GBoxedCopyFunc) afrodite_source_item_ref, afrodite_source_item_unref, g_direct_equal);
	while (TRUE) {
		gint stamp;
		gboolean _tmp1_ = FALSE;
		stamp = g_atomic_int_get (&self->priv->_parser_stamp);
		g_atomic_int_set (&self->priv->_parser_remaining_files, vala_collection_get_size ((ValaCollection*) self->priv->_source_queue));
		g_mutex_lock (self->priv->_source_queue_mutex);
		{
			ValaIterator* _item_it;
			_item_it = vala_iterable_iterator ((ValaIterable*) self->priv->_source_queue);
			while (TRUE) {
				AfroditeSourceItem* item;
				AfroditeSourceItem* _tmp0_;
				if (!vala_iterator_next (_item_it)) {
					break;
				}
				item = (AfroditeSourceItem*) vala_iterator_get (_item_it);
				vala_collection_add ((ValaCollection*) sources, _tmp0_ = afrodite_source_item_copy (item));
				_afrodite_source_item_unref0 (_tmp0_);
				_afrodite_source_item_unref0 (item);
			}
			_vala_collection_object_unref0 (_item_it);
		}
		afrodite_utils_trace ("completionengine.vala:252: engine %s: queued %d", self->id, vala_collection_get_size ((ValaCollection*) sources));
		g_atomic_int_set (&self->priv->_current_parsing_total_file_count, vala_collection_get_size ((ValaCollection*) sources));
		vala_collection_clear ((ValaCollection*) self->priv->_source_queue);
		g_mutex_unlock (self->priv->_source_queue_mutex);
		{
			ValaIterator* _source_it;
			_source_it = vala_iterable_iterator ((ValaIterable*) sources);
			while (TRUE) {
				AfroditeSourceItem* source;
				AfroditeParser* p;
				AfroditeParseResult* parse_results;
				if (!vala_iterator_next (_source_it)) {
					break;
				}
				source = (AfroditeSourceItem*) vala_iterator_get (_source_it);
				p = afrodite_parser_new_with_source (source);
				parse_results = afrodite_parser_parse (p);
				{
					g_static_rec_mutex_lock (&self->priv->__lock__parse_result_list);
					{
						vala_collection_add ((ValaCollection*) self->priv->_parse_result_list, parse_results);
						if (self->priv->_idle_id == 0) {
							self->priv->_idle_id = g_timeout_add_full (G_PRIORITY_LOW, (guint) 250, _afrodite_completion_engine_on_parse_results_gsource_func, g_object_ref (self), g_object_unref);
						}
					}
					__finally7:
					{
						g_static_rec_mutex_unlock (&self->priv->__lock__parse_result_list);
					}
					if (_inner_error_ != NULL) {
						_g_object_unref0 (parse_results);
						_g_object_unref0 (p);
						_afrodite_source_item_unref0 (source);
						_vala_collection_object_unref0 (_source_it);
						_vala_collection_object_unref0 (sources);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				g_atomic_int_add (&self->priv->_parser_remaining_files, -1);
				_g_object_unref0 (parse_results);
				_g_object_unref0 (p);
				_afrodite_source_item_unref0 (source);
			}
			_vala_collection_object_unref0 (_source_it);
		}
		vala_collection_clear ((ValaCollection*) sources);
		if (self->priv->_ast == NULL) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = g_atomic_int_compare_and_exchange (&self->priv->_parser_stamp, stamp, 0);
		}
		if (_tmp1_) {
			break;
		}
	}
	g_atomic_int_set (&self->priv->_current_parsing_total_file_count, 0);
	sources = (_tmp2_ = NULL, _vala_collection_object_unref0 (sources), _tmp2_);
	result = NULL;
	_vala_collection_object_unref0 (sources);
	return result;
}


static void afrodite_completion_engine_on_begin_parsing (AfroditeCompletionEngine* self) {
	g_return_if_fail (self != NULL);
	if (!self->priv->_is_parsing) {
		self->priv->_is_parsing = TRUE;
		g_signal_emit_by_name (self, "begin-parsing", self);
	}
}


static void afrodite_completion_engine_on_end_parsing (AfroditeCompletionEngine* self) {
	g_return_if_fail (self != NULL);
	if (g_atomic_int_get (&self->priv->_current_parsing_total_file_count) == 0) {
		self->priv->_is_parsing = FALSE;
		g_signal_emit_by_name (self, "end-parsing", self);
	}
}


static void _afrodite_completion_engine_on_merge_and_resolve_ended_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	afrodite_completion_engine_on_merge_and_resolve_ended (self, source_object, res);
	g_object_unref (self);
}


static gboolean afrodite_completion_engine_on_parse_results (AfroditeCompletionEngine* self) {
	gboolean result = FALSE;
	gboolean merge_scheduled;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	merge_scheduled = FALSE;
	{
		g_static_rec_mutex_lock (&self->priv->__lock__parse_result_list);
		{
			if (vala_collection_get_size ((ValaCollection*) self->priv->_parse_result_list) > 0) {
				{
					ValaIterator* _key_it;
					_key_it = vala_iterable_iterator ((ValaIterable*) self->priv->_parse_result_list);
					while (TRUE) {
						AfroditeParseResult* key;
						if (!vala_iterator_next (_key_it)) {
							break;
						}
						key = (AfroditeParseResult*) vala_iterator_get (_key_it);
						if (!merge_scheduled) {
							merge_scheduled = TRUE;
							afrodite_completion_engine_merge_and_resolve (self, key, _afrodite_completion_engine_on_merge_and_resolve_ended_gasync_ready_callback, g_object_ref (self));
							vala_collection_remove ((ValaCollection*) self->priv->_parse_result_list, key);
							_g_object_unref0 (key);
							break;
						}
						_g_object_unref0 (key);
					}
					_vala_collection_object_unref0 (_key_it);
				}
			} else {
				self->priv->_idle_id = (guint) 0;
			}
		}
		__finally8:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock__parse_result_list);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (merge_scheduled) {
		afrodite_completion_engine_on_begin_parsing (self);
	} else {
		afrodite_completion_engine_on_end_parsing (self);
	}
	result = FALSE;
	return result;
}


static void afrodite_completion_engine_on_merge_and_resolve_ended (AfroditeCompletionEngine* self, GObject* source, GAsyncResult* r) {
	AfroditeParseResult* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	_tmp0_ = afrodite_completion_engine_merge_and_resolve_finish (self, r);
	_g_object_unref0 (_tmp0_);
	self->priv->_idle_id = g_timeout_add_full (G_PRIORITY_LOW, (guint) 250, _afrodite_completion_engine_on_parse_results_gsource_func, g_object_ref (self), g_object_unref);
}


static void afrodite_completion_engine_merge_and_resolve_data_free (gpointer _data) {
	AfroditeCompletionEngineMergeAndResolveData* data;
	data = _data;
	_g_object_unref0 (data->_result_);
	_g_object_unref0 (data->result);
	g_object_unref (data->self);
	g_slice_free (AfroditeCompletionEngineMergeAndResolveData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void afrodite_completion_engine_merge_and_resolve (AfroditeCompletionEngine* self, AfroditeParseResult* _result_, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AfroditeCompletionEngineMergeAndResolveData* _data_;
	_data_ = g_slice_new0 (AfroditeCompletionEngineMergeAndResolveData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, afrodite_completion_engine_merge_and_resolve);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, afrodite_completion_engine_merge_and_resolve_data_free);
	_data_->self = g_object_ref (self);
	_data_->_result_ = _g_object_ref0 (_result_);
	afrodite_completion_engine_merge_and_resolve_co (_data_);
}


static AfroditeParseResult* afrodite_completion_engine_merge_and_resolve_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_) {
	AfroditeParseResult* result;
	AfroditeCompletionEngineMergeAndResolveData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void afrodite_completion_engine_merge_and_resolve_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AfroditeCompletionEngineMergeAndResolveData* data;
	data = _user_data_;
	data->_res_ = _res_;
	afrodite_completion_engine_merge_and_resolve_co (data);
}


static gboolean afrodite_completion_engine_merge_and_resolve_co (AfroditeCompletionEngineMergeAndResolveData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 6:
		goto _state_6;
	}
	_state_0:
	afrodite_utils_trace ("completionengine.vala:354: engine %s: async merge and resolve: %s", data->self->id, data->_result_->source_path);
	{
		data->_s_it = (data->_tmp1_ = vala_iterable_iterator ((ValaIterable*) (data->_tmp0_ = vala_code_context_get_source_files (data->_result_->context))), _vala_collection_object_unref0 (data->_tmp0_), data->_tmp1_);
		while (TRUE) {
			if (!vala_iterator_next (data->_s_it)) {
				break;
			}
			data->s = (ValaSourceFile*) vala_iterator_get (data->_s_it);
			if (_vala_strcmp0 (vala_source_file_get_filename (data->s), data->_result_->source_path) == 0) {
				data->ast_source = afrodite_ast_lookup_source_file (data->self->priv->_ast, data->_result_->source_path);
				data->source_exists = data->ast_source != NULL;
				data->need_update = TRUE;
				if (data->source_exists) {
					data->_tmp3_ = data->_result_->is_edited;
				} else {
					data->_tmp3_ = FALSE;
				}
				if (data->_tmp3_) {
					data->_tmp2_ = vala_collection_get_size ((ValaCollection*) data->_result_->errors) > 0;
				} else {
					data->_tmp2_ = FALSE;
				}
				if (!data->_tmp2_) {
					if (data->source_exists) {
						data->_tmp4_ = !data->_result_->is_edited;
					} else {
						data->_tmp4_ = FALSE;
					}
					if (data->_tmp4_) {
						data->need_update = afrodite_source_file_update_last_modification_time (data->ast_source);
					}
					data->ast_source = (data->_tmp5_ = NULL, _afrodite_source_file_unref0 (data->ast_source), data->_tmp5_);
					if (data->need_update) {
						data->_state_ = 6;
						afrodite_completion_engine_perform_merge_and_resolve (data->self, data->s, data->_result_, data->source_exists, afrodite_completion_engine_merge_and_resolve_ready, data);
						return FALSE;
						_state_6:
						afrodite_completion_engine_perform_merge_and_resolve_finish (data->self, data->_res_);
						g_signal_emit_by_name (data->self, "file-parsed", data->self, data->_result_->source_path, data->_result_);
					}
				} else {
					afrodite_utils_trace ("completionengine.vala:377: engine %s: source (live buffer) with errors" \
" mantaining the previous parsing: %s", data->self->id, data->_result_->source_path);
				}
				_afrodite_source_file_unref0 (data->ast_source);
				_vala_source_file_unref0 (data->s);
				break;
			}
			_vala_source_file_unref0 (data->s);
		}
		_vala_collection_object_unref0 (data->_s_it);
	}
	data->result = _g_object_ref0 (data->_result_);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void afrodite_completion_engine_perform_merge_and_resolve_data_free (gpointer _data) {
	AfroditeCompletionEnginePerformMergeAndResolveData* data;
	data = _data;
	_vala_source_file_unref0 (data->s);
	_g_object_unref0 (data->_result_);
	g_object_unref (data->self);
	g_slice_free (AfroditeCompletionEnginePerformMergeAndResolveData, data);
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static void afrodite_completion_engine_perform_merge_and_resolve (AfroditeCompletionEngine* self, ValaSourceFile* s, AfroditeParseResult* _result_, gboolean source_exists, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AfroditeCompletionEnginePerformMergeAndResolveData* _data_;
	_data_ = g_slice_new0 (AfroditeCompletionEnginePerformMergeAndResolveData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, afrodite_completion_engine_perform_merge_and_resolve);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, afrodite_completion_engine_perform_merge_and_resolve_data_free);
	_data_->self = g_object_ref (self);
	_data_->s = _vala_source_file_ref0 (s);
	_data_->_result_ = _g_object_ref0 (_result_);
	_data_->source_exists = source_exists;
	afrodite_completion_engine_perform_merge_and_resolve_co (_data_);
}


static void afrodite_completion_engine_perform_merge_and_resolve_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_) {
	AfroditeCompletionEnginePerformMergeAndResolveData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void afrodite_completion_engine_perform_merge_and_resolve_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AfroditeCompletionEnginePerformMergeAndResolveData* data;
	data = _user_data_;
	data->_res_ = _res_;
	afrodite_completion_engine_perform_merge_and_resolve_co (data);
}


static gboolean afrodite_completion_engine_perform_merge_and_resolve_co (AfroditeCompletionEnginePerformMergeAndResolveData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 7:
		goto _state_7;
		case 8:
		goto _state_8;
	}
	_state_0:
	data->_state_ = 7;
	afrodite_completion_engine_merge_vala_source (data->self, data->s, data->_result_, data->source_exists, afrodite_completion_engine_perform_merge_and_resolve_ready, data);
	return FALSE;
	_state_7:
	afrodite_completion_engine_merge_vala_source_finish (data->self, data->_res_);
	data->_state_ = 8;
	afrodite_completion_engine_resolve_ast (data->self, afrodite_completion_engine_perform_merge_and_resolve_ready, data);
	return FALSE;
	_state_8:
	afrodite_completion_engine_resolve_ast_finish (data->self, data->_res_);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void afrodite_completion_engine_merge_vala_source_data_free (gpointer _data) {
	AfroditeCompletionEngineMergeValaSourceData* data;
	data = _data;
	_vala_source_file_unref0 (data->s);
	_g_object_unref0 (data->_result_);
	g_object_unref (data->self);
	g_slice_free (AfroditeCompletionEngineMergeValaSourceData, data);
}


static void afrodite_completion_engine_merge_vala_source (AfroditeCompletionEngine* self, ValaSourceFile* s, AfroditeParseResult* _result_, gboolean source_exists, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AfroditeCompletionEngineMergeValaSourceData* _data_;
	_data_ = g_slice_new0 (AfroditeCompletionEngineMergeValaSourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, afrodite_completion_engine_merge_vala_source);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, afrodite_completion_engine_merge_vala_source_data_free);
	_data_->self = g_object_ref (self);
	_data_->s = _vala_source_file_ref0 (s);
	_data_->_result_ = _g_object_ref0 (_result_);
	_data_->source_exists = source_exists;
	afrodite_completion_engine_merge_vala_source_co (_data_);
}


static void afrodite_completion_engine_merge_vala_source_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_) {
	AfroditeCompletionEngineMergeValaSourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void afrodite_completion_engine_merge_vala_source_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AfroditeCompletionEngineMergeValaSourceData* data;
	data = _user_data_;
	data->_res_ = _res_;
	afrodite_completion_engine_merge_vala_source_co (data);
}


static gboolean afrodite_completion_engine_merge_vala_source_co (AfroditeCompletionEngineMergeValaSourceData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 9:
		goto _state_9;
		case 10:
		goto _state_10;
	}
	_state_0:
	data->merger = afrodite_ast_merger_new (data->self->priv->_ast);
	if (data->source_exists) {
		data->_state_ = 9;
		afrodite_ast_merger_remove_source_filename (data->merger, data->_result_->source_path, afrodite_completion_engine_merge_vala_source_ready, data);
		return FALSE;
		_state_9:
		afrodite_ast_merger_remove_source_filename_finish (data->merger, data->_res_);
	}
	data->_state_ = 10;
	afrodite_ast_merger_merge_vala_context (data->merger, data->s, data->_result_->context, data->_result_->is_glib, afrodite_completion_engine_merge_vala_source_ready, data);
	return FALSE;
	_state_10:
	afrodite_ast_merger_merge_vala_context_finish (data->merger, data->_res_);
	data->_result_->context = (data->_tmp0_ = NULL, _vala_code_context_unref0 (data->_result_->context), data->_tmp0_);
	data->merger = (data->_tmp1_ = NULL, _vala_code_visitor_unref0 (data->merger), data->_tmp1_);
	_vala_code_visitor_unref0 (data->merger);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void afrodite_completion_engine_resolve_ast_data_free (gpointer _data) {
	AfroditeCompletionEngineResolveAstData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (AfroditeCompletionEngineResolveAstData, data);
}


static void afrodite_completion_engine_resolve_ast (AfroditeCompletionEngine* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AfroditeCompletionEngineResolveAstData* _data_;
	_data_ = g_slice_new0 (AfroditeCompletionEngineResolveAstData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, afrodite_completion_engine_resolve_ast);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, afrodite_completion_engine_resolve_ast_data_free);
	_data_->self = g_object_ref (self);
	afrodite_completion_engine_resolve_ast_co (_data_);
}


static void afrodite_completion_engine_resolve_ast_finish (AfroditeCompletionEngine* self, GAsyncResult* _res_) {
	AfroditeCompletionEngineResolveAstData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void afrodite_completion_engine_resolve_ast_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AfroditeCompletionEngineResolveAstData* data;
	data = _user_data_;
	data->_res_ = _res_;
	afrodite_completion_engine_resolve_ast_co (data);
}


static gboolean afrodite_completion_engine_resolve_ast_co (AfroditeCompletionEngineResolveAstData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->resolver = afrodite_symbol_resolver_new ();
	afrodite_symbol_resolver_resolve (data->resolver, data->self->priv->_ast);
	_afrodite_symbol_resolver_unref0 (data->resolver);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


gboolean afrodite_completion_engine_get_is_parsing (AfroditeCompletionEngine* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_parsing;
	return result;
}


AfroditeAst* afrodite_completion_engine_get_ast (AfroditeCompletionEngine* self) {
	AfroditeAst* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_ast;
	return result;
}


static void afrodite_completion_engine_class_init (AfroditeCompletionEngineClass * klass) {
	afrodite_completion_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AfroditeCompletionEnginePrivate));
	G_OBJECT_CLASS (klass)->get_property = afrodite_completion_engine_get_property;
	G_OBJECT_CLASS (klass)->finalize = afrodite_completion_engine_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_COMPLETION_ENGINE_IS_PARSING, g_param_spec_boolean ("is-parsing", "is-parsing", "is-parsing", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AFRODITE_COMPLETION_ENGINE_AST, afrodite_param_spec_ast ("ast", "ast", "ast", AFRODITE_TYPE_AST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("begin_parsing", AFRODITE_TYPE_COMPLETION_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, AFRODITE_TYPE_COMPLETION_ENGINE);
	g_signal_new ("end_parsing", AFRODITE_TYPE_COMPLETION_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, AFRODITE_TYPE_COMPLETION_ENGINE);
	g_signal_new ("file_parsed", AFRODITE_TYPE_COMPLETION_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_STRING_OBJECT, G_TYPE_NONE, 3, AFRODITE_TYPE_COMPLETION_ENGINE, G_TYPE_STRING, AFRODITE_TYPE_PARSE_RESULT);
}


static void afrodite_completion_engine_instance_init (AfroditeCompletionEngine * self) {
	self->priv = AFRODITE_COMPLETION_ENGINE_GET_PRIVATE (self);
	self->priv->_parser_stamp = 0;
	self->priv->_parser_remaining_files = 0;
	self->priv->_current_parsing_total_file_count = 0;
	self->priv->_glib_init = FALSE;
	self->priv->_is_parsing = FALSE;
	g_static_rec_mutex_init (&self->priv->__lock__parse_result_list);
	self->priv->_parse_result_list = (ValaList*) vala_array_list_new (AFRODITE_TYPE_PARSE_RESULT, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->_idle_id = (guint) 0;
}


static void afrodite_completion_engine_finalize (GObject* obj) {
	AfroditeCompletionEngine * self;
	self = AFRODITE_COMPLETION_ENGINE (obj);
	{
		AfroditeAst* _tmp0_;
		afrodite_utils_trace ("completionengine.vala:69: Completion %s destroy", self->id);
		self->priv->_ast = (_tmp0_ = NULL, _afrodite_ast_unref0 (self->priv->_ast), _tmp0_);
		if (g_atomic_int_get (&self->priv->_parser_stamp) != 0) {
			afrodite_utils_trace ("completionengine.vala:74: join the parser thread before exit");
			g_thread_join (self->priv->_parser_thread);
		}
		self->priv->_parser_thread = NULL;
		if (self->priv->_idle_id != 0) {
			g_source_remove (self->priv->_idle_id);
			self->priv->_idle_id = (guint) 0;
		}
		afrodite_utils_trace ("completionengine.vala:82: Completion %s destroyed", self->id);
	}
	_g_free0 (self->id);
	_vala_collection_object_unref0 (self->priv->_vapidirs);
	_vala_collection_object_unref0 (self->priv->_source_queue);
	_vala_collection_object_unref0 (self->priv->_merge_queue);
	_g_mutex_free0 (self->priv->_source_queue_mutex);
	_g_mutex_free0 (self->priv->_merge_queue_mutex);
	_afrodite_ast_unref0 (self->priv->_ast);
	g_static_rec_mutex_free (&self->priv->__lock__parse_result_list);
	_vala_collection_object_unref0 (self->priv->_parse_result_list);
	G_OBJECT_CLASS (afrodite_completion_engine_parent_class)->finalize (obj);
}


GType afrodite_completion_engine_get_type (void) {
	static volatile gsize afrodite_completion_engine_type_id__volatile = 0;
	if (g_once_init_enter (&afrodite_completion_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AfroditeCompletionEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) afrodite_completion_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AfroditeCompletionEngine), 0, (GInstanceInitFunc) afrodite_completion_engine_instance_init, NULL };
		GType afrodite_completion_engine_type_id;
		afrodite_completion_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "AfroditeCompletionEngine", &g_define_type_info, 0);
		g_once_init_leave (&afrodite_completion_engine_type_id__volatile, afrodite_completion_engine_type_id);
	}
	return afrodite_completion_engine_type_id__volatile;
}


static void afrodite_completion_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AfroditeCompletionEngine * self;
	self = AFRODITE_COMPLETION_ENGINE (object);
	switch (property_id) {
		case AFRODITE_COMPLETION_ENGINE_IS_PARSING:
		g_value_set_boolean (value, afrodite_completion_engine_get_is_parsing (self));
		break;
		case AFRODITE_COMPLETION_ENGINE_AST:
		afrodite_value_set_ast (value, afrodite_completion_engine_get_ast (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__OBJECT_STRING_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_STRING_OBJECT) (gpointer data1, gpointer arg_1, const char* arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_string (param_values + 2), g_value_get_object (param_values + 3), data2);
}



