/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Damien
	CALISTE, laboratoire L_Sim, (2001-2009)
  
	Adresse ml :
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Damien
	CALISTE, laboratoire L_Sim, (2001-2009)

	E-mail address:
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "extraNode.h"

#include <glib.h>
#include "dataNode.h"

/**
 * SECTION:extraNode
 * @short_description: add further characteristics to the nodes.
 *
 * <para>blabla</para>
 */

#define LABEL_ID "extraNode_label"

/* Local variables. */
static DataNode *dataNodeLabel = NULL;
static GValue    dataLabel     = {0, {{0}, {0}}};

static void freeLabel(gpointer obj, gpointer data _U_)
{
  g_free(obj);
}
static gpointer newOrCopyLabel(gconstpointer orig, gpointer user_data _U_)
{
  return g_strdup(orig);
}

void extraNodeAdd_label(VisuData *data)
{
  VisuNodeProperty* nodeProp;

  /* Test if the property is already set or not. */
  nodeProp = visuNodeGet_property(visuDataGet_nodeArray(data), LABEL_ID);
  if (!nodeProp)
    /* If not, create it. */
    visuNodeNew_pointerProperty(visuDataGet_nodeArray(data),
				LABEL_ID, freeLabel, newOrCopyLabel, (gpointer)0);

  /* Register a new NodeData, if not already. */
  if (!dataNodeLabel)
    {
      dataNodeLabel = nodeDataNew(LABEL_ID, G_TYPE_STRING);
      nodeDataSet_label(dataNodeLabel, _("Label"));
      nodeDataSet_editable(dataNodeLabel, TRUE);

      g_value_init(&dataLabel, G_TYPE_POINTER);
    }

  /* Make this property used. */
  nodeDataSet_used(dataNodeLabel, data, 1);
}

void extraNodeSet_label(VisuData *data, unsigned int nodeId, const gchar *label)
{
  VisuNode *node;
  gchar *lbl;

  node = visuDataGet_nodeFromNumber(data, nodeId);
  g_return_if_fail(node);

  /* Associates the values to the node. */
  lbl = g_strdup(label);
  g_value_set_pointer(&dataLabel, (gpointer)lbl);
  visuNodeSet_propertyValue(visuDataGet_nodeArray(data), node, LABEL_ID, &dataLabel);
}
const gchar* extraNodeGet_label(VisuData *data, VisuNode *node)
{
  VisuNodeProperty* nodeProp;
  gchar *lbl;

  nodeProp = visuNodeGet_property(visuDataGet_nodeArray(data), LABEL_ID);
  if (!nodeProp)
    return (const gchar*)0;

  /* Read the value of the node. */
  visuNodePropertyGet_value(nodeProp, node, &dataLabel);
  lbl = (gchar*)g_value_get_pointer(&dataLabel);

  return lbl;
}
