/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#ifndef TOOLOPTIONS_H
#define TOOLOPTIONS_H

#include <glib.h>
/**
 * OptionTable:
 *
 * This hashtable is used to specificaly bind strings to
 * #Option elements.
 */
typedef GHashTable OptionTable;

/**
 * Option_stuct:
 *
 * Opaque structure to store values, their ranges...
 */
struct Option_stuct;
/**
 * Option:
 *
 * Short way to address #Option_stuct.
 */
typedef struct Option_stuct Option;

/**
 * toolOptionsNew_table:
 * 
 * Create a new table of options. Strings are used as keys and elements are #Option.
 *
 * Returns: a newly created table. Use toolOptionsFree_table() to destroy it.
 */
#define toolOptionsNew_table() g_hash_table_new_full(g_str_hash, g_str_equal, NULL, \
						     toolOptionsFree_option)
/**
 * toolOptionsFree_table:
 * @table: the table to free.
 * 
 * Free all memory used by a table of options, and free also its elements.
 */
#define toolOptionsFree_table(table) g_hash_table_destroy((GHashTable*)table)

/**
 * toolOptionsGet_optionFromTable:
 * @table: the table to look in ;
 * @option: a string being the option name.
 * 
 * Look in @table to find @option. If no option with this name is found, then
 * it returns NULL.
 */
#define toolOptionsGet_optionFromTable(table, option) g_hash_table_lookup((GHashTable*)table, \
									  (gchar*)option)
/**
 * toolOptionsAdd_optionToTable:
 * @table: the table to add the option to ;
 * @option: an #Option to be added.
 * 
 * Add the given @option to the table, using its name as key.
 */
#define toolOptionsAdd_optionToTable(table, option) \
  g_hash_table_insert((GHashTable*)table, (gpointer)toolOptionsGet_name(option), \
		      (gpointer)option)

/**
 * OptionTypes:
 * @OPTION_BOOLEAN: a boolean value ;
 * @OPTION_INTEGER: an integer value ;
 * @OPTION_FLOAT: a floating point value ;
 * @NB_OPTION_TYPES: number of suppoted types.
 *
 * These are types supported in the #OptionTable.
 */
typedef enum
  {
    OPTION_BOOLEAN,
    OPTION_INTEGER,
    OPTION_FLOAT,
    NB_OPTION_TYPES
  } OptionTypes;

/**
 * toolOptionsNew_optionBoolean:
 * @name: a string identifying the option ;
 * @label: a string describing shortly the option (must be in UTF-8).
 *
 * Create a new #Option using the name as identifier.
 *
 * Returns: a newly created option, use toolOptionsFree_option() to free it.
 */
Option* toolOptionsNew_optionBoolean(const gchar *name, const gchar *label);
/**
 * toolOptionsNew_optionInteger:
 * @name: a string identifying the option ;
 * @label: a string describing shortly the option (must be in UTF-8).
 *
 * Create a new #Option using the name as identifier.
 *
 * Returns: a newly created option, use toolOptionsFree_option() to free it.
 */
Option* toolOptionsNew_optionInteger(const gchar *name, const gchar *label);
/**
 * toolOptionsNew_optionFloat:
 * @name: a string identifying the option ;
 * @label: a string describing shortly the option (must be in UTF-8).
 *
 * Create a new #Option using the name as identifier.
 *
 * Returns: a newly created option, use toolOptionsFree_option() to free it.
 */
Option* toolOptionsNew_optionFloat(const gchar *name, const gchar *label);

/**
 * toolOptionsFree_option:
 * @option: the #Option to free.
 *
 * Free the memory used by the @option.
 */
void toolOptionsFree_option(gpointer option);

/**
 * toolOptionsGet_name:
 * @option: the #Option to get the name of.
 *
 * Get the name of the option.
 *
 * Returns: a string owned by V_Sim, should not be freed.
 */
gchar* toolOptionsGet_name(Option *option);
/**
 * toolOptionsGet_label:
 * @option: the #Option to get the label of.
 *
 * Get the label of the option.
 *
 * Returns: a string owned by V_Sim, should not be freed.
 */
gchar* toolOptionsGet_label(Option *option);
/**
 * toolOptionsGet_type:
 * @option: the #Option to get the type of.
 *
 * Get the type of the option.
 *
 * Returns: a #OptionTypes value.
 */
OptionTypes toolOptionsGet_type(Option *option);

/**
 * toolOptionsSet_valueBoolean:
 * @option: the #Option to set the value of ;
 * @value: the new value.
 *
 * Change or set (if not set yet) the value of one option.
 */
void toolOptionsSet_valueBoolean(Option *option, gboolean value);
/**
 * toolOptionsSet_valueInteger:
 * @option: the #Option to set the value of ;
 * @value: the new value.
 *
 * Change or set (if not set yet) the value of one option.
 */
void toolOptionsSet_valueInteger(Option *option, int value);
/**
 * toolOptionsSet_valueFloat:
 * @option: the #Option to set the value of ;
 * @value: the new value.
 *
 * Change or set (if not set yet) the value of one option.
 */
void toolOptionsSet_valueFloat  (Option *option, float value);

/**
 * toolOptionsGet_valueBoolean:
 * @option: the #Option to get the value from ;
 * @value: a location to store the value.
 *
 * Read the value of one option.
 *
 * Returns: FALSE if the value is currently unset.
 */
gboolean toolOptionsGet_valueBoolean(Option *option, gboolean *value);
/**
 * toolOptionsGet_valueInteger:
 * @option: the #Option to get the value from ;
 * @value: a location to store the value.
 *
 * Read the value of one option.
 *
 * Returns: FALSE if the value is currently unset.
 */
gboolean toolOptionsGet_valueInteger(Option *option, int *value);
/**
 * toolOptionsGet_valueFloat:
 * @option: the #Option to get the value from ;
 * @value: a location to store the value.
 *
 * Read the value of one option.
 *
 * Returns: FALSE if the value is currently unset.
 */
gboolean toolOptionsGet_valueFloat  (Option *option, float *value);
/**
 * toolOptionsGet_valueAndLabel:
 * @option: the #Option to get the value from.
 *
 * This method returns a string with the value followed by the label in parenthesis
 * and with Pango markup for smaller font.
 *
 * Returns: a newly created markup string.
 */
gchar* toolOptionsGet_valueAndLabel(Option *option);

#endif
