/* i086-dos16.sys.h
   created from i086-dos16.sys.bin, 7014 (0x1b66) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_I086_DOS16_SYS_SIZE    7014
#define STUB_I086_DOS16_SYS_ADLER32 0x9d4912a7
#define STUB_I086_DOS16_SYS_CRC32   0xf0c5326f

unsigned char stub_i086_dos16_sys[7014] = {
127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
148,  2,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,   /* 0x  20 */
 53,  0, 50,  0,255,255,255,255,  0,  0, 10,  0,  0,  0, 96, 80,   /* 0x  30 */
 83, 81, 82, 86, 87, 85,190,  0,  0,191,  0,  0,137,241,  6, 30,   /* 0x  40 */
  7,253,243,164,252,187,  0,128,135,247,131,238,  0, 25,237, 87,   /* 0x  50 */
233,255,255, 85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,  0,   /* 0x  60 */
  0,  0,  0,  0,  0,  0,  0,  0, 45,164,232, 11,  0,114,250, 65,   /* 0x  70 */
232,  6,  0,227, 21,227, 20,115,  6,131,233,  3,114,  6,136,204,   /* 0x  80 */
172,247,208,149, 49,201,232,  6,  0, 17,201,117,  8, 65,232,  6,   /* 0x  90 */
  0,115,251, 65, 65, 65,129,253,  0,243,131,209,  1,141,  3,150,   /* 0x  a0 */
243,164,150,235,  0,232,  2,  0, 17,201,  1,219,117,  4,173, 17,   /* 0x  b0 */
192,147,195, 94,185,  0,  0,172, 44,232, 60,  1,119,249,193,  4,   /* 0x  c0 */
  8, 41, 52,139, 28,134,223, 41,243,137, 28,173,226,  3,176,232,   /* 0x  d0 */
176,233, 95,185,  0,  0,242,174,117, 20,117,  2,193,  5,  8, 41,   /* 0x  e0 */
 61,139, 29,134,223, 41,251,137, 29,175,235,  3,  7, 97, 93, 95,   /* 0x  f0 */
 94, 90, 89, 91, 88,233,254,255,116,109,112, 47,105, 48, 56, 54,   /* 0x 100 */
 45,100,111,115, 49, 54, 46,115,121,115, 46, 98,105,110, 58, 32,   /* 0x 110 */
 32, 32, 32, 32,102,105,108,101, 32,102,111,114,109, 97,116, 32,   /* 0x 120 */
101,108,102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,   /* 0x 130 */
105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32,   /* 0x 140 */
 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32,   /* 0x 150 */
 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32,   /* 0x 160 */
 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32,   /* 0x 170 */
 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32,   /* 0x 180 */
 83, 89, 83, 77, 65, 73, 78, 49, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x 190 */
 48, 48, 48, 48, 48, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x 1a0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x 1b0 */
 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x 1c0 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x 1d0 */
 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 83, 89, 83, 73, 50, 56,   /* 0x 1e0 */
 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49,   /* 0x 1f0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x 200 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 51,101, 32, 32,   /* 0x 210 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x 220 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 83, 89, 83,   /* 0x 230 */
 73, 48, 56, 54, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x 240 */
 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x 250 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 51,   /* 0x 260 */
102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x 270 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32,   /* 0x 280 */
 83, 89, 83, 77, 65, 73, 78, 50, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x 290 */
 48, 48, 48, 48, 49, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x 2a0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x 2b0 */
 48, 48, 52, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x 2c0 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x 2d0 */
 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 83, 89, 83, 83, 66, 66,   /* 0x 2e0 */
 66, 80, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50,   /* 0x 2f0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x 300 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 53,100, 32, 32,   /* 0x 310 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x 320 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 83, 89, 83,   /* 0x 330 */
 67, 65, 76, 76, 84, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x 340 */
 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x 350 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 53,   /* 0x 360 */
102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x 370 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32,   /* 0x 380 */
 83, 89, 83, 77, 65, 73, 78, 51, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x 390 */
 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x 3a0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x 3b0 */
 48, 48, 54, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x 3c0 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x 3d0 */
 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 85, 80, 88, 49, 72, 69,   /* 0x 3e0 */
 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54,   /* 0x 3f0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x 400 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 54, 51, 32, 32,   /* 0x 410 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x 420 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 83, 89, 83,   /* 0x 430 */
 67, 85, 84, 80, 79, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x 440 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x 450 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 55,   /* 0x 460 */
 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x 470 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32,   /* 0x 480 */
 78, 82, 86, 50, 66, 49, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x 490 */
 48, 48, 48, 48, 48, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x 4a0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x 4b0 */
 48, 48, 55, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x 4c0 */
 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,   /* 0x 4d0 */
 68, 79, 78, 76, 89, 10, 32, 49, 48, 32, 78, 82, 86, 68, 68, 79,   /* 0x 4e0 */
 78, 69, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50,   /* 0x 4f0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x 500 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 56, 51, 32, 32,   /* 0x 510 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x 520 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x 530 */
 32, 49, 49, 32, 78, 82, 86, 68, 82, 69, 84, 85, 32, 32, 32, 32,   /* 0x 540 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,   /* 0x 550 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x 560 */
 48, 48, 48, 48, 48, 48, 56, 53, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x 570 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,   /* 0x 580 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 50, 32, 78, 82,   /* 0x 590 */
 86, 68, 69, 67, 79, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x 5a0 */
 48, 48, 49,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x 5b0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x 5c0 */
 56, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x 5d0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x 5e0 */
 78, 76, 89, 10, 32, 49, 51, 32, 78, 82, 86, 76, 69, 68, 48, 48,   /* 0x 5f0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32,   /* 0x 600 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x 610 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 97, 53, 32, 32, 50, 42,   /* 0x 620 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x 630 */
 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32, 78, 82, 86, 71, 84,   /* 0x 640 */
 68, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x 650 */
 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x 660 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 97, 54, 32,   /* 0x 670 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x 680 */
 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 53, 32, 78, 82,   /* 0x 690 */
 86, 68, 69, 67, 79, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,   /* 0x 6a0 */
 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x 6b0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x 6c0 */
 97,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,   /* 0x 6d0 */
 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,   /* 0x 6e0 */
 78, 76, 89, 10, 32, 49, 54, 32, 67, 65, 76, 76, 84, 82, 49, 54,   /* 0x 6f0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32,   /* 0x 700 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x 710 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 99, 51, 32, 32, 50, 42,   /* 0x 720 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x 730 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,   /* 0x 740 */
 55, 32, 67, 84, 49, 54, 73, 50, 56, 54, 32, 32, 32, 32, 32, 32,   /* 0x 750 */
 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x 760 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x 770 */
 48, 48, 48, 48, 99,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x 780 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x 790 */
 10, 32, 49, 56, 32, 67, 84, 49, 54, 83, 85, 66, 48, 32, 32, 32,   /* 0x 7a0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,   /* 0x 7b0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x 7c0 */
 32, 48, 48, 48, 48, 48, 48,100, 49, 32, 32, 50, 42, 42, 48, 32,   /* 0x 7d0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x 7e0 */
 78, 76, 89, 10, 32, 49, 57, 32, 67, 84, 49, 54, 73, 48, 56, 54,   /* 0x 7f0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32, 32,   /* 0x 800 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x 810 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 51, 32, 32, 50, 42,   /* 0x 820 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x 830 */
 65, 68, 79, 78, 76, 89, 10, 32, 50, 48, 32, 67, 65, 76, 76, 84,   /* 0x 840 */
 82, 73, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x 850 */
 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x 860 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 98, 32,   /* 0x 870 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x 880 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x 890 */
 10, 32, 50, 49, 32, 67, 84, 49, 54, 69, 56, 48, 48, 32, 32, 32,   /* 0x 8a0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,   /* 0x 8b0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x 8c0 */
 32, 48, 48, 48, 48, 48, 48,100,101, 32, 32, 50, 42, 42, 48, 32,   /* 0x 8d0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x 8e0 */
 78, 76, 89, 10, 32, 50, 50, 32, 67, 84, 49, 54, 69, 57, 48, 48,   /* 0x 8f0 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,   /* 0x 900 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x 910 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 48, 32, 32, 50, 42,   /* 0x 920 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x 930 */
 65, 68, 79, 78, 76, 89, 10, 32, 50, 51, 32, 67, 65, 76, 76, 84,   /* 0x 940 */
 82, 73, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x 950 */
 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x 960 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 50, 32,   /* 0x 970 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x 980 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x 990 */
 10, 32, 50, 52, 32, 67, 84, 49, 54, 74, 69, 78, 68, 32, 32, 32,   /* 0x 9a0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,   /* 0x 9b0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x 9c0 */
 32, 48, 48, 48, 48, 48, 48,101, 56, 32, 32, 50, 42, 42, 48, 32,   /* 0x 9d0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x 9e0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 53, 32, 67,   /* 0x 9f0 */
 84, 49, 54, 74, 85, 76, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x a00 */
 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x a10 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x a20 */
 48,101, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x a30 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x a40 */
 79, 78, 76, 89, 10, 32, 50, 54, 32, 67, 84, 49, 54, 73, 50, 56,   /* 0x a50 */
 55, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32,   /* 0x a60 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x a70 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 99, 32, 32, 50,   /* 0x a80 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x a90 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 55, 32, 67, 84, 49, 54,   /* 0x aa0 */
 83, 85, 66, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x ab0 */
 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x ac0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101,102,   /* 0x ad0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x ae0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 56, 32, 67,   /* 0x af0 */
 84, 49, 54, 73, 48, 56, 55, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x b00 */
 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x b10 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x b20 */
 48,102, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x b30 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50,   /* 0x b40 */
 57, 32, 67, 65, 76, 76, 84, 82, 73, 54, 32, 32, 32, 32, 32, 32,   /* 0x b50 */
 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x b60 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x b70 */
 48, 48, 48, 48,102, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x b80 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x b90 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 48, 32, 83, 89, 83, 77,   /* 0x ba0 */
 65, 73, 78, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x bb0 */
 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x bc0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,102, 99,   /* 0x bd0 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x be0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 49, 32, 83,   /* 0x bf0 */
 89, 83, 73, 50, 56, 54, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x c00 */
 48, 48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x c10 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x c20 */
 48,102,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x c30 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51,   /* 0x c40 */
 50, 32, 83, 89, 83, 73, 48, 56, 54, 50, 32, 32, 32, 32, 32, 32,   /* 0x c50 */
 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x c60 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x c70 */
 48, 48, 48, 48,102,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x c80 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x c90 */
 10, 32, 51, 51, 32, 83, 89, 83, 74, 85, 77, 80, 49, 32, 32, 32,   /* 0x ca0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48,   /* 0x cb0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x cc0 */
 32, 48, 48, 48, 48, 48, 49, 48, 53, 32, 32, 50, 42, 42, 48, 32,   /* 0x cd0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x ce0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79,   /* 0x cf0 */
 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x d00 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89, 83, 77, 65, 73,   /* 0x d10 */
 78, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 83, 89, 83, 77,   /* 0x d20 */
 65, 73, 78, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x d30 */
 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 49, 54, 48,  9, 48,   /* 0x d40 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66, 49, 54, 48,   /* 0x d50 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x d60 */
 32, 32, 78, 82, 86, 68, 69, 67, 79, 50,  9, 48, 48, 48, 48, 48,   /* 0x d70 */
 48, 48, 48, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 48, 48, 48,   /* 0x d80 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65,   /* 0x d90 */
 76, 76, 84, 82, 49, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x da0 */
 67, 65, 76, 76, 84, 82, 49, 54, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x db0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,   /* 0x dc0 */
 73, 53,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76,   /* 0x dd0 */
 84, 82, 73, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x de0 */
 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 73, 54,  9, 48,   /* 0x df0 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 73, 54,   /* 0x e00 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x e10 */
 32, 32, 83, 89, 83, 73, 50, 56, 54, 49,  9, 48, 48, 48, 48, 48,   /* 0x e20 */
 48, 48, 48, 32, 83, 89, 83, 73, 50, 56, 54, 49, 10, 48, 48, 48,   /* 0x e30 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89,   /* 0x e40 */
 83, 73, 48, 56, 54, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x e50 */
 83, 89, 83, 73, 48, 56, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x e60 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89, 83, 77, 65, 73,   /* 0x e70 */
 78, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 83, 89, 83, 77,   /* 0x e80 */
 65, 73, 78, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x e90 */
 32, 32, 32,100, 32, 32, 83, 89, 83, 83, 66, 66, 66, 80,  9, 48,   /* 0x ea0 */
 48, 48, 48, 48, 48, 48, 48, 32, 83, 89, 83, 83, 66, 66, 66, 80,   /* 0x eb0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x ec0 */
 32, 32, 83, 89, 83, 67, 65, 76, 76, 84,  9, 48, 48, 48, 48, 48,   /* 0x ed0 */
 48, 48, 48, 32, 83, 89, 83, 67, 65, 76, 76, 84, 10, 48, 48, 48,   /* 0x ee0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89,   /* 0x ef0 */
 83, 77, 65, 73, 78, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x f00 */
 83, 89, 83, 77, 65, 73, 78, 51, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x f10 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 80, 88, 49, 72, 69,   /* 0x f20 */
 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 85, 80, 88, 49,   /* 0x f30 */
 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x f40 */
 32, 32, 32,100, 32, 32, 83, 89, 83, 67, 85, 84, 80, 79,  9, 48,   /* 0x f50 */
 48, 48, 48, 48, 48, 48, 48, 32, 83, 89, 83, 67, 85, 84, 80, 79,   /* 0x f60 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x f70 */
 32, 32, 78, 82, 86, 68, 68, 79, 78, 69,  9, 48, 48, 48, 48, 48,   /* 0x f80 */
 48, 48, 48, 32, 78, 82, 86, 68, 68, 79, 78, 69, 10, 48, 48, 48,   /* 0x f90 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82,   /* 0x fa0 */
 86, 68, 82, 69, 84, 85,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x fb0 */
 78, 82, 86, 68, 82, 69, 84, 85, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x fc0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 68, 69, 67,   /* 0x fd0 */
 79, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 68,   /* 0x fe0 */
 69, 67, 79, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x ff0 */
 32, 32, 32,100, 32, 32, 78, 82, 86, 76, 69, 68, 48, 48,  9, 48,   /* 0x1000 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 76, 69, 68, 48, 48,   /* 0x1010 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x1020 */
 32, 32, 78, 82, 86, 71, 84, 68, 48, 48,  9, 48, 48, 48, 48, 48,   /* 0x1030 */
 48, 48, 48, 32, 78, 82, 86, 71, 84, 68, 48, 48, 10, 48, 48, 48,   /* 0x1040 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,   /* 0x1050 */
 49, 54, 73, 50, 56, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1060 */
 67, 84, 49, 54, 73, 50, 56, 54, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1070 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 83, 85,   /* 0x1080 */
 66, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54,   /* 0x1090 */
 83, 85, 66, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x10a0 */
 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 73, 48, 56, 54,  9, 48,   /* 0x10b0 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54, 73, 48, 56, 54,   /* 0x10c0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x10d0 */
 32, 32, 67, 65, 76, 76, 84, 82, 73, 50,  9, 48, 48, 48, 48, 48,   /* 0x10e0 */
 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 73, 50, 10, 48, 48, 48,   /* 0x10f0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,   /* 0x1100 */
 49, 54, 69, 56, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1110 */
 67, 84, 49, 54, 69, 56, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1120 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 69, 57,   /* 0x1130 */
 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54,   /* 0x1140 */
 69, 57, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x1150 */
 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 74, 69, 78, 68,  9, 48,   /* 0x1160 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54, 74, 69, 78, 68,   /* 0x1170 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x1180 */
 32, 32, 67, 84, 49, 54, 74, 85, 76, 50,  9, 48, 48, 48, 48, 48,   /* 0x1190 */
 48, 48, 48, 32, 67, 84, 49, 54, 74, 85, 76, 50, 10, 48, 48, 48,   /* 0x11a0 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,   /* 0x11b0 */
 49, 54, 73, 50, 56, 55,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x11c0 */
 67, 84, 49, 54, 73, 50, 56, 55, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x11d0 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 83, 85,   /* 0x11e0 */
 66, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54,   /* 0x11f0 */
 83, 85, 66, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x1200 */
 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 73, 48, 56, 55,  9, 48,   /* 0x1210 */
 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54, 73, 48, 56, 55,   /* 0x1220 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,   /* 0x1230 */
 32, 32, 83, 89, 83, 77, 65, 73, 78, 53,  9, 48, 48, 48, 48, 48,   /* 0x1240 */
 48, 48, 48, 32, 83, 89, 83, 77, 65, 73, 78, 53, 10, 48, 48, 48,   /* 0x1250 */
 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89,   /* 0x1260 */
 83, 73, 50, 56, 54, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1270 */
 83, 89, 83, 73, 50, 56, 54, 50, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1280 */
 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 89, 83, 73, 48, 56,   /* 0x1290 */
 54, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 83, 89, 83, 73,   /* 0x12a0 */
 48, 56, 54, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,   /* 0x12b0 */
 32, 32, 32,100, 32, 32, 83, 89, 83, 74, 85, 77, 80, 49,  9, 48,   /* 0x12c0 */
 48, 48, 48, 48, 48, 48, 48, 32, 83, 89, 83, 74, 85, 77, 80, 49,   /* 0x12d0 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,   /* 0x12e0 */
 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x12f0 */
 32, 97,116,116,114,105, 98,117,116,101, 10, 48, 48, 48, 48, 48,   /* 0x1300 */
 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,   /* 0x1310 */
 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,105,110,116,101,114,   /* 0x1320 */
114,117,112,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,   /* 0x1330 */
 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,   /* 0x1340 */
 48, 48, 48, 48, 32, 99,111,112,121, 95,115,111,117,114, 99,101,   /* 0x1350 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,   /* 0x1360 */
 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1370 */
 32, 99,111,112,121, 95,100,101,115,116,105,110, 97,116,105,111,   /* 0x1380 */
110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,   /* 0x1390 */
 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x13a0 */
 48, 32,110,101,103, 95,101, 95,108,101,110, 10, 48, 48, 48, 48,   /* 0x13b0 */
 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,   /* 0x13c0 */
 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99, 97,108,108,   /* 0x13d0 */
116,114,105, 99,107, 95, 99, 97,108,108,115, 10, 48, 48, 48, 48,   /* 0x13e0 */
 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,   /* 0x13f0 */
 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,111,114,105,103,   /* 0x1400 */
105,110, 97,108, 95,115,116,114, 97,116,101,103,121, 10, 10, 82,   /* 0x1410 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x1420 */
 83, 32, 70, 79, 82, 32, 91, 83, 89, 83, 77, 65, 73, 78, 49, 93,   /* 0x1430 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x1440 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x1450 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56,   /* 0x1460 */
 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 97,116,   /* 0x1470 */
116,114,105, 98,117,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 54,   /* 0x1480 */
 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32,   /* 0x1490 */
 32, 32, 32, 83, 89, 83, 77, 65, 73, 78, 49, 10, 48, 48, 48, 48,   /* 0x14a0 */
 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32,   /* 0x14b0 */
 32, 32, 32, 32, 32, 32, 32,105,110,116,101,114,114,117,112,116,   /* 0x14c0 */
 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,   /* 0x14d0 */
 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 89, 83, 77, 65, 73,   /* 0x14e0 */
 78, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x14f0 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1500 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,   /* 0x1510 */
 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1520 */
 32, 99,111,112,121, 95,115,111,117,114, 99,101, 10, 48, 48, 48,   /* 0x1530 */
 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32,   /* 0x1540 */
 32, 32, 32, 32, 32, 32, 32, 32, 99,111,112,121, 95,100,101,115,   /* 0x1550 */
116,105,110, 97,116,105,111,110, 10, 48, 48, 48, 48, 48, 48, 49,   /* 0x1560 */
 54, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x1570 */
 32, 32, 32, 32,110,101,103, 95,101, 95,108,101,110, 10, 10, 82,   /* 0x1580 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x1590 */
 83, 32, 70, 79, 82, 32, 91, 83, 89, 83, 77, 65, 73, 78, 51, 93,   /* 0x15a0 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x15b0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x15c0 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,   /* 0x15d0 */
 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x15e0 */
 86, 50, 66, 49, 54, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x15f0 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x1600 */
 78, 82, 86, 50, 66, 49, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x1610 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1620 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x1630 */
 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32,   /* 0x1640 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10,   /* 0x1650 */
 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x1660 */
 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69,   /* 0x1670 */
 67, 79, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x1680 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86,   /* 0x1690 */
 68, 68, 79, 78, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x16a0 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x16b0 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x16c0 */
 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,   /* 0x16d0 */
 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 10, 82, 69,   /* 0x16e0 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x16f0 */
 32, 70, 79, 82, 32, 91, 78, 82, 86, 68, 82, 69, 84, 85, 93, 58,   /* 0x1700 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x1710 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x1720 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,   /* 0x1730 */
 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x1740 */
 68, 69, 67, 79, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,   /* 0x1750 */
 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,   /* 0x1760 */
 82, 86, 68, 69, 67, 79, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x1770 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1780 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x1790 */
 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,   /* 0x17a0 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 49, 54, 48, 10, 48,   /* 0x17b0 */
 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x17c0 */
 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67,   /* 0x17d0 */
 79, 50, 10, 48, 48, 48, 48, 48, 48, 49, 56, 32, 82, 95, 51, 56,   /* 0x17e0 */
 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x17f0 */
 86, 68, 69, 67, 79, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x1800 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x1810 */
 78, 82, 86, 68, 69, 67, 79, 50, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x1820 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1830 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x1840 */
 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x1850 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 49, 54, 48, 10,   /* 0x1860 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x1870 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49,   /* 0x1880 */
 54, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x1890 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x18a0 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95,   /* 0x18b0 */
 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x18c0 */
 99, 97,108,108,116,114,105, 99,107, 95, 99, 97,108,108,115, 10,   /* 0x18d0 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x18e0 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 73,   /* 0x18f0 */
 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x1900 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x1910 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95,   /* 0x1920 */
 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1930 */
 67, 65, 76, 76, 84, 82, 49, 54, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x1940 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x1950 */
 32, 91, 67, 65, 76, 76, 84, 82, 73, 53, 93, 58, 10, 79, 70, 70,   /* 0x1960 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x1970 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x1980 */
 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32,   /* 0x1990 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 99, 97,108,108,116,114,105,   /* 0x19a0 */
 99,107, 95, 99, 97,108,108,115, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x19b0 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x19c0 */
 32, 91, 67, 84, 49, 54, 74, 69, 78, 68, 93, 58, 10, 79, 70, 70,   /* 0x19d0 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x19e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x19f0 */
 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0x1a00 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79,   /* 0x1a10 */
 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x1a20 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 49, 54, 74,   /* 0x1a30 */
 85, 76, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x1a40 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1a50 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,   /* 0x1a60 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x1a70 */
 32, 32, 67, 65, 76, 76, 84, 82, 73, 54, 10, 10, 82, 69, 76, 79,   /* 0x1a80 */
 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,   /* 0x1a90 */
 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 73, 54, 93, 58, 10, 79,   /* 0x1aa0 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x1ab0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x1ac0 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 80,   /* 0x1ad0 */
 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,   /* 0x1ae0 */
 82, 73, 53, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x1af0 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 89, 83,   /* 0x1b00 */
 74, 85, 77, 80, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,   /* 0x1b10 */
 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1b20 */
 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1b30 */
 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32,   /* 0x1b40 */
 32, 32, 32, 32,111,114,105,103,105,110, 97,108, 95,115,116,114,   /* 0x1b50 */
 97,116,101,103,121, 10                                            /* 0x1b60 */
};
