/********************************************************************
 * SQLPrimaryKeys
 *
 **********************************************************************
 *
 * This code was created by Peter Harvey (mostly during Christmas 98/99).
 * This code is LGPL. Please ensure that this message remains in future
 * distributions and uses of this code (thats about all I get out of it).
 * - Peter Harvey pharvey@codebydesign.com
 *
 ********************************************************************/

#include "driver.h"

SQLRETURN SQLPrimaryKeys( SQLHSTMT        hDrvStmt,
								SQLCHAR         *szCatalogName,
								SQLSMALLINT     nCatalogNameLength,
								SQLCHAR         *szSchemaName,
								SQLSMALLINT     nSchemaNameLength,
								SQLCHAR         *szTableName,
								SQLSMALLINT     nTableNameLength )
{
    HDRVSTMT hStmt	= (HDRVSTMT)hDrvStmt;

	/* SANITY CHECKS */
    if( hStmt == SQL_NULL_HSTMT )
        return SQL_INVALID_HANDLE;

	sprintf((char*) hStmt->szSqlMsg, "hStmt = %p", hStmt );
    logPushMsg( hStmt->hLog, __FILE__, __FILE__, __LINE__, LOG_WARNING, LOG_WARNING,(char*) hStmt->szSqlMsg );

	if ( !szTableName )
	{
		logPushMsg( hStmt->hLog, __FILE__, __FILE__, __LINE__, LOG_WARNING, LOG_ERROR, "Valid szTableName required" );
		return SQL_ERROR;
	}

    /**************************
	 * close any existing result
     **************************/
	
	/************************
	 *
	 ************************/

    logPushMsg( hStmt->hLog, __FILE__, __FILE__, __LINE__, LOG_INFO, LOG_INFO, "SQL_SUCCESS" );
	return SQL_SUCCESS;
}



