/***************************************************************************
 *   Copyright (C) 2008 by Alexey Balakin                                  *
 *   mathgl.abalakin@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qapplication.h>
#include "scriptwindow.h"
#include "helpwindow.h"
#include "finddialog.h"
HelpWindow *hlp=NULL;
HintDialog *hintDialog=NULL;
extern QString pathHelp;
extern bool showHint;
void udavLoadDefCommands();
//-----------------------------------------------------------------------------
int main(int argc, char **argv)
{
	QApplication a(argc, argv);
	udavLoadDefCommands();
#ifdef WIN32
	pathHelp = MGL_DOC_DIR;
#else
	pathHelp = MGL_DOC_DIR[0] ? MGL_DOC_DIR : "/usr/local/share/doc/udav/";
#endif
	hlp = new HelpWindow();
	hintDialog = new HintDialog();
	ScriptWindow *mw = new ScriptWindow();
	if(argc>1)	mw->load(QString(argv[1]), true);
	mw->show();
	a.connect(&a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()));
	if(showHint)	hintDialog->exec();
	return a.exec();
}
//-----------------------------------------------------------------------------
