/*
 * luxus.h - tuXeyes figure definition for luxus
 * Copyright (C) 1999 Ivo van der Wijk
 *
 * The tux image is (c) Larry Ewing (lewing@isc.tamu.edu)
 * The dustpuppy image is (c) Illiad (http://www.userfriendly.org)
 * The bsd daemon ("Chuck") is (c) Eric Green
 * The luxus image is (c) Urs M. E. Streidl (http://www.gigaperls.org/linux/)
 * 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Please note: Pixmaps/images are copyrighted by Urs M. E. Streidl.
 * Check http://www.gigaperls.org/linux/ fore more figures.
 */
#ifndef LUXUS_H
#define LUXUS_H

#include <qapplication.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qimage.h>

#include "figure.h"

/*
 * Include pixmaps. Masks will be converted to bitmaps
 */
#include "luxus/luxus_main.xpm"
#include "luxus/luxus_mask.xpm"
#include "luxus/luxus_leftpupil.xpm"
#include "luxus/luxus_rightpupil.xpm"
#include "luxus/luxus_eyes.xpm"
#include "luxus/luxus_eyes_mask.xpm"
#include "luxus/luxus_leftpupilmask.xpm"
#include "luxus/luxus_rightpupilmask.xpm"

class	luxus: public figure
{
public:
	luxus(): figure()
	{
		loadImage(tuxOrig, luxus_main);
		loadImage(tuxMaskXPM, luxus_mask);
		loadImage(leftPupilOrig, luxus_leftpupil);
		loadImage(rightPupilOrig, luxus_rightpupil);
		loadImage(eyeRegionOrig, luxus_eyes);
		loadImage(eyeMaskXPM, luxus_eyes_mask);
		loadImage(leftPupilMaskXPM, luxus_leftpupilmask);
		loadImage(rightPupilMaskXPM, luxus_rightpupilmask);

		// these values have to determined by examining the picture
		leftEyeX = 143;
		leftEyeY = 121;
		rightEyeX = 192;
		rightEyeY = 106;
		leftPupilRadius = 10;
		rightPupilRadius = 13;
		eyeXOffset = 0;
		eyeYOffset = 56;
	}
	~luxus() {}
private:
};

#endif // LUXUS_H
