//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef Tulip_ParaSelection_H
#define Tulip_ParaSelection_H

#include <tulip/TulipPlugin.h>
/** \addtogroup selection */
/*@{*/

/**
 * This selection plugins enables to find the multiple-edges and parallel-edges in a graph.
 * Let e1, e2 two edges, e1 and e2 are parallel edges if source(e1)=source(e2) and 
 * target(e1) = target(e2).
 * If it exists n edges between two nodes, only n-1 edges will be selected. 
 *
 *  \author David Auber, LaBRI University Bordeaux I France: 
 *   auber@tulip-software.org
 */
class MultipleEdgeSelection:public tlp::BooleanAlgorithm { 
public:
  MultipleEdgeSelection(const tlp::PropertyContext &);
  bool run();
};
/*@}*/
#endif




