//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef MOUSESELECTION_H
#define MOUSESELECTION_H

#include <tulip/GWInteractor.h>

class QMouseEvent;
class QKeyEvent;

namespace tlp {

class Graph;
/** \addtogroup Mouse_interactor */ 
/*@{*/
class TLP_QT_SCOPE MouseSelector:public Interactor
{
protected:
  Qt::MouseButton mButton;
  Qt::KeyboardModifier kModifier;
  unsigned int x,y;
  int w,h;
  bool started;
  Graph *graph;
public:
  MouseSelector(Qt::MouseButton button = Qt::LeftButton,
		Qt::KeyboardModifier modifier = Qt::NoModifier);
  ~MouseSelector() {}
  bool draw(GlMainWidget *);
  bool eventFilter(QObject *, QEvent *);
  Interactor *clone() { return new MouseSelector(mButton, kModifier); }
};
/*@}*/

}
#endif
