
INCLUDE(PackageAddTestHelpers)


# Allow for a maximum of 20 (0 through 19) test commands
SET(PACKAGE_ADD_ADVANCED_TEST_MAX_NUM_TEST_CMND_IDX 19)


#
# Join arguments together to add to a SET(...) statement to passed to
# EXECUTE_PROCESS(...)
#

FUNCTION(JOIN_EXEC_PROCESS_SET_ARGS  OUTPUT_STRING_VAR)
  SET(OUTPUT_STRING "")
  FOREACH(STRING_VAL_RAW ${ARGN})
    # Remove quotes around arguments because CTest does not need them
    STRING(REGEX REPLACE "\"" "" STRING_VAL "${STRING_VAL_RAW}")
    IF (OUTPUT_STRING STREQUAL "")
      SET(OUTPUT_STRING "\"${STRING_VAL}\"")
    ELSE()
      SET(OUTPUT_STRING "${OUTPUT_STRING} \"${STRING_VAL}\"")
    ENDIF()
  ENDFOREACH()
  SET(${OUTPUT_STRING_VAR} "${OUTPUT_STRING}" PARENT_SCOPE)
ENDFUNCTION()


#
# Unit test helper function for PACKAGE_ADD_ADVANCED_TEST(...) that resets
# state before calling PACKAGE_ADD_ADVANCED_TEST(...) in unit test mode.
#

FUNCTION(PACKAGE_ADD_ADVANCED_TEST_UNITTEST_RESET)

  GLOBAL_SET(PACKAGE_ADD_ADVANCED_TEST_UNITTEST TRUE)

  GLOBAL_SET(PACKAGE_ADD_ADVANCED_TEST_NUM_CMNDS)

  FOREACH( TEST_CMND_IDX RANGE ${PACKAGE_ADD_ADVANCED_TEST_MAX_NUM_TEST_CMND_IDX})
    GLOBAL_SET(PACKAGE_ADD_ADVANCED_TEST_CMND_ARRAY_${TEST_CMND_IDX})
  ENDFOREACH()

ENDFUNCTION()
