##############################################################################
#
# Copyright (c) 2007 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

from osv import fields, osv


class Bank(osv.osv):
	_description='Bank'
	_name = 'res.bank'
	_columns = {
		'name': fields.char('Name', size=128, required=True),
		'code': fields.char('Code', size=64),
		'street': fields.char('Street', size=128),
		'street2': fields.char('Street2', size=128),
		'zip': fields.char('Zip', change_default=True, size=24),
		'city': fields.char('City', size=128),
		'state': fields.many2one("res.country.state", 'State',
			domain="[('country_id', '=', country)]"),
		'country': fields.many2one('res.country', 'Country'),
		'email': fields.char('E-Mail', size=64),
		'phone': fields.char('Phone', size=64),
		'fax': fields.char('Fax', size=64),
		'active': fields.boolean('Active'),
		'bic': fields.char('BIC/Swift code', size=11,
			help="Bank Identifier Code"),
	}
	_defaults = {
		'active': lambda *a: 1,
	}

Bank()
