import gtk
import gtk.glade as glade
from DurationChooser import DurationChooser

class AddEditPresetDialog(object):
    def __init__(self, glade_file_name, title, name_validator_func,
                 name='', hours=0, minutes=0, seconds=0):
        self._valid_name_func = name_validator_func
        
        glade_widgets = glade.XML(glade_file_name, 'add_edit_preset_dialog')
        self._dialog = glade_widgets.get_widget('add_edit_preset_dialog')
        self._ok_button = glade_widgets.get_widget('ok_button')
        self._cancel_button = glade_widgets.get_widget('cancel_button')
        self._name_entry = glade_widgets.get_widget('name_entry')
        duration_chooser_container = glade_widgets.get_widget('duration_chooser_container')
        self._duration_chooser = DurationChooser(gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL))
        
        duration_chooser_container.pack_start(self._duration_chooser)
        
        self._dialog.set_title(title)
        self._dialog.set_default_response(gtk.RESPONSE_OK)
        self._name_entry.set_text(name)
        self._duration_chooser.set_duration(hours, minutes, seconds)
        
        self._name_entry.connect('changed', lambda entry: self._check_for_valid_save_preset_input())
        self._duration_chooser.connect('duration-changed',
                                       lambda chooser: self._check_for_valid_save_preset_input())
        
        self._duration_chooser.show()
    
    def _non_zero_duration(self):
        (hours, minutes, seconds) = self._duration_chooser.get_duration()
        return (hours > 0 or minutes > 0 or seconds > 0)
        
    def _check_for_valid_save_preset_input(self):
        self._ok_button.props.sensitive = (self._non_zero_duration() and 
                                           self._valid_name_func(self._name_entry.get_text()))

    def get_preset(self):
        self._check_for_valid_save_preset_input()
        result = self._dialog.run()
        self._dialog.hide()
        if result == gtk.RESPONSE_OK:
            (hours, minutes, seconds) = self._duration_chooser.get_duration()
            return (self._name_entry.get_text(), hours, minutes, seconds)
        else:
            return None
