#include <stdio.h>
#include <walk_heap.h>
#include <jni.h>
#include <jvmti.h>
#include <tijmp.h>
#include <object_info_list.h>
#include <string.h>

extern jvmtiEnv *jvmti;

object_info_list* create_object_info_list (jclass clz) {
    object_info_list* oil;

    (*jvmti)->Allocate (jvmti, sizeof(*oil), (unsigned char**)&oil);
    oil->clz = clz;
    oil->size = 1000;
    oil->count = 0;
    /** 1000 is probably a good enought start guess. */
    (*jvmti)->Allocate (jvmti, sizeof (*oil->sizes) * oil->size, 
			(unsigned char**)&oil->sizes);
    (*jvmti)->Allocate (jvmti, sizeof (*oil->lengths) * oil->size, 
			(unsigned char**)&oil->lengths);
    (*jvmti)->Allocate (jvmti, sizeof (*oil->tags) * oil->size, 
			(unsigned char**)&oil->tags);
    return oil;
}

void free_object_info_list (object_info_list* oil) {
    if (oil == NULL)
	return;
    if (oil->sizes)
	(*jvmti)->Deallocate (jvmti, (unsigned char*)oil->sizes);
    if (oil->lengths)
	(*jvmti)->Deallocate (jvmti, (unsigned char*)oil->lengths);
    if (oil->objects)
	(*jvmti)->Deallocate (jvmti, (unsigned char*)oil->objects);
    if (oil->tags)
	(*jvmti)->Deallocate (jvmti, (unsigned char*)oil->tags);
    (*jvmti)->Deallocate (jvmti, (unsigned char*)oil);
}

static void expand (object_info_list* oil) {
    jlong* new_sizes;
    jint*  new_lengths;
    jlong* new_tags;
    
    jint new_size = oil->size * 2;
    (*jvmti)->Allocate (jvmti, sizeof (*oil->sizes) * new_size, 
			(unsigned char**)&new_sizes);
    memcpy (new_sizes, oil->sizes, 
	    sizeof (*oil->sizes) * oil->size);

    (*jvmti)->Allocate (jvmti, sizeof (*oil->lengths) * new_size, 
			(unsigned char**)&new_lengths);
    memcpy (new_lengths, oil->lengths, 
	    sizeof (*oil->lengths) * oil->size);

    (*jvmti)->Allocate (jvmti, sizeof (*oil->tags) * new_size, 
			(unsigned char**)&new_tags);
    memcpy (new_tags, oil->tags, 
	    sizeof (*oil->tags) * oil->size);

    (*jvmti)->Deallocate (jvmti, (unsigned char*)oil->sizes);
    (*jvmti)->Deallocate (jvmti, (unsigned char*)oil->lengths);
    (*jvmti)->Deallocate (jvmti, (unsigned char*)oil->tags);
    oil->sizes = new_sizes;
    oil->lengths = new_lengths;
    oil->size = new_size;
    oil->tags = new_tags;
}

void add_object_info_to_list (object_info_list* oil, jlong size, 
			      jint length, jlong tag) {
    if (oil->count == (oil->size - 1))
	expand (oil);
    oil->sizes[oil->count] = size;
    oil->lengths[oil->count] = length;
    oil->tags[oil->count] = tag;
    oil->count++;
}

void create_object_store (object_info_list* oil) {
    (*jvmti)->Allocate (jvmti, sizeof (*oil->objects) * oil->count, 
			(unsigned char**)&oil->objects);
    memset (oil->objects, 0, sizeof (*oil->objects) * oil->count);
}
