/***************************************************************************
                             th-utils.h
                             ----------
    begin                : Tue Apr 06 2004
    copyright            : (C) 2004 by Tim-Philipp Mller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _th_utils_h_included_
#define _th_utils_h_included_

#include <gtk/gtkwidget.h>
#include <gst/gstbin.h>
#include <gst/gstbuffer.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

typedef struct _ThMountPoint ThMountPoint;
struct _ThMountPoint
{
	gchar   *mnt_point;
	GList   *filenames;
	gdouble  space_needed; /* in MB */
	gdouble  space_avail;  /* in MB */
};

#define TH_TIME_FORMAT "u:%02u:%02u"

#define TH_TIME_ARGS(t) \
  GST_CLOCK_TIME_IS_VALID (t) ? \
  (guint) (((GstClockTime)(t)) / (GST_SECOND * 60 * 60)) : 99, \
  GST_CLOCK_TIME_IS_VALID (t) ? \
  (guint) ((((GstClockTime)(t)) / (GST_SECOND * 60)) % 60) : 99, \
  GST_CLOCK_TIME_IS_VALID (t) ? \
  (guint) ((((GstClockTime)(t)) / GST_SECOND) % 60) : 99

/* functions */

void              th_label_set_text          (gpointer     label,
                                              const gchar *format,
                                              ... ) G_GNUC_PRINTF (2,3);

void              th_label_set_markup        (gpointer     label,
                                              const gchar *format,
                                              ... ) G_GNUC_PRINTF (2,3);

gboolean          th_utils_ui_load_interface (const gchar   *gladefn,  
                                              gboolean       autoconnect_signals,
                                              const gchar   *widget_name1,
                                              GtkWidget    **p_widget1,
                                              ... ) G_GNUC_NULL_TERMINATED;

GdkPixbuf        *th_pixbuf_from_yuv_i420_buffer (GstBuffer *buf, guint width, guint height);

gboolean          th_mkdir_recursive (const gchar *basedir, const gchar *adddir, GError **err);

const gchar      *th_utils_get_language_name (const gchar *lang);

gboolean          th_utils_free_space_check_init         (GList **p_mount_point_list);

void              th_utils_free_space_check_deinit       (GList **p_mount_point_list);

gboolean          th_utils_free_space_check_add_filename (GList        **p_mount_point_list, 
                                                          const gchar   *fn, 
                                                          gdouble        space_needed);

GList            *th_utils_free_space_check              (GList **p_mount_point_list);

gdouble           th_utils_get_free_space_from_path      (const gchar *path);

gboolean          th_utils_running_in_valgrind (void);

void              th_utils_vg_style_print (const gchar *txt);

GdkPixbuf        *th_utils_get_shaded_pixbuf (GdkPixbuf *src, guint x, guint y, guint w, guint h, gint shift);

gboolean          th_utils_device_might_be_dvd_drive (const gchar *device, GError **err);

gboolean          th_utils_invoke_browser_with_url (const gchar *url);

void              th_log (const gchar *format, ...) G_GNUC_PRINTF (1,2);

void              th_log_show (void);

void              th_log_add_line (const gchar *txt);

gint              th_utils_get_plugin_rank (const gchar *plugin_name,   /* e.g. 'gstelements' */
                                            const gchar *feature_name); /* e.g. 'filesrc'     */

gchar            *th_utils_get_human_size_str (guint64 size_in_bytes);

gchar            *th_get_user_data_fn (const gchar *filename);

gchar            *th_get_user_cache_fn (const gchar *filename);

gchar            *th_get_user_config_fn (const gchar *filename);

void              th_bin_set_child_properties (GstBin *bin,
                                               const gchar *child_name,
                                               const gchar *prop1_name,
                                               ...) G_GNUC_NULL_TERMINATED;

void              th_simplify_fraction (guint * num, guint * denom);

#endif /* _th_utils_h_included_ */
