/* Copyright (C) 1988-1998 Takafumi Sakurai
 * Permission to use, copy, modify, and distribute this file for any
 * purpose is hereby granted without fee, provided that both the above
 * copyright notice and this permission appear in all copies.
*/

/* Multi-lingual character set */
#define	MC_ASCII	0x0
#define	MC_LTN1		0x1
#define	MC_LTN2		0x2
#define	MC_LTN3		0x3
#define	MC_LTN4		0x4
#define	MC_THAI		0x5
#define	MC_GRK		0x6
#define	MC_ARB		0x7
#define	MC_HBW		0x8
#define	MC_KANA		0x9
#define	MC_ROMAN	0xa
#define	MC_CRL		0xc
#define	MC_LTN5		0xd
#define	MC_JPOLD	0x10
#define	MC_CN		0x11
#define	MC_JP		0x12
#define	MC_KR		0x13
#define	MC_JPS		0x14
#define	MC_BIG51	0x18
#define	MC_BIG52	0x19

/* Mule private */
#define	MC_SISHENG	0x20
#define	MC_VN1		0x22
#define	MC_VN2		0x23
#define	MC_ARBD		0x24
#define	MC_ARB1		0x25
#define	MC_IPA		0x26

/* non-iso2022 representation */
#define	MC_NONE		0x80
#define	MC_EIGHT	0x81
#define	MC_SJIS		0x82
#define	MC_BIG5h	0x83
#define	MC_BIG5e	0x84

#define	make_ict(i,g0,g1)	((i)<<16|(g0)<<8|(g1))
#define	ict_iso(t)	((t)>>16)
#define	ict_G0(t)	(((t)>>8)&0xff)
#define	ict_G1(t)	((t)&0xff)
#define	make_oct(i,gr)	((i)<<8|(gr))
#define	oct_iso(t)	((t)>>8)
#define	oct_GR(t)	((t)&0xff)

/* ISO state for input */
#define	ISO_ONE		0
#define	ISO_GL22	1
#define	ISO_GR22	2

#define	Lctrl(c)	((c) < (int)' ')
#define	Rctrl(c)	(((c)&0x7f) < (int)' ')
#define	ESC		0x1b
#define	SI		0x0f
#define	SO		0x0e

#define	mletter_token_shift	16
#define	mletter_token_flag	(1<<mletter_token_shift)
#define	is_mlrep(c)		((c)&mletter_token_flag)
#define	is_mlrep_ascii(c)	((c)<=255)
#define	make_mlrep1(m,c)	\
	(((m)<<mletter_token_shift)+(c))
#define	make_mlrep(m,c1,c2)	\
	(((m)<<mletter_token_shift)+((c1)<<8)+(c2))
#define	mlrep_mc(c)		((c)>>mletter_token_shift)
#define	mlrep_char(c)		((c)&(mletter_token_flag-1))
#define	char_fst(c)		((c)>>8)
#define	char_snd(c)		((c)&0xff)
#define	mlrep_char_fst(c)	char_fst(mlrep_char(c))
#define	mlrep_char_snd(c)	char_snd(c)

/* ml_font_blen_tab defined in web */
#define	ml_font_blen(m)		mlfontblentab[m]

typedef	unsigned char textchar;
typedef	unsigned int mlchar;

#define	G0reg	0
#define	G1reg	1
#define	G2reg	2
#define	G3reg	3
#define	GEreg	4
#define	G0set	Gchsets[G0reg]
#define	G1set	Gchsets[G1reg]
#define	G2set	Gchsets[G2reg]
#define	G3set	Gchsets[G3reg]

typedef struct {
    unsigned char iso;
    unsigned char Gchsets[4];
    unsigned char GLinvk, GRinvk;
    unsigned char GLset, GRset;
    int (*GLchar)(), (*GLmake)();
    int (*GRchar)(), (*GRmake)();
    unsigned char instat;
    textchar inpend;
    int (*in_ln)();
    unsigned char GRout;
    int (*GRoutchar)();
    int (*out_ch)();
} mlcinfo;

extern int hasargcode;
extern int hasargterm;
extern int hasarglog;
extern int hasargspec;
extern mlcinfo mlcodeinfo[];

#include	"mlcoding.h"
