/*
 * defs.h - a definition file for xmdvi
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#define XMDVI_VERSION        "2.4.2"

#ifdef __linux__
#   define __BSD_SOURCE
#   define __USE_BSD
#endif

#define Public   /*null*/
#define Private  static
#define Import   extern

extern DVI_DEVICE    DviDev;
extern DVI           DviFile;
extern DVI_PROPERTY  DviProperty;
extern char*         DviFileName;
extern char*         DviFileNameBase;
extern char*         DviFileNameNew;
extern int           DviCurrentPage;
extern double        DviShrinkFactor;
extern int           DviEPSRendering;
extern int           DviVisualText;
extern int           DviVisualEPS;
extern int           DviDisableCommand;

#define VISUAL_MONO       1 
#define VISUAL_MONO_STR     "Monochrome"
#define VISUAL_GRAY       2
#define VISUAL_GRAY_STR     "Grayscale"
#define VISUAL_RGB        3
#define VISUAL_RGB_STR      "RGB"

#define EPS_STYLE_LATEX2E_GRAPHICS_STY       0
#define EPS_STYLE_LATEX2E_GRAPHICS_STY_STR   "LaTeX2e/graphics.sty"
#define EPS_STYLE_LATEX209_EPSF_STY          2
#define EPS_STYLE_LATEX209_EPSF_STY_STR      "LaTeX2.09/epsf.sty"

/*EOF*/
