/*  XGDVI
 *  Copyright (C) 1999  Hirotsugu Kakugawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../config.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#if HAVE_STRING_H
#  include <string.h>
#endif
#if HAVE_STRINGS_H
#  include <strings.h>
#endif

#include <gtk/gtk.h>

#include "libdvi29.h"
#include "defs.h"
#include "xgdvi.h"
#include "gui.h"


static void
on_destry                              (GtkObject      *obj,
                                        gpointer        user_data);

void
on_FileOK_pressed                      (GtkButton       *button,
                                        gpointer         user_data);
void
on_FileCancel_pressed                  (GtkButton       *button,
                                        gpointer         user_data);



static int        FileSelectionShown = 0;
static GtkWidget *FileSelection      = NULL;




GtkWidget*
create_FileSelection ()
{
  GtkWidget *FileOK;
  GtkWidget *FileCancel;

  FileSelection = gtk_file_selection_new (_("xgdvi: Open DVI File"));
  FileSelectionShown = 0;

#if 0
  gtk_widget_set_events(FileSelection, GDK_KEY_PRESS_MASK);
  gtk_signal_connect(GTK_OBJECT(FileSelection), "key_press_event", 
		     GTK_SIGNAL_FUNC(event_key_press), NULL);
#endif
  gtk_signal_connect(GTK_OBJECT(FileSelection), "destroy", 
		     GTK_SIGNAL_FUNC(on_destry), NULL);
  gtk_signal_connect (GTK_OBJECT (FileSelection), "destroy",
		      GTK_SIGNAL_FUNC(gtk_widget_destroyed), NULL);

  gtk_object_set_data (GTK_OBJECT (xgdvi), "FileSelection", FileSelection);
  gtk_container_border_width (GTK_CONTAINER (FileSelection), 10);

  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (FileSelection));

  FileOK = GTK_FILE_SELECTION (FileSelection)->ok_button;
  gtk_widget_show (FileOK);
  GTK_WIDGET_SET_FLAGS (FileOK, GTK_CAN_DEFAULT);
  gtk_tooltips_set_tip(gtk_tooltips_new(), FileOK,
		       (gchar*) _("Open a selected DVI file and display."),
		       (gchar*) NULL);
  gtk_signal_connect (GTK_OBJECT (FileOK), "clicked",
                      GTK_SIGNAL_FUNC (on_FileOK_pressed),
                      NULL);

  FileCancel = GTK_FILE_SELECTION (FileSelection)->cancel_button;
  gtk_widget_show (FileCancel);
  GTK_WIDGET_SET_FLAGS (FileCancel, GTK_CAN_DEFAULT);
  gtk_tooltips_set_tip(gtk_tooltips_new(), FileCancel,
		       (gchar*) _("Close the file selection window."),
		       (gchar*) NULL);
  gtk_signal_connect (GTK_OBJECT (FileCancel), "clicked",
                      GTK_SIGNAL_FUNC (on_FileCancel_pressed),
                      NULL);

  return FileSelection;
}



void
show_FileSelection(void)
{
  if (FileSelectionShown == 0){
    FileSelectionShown = 1;
    gtk_widget_show (FileSelection);
  }
}

void
hide_FileSelection(void)
{
  if (FileSelectionShown == 1){
    FileSelectionShown = 0;
    gtk_widget_hide (FileSelection);
  }
}


static void
on_destry                              (GtkObject       *obj,
                                        gpointer         user_data)
{
  FileSelectionShown = 0;
  FileSelection = create_FileSelection ();
}

void
on_File_clicked                        (GtkButton       *button,
                                        gpointer         user_data)
{
  if (FileSelectionShown == 0){
    FileSelectionShown = 1;
    gtk_widget_show (FileSelection);
  } else {
    FileSelectionShown = 0;
    gtk_widget_hide (FileSelection);
  } 
}


void
on_FileOK_pressed                      (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar *fname; 

  fname = gtk_file_selection_get_filename (GTK_FILE_SELECTION (FileSelection));
  find_file_gui((char*)fname);
  draw_page();
}


void
on_FileCancel_pressed                  (GtkButton       *button,
                                        gpointer         user_data)
{
  on_File_clicked(NULL, NULL);
}


void
set_fname_FileSelection(char *fname)
{
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(FileSelection), 
				  (gchar*)fname);
}
